/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCondition {
    public final ColumnDefinition column;
    private final Term collectionElement;
    private final FieldIdentifier field;
    private final Term value;
    private final List<Term> inValues;
    public final Operator operator;

    private ColumnCondition(ColumnDefinition column, Term collectionElement, FieldIdentifier field, Term value, List<Term> inValues, Operator op) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.field = field;
        this.value = value;
        this.inValues = inValues;
        this.operator = op;
        assert (field == null || collectionElement == null);
        if (this.operator != Operator.IN) assert (this.inValues == null);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term value, Operator op) {
        return new ColumnCondition(column, null, null, value, null, op);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term collectionElement, Term value, Operator op) {
        return new ColumnCondition(column, collectionElement, null, value, null, op);
    }

    public static ColumnCondition condition(ColumnDefinition column, FieldIdentifier udtField, Term value, Operator op) {
        return new ColumnCondition(column, null, udtField, value, null, op);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, List<Term> inValues) {
        return new ColumnCondition(column, null, null, null, inValues, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, List<Term> inValues) {
        return new ColumnCondition(column, collectionElement, null, null, inValues, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, FieldIdentifier udtField, List<Term> inValues) {
        return new ColumnCondition(column, null, udtField, null, inValues, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term inMarker) {
        return new ColumnCondition(column, null, null, inMarker, null, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, Term inMarker) {
        return new ColumnCondition(column, collectionElement, null, inMarker, null, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, FieldIdentifier udtField, Term inMarker) {
        return new ColumnCondition(column, null, udtField, inMarker, null, Operator.IN);
    }

    public void addFunctionsTo(List<Function> functions) {
        if (this.collectionElement != null) {
            this.collectionElement.addFunctionsTo(functions);
        }
        if (this.value != null) {
            this.value.addFunctionsTo(functions);
        }
        if (this.inValues != null) {
            for (Term value : this.inValues) {
                if (value == null) continue;
                value.addFunctionsTo(functions);
            }
        }
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        if (this.operator == Operator.IN && this.inValues != null) {
            for (Term value : this.inValues) {
                value.collectMarkerSpecification(boundNames);
            }
        } else {
            this.value.collectMarkerSpecification(boundNames);
        }
    }

    public Bound bind(QueryOptions options) throws InvalidRequestException {
        boolean isInCondition;
        boolean bl = isInCondition = this.operator == Operator.IN;
        if (this.column.type instanceof CollectionType) {
            if (this.collectionElement != null) {
                return isInCondition ? new ElementAccessInBound(this, options) : new ElementAccessBound(this, options);
            }
            return isInCondition ? new CollectionInBound(this, options) : new CollectionBound(this, options);
        }
        if (this.column.type.isUDT()) {
            if (this.field != null) {
                return isInCondition ? new UDTFieldAccessInBound(this, options) : new UDTFieldAccessBound(this, options);
            }
            return isInCondition ? new UDTInBound(this, options) : new UDTBound(this, options);
        }
        return isInCondition ? new SimpleInBound(this, options) : new SimpleBound(this, options);
    }

    private static Cell getCell(Row row, ColumnDefinition column) {
        return row == null ? null : row.getCell(column);
    }

    private static Cell getCell(Row row, ColumnDefinition column, CellPath path) {
        return row == null ? null : row.getCell(column, path);
    }

    private static Iterator<Cell> getCells(Row row, ColumnDefinition column) {
        if (row == null) {
            return Collections.emptyIterator();
        }
        ComplexColumnData complexData = row.getComplexColumnData(column);
        return complexData == null ? Collections.emptyIterator() : complexData.iterator();
    }

    private static boolean evaluateComparisonWithOperator(int comparison, Operator operator) {
        switch (operator) {
            case EQ: {
                return false;
            }
            case LT: 
            case LTE: {
                return comparison < 0;
            }
            case GT: 
            case GTE: {
                return comparison > 0;
            }
            case NEQ: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private static ByteBuffer cellValueAtIndex(Iterator<Cell> iter, int index) {
        int adv = Iterators.advance(iter, (int)index);
        if (adv == index && iter.hasNext()) {
            return iter.next().value();
        }
        return null;
    }

    public static class Raw {
        private final Term.Raw value;
        private final List<Term.Raw> inValues;
        private final AbstractMarker.INRaw inMarker;
        private final Term.Raw collectionElement;
        private final FieldIdentifier udtField;
        private final Operator operator;

        private Raw(Term.Raw value, List<Term.Raw> inValues, AbstractMarker.INRaw inMarker, Term.Raw collectionElement, FieldIdentifier udtField, Operator op) {
            this.value = value;
            this.inValues = inValues;
            this.inMarker = inMarker;
            this.collectionElement = collectionElement;
            this.udtField = udtField;
            this.operator = op;
        }

        public static Raw simpleCondition(Term.Raw value, Operator op) {
            return new Raw(value, null, null, null, null, op);
        }

        public static Raw simpleInCondition(List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, null, Operator.IN);
        }

        public static Raw simpleInCondition(AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, null, Operator.IN);
        }

        public static Raw collectionCondition(Term.Raw value, Term.Raw collectionElement, Operator op) {
            return new Raw(value, null, null, collectionElement, null, op);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, collectionElement, null, Operator.IN);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, collectionElement, null, Operator.IN);
        }

        public static Raw udtFieldCondition(Term.Raw value, FieldIdentifier udtField, Operator op) {
            return new Raw(value, null, null, null, udtField, op);
        }

        public static Raw udtFieldInCondition(FieldIdentifier udtField, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, udtField, Operator.IN);
        }

        public static Raw udtFieldInCondition(FieldIdentifier udtField, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, udtField, Operator.IN);
        }

        public ColumnCondition prepare(String keyspace, ColumnDefinition receiver, CFMetaData cfm) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Conditions on counters are not supported");
            }
            if (this.collectionElement != null) {
                ColumnSpecification valueSpec;
                ColumnSpecification elementSpec;
                if (!receiver.type.isCollection()) {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
                }
                switch (((CollectionType)receiver.type).kind) {
                    case LIST: {
                        elementSpec = Lists.indexSpecOf(receiver);
                        valueSpec = Lists.valueSpecOf(receiver);
                        break;
                    }
                    case MAP: {
                        elementSpec = Maps.keySpecOf(receiver);
                        valueSpec = Maps.valueSpecOf(receiver);
                        break;
                    }
                    case SET: {
                        throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (this.operator == Operator.IN) {
                    if (this.inValues == null) {
                        return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), (Term)this.inMarker.prepare(keyspace, valueSpec));
                    }
                    ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                    for (Term.Raw value : this.inValues) {
                        terms.add(value.prepare(keyspace, valueSpec));
                    }
                    return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), terms);
                }
                return ColumnCondition.condition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.value.prepare(keyspace, valueSpec), this.operator);
            }
            if (this.udtField != null) {
                UserType userType = (UserType)receiver.type;
                int fieldPosition = userType.fieldPosition(this.udtField);
                if (fieldPosition == -1) {
                    throw new InvalidRequestException(String.format("Unknown field %s for column %s", this.udtField, receiver.name));
                }
                ColumnSpecification fieldReceiver = UserTypes.fieldSpecOf(receiver, fieldPosition);
                if (this.operator == Operator.IN) {
                    if (this.inValues == null) {
                        return ColumnCondition.inCondition(receiver, this.udtField, (Term)this.inMarker.prepare(keyspace, fieldReceiver));
                    }
                    ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                    for (Term.Raw value : this.inValues) {
                        terms.add(value.prepare(keyspace, fieldReceiver));
                    }
                    return ColumnCondition.inCondition(receiver, this.udtField, terms);
                }
                return ColumnCondition.condition(receiver, this.udtField, this.value.prepare(keyspace, fieldReceiver), this.operator);
            }
            if (this.operator == Operator.IN) {
                if (this.inValues == null) {
                    return ColumnCondition.inCondition(receiver, this.inMarker.prepare(keyspace, receiver));
                }
                ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                for (Term.Raw value : this.inValues) {
                    terms.add(value.prepare(keyspace, receiver));
                }
                return ColumnCondition.inCondition(receiver, terms);
            }
            return ColumnCondition.condition(receiver, this.value.prepare(keyspace, receiver), this.operator);
        }
    }

    public static class UDTInBound
    extends Bound {
        private final List<ByteBuffer> inValues;
        private final ProtocolVersion protocolVersion;

        private UDTInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isUDT() && condition.field == null);
            assert (condition.operator == Operator.IN);
            this.protocolVersion = options.getProtocolVersion();
            this.inValues = new ArrayList<ByteBuffer>();
            if (condition.inValues == null) {
                Lists.Marker inValuesMarker = (Lists.Marker)condition.value;
                Term.Terminal terminal = inValuesMarker.bind(options);
                if (terminal == null) {
                    throw new InvalidRequestException("Invalid null list in IN condition");
                }
                if (terminal == Constants.UNSET_VALUE) {
                    throw new InvalidRequestException("Invalid 'unset' value in condition");
                }
                for (ByteBuffer buffer : ((Lists.Value)terminal).elements) {
                    this.inValues.add(buffer);
                }
            } else {
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            Cell cell;
            Iterator cells;
            UserType userType = (UserType)this.column.type;
            ByteBuffer rowValue = userType.isMultiCell() ? ((cells = ColumnCondition.getCells(row, this.column)).hasNext() ? userType.serializeForNativeProtocol(cells, this.protocolVersion) : null) : ((cell = ColumnCondition.getCell(row, this.column)) == null ? null : cell.value());
            for (ByteBuffer value : this.inValues) {
                if (!(value == null || rowValue == null ? value == rowValue : userType.compare(value, rowValue) == 0)) continue;
                return true;
            }
            return false;
        }
    }

    static class UDTBound
    extends Bound {
        private final ByteBuffer value;
        private final ProtocolVersion protocolVersion;

        private UDTBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isUDT() && condition.field == null);
            assert (condition.operator != Operator.IN);
            this.protocolVersion = options.getProtocolVersion();
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            ByteBuffer rowValue;
            UserType userType = (UserType)this.column.type;
            if (userType.isMultiCell()) {
                Iterator iter = ColumnCondition.getCells(row, this.column);
                rowValue = iter.hasNext() ? userType.serializeForNativeProtocol(iter, this.protocolVersion) : null;
            } else {
                Cell cell = ColumnCondition.getCell(row, this.column);
                ByteBuffer byteBuffer = rowValue = cell == null ? null : cell.value();
            }
            if (this.value == null) {
                if (this.operator == Operator.EQ) {
                    return rowValue == null;
                }
                if (this.operator == Operator.NEQ) {
                    return rowValue != null;
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
            }
            return this.compareWithOperator(this.operator, userType, this.value, rowValue);
        }
    }

    static class UDTFieldAccessInBound
    extends Bound {
        public final FieldIdentifier field;
        public final List<ByteBuffer> inValues;

        private UDTFieldAccessInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isUDT() && condition.field != null);
            this.field = condition.field;
            if (condition.inValues == null) {
                this.inValues = ((Lists.Value)condition.value.bind(options)).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            Cell cell;
            UserType userType = (UserType)this.column.type;
            int fieldPosition = userType.fieldPosition(this.field);
            assert (fieldPosition >= 0);
            ByteBuffer cellValue = this.column.type.isMultiCell() ? ((cell = ColumnCondition.getCell(row, this.column, userType.cellPathForField(this.field))) == null ? null : cell.value()) : ((cell = ColumnCondition.getCell(row, this.column)) == null ? null : userType.split(ColumnCondition.getCell(row, this.column).value())[fieldPosition]);
            AbstractType<?> valueType = userType.fieldType(fieldPosition);
            for (ByteBuffer value : this.inValues) {
                if (!this.compareWithOperator(Operator.EQ, valueType, value, cellValue)) continue;
                return true;
            }
            return false;
        }
    }

    static class UDTFieldAccessBound
    extends Bound {
        public final FieldIdentifier field;
        public final ByteBuffer value;

        private UDTFieldAccessBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isUDT() && condition.field != null);
            assert (condition.operator != Operator.IN);
            this.field = condition.field;
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            Cell cell;
            UserType userType = (UserType)this.column.type;
            int fieldPosition = userType.fieldPosition(this.field);
            assert (fieldPosition >= 0);
            ByteBuffer cellValue = this.column.type.isMultiCell() ? ((cell = ColumnCondition.getCell(row, this.column, userType.cellPathForField(this.field))) == null ? null : cell.value()) : ((cell = ColumnCondition.getCell(row, this.column)) == null ? null : userType.split(cell.value())[fieldPosition]);
            return this.compareWithOperator(this.operator, userType.fieldType(fieldPosition), this.value, cellValue);
        }
    }

    public static class CollectionInBound
    extends Bound {
        private final List<Term.Terminal> inValues;

        private CollectionInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            block13: {
                block11: {
                    Term.Terminal terminal;
                    CollectionType collectionType;
                    block14: {
                        block12: {
                            super(condition.column, condition.operator);
                            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
                            assert (condition.operator == Operator.IN);
                            this.inValues = new ArrayList<Term.Terminal>();
                            if (condition.inValues != null) break block11;
                            collectionType = (CollectionType)this.column.type;
                            Lists.Marker inValuesMarker = (Lists.Marker)condition.value;
                            terminal = inValuesMarker.bind(options);
                            if (terminal == null) {
                                throw new InvalidRequestException("Invalid null list in IN condition");
                            }
                            if (terminal == Constants.UNSET_VALUE) {
                                throw new InvalidRequestException("Invalid 'unset' value in condition");
                            }
                            if (!(this.column.type instanceof ListType)) break block12;
                            ListType<?> deserializer = ListType.getInstance(collectionType.valueComparator(), false);
                            for (ByteBuffer buffer : ((Lists.Value)terminal).elements) {
                                if (buffer == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                                if (buffer == null) {
                                    this.inValues.add(null);
                                    continue;
                                }
                                this.inValues.add(Lists.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                            }
                            break block13;
                        }
                        if (!(this.column.type instanceof MapType)) break block14;
                        MapType<?, ?> deserializer = MapType.getInstance(collectionType.nameComparator(), collectionType.valueComparator(), false);
                        for (ByteBuffer buffer : ((Lists.Value)terminal).elements) {
                            if (buffer == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                            if (buffer == null) {
                                this.inValues.add(null);
                                continue;
                            }
                            this.inValues.add(Maps.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                        }
                        break block13;
                    }
                    if (!(this.column.type instanceof SetType)) break block13;
                    SetType<?> deserializer = SetType.getInstance(collectionType.valueComparator(), false);
                    for (ByteBuffer buffer : ((Lists.Value)terminal).elements) {
                        if (buffer == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                        if (buffer == null) {
                            this.inValues.add(null);
                            continue;
                        }
                        this.inValues.add(Sets.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                    }
                    break block13;
                }
                for (Term value : condition.inValues) {
                    Term.Terminal terminal = value.bind(options);
                    if (terminal == Constants.UNSET_VALUE) continue;
                    this.inValues.add(terminal);
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            if (type.isMultiCell()) {
                for (Term.Terminal value : this.inValues) {
                    if (!CollectionBound.valueAppliesTo(type, ColumnCondition.getCells(row, this.column), value, Operator.EQ)) continue;
                    return true;
                }
                return false;
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            for (Term.Terminal value : this.inValues) {
                if (!(value == null ? cell == null : type.compare(value.get(ProtocolVersion.V3), cell.value()) == 0)) continue;
                return true;
            }
            return false;
        }
    }

    static class CollectionBound
    extends Bound {
        private final Term.Terminal value;

        private CollectionBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isCollection() && condition.collectionElement == null);
            assert (condition.operator != Operator.IN);
            this.value = condition.value.bind(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            if (type.isMultiCell()) {
                Iterator iter = ColumnCondition.getCells(row, this.column);
                if (this.value == null) {
                    if (this.operator == Operator.EQ) {
                        return !iter.hasNext();
                    }
                    if (this.operator == Operator.NEQ) {
                        return iter.hasNext();
                    }
                    throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
                }
                return CollectionBound.valueAppliesTo(type, iter, this.value, this.operator);
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            if (this.value == null) {
                if (this.operator == Operator.EQ) {
                    return cell == null;
                }
                if (this.operator == Operator.NEQ) {
                    return cell != null;
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
            }
            ByteBuffer conditionValue = type.kind == CollectionType.Kind.LIST ? ((Lists.Value)this.value).get(ProtocolVersion.V3) : (type.kind == CollectionType.Kind.SET ? ((Sets.Value)this.value).get(ProtocolVersion.V3) : ((Maps.Value)this.value).get(ProtocolVersion.V3));
            return this.compareWithOperator(this.operator, type, conditionValue, cell.value());
        }

        static boolean valueAppliesTo(CollectionType type, Iterator<Cell> iter, Term.Terminal value, Operator operator) {
            if (value == null) {
                return !iter.hasNext();
            }
            switch (type.kind) {
                case LIST: {
                    List<ByteBuffer> valueList = ((Lists.Value)value).elements;
                    return CollectionBound.listAppliesTo((ListType)type, iter, valueList, operator);
                }
                case SET: {
                    SortedSet<ByteBuffer> valueSet = ((Sets.Value)value).elements;
                    return CollectionBound.setAppliesTo((SetType)type, iter, valueSet, operator);
                }
                case MAP: {
                    Map<ByteBuffer, ByteBuffer> valueMap = ((Maps.Value)value).map;
                    return CollectionBound.mapAppliesTo((MapType)type, iter, valueMap, operator);
                }
            }
            throw new AssertionError();
        }

        private static boolean setOrListAppliesTo(AbstractType<?> type, Iterator<Cell> iter, Iterator<ByteBuffer> conditionIter, Operator operator, boolean isSet) {
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                ByteBuffer cellValue = isSet ? iter.next().path().get(0) : iter.next().value();
                int comparison = type.compare(cellValue, conditionIter.next());
                if (comparison == 0) continue;
                return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }

        static boolean listAppliesTo(ListType type, Iterator<Cell> iter, List<ByteBuffer> elements, Operator operator) {
            return CollectionBound.setOrListAppliesTo(type.getElementsType(), iter, elements.iterator(), operator, false);
        }

        static boolean setAppliesTo(SetType type, Iterator<Cell> iter, Set<ByteBuffer> elements, Operator operator) {
            ArrayList<ByteBuffer> sortedElements = new ArrayList<ByteBuffer>(elements.size());
            sortedElements.addAll(elements);
            Collections.sort(sortedElements, type.getElementsType());
            return CollectionBound.setOrListAppliesTo(type.getElementsType(), iter, sortedElements.iterator(), operator, true);
        }

        static boolean mapAppliesTo(MapType type, Iterator<Cell> iter, Map<ByteBuffer, ByteBuffer> elements, Operator operator) {
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> conditionIter = elements.entrySet().iterator();
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                Map.Entry<ByteBuffer, ByteBuffer> conditionEntry = conditionIter.next();
                Cell c = iter.next();
                int comparison = type.getKeysType().compare(c.path().get(0), conditionEntry.getKey());
                if (comparison != 0) {
                    return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
                }
                comparison = type.getValuesType().compare(c.value(), conditionEntry.getValue());
                if (comparison == 0) continue;
                return ColumnCondition.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }
    }

    static class ElementAccessInBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final List<ByteBuffer> inValues;

        private ElementAccessInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            if (condition.inValues == null) {
                Term.Terminal terminal = condition.value.bind(options);
                if (terminal == Constants.UNSET_VALUE) {
                    throw new InvalidRequestException("Invalid 'unset' value in condition");
                }
                this.inValues = ((Lists.Value)terminal).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    ByteBuffer buffer = value.bindAndGet(options);
                    if (buffer == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                    this.inValues.add(buffer);
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            ByteBuffer cellValue;
            Cell cell;
            AbstractType<Object> valueType;
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                MapType mapType = (MapType)this.column.type;
                valueType = mapType.getValuesType();
                cellValue = this.column.type.isMultiCell() ? ((cell = ColumnCondition.getCell(row, this.column, CellPath.create(this.collectionElement))) == null ? null : cell.value()) : ((cell = ColumnCondition.getCell(row, this.column)) == null ? null : ((MapSerializer)mapType.getSerializer()).getSerializedValue(cell.value(), this.collectionElement, mapType.getKeysType()));
            } else {
                ListType listType = (ListType)this.column.type;
                valueType = listType.getElementsType();
                cellValue = this.column.type.isMultiCell() ? ColumnCondition.cellValueAtIndex(ColumnCondition.getCells(row, this.column), ElementAccessBound.getListIndex(this.collectionElement)) : ((cell = ColumnCondition.getCell(row, this.column)) == null ? null : ((ListSerializer)listType.getSerializer()).getElement(cell.value(), ElementAccessBound.getListIndex(this.collectionElement)));
            }
            for (ByteBuffer value : this.inValues) {
                if (!this.compareWithOperator(Operator.EQ, valueType, value, cellValue)) continue;
                return true;
            }
            return false;
        }
    }

    static class ElementAccessBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final ByteBuffer value;

        private ElementAccessBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            assert (condition.operator != Operator.IN);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                MapType mapType = (MapType)this.column.type;
                if (this.column.type.isMultiCell()) {
                    Cell cell = ColumnCondition.getCell(row, this.column, CellPath.create(this.collectionElement));
                    return this.isSatisfiedByValue(this.value, cell, ((MapType)this.column.type).getValuesType(), this.operator);
                }
                Cell cell = ColumnCondition.getCell(row, this.column);
                ByteBuffer mapElementValue = ((MapSerializer)mapType.getSerializer()).getSerializedValue(cell.value(), this.collectionElement, mapType.getKeysType());
                return this.compareWithOperator(this.operator, mapType.getValuesType(), this.value, mapElementValue);
            }
            ListType listType = (ListType)this.column.type;
            if (this.column.type.isMultiCell()) {
                ByteBuffer columnValue = ColumnCondition.cellValueAtIndex(ColumnCondition.getCells(row, this.column), ElementAccessBound.getListIndex(this.collectionElement));
                return this.compareWithOperator(this.operator, ((ListType)this.column.type).getElementsType(), this.value, columnValue);
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            ByteBuffer listElementValue = ((ListSerializer)listType.getSerializer()).getElement(cell.value(), ElementAccessBound.getListIndex(this.collectionElement));
            return this.compareWithOperator(this.operator, listType.getElementsType(), this.value, listElementValue);
        }

        static int getListIndex(ByteBuffer collectionElement) throws InvalidRequestException {
            int idx = ByteBufferUtil.toInt(collectionElement);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            return idx;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }
    }

    static class SimpleInBound
    extends Bound {
        public final List<ByteBuffer> inValues;

        private SimpleInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.field == null);
            assert (condition.operator == Operator.IN);
            if (condition.inValues == null) {
                Term.Terminal terminal = condition.value.bind(options);
                if (terminal == null) {
                    throw new InvalidRequestException("Invalid null list in IN condition");
                }
                if (terminal == Constants.UNSET_VALUE) {
                    throw new InvalidRequestException("Invalid 'unset' value in condition");
                }
                this.inValues = ((Lists.Value)terminal).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    ByteBuffer buffer = value.bindAndGet(options);
                    if (buffer == ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            Cell c = ColumnCondition.getCell(row, this.column);
            for (ByteBuffer value : this.inValues) {
                if (!this.isSatisfiedByValue(value, c, this.column.type, Operator.EQ)) continue;
                return true;
            }
            return false;
        }
    }

    static class SimpleBound
    extends Bound {
        public final ByteBuffer value;

        private SimpleBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.field == null);
            assert (condition.operator != Operator.IN);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            return this.isSatisfiedByValue(this.value, ColumnCondition.getCell(row, this.column), this.column.type, this.operator);
        }
    }

    public static abstract class Bound {
        public final ColumnDefinition column;
        public final Operator operator;

        protected Bound(ColumnDefinition column, Operator operator) {
            this.column = column;
            this.operator = operator;
        }

        public abstract boolean appliesTo(Row var1) throws InvalidRequestException;

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected boolean isSatisfiedByValue(ByteBuffer value, Cell c, AbstractType<?> type, Operator operator) throws InvalidRequestException {
            return this.compareWithOperator(operator, type, value, c == null ? null : c.value());
        }

        protected boolean compareWithOperator(Operator operator, AbstractType<?> type, ByteBuffer value, ByteBuffer otherValue) throws InvalidRequestException {
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException("Invalid 'unset' value in condition");
            }
            if (value == null) {
                switch (operator) {
                    case EQ: {
                        return otherValue == null;
                    }
                    case NEQ: {
                        return otherValue != null;
                    }
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{operator}));
            }
            if (otherValue == null) {
                return operator == Operator.NEQ;
            }
            return operator.isSatisfiedBy(type, otherValue, value);
        }
    }
}

