/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;

public class Terms {
    private static com.google.common.base.Function<Term, Iterable<Function>> TO_FUNCTION_ITERABLE = new com.google.common.base.Function<Term, Iterable<Function>>(){

        public Iterable<Function> apply(Term term) {
            return term.getFunctions();
        }
    };

    public static Iterable<Function> getFunctions(Iterable<Term> terms) {
        if (terms == null) {
            return Collections.emptySet();
        }
        return Iterables.concat((Iterable)Iterables.transform(terms, TO_FUNCTION_ITERABLE));
    }

    public static ByteBuffer asBytes(String keyspace, String term, AbstractType type) {
        ColumnSpecification receiver = new ColumnSpecification(keyspace, "--dummy--", new ColumnIdentifier("(dummy)", true), type);
        Term.Raw rawTerm = CQLFragmentParser.parseAny(CqlParser::term, term, "CQL term");
        return rawTerm.prepare(keyspace, receiver).bindAndGet(QueryOptions.DEFAULT);
    }
}

