/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;

public abstract class JavaUDF {
    private final DataType returnDataType;
    private final DataType[] argDataTypes;

    protected JavaUDF(DataType returnDataType, DataType[] argDataTypes) {
        this.returnDataType = returnDataType;
        this.argDataTypes = argDataTypes;
    }

    protected abstract ByteBuffer executeImpl(int var1, List<ByteBuffer> var2);

    protected Object compose(int protocolVersion, int argIndex, ByteBuffer value) {
        return UDFunction.compose(this.argDataTypes, protocolVersion, argIndex, value);
    }

    protected ByteBuffer decompose(int protocolVersion, Object value) {
        return UDFunction.decompose(this.returnDataType, protocolVersion, value);
    }

    protected float compose_float(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return ((Float)UDHelper.deserialize(DataType.cfloat(), protocolVersion, value)).floatValue();
    }

    protected double compose_double(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Double)UDHelper.deserialize(DataType.cdouble(), protocolVersion, value);
    }

    protected byte compose_byte(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Byte)UDHelper.deserialize(DataType.tinyint(), protocolVersion, value);
    }

    protected short compose_short(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Short)UDHelper.deserialize(DataType.smallint(), protocolVersion, value);
    }

    protected int compose_int(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Integer)UDHelper.deserialize(DataType.cint(), protocolVersion, value);
    }

    protected long compose_long(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Long)UDHelper.deserialize(DataType.bigint(), protocolVersion, value);
    }

    protected boolean compose_boolean(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Boolean)UDHelper.deserialize(DataType.cboolean(), protocolVersion, value);
    }
}

