/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.lifecycle.ILifecycleTransaction;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.ViewBuilder;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.IndexSummaryRedistribution;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.SnapshotDeletingTask;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CompactionMetrics;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.MerkleTrees;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance;
    public static final int NO_GC = Integer.MIN_VALUE;
    public static final int GC_ALL = Integer.MAX_VALUE;
    public static final ThreadLocal<Boolean> isCompactionManager;
    private final CompactionExecutor executor = new CompactionExecutor();
    private final CompactionExecutor validationExecutor = new ValidationExecutor();
    private final CompactionExecutor cacheCleanupExecutor = new CacheCleanupExecutor();
    private final CompactionMetrics metrics = new CompactionMetrics(this.executor, this.validationExecutor);
    @VisibleForTesting
    final Multiset<ColumnFamilyStore> compactingCF = ConcurrentHashMultiset.create();
    private final AtomicInteger globalCompactionPauseCount = new AtomicInteger(0);
    private final RateLimiter compactionRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);

    public RateLimiter getRateLimiter() {
        this.setRate(DatabaseDescriptor.getCompactionThroughputMbPerSec());
        return this.compactionRateLimiter;
    }

    public void setRate(double throughPutMbPerSec) {
        double throughput = throughPutMbPerSec * 1024.0 * 1024.0;
        if (throughput == 0.0 || StorageService.instance.isBootstrapMode()) {
            throughput = Double.MAX_VALUE;
        }
        if (this.compactionRateLimiter.getRate() != throughput) {
            this.compactionRateLimiter.setRate(throughput);
        }
    }

    public List<Future<?>> submitBackground(ColumnFamilyStore cfs) {
        if (cfs.isAutoCompactionDisabled()) {
            logger.trace("Autocompaction is disabled");
            return Collections.emptyList();
        }
        int count = this.compactingCF.count((Object)cfs);
        if (count > 0 && this.executor.getActiveCount() >= this.executor.getMaximumPoolSize()) {
            logger.trace("Background compaction is still running for {}.{} ({} remaining). Skipping", new Object[]{cfs.keyspace.getName(), cfs.name, count});
            return Collections.emptyList();
        }
        logger.trace("Scheduling a background task check for {}.{} with {}", new Object[]{cfs.keyspace.getName(), cfs.name, cfs.getCompactionStrategyManager().getName()});
        ArrayList futures = new ArrayList(1);
        ListenableFuture<?> fut = this.executor.submitIfRunning(new BackgroundCompactionCandidate(cfs), "background task");
        if (!fut.isCancelled()) {
            futures.add((Future<?>)fut);
        } else {
            this.compactingCF.remove((Object)cfs);
        }
        return futures;
    }

    public boolean isCompacting(Iterable<ColumnFamilyStore> cfses) {
        for (ColumnFamilyStore cfs : cfses) {
            if (cfs.getTracker().getCompacting().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void forceShutdown() {
        this.executor.shutdown();
        this.validationExecutor.shutdown();
        this.cacheCleanupExecutor.shutdown();
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            holder.stop();
        }
        for (ExecutorService executorService : Arrays.asList(this.executor, this.validationExecutor, this.cacheCleanupExecutor)) {
            try {
                if (executorService.awaitTermination(1L, TimeUnit.MINUTES)) continue;
                logger.warn("Failed to wait for compaction executors shutdown");
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for tasks to be terminated", (Throwable)e);
            }
        }
    }

    public void finishCompactionsAndShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
    }

    /*
     * Exception decompiling
     */
    private AllSSTableOpStatus parallelAllSSTableOperation(ColumnFamilyStore cfs, OneSSTableOperation operation, int jobs, OperationType operationType) throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AllSSTableOpStatus performScrub(ColumnFamilyStore cfs, boolean skipCorrupted, boolean checkData, int jobs) throws InterruptedException, ExecutionException {
        return this.performScrub(cfs, skipCorrupted, checkData, false, jobs);
    }

    public AllSSTableOpStatus performScrub(final ColumnFamilyStore cfs, final boolean skipCorrupted, final boolean checkData, final boolean reinsertOverflowedTTL, int jobs) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) throws IOException {
                CompactionManager.this.scrubOne(cfs, input, skipCorrupted, checkData, reinsertOverflowedTTL);
            }
        }, jobs, OperationType.SCRUB);
    }

    public AllSSTableOpStatus performVerify(final ColumnFamilyStore cfs, final boolean extendedVerify) throws InterruptedException, ExecutionException {
        assert (!cfs.isIndex());
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction input) {
                return input.originals();
            }

            @Override
            public void execute(LifecycleTransaction input) throws IOException {
                CompactionManager.this.verifyOne(cfs, input.onlyOne(), extendedVerify);
            }
        }, 0, OperationType.VERIFY);
    }

    public AllSSTableOpStatus performSSTableRewrite(final ColumnFamilyStore cfs, final boolean excludeCurrentVersion, int jobs) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList sortedSSTables = Lists.newArrayList(transaction.originals());
                Collections.sort(sortedSSTables, SSTableReader.sizeComparator.reversed());
                Iterator iter = sortedSSTables.iterator();
                while (iter.hasNext()) {
                    SSTableReader sstable = (SSTableReader)iter.next();
                    if (!excludeCurrentVersion || !sstable.descriptor.version.equals(sstable.descriptor.getFormat().getLatestVersion())) continue;
                    transaction.cancel(sstable);
                    iter.remove();
                }
                return sortedSSTables;
            }

            @Override
            public void execute(LifecycleTransaction txn) throws IOException {
                AbstractCompactionTask task = cfs.getCompactionStrategyManager().getCompactionTask(txn, Integer.MIN_VALUE, Long.MAX_VALUE);
                task.setUserDefined(true);
                task.setCompactionType(OperationType.UPGRADE_SSTABLES);
                task.execute(CompactionManager.this.metrics);
            }
        }, jobs, OperationType.UPGRADE_SSTABLES);
    }

    public AllSSTableOpStatus performCleanup(final ColumnFamilyStore cfStore, int jobs) throws InterruptedException, ExecutionException {
        assert (!cfStore.isIndex());
        Keyspace keyspace = cfStore.keyspace;
        if (!StorageService.instance.getTokenMetadata().getPendingRanges(keyspace.getName(), FBUtilities.getBroadcastAddress()).isEmpty()) {
            logger.info("Cleanup cannot run while node has pending ranges for keyspace {} table {}, wait for node addition/decommission to complete and try again", (Object)cfStore.keyspace.getName(), (Object)cfStore.getTableName());
            return AllSSTableOpStatus.ABORTED;
        }
        final Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(keyspace.getName());
        final boolean hasIndexes = cfStore.indexManager.hasIndexes();
        return this.parallelAllSSTableOperation(cfStore, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(LifecycleTransaction transaction) {
                ArrayList sortedSSTables = Lists.newArrayList(transaction.originals());
                Iterator sstableIter = sortedSSTables.iterator();
                int totalSSTables = 0;
                int skippedSStables = 0;
                while (sstableIter.hasNext()) {
                    SSTableReader sstable = (SSTableReader)sstableIter.next();
                    ++totalSSTables;
                    if (CompactionManager.needsCleanup(sstable, ranges)) continue;
                    logger.debug("Not cleaning up {} ([{}, {}]) - no tokens outside owned ranges {}", new Object[]{sstable, sstable.first.getToken(), sstable.last.getToken(), ranges});
                    sstableIter.remove();
                    transaction.cancel(sstable);
                    ++skippedSStables;
                }
                logger.info("Skipping cleanup for {}/{} sstables for {}.{} since they are fully contained in owned ranges ({})", new Object[]{skippedSStables, totalSSTables, cfStore.keyspace.getName(), cfStore.getTableName(), ranges});
                sortedSSTables.sort(new SSTableReader.SizeComparator());
                return sortedSSTables;
            }

            @Override
            public void execute(LifecycleTransaction txn) throws IOException {
                CleanupStrategy cleanupStrategy = CleanupStrategy.get(cfStore, ranges, FBUtilities.nowInSeconds());
                CompactionManager.this.doCleanupOne(cfStore, txn, cleanupStrategy, ranges, hasIndexes);
            }
        }, jobs, OperationType.CLEANUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> submitAntiCompaction(final ColumnFamilyStore cfs, final Collection<Range<Token>> ranges, final Refs<SSTableReader> sstables, final long repairedAt, final UUID parentRepairSession) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                LifecycleTransaction modifier = null;
                while (modifier == null) {
                    for (SSTableReader compactingSSTable : cfs.getTracker().getCompacting()) {
                        sstables.releaseIfHolds(compactingSSTable);
                    }
                    HashSet<SSTableReader> compactedSSTables = new HashSet<SSTableReader>();
                    for (SSTableReader sstable : sstables) {
                        if (!sstable.isMarkedCompacted()) continue;
                        compactedSSTables.add(sstable);
                    }
                    sstables.release(compactedSSTables);
                    modifier = cfs.getTracker().tryModify(sstables, OperationType.ANTICOMPACTION);
                }
                CompactionManager.this.performAnticompaction(cfs, ranges, sstables, modifier, repairedAt, parentRepairSession);
            }
        };
        ListenableFuture<?> ret = null;
        try {
            ListenableFuture<?> listenableFuture = ret = this.executor.submitIfRunning(runnable, "anticompaction");
            return listenableFuture;
        }
        finally {
            if (ret == null || ret.isCancelled()) {
                sstables.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAnticompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Refs<SSTableReader> validatedForRepair, LifecycleTransaction txn, long repairedAt, UUID parentRepairSession) throws InterruptedException, IOException {
        logger.info("[repair #{}] Starting anticompaction for {}.{} on {}/{} sstables", new Object[]{parentRepairSession, cfs.keyspace.getName(), cfs.getTableName(), validatedForRepair.size(), cfs.getLiveSSTables()});
        logger.trace("[repair #{}] Starting anticompaction for ranges {}", (Object)parentRepairSession, ranges);
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>(validatedForRepair);
        HashSet<SSTableReader> mutatedRepairStatuses = new HashSet<SSTableReader>();
        HashSet<SSTableReader> nonAnticompacting = new HashSet<SSTableReader>();
        Iterator sstableIterator = sstables.iterator();
        try {
            List normalizedRanges = Range.normalize(ranges);
            while (sstableIterator.hasNext()) {
                SSTableReader sstable = (SSTableReader)sstableIterator.next();
                ArrayList<String> anticompactRanges = new ArrayList<String>();
                if (sstable.isRepaired()) {
                    nonAnticompacting.add(sstable);
                }
                Bounds<Token> sstableBounds = new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken());
                boolean shouldAnticompact = false;
                for (Range<RingPosition> range : normalizedRanges) {
                    if (range.contains(sstableBounds.left) && range.contains(sstableBounds.right)) {
                        logger.info("[repair #{}] SSTable {} fully contained in range {}, mutating repairedAt instead of anticompacting", new Object[]{parentRepairSession, sstable, range});
                        sstable.descriptor.getMetadataSerializer().mutateRepairedAt(sstable.descriptor, repairedAt);
                        sstable.reloadSSTableMetadata();
                        if (!nonAnticompacting.contains(sstable)) {
                            mutatedRepairStatuses.add(sstable);
                        }
                        sstableIterator.remove();
                        shouldAnticompact = true;
                        break;
                    }
                    if (!range.intersects(sstableBounds) || nonAnticompacting.contains(sstable)) continue;
                    anticompactRanges.add(range.toString());
                    shouldAnticompact = true;
                }
                if (!anticompactRanges.isEmpty()) {
                    logger.info("[repair #{}] SSTable {} ({}) will be anticompacted on range {}", new Object[]{parentRepairSession, sstable, sstableBounds, String.join((CharSequence)", ", anticompactRanges)});
                }
                if (shouldAnticompact) continue;
                logger.info("[repair #{}] SSTable {} ({}) not subject to anticompaction of repaired ranges {}, not touching repairedAt.", new Object[]{parentRepairSession, sstable, sstableBounds, normalizedRanges});
                nonAnticompacting.add(sstable);
                sstableIterator.remove();
            }
            cfs.getTracker().notifySSTableRepairedStatusChanged(mutatedRepairStatuses);
            txn.cancel((Iterable<SSTableReader>)Sets.union(nonAnticompacting, mutatedRepairStatuses));
            validatedForRepair.release((Collection<SSTableReader>)Sets.union(nonAnticompacting, mutatedRepairStatuses));
            assert (txn.originals().equals(sstables));
            if (!sstables.isEmpty()) {
                this.doAntiCompaction(cfs, ranges, txn, repairedAt);
            }
            txn.finish();
        }
        finally {
            validatedForRepair.release();
            txn.close();
        }
        logger.info("[repair #{}] Completed anticompaction successfully", (Object)parentRepairSession);
    }

    public void performMaximal(ColumnFamilyStore cfStore, boolean splitOutput) {
        FBUtilities.waitOnFutures(this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore, FBUtilities.nowInSeconds()), splitOutput));
    }

    public List<Future<?>> submitMaximal(ColumnFamilyStore cfStore, int gcBefore, boolean splitOutput) {
        Collection<AbstractCompactionTask> tasks = cfStore.getCompactionStrategyManager().getMaximalTasks(gcBefore, splitOutput);
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList futures = new ArrayList();
        int nonEmptyTasks = 0;
        for (final AbstractCompactionTask task : tasks) {
            WrappedRunnable runnable;
            ListenableFuture<?> fut;
            if (task.transaction.originals().size() > 0) {
                ++nonEmptyTasks;
            }
            if ((fut = this.executor.submitIfRunning(runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws IOException {
                    task.execute(CompactionManager.this.metrics);
                }
            }, "maximal task")).isCancelled()) continue;
            futures.add((Future<?>)fut);
        }
        if (nonEmptyTasks > 1) {
            logger.info("Cannot perform a full major compaction as repaired and unrepaired sstables cannot be compacted together. These two set of sstables will be compacted separately.");
        }
        return futures;
    }

    @Override
    public void forceUserDefinedCompaction(String dataFiles) {
        String[] filenames = dataFiles.split(",");
        ArrayListMultimap descriptors = ArrayListMultimap.create();
        for (String filename : filenames) {
            Descriptor desc = Descriptor.fromFilename(filename.trim());
            if (Schema.instance.getCFMetaData(desc) == null) {
                logger.warn("Schema does not exist for file {}. Skipping.", (Object)filename);
                continue;
            }
            ColumnFamilyStore cfs = Keyspace.open(desc.ksname).getColumnFamilyStore(desc.cfname);
            descriptors.put((Object)cfs, (Object)cfs.getDirectories().find(new File(filename.trim()).getName()));
        }
        ArrayList futures = new ArrayList();
        int nowInSec = FBUtilities.nowInSeconds();
        for (ColumnFamilyStore cfs : descriptors.keySet()) {
            futures.add(this.submitUserDefined(cfs, descriptors.get((Object)cfs), CompactionManager.getDefaultGcBefore(cfs, nowInSec)));
        }
        FBUtilities.waitOnFutures(futures);
    }

    public Future<?> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(dataFiles.size());
                for (Descriptor desc : dataFiles) {
                    SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                    if (sstable == null) {
                        logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                        continue;
                    }
                    sstables.add(sstable);
                }
                if (sstables.isEmpty()) {
                    logger.info("No files to compact for user defined compaction");
                } else {
                    AbstractCompactionTask task = cfs.getCompactionStrategyManager().getUserDefinedTask(sstables, gcBefore);
                    if (task != null) {
                        task.execute(CompactionManager.this.metrics);
                    }
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "user defined task");
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        for (SSTableReader sstable : cfs.getSSTables(SSTableSet.CANONICAL)) {
            if (!sstable.descriptor.equals(descriptor)) continue;
            return sstable;
        }
        return null;
    }

    public Future<?> submitValidation(final ColumnFamilyStore cfStore, final Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try {
                    CompactionManager.this.doValidationCompaction(cfStore, validator);
                }
                catch (Throwable e) {
                    validator.fail();
                    throw e;
                }
                return this;
            }
        };
        return this.validationExecutor.submitIfRunning(callable, "validation");
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemKeyspaces()) {
            for (ColumnFamilyStore cfs : Keyspace.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubOne(ColumnFamilyStore cfs, LifecycleTransaction modifier, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL) throws IOException {
        CompactionInfo.Holder scrubInfo = null;
        try {
            try (Scrubber scrubber = new Scrubber(cfs, modifier, skipCorrupted, checkData, reinsertOverflowedTTL);){
                scrubInfo = scrubber.getScrubInfo();
                this.metrics.beginCompaction(scrubInfo);
                scrubber.scrub();
            }
            if (scrubInfo != null) {
                this.metrics.finishCompaction(scrubInfo);
            }
        }
        catch (Throwable throwable) {
            if (scrubInfo != null) {
                this.metrics.finishCompaction(scrubInfo);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOne(ColumnFamilyStore cfs, SSTableReader sstable, boolean extendedVerify) throws IOException {
        CompactionInfo.Holder verifyInfo = null;
        try {
            try (Verifier verifier = new Verifier(cfs, sstable, false);){
                verifyInfo = verifier.getVerifyInfo();
                this.metrics.beginCompaction(verifyInfo);
                verifier.verify(extendedVerify);
            }
            if (verifyInfo != null) {
                this.metrics.finishCompaction(verifyInfo);
            }
        }
        catch (Throwable throwable) {
            if (verifyInfo != null) {
                this.metrics.finishCompaction(verifyInfo);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public static boolean needsCleanup(SSTableReader sstable, Collection<Range<Token>> ownedRanges) {
        if (ownedRanges.isEmpty()) {
            return true;
        }
        List sortedRanges = Range.normalize(ownedRanges);
        Range firstRange = sortedRanges.get(0);
        if (sstable.first.getToken().compareTo(firstRange.left) <= 0) {
            return true;
        }
        for (int i = 0; i < sortedRanges.size(); ++i) {
            Range range = sortedRanges.get(i);
            if (((Token)range.right).isMinimum()) {
                return false;
            }
            DecoratedKey firstBeyondRange = sstable.firstKeyBeyond(((Token)range.right).maxKeyBound());
            if (firstBeyondRange == null) {
                return false;
            }
            if (i == sortedRanges.size() - 1) {
                return true;
            }
            Range nextRange = sortedRanges.get(i + 1);
            if (firstBeyondRange.getToken().compareTo(nextRange.left) > 0) continue;
            return true;
        }
        return false;
    }

    private void doCleanupOne(ColumnFamilyStore cfs, LifecycleTransaction txn, CleanupStrategy cleanupStrategy, Collection<Range<Token>> ranges, boolean hasIndexes) throws IOException {
        Object finished;
        Object object;
        assert (!cfs.isIndex());
        SSTableReader sstable = txn.onlyOne();
        if (!hasIndexes && !((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges)) {
            txn.obsoleteOriginals();
            txn.finish();
            logger.info("SSTable {} ([{}, {}]) does not intersect the owned ranges ({}), dropping it", new Object[]{sstable, sstable.first.getToken(), sstable.last.getToken(), ranges});
            return;
        }
        long start = System.nanoTime();
        long totalkeysWritten = 0L;
        long expectedBloomFilterSize = Math.max((long)cfs.metadata.params.minIndexInterval, SSTableReader.getApproximateKeyCount(txn.originals()));
        if (logger.isTraceEnabled()) {
            logger.trace("Expected bloom filter size : {}", (Object)expectedBloomFilterSize);
        }
        logger.info("Cleaning up {}", (Object)sstable);
        File compactionFileLocation = cfs.getDirectories().getWriteableLocationAsFile(cfs.getExpectedCompactedFileSize(txn.originals(), OperationType.CLEANUP));
        if (compactionFileLocation == null) {
            throw new IOException("disk full");
        }
        int nowInSec = FBUtilities.nowInSeconds();
        try (SSTableRewriter writer = SSTableRewriter.construct(cfs, txn, false, sstable.maxDataAge, false);
             ISSTableScanner scanner = cleanupStrategy.getScanner(sstable, this.getRateLimiter());
             CompactionController controller = new CompactionController(cfs, txn.originals(), CompactionManager.getDefaultGcBefore(cfs, nowInSec));){
            Refs<SSTableReader> refs = Refs.ref(Collections.singleton(sstable));
            object = null;
            try (CompactionIterator ci2 = new CompactionIterator(OperationType.CLEANUP, Collections.singletonList(scanner), controller, nowInSec, UUIDGen.getTimeUUID(), this.metrics);){
                writer.switchWriter(CompactionManager.createWriter(cfs, compactionFileLocation, expectedBloomFilterSize, sstable.getSSTableMetadata().repairedAt, sstable, txn));
                while (ci2.hasNext()) {
                    if (ci2.isStopRequested()) {
                        throw new CompactionInterruptedException(ci2.getCompactionInfo());
                    }
                    UnfilteredRowIterator partition = ci2.next();
                    Throwable throwable = null;
                    try {
                        UnfilteredRowIterator notCleaned = cleanupStrategy.cleanup(partition);
                        Throwable throwable2 = null;
                        try {
                            if (notCleaned == null || writer.append(notCleaned) == null) continue;
                            ++totalkeysWritten;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (notCleaned == null) continue;
                            if (throwable2 != null) {
                                try {
                                    notCleaned.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            notCleaned.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                cfs.indexManager.flushAllIndexesBlocking();
                finished = writer.finish();
            }
            catch (Throwable ci2) {
                object = ci2;
                throw ci2;
            }
            finally {
                if (refs != null) {
                    if (object != null) {
                        try {
                            refs.close();
                        }
                        catch (Throwable ci2) {
                            ((Throwable)object).addSuppressed(ci2);
                        }
                    } else {
                        refs.close();
                    }
                }
            }
        }
        if (!finished.isEmpty()) {
            String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
            long dTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long startsize = sstable.onDiskLength();
            long endsize = 0L;
            object = finished.iterator();
            while (object.hasNext()) {
                SSTableReader newSstable = (SSTableReader)object.next();
                endsize += newSstable.onDiskLength();
            }
            double ratio = (double)endsize / (double)startsize;
            logger.info(String.format(format, ((SSTableReader)finished.get(0)).getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
        }
    }

    public static SSTableWriter createWriter(ColumnFamilyStore cfs, File compactionFileLocation, long expectedBloomFilterSize, long repairedAt, SSTableReader sstable, LifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        SerializationHeader header = sstable.header;
        if (header == null) {
            header = SerializationHeader.make(sstable.metadata, Collections.singleton(sstable));
        }
        return SSTableWriter.create(cfs.metadata, Descriptor.fromFilename(cfs.getSSTablePath(compactionFileLocation)), expectedBloomFilterSize, repairedAt, sstable.getSSTableLevel(), header, (LifecycleNewTracker)txn);
    }

    public static SSTableWriter createWriterForAntiCompaction(ColumnFamilyStore cfs, File compactionFileLocation, int expectedBloomFilterSize, long repairedAt, Collection<SSTableReader> sstables, ILifecycleTransaction txn) {
        FileUtils.createDirectory(compactionFileLocation);
        int minLevel = Integer.MAX_VALUE;
        for (SSTableReader sstable : sstables) {
            if (minLevel == Integer.MAX_VALUE) {
                minLevel = sstable.getSSTableLevel();
            }
            if (minLevel == sstable.getSSTableLevel()) continue;
            minLevel = 0;
            break;
        }
        return SSTableWriter.create(Descriptor.fromFilename(cfs.getSSTablePath(compactionFileLocation)), Long.valueOf(expectedBloomFilterSize), (Long)repairedAt, cfs.metadata, new MetadataCollector(sstables, cfs.metadata.comparator, minLevel), SerializationHeader.make(cfs.metadata, sstables), (LifecycleNewTracker)txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, Validator validator) throws IOException {
        if (!cfs.isValid()) {
            return;
        }
        Refs<SSTableReader> sstables = null;
        try {
            int gcBefore;
            int nowInSec = FBUtilities.nowInSeconds();
            UUID parentRepairSessionId = validator.desc.parentSessionId;
            boolean isGlobalSnapshotValidation = cfs.snapshotExists(parentRepairSessionId.toString());
            String snapshotName = isGlobalSnapshotValidation ? parentRepairSessionId.toString() : validator.desc.sessionId.toString();
            boolean isSnapshotValidation = cfs.snapshotExists(snapshotName);
            if (isSnapshotValidation) {
                sstables = cfs.getSnapshotSSTableReader(snapshotName);
                gcBefore = cfs.gcBefore((int)(cfs.getSnapshotCreationTime(snapshotName) / 1000L));
            } else {
                StorageService.instance.forceKeyspaceFlush(cfs.keyspace.getName(), cfs.name);
                sstables = this.getSSTablesToValidate(cfs, validator);
                if (sstables == null) {
                    return;
                }
                gcBefore = validator.gcBefore > 0 ? validator.gcBefore : CompactionManager.getDefaultGcBefore(cfs, nowInSec);
            }
            MerkleTrees tree = CompactionManager.createMerkleTrees(sstables, validator.desc.ranges, cfs);
            long start = System.nanoTime();
            try (AbstractCompactionStrategy.ScannerList scanners = cfs.getCompactionStrategyManager().getScanners(sstables, validator.desc.ranges);
                 ValidationCompactionController controller = new ValidationCompactionController(cfs, gcBefore);
                 ValidationCompactionIterator ci = new ValidationCompactionIterator(scanners.scanners, controller, nowInSec, this.metrics);){
                validator.prepare(cfs, tree);
                while (ci.hasNext()) {
                    if (ci.isStopRequested()) {
                        throw new CompactionInterruptedException(ci.getCompactionInfo());
                    }
                    UnfilteredRowIterator partition = ci.next();
                    Throwable throwable = null;
                    try {
                        validator.add(partition);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                validator.complete();
            }
            finally {
                if (isSnapshotValidation && !isGlobalSnapshotValidation) {
                    cfs.clearSnapshot(snapshotName);
                }
            }
            if (logger.isDebugEnabled()) {
                long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                logger.debug("Validation finished in {} msec, for {}", (Object)duration, (Object)validator.desc);
            }
        }
        finally {
            if (sstables != null) {
                sstables.release();
            }
        }
    }

    private static MerkleTrees createMerkleTrees(Iterable<SSTableReader> sstables, Collection<Range<Token>> ranges, ColumnFamilyStore cfs) {
        long numPartitions;
        MerkleTrees tree = new MerkleTrees(cfs.getPartitioner());
        long allPartitions = 0L;
        HashMap<Range<Token>, Long> rangePartitionCounts = new HashMap<Range<Token>, Long>();
        for (Range<Token> range : ranges) {
            numPartitions = 0L;
            for (SSTableReader sstable : sstables) {
                numPartitions += sstable.estimatedKeysForRanges(Collections.singleton(range));
            }
            rangePartitionCounts.put(range, numPartitions);
            allPartitions += numPartitions;
        }
        for (Range<Token> range : ranges) {
            numPartitions = (Long)rangePartitionCounts.get(range);
            double rangeOwningRatio = allPartitions > 0L ? (double)numPartitions / (double)allPartitions : 0.0;
            int maxDepth = rangeOwningRatio > 0.0 ? (int)Math.floor(Math.max(0.0, (double)DatabaseDescriptor.getRepairSessionMaxTreeDepth() - Math.log(1.0 / rangeOwningRatio) / Math.log(2.0))) : 0;
            int depth = numPartitions > 0L ? (int)Math.min(Math.ceil(Math.log(numPartitions) / Math.log(2.0)), (double)maxDepth) : 0;
            tree.addMerkleTree((int)Math.pow(2.0, depth), range);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created {} merkle trees with merkle trees size {}, {} partitions, {} bytes", new Object[]{tree.ranges().size(), tree.size(), allPartitions, MerkleTrees.serializer.serializedSize(tree, 0)});
        }
        return tree;
    }

    private synchronized Refs<SSTableReader> getSSTablesToValidate(ColumnFamilyStore cfs, Validator validator) {
        Refs<SSTableReader> sstables;
        ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(validator.desc.parentSessionId);
        if (prs == null) {
            return null;
        }
        HashSet<SSTableReader> sstablesToValidate = new HashSet<SSTableReader>();
        if (prs.isGlobal) {
            prs.markSSTablesRepairing(cfs.metadata.cfId, validator.desc.parentSessionId);
        }
        try (ColumnFamilyStore.RefViewFragment sstableCandidates = cfs.selectAndReference(View.select(SSTableSet.CANONICAL, (com.google.common.base.Predicate<SSTableReader>)((com.google.common.base.Predicate)s -> !prs.isIncremental || !s.isRepaired())));){
            for (SSTableReader sstable : sstableCandidates.sstables) {
                if (!((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(validator.desc.ranges)) continue;
                sstablesToValidate.add(sstable);
            }
            sstables = Refs.tryRef(sstablesToValidate);
            if (sstables == null) {
                logger.error("Could not reference sstables");
                throw new RuntimeException("Could not reference sstables");
            }
        }
        return sstables;
    }

    private void doAntiCompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, LifecycleTransaction repaired, long repairedAt) {
        int numAnticompact = repaired.originals().size();
        logger.info("Performing anticompaction on {} sstables", (Object)numAnticompact);
        Collection<Collection<SSTableReader>> groupedSSTables = cfs.getCompactionStrategyManager().groupSSTablesForAntiCompaction(repaired.originals());
        int antiCompactedSSTableCount = 0;
        for (Collection<SSTableReader> sstableGroup : groupedSSTables) {
            LifecycleTransaction txn = repaired.split(sstableGroup);
            Throwable throwable = null;
            try {
                int antiCompacted = this.antiCompactGroup(cfs, ranges, txn, repairedAt);
                antiCompactedSSTableCount += antiCompacted;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txn == null) continue;
                if (throwable != null) {
                    try {
                        txn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txn.close();
            }
        }
        String format = "Anticompaction completed successfully, anticompacted from {} to {} sstable(s).";
        logger.info(format, (Object)numAnticompact, (Object)antiCompactedSSTableCount);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    int antiCompactGroup(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, LifecycleTransaction anticompactionGroup, long repairedAt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Future<?> submitIndexBuild(final SecondaryIndexBuilder builder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompactionManager.this.metrics.beginCompaction(builder);
                try {
                    builder.build();
                }
                finally {
                    CompactionManager.this.metrics.finishCompaction(builder);
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "index build");
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!AutoSavingCache.flushInProgress.add(writer.cacheType())) {
                    logger.trace("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.metrics.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.metrics.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.remove((Object)writer.cacheType());
                }
            }
        };
        return this.executor.submitIfRunning(runnable, "cache write");
    }

    public List<SSTableReader> runIndexSummaryRedistribution(IndexSummaryRedistribution redistribution) throws IOException {
        this.metrics.beginCompaction(redistribution);
        try {
            List<SSTableReader> list = redistribution.redistributeSummaries();
            return list;
        }
        finally {
            this.metrics.finishCompaction(redistribution);
        }
    }

    public static int getDefaultGcBefore(ColumnFamilyStore cfs, int nowInSec) {
        return cfs.isIndex() ? nowInSec : cfs.gcBefore(nowInSec);
    }

    public Future<?> submitViewBuilder(final ViewBuilder builder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompactionManager.this.metrics.beginCompaction(builder);
                try {
                    builder.run();
                }
                finally {
                    CompactionManager.this.metrics.finishCompaction(builder);
                }
            }
        };
        if (this.executor.isShutdown()) {
            logger.info("Compaction executor has shut down, not submitting index build");
            return null;
        }
        return this.executor.submit(runnable);
    }

    public int getActiveCompactions() {
        return CompactionMetrics.getCompactions().size();
    }

    @Override
    public List<Map<String, String>> getCompactions() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().asMap());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<String> out = new ArrayList<String>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public TabularData getCompactionHistory() {
        try {
            return SystemKeyspace.getCompactionHistory();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalBytesCompacted() {
        return this.metrics.bytesCompacted.getCount();
    }

    public long getTotalCompactionsCompleted() {
        return this.metrics.totalCompactionsCompleted.getCount();
    }

    public int getPendingTasks() {
        return (Integer)this.metrics.pendingTasks.getValue();
    }

    public long getCompletedTasks() {
        return (Long)this.metrics.completedTasks.getValue();
    }

    @Override
    public void stopCompaction(String type) {
        OperationType operation = OperationType.valueOf(type);
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            if (holder.getCompactionInfo().getTaskType() != operation) continue;
            holder.stop();
        }
    }

    @Override
    public void stopCompactionById(String compactionId) {
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            UUID holderId = holder.getCompactionInfo().compactionId();
            if (holderId == null || !holderId.equals(UUID.fromString(compactionId))) continue;
            holder.stop();
        }
    }

    @Override
    public int getCoreCompactorThreads() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public void setCoreCompactorThreads(int number) {
        this.executor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumCompactorThreads() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumCompactorThreads(int number) {
        this.executor.setMaximumPoolSize(number);
    }

    @Override
    public int getCoreValidationThreads() {
        return this.validationExecutor.getCorePoolSize();
    }

    @Override
    public void setCoreValidationThreads(int number) {
        this.validationExecutor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumValidatorThreads() {
        return this.validationExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumValidatorThreads(int number) {
        this.validationExecutor.setMaximumPoolSize(number);
    }

    public void interruptCompactionFor(Iterable<CFMetaData> columnFamilies, boolean interruptValidation) {
        assert (columnFamilies != null);
        for (CompactionInfo.Holder compactionHolder : CompactionMetrics.getCompactions()) {
            CompactionInfo info = compactionHolder.getCompactionInfo();
            if (info.getTaskType() == OperationType.VALIDATION && !interruptValidation || info.getCFMetaData() != null && !Iterables.contains(columnFamilies, (Object)info.getCFMetaData())) continue;
            compactionHolder.stop();
        }
    }

    public void interruptCompactionForCFs(Iterable<ColumnFamilyStore> cfss, boolean interruptValidation) {
        ArrayList<CFMetaData> metadata = new ArrayList<CFMetaData>();
        for (ColumnFamilyStore cfs : cfss) {
            metadata.add(cfs.metadata);
        }
        this.interruptCompactionFor(metadata, interruptValidation);
    }

    public void waitForCessation(Iterable<ColumnFamilyStore> cfss) {
        long start = System.nanoTime();
        long delay = TimeUnit.MINUTES.toNanos(1L);
        while (System.nanoTime() - start < delay && instance.isCompacting(cfss)) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public boolean isGlobalCompactionPaused() {
        return this.globalCompactionPauseCount.get() > 0;
    }

    public CompactionPauser pauseGlobalCompaction() {
        CompactionPauser pauser = this.globalCompactionPauseCount::decrementAndGet;
        this.globalCompactionPauseCount.incrementAndGet();
        return pauser;
    }

    static {
        isCompactionManager = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        instance = new CompactionManager();
        MBeanWrapper.instance.registerMBean((Object)instance, MBEAN_OBJECT_NAME);
    }

    public static interface CompactionPauser
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface CompactionExecutorStatsCollector {
        public void beginCompaction(CompactionInfo.Holder var1);

        public void finishCompaction(CompactionInfo.Holder var1);
    }

    private static class CacheCleanupExecutor
    extends CompactionExecutor {
        public CacheCleanupExecutor() {
            super(1, "CacheCleanupExecutor");
        }
    }

    private static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(1, Integer.MAX_VALUE, "ValidationExecutor", new SynchronousQueue<Runnable>());
        }
    }

    static class CompactionExecutor
    extends JMXEnabledThreadPoolExecutor {
        protected CompactionExecutor(int minThreads, int maxThreads, String name, BlockingQueue<Runnable> queue) {
            super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name, 1), "internal");
        }

        private CompactionExecutor(int threadCount, String name) {
            this(threadCount, threadCount, name, new LinkedBlockingQueue<Runnable>());
        }

        public CompactionExecutor() {
            this(Math.max(1, DatabaseDescriptor.getConcurrentCompactors()), "CompactionExecutor");
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            isCompactionManager.set(true);
            super.beforeExecute(t, r);
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            DebuggableThreadPoolExecutor.maybeResetTraceSessionWrapper(r);
            if (t == null) {
                t = DebuggableThreadPoolExecutor.extractThrowable(r);
            }
            if (t != null) {
                if (t instanceof CompactionInterruptedException) {
                    logger.info(t.getMessage());
                    if (t.getSuppressed() != null && t.getSuppressed().length > 0) {
                        logger.warn("Interruption of compaction encountered exceptions:", t);
                    } else {
                        logger.trace("Full interruption stack trace:", t);
                    }
                } else {
                    DebuggableThreadPoolExecutor.handleOrLog(t);
                }
            }
            SnapshotDeletingTask.rescheduleFailedTasks();
        }

        public ListenableFuture<?> submitIfRunning(Runnable task, String name) {
            return this.submitIfRunning(Executors.callable(task, null), name);
        }

        public ListenableFuture<?> submitIfRunning(Callable<?> task, String name) {
            if (this.isShutdown()) {
                logger.info("Executor has been shut down, not submitting {}", (Object)name);
                return Futures.immediateCancelledFuture();
            }
            try {
                ListenableFutureTask ret = ListenableFutureTask.create(task);
                this.execute((Runnable)ret);
                return ret;
            }
            catch (RejectedExecutionException ex) {
                if (this.isShutdown()) {
                    logger.info("Executor has shut down, could not submit {}", (Object)name);
                } else {
                    logger.error("Failed to submit {}", (Object)name, (Object)ex);
                }
                return Futures.immediateCancelledFuture();
            }
        }
    }

    private static class ValidationCompactionController
    extends CompactionController {
        public ValidationCompactionController(ColumnFamilyStore cfs, int gcBefore) {
            super(cfs, gcBefore);
        }

        @Override
        public Predicate<Long> getPurgeEvaluator(DecoratedKey key) {
            return time -> true;
        }
    }

    private static class ValidationCompactionIterator
    extends CompactionIterator {
        public ValidationCompactionIterator(List<ISSTableScanner> scanners, ValidationCompactionController controller, int nowInSec, CompactionMetrics metrics) {
            super(OperationType.VALIDATION, scanners, controller, nowInSec, UUIDGen.getTimeUUID(), metrics);
        }
    }

    private static abstract class CleanupStrategy {
        protected final Collection<Range<Token>> ranges;
        protected final int nowInSec;

        protected CleanupStrategy(Collection<Range<Token>> ranges, int nowInSec) {
            this.ranges = ranges;
            this.nowInSec = nowInSec;
        }

        public static CleanupStrategy get(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
            return cfs.indexManager.hasIndexes() ? new Full(cfs, ranges, nowInSec) : new Bounded(cfs, ranges, nowInSec);
        }

        public abstract ISSTableScanner getScanner(SSTableReader var1, RateLimiter var2);

        public abstract UnfilteredRowIterator cleanup(UnfilteredRowIterator var1);

        private static final class Full
        extends CleanupStrategy {
            private final ColumnFamilyStore cfs;

            public Full(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
                super(ranges, nowInSec);
                this.cfs = cfs;
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(limiter);
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                if (Range.isInRanges(partition.partitionKey().getToken(), this.ranges)) {
                    return partition;
                }
                this.cfs.invalidateCachedPartition(partition.partitionKey());
                this.cfs.indexManager.deletePartition(partition, this.nowInSec);
                return null;
            }
        }

        private static final class Bounded
        extends CleanupStrategy {
            public Bounded(final ColumnFamilyStore cfs, Collection<Range<Token>> ranges, int nowInSec) {
                super(ranges, nowInSec);
                instance.cacheCleanupExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        cfs.cleanupCache();
                    }
                });
            }

            @Override
            public ISSTableScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(this.ranges, limiter);
            }

            @Override
            public UnfilteredRowIterator cleanup(UnfilteredRowIterator partition) {
                return partition;
            }
        }
    }

    public static enum AllSSTableOpStatus {
        SUCCESSFUL(0),
        ABORTED(1),
        UNABLE_TO_CANCEL(2);

        public final int statusCode;

        private AllSSTableOpStatus(int statusCode) {
            this.statusCode = statusCode;
        }
    }

    private static interface OneSSTableOperation {
        public Iterable<SSTableReader> filterSSTables(LifecycleTransaction var1);

        public void execute(LifecycleTransaction var1) throws IOException;
    }

    class BackgroundCompactionCandidate
    implements Runnable {
        private final ColumnFamilyStore cfs;

        BackgroundCompactionCandidate(ColumnFamilyStore cfs) {
            CompactionManager.this.compactingCF.add((Object)cfs);
            this.cfs = cfs;
        }

        @Override
        public void run() {
            try {
                logger.trace("Checking {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.name);
                if (!this.cfs.isValid()) {
                    logger.trace("Aborting compaction for dropped CF");
                    return;
                }
                CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
                AbstractCompactionTask task = strategy.getNextBackgroundTask(CompactionManager.getDefaultGcBefore(this.cfs, FBUtilities.nowInSeconds()));
                if (task == null) {
                    logger.trace("No tasks available");
                    return;
                }
                task.execute(CompactionManager.this.metrics);
            }
            finally {
                CompactionManager.this.compactingCF.remove((Object)this.cfs);
            }
            CompactionManager.this.submitBackground(this.cfs);
        }
    }
}

