/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnException;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PurgeFunction;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexNotAvailableException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.UnknownIndexException;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadCommand
implements ReadQuery {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCommand.class);
    public static final IVersionedSerializer<ReadCommand> serializer = new Serializer();
    public static final IVersionedSerializer<ReadCommand> rangeSliceSerializer = new RangeSliceSerializer();
    public static final IVersionedSerializer<ReadCommand> legacyRangeSliceCommandSerializer = new LegacyRangeSliceCommandSerializer();
    public static final IVersionedSerializer<ReadCommand> legacyPagedRangeCommandSerializer = new LegacyPagedRangeCommandSerializer();
    public static final IVersionedSerializer<ReadCommand> legacyReadCommandSerializer = new LegacyReadCommandSerializer();
    private final Kind kind;
    private final CFMetaData metadata;
    private final int nowInSec;
    private final ColumnFilter columnFilter;
    private final RowFilter rowFilter;
    private final DataLimits limits;
    protected Optional<IndexMetadata> index = Optional.empty();
    private boolean indexManagerQueried = false;
    private boolean isDigestQuery;
    private int digestVersion;
    private final boolean isForThrift;

    protected ReadCommand(Kind kind, boolean isDigestQuery, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits) {
        this.kind = kind;
        this.isDigestQuery = isDigestQuery;
        this.digestVersion = digestVersion;
        this.isForThrift = isForThrift;
        this.metadata = metadata;
        this.nowInSec = nowInSec;
        this.columnFilter = columnFilter;
        this.rowFilter = rowFilter;
        this.limits = limits;
    }

    protected abstract void serializeSelection(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long selectionSerializedSize(int var1);

    public CFMetaData metadata() {
        return this.metadata;
    }

    public int nowInSec() {
        return this.nowInSec;
    }

    public abstract long getTimeout();

    public ColumnFilter columnFilter() {
        return this.columnFilter;
    }

    public RowFilter rowFilter() {
        return this.rowFilter;
    }

    @Override
    public DataLimits limits() {
        return this.limits;
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public int digestVersion() {
        return this.digestVersion;
    }

    public ReadCommand setIsDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery = isDigestQuery;
        return this;
    }

    public ReadCommand setDigestVersion(int digestVersion) {
        this.digestVersion = digestVersion;
        return this;
    }

    public boolean isForThrift() {
        return this.isForThrift;
    }

    public abstract ClusteringIndexFilter clusteringIndexFilter(DecoratedKey var1);

    public abstract ReadCommand copy();

    protected abstract UnfilteredPartitionIterator queryStorage(ColumnFamilyStore var1, ReadOrderGroup var2);

    protected abstract int oldestUnrepairedTombstone();

    public ReadResponse createResponse(UnfilteredPartitionIterator iterator) {
        return this.isDigestQuery() ? ReadResponse.createDigestResponse(iterator, this) : ReadResponse.createDataResponse(iterator, this);
    }

    public long indexSerializedSize(int version) {
        if (this.index.isPresent()) {
            return IndexMetadata.serializer.serializedSize(this.index.get(), version);
        }
        return 0L;
    }

    public Index getIndex(ColumnFamilyStore cfs) {
        if (this.index.isPresent()) {
            return cfs.indexManager.getIndex(this.index.get());
        }
        if (this.indexManagerQueried) {
            return null;
        }
        Index selected = cfs.indexManager.getBestIndexFor(this);
        this.indexManagerQueried = true;
        if (selected == null) {
            return null;
        }
        this.index = Optional.of(selected.getIndexMetadata());
        return selected;
    }

    public UnfilteredPartitionIterator executeLocally(ReadOrderGroup orderGroup) {
        long startTimeNanos = System.nanoTime();
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(this.metadata());
        Index index = this.getIndex(cfs);
        Index.Searcher searcher = null;
        if (index != null) {
            if (!cfs.indexManager.isIndexQueryable(index)) {
                throw new IndexNotAvailableException(index);
            }
            searcher = index.searcherFor(this);
            Tracing.trace("Executing read on {}.{} using index {}", cfs.metadata.ksName, cfs.metadata.cfName, index.getIndexMetadata().name);
        }
        UnfilteredPartitionIterator resultIterator = searcher == null ? this.queryStorage(cfs, orderGroup) : searcher.search(orderGroup);
        try {
            resultIterator = this.withMetricsRecording(this.withoutPurgeableTombstones(resultIterator, cfs), cfs.metric, startTimeNanos);
            RowFilter updatedFilter = searcher == null ? this.rowFilter() : index.getPostIndexQueryFilter(this.rowFilter());
            return this.limits().filter(updatedFilter.filter(resultIterator, this.nowInSec()), this.nowInSec());
        }
        catch (Error | RuntimeException e) {
            resultIterator.close();
            throw e;
        }
    }

    protected abstract void recordLatency(TableMetrics var1, long var2);

    @Override
    public PartitionIterator executeInternal(ReadOrderGroup orderGroup) {
        return UnfilteredPartitionIterators.filter(this.executeLocally(orderGroup), this.nowInSec());
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        return ReadOrderGroup.forCommand(this);
    }

    private UnfilteredPartitionIterator withMetricsRecording(UnfilteredPartitionIterator iter, final TableMetrics metric, final long startTimeNanos) {
        class MetricRecording
        extends Transformation<UnfilteredRowIterator> {
            private final int failureThreshold = DatabaseDescriptor.getTombstoneFailureThreshold();
            private final int warningThreshold = DatabaseDescriptor.getTombstoneWarnThreshold();
            private final boolean respectTombstoneThresholds;
            private int liveRows;
            private int tombstones;
            private DecoratedKey currentKey;

            MetricRecording() {
                this.respectTombstoneThresholds = !Schema.isSystemKeyspace(ReadCommand.this.metadata().ksName);
                this.liveRows = 0;
                this.tombstones = 0;
            }

            @Override
            public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator iter) {
                this.currentKey = iter.partitionKey();
                return Transformation.apply(iter, this);
            }

            @Override
            public Row applyToStatic(Row row) {
                return this.applyToRow(row);
            }

            @Override
            public Row applyToRow(Row row) {
                if (row.hasLiveData(ReadCommand.this.nowInSec())) {
                    ++this.liveRows;
                }
                for (Cell cell : row.cells()) {
                    if (cell.isLive(ReadCommand.this.nowInSec())) continue;
                    this.countTombstone(row.clustering());
                }
                return row;
            }

            @Override
            public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
                this.countTombstone(marker.clustering());
                return marker;
            }

            private void countTombstone(ClusteringPrefix clustering) {
                ++this.tombstones;
                if (this.tombstones > this.failureThreshold && this.respectTombstoneThresholds) {
                    String query = ReadCommand.this.toCQLString();
                    Tracing.trace("Scanned over {} tombstones for query {}; query aborted (see tombstone_failure_threshold)", (Object)this.failureThreshold, (Object)query);
                    throw new TombstoneOverwhelmingException(this.tombstones, query, ReadCommand.this.metadata(), this.currentKey, clustering);
                }
            }

            @Override
            public void onClose() {
                boolean warnTombstones;
                ReadCommand.this.recordLatency(metric, System.nanoTime() - startTimeNanos);
                metric.tombstoneScannedHistogram.update(this.tombstones);
                metric.liveScannedHistogram.update(this.liveRows);
                boolean bl = warnTombstones = this.tombstones > this.warningThreshold && this.respectTombstoneThresholds;
                if (warnTombstones) {
                    String msg = String.format("Read %d live rows and %d tombstone cells for query %1.512s (see tombstone_warn_threshold)", this.liveRows, this.tombstones, ReadCommand.this.toCQLString());
                    ClientWarn.instance.warn(msg);
                    logger.warn(msg);
                }
                Tracing.trace("Read {} live and {} tombstone cells{}", this.liveRows, this.tombstones, warnTombstones ? " (see tombstone_warn_threshold)" : "");
            }
        }
        return Transformation.apply(iter, new MetricRecording());
    }

    public abstract MessageOut<ReadCommand> createMessage(int var1);

    protected abstract void appendCQLWhereClause(StringBuilder var1);

    protected UnfilteredPartitionIterator withoutPurgeableTombstones(UnfilteredPartitionIterator iterator, final ColumnFamilyStore cfs) {
        final boolean isForThrift = iterator.isForThrift();
        class WithoutPurgeableTombstones
        extends PurgeFunction {
            public WithoutPurgeableTombstones() {
                super(bl, ReadCommand.this.nowInSec(), columnFamilyStore.gcBefore(ReadCommand.this.nowInSec()), ReadCommand.this.oldestUnrepairedTombstone(), columnFamilyStore.getCompactionStrategyManager().onlyPurgeRepairedTombstones());
            }

            @Override
            protected long getMaxPurgeableTimestamp() {
                return Long.MAX_VALUE;
            }
        }
        return Transformation.apply(iterator, new WithoutPurgeableTombstones());
    }

    public String toCQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.columnFilter());
        sb.append(" FROM ").append(this.metadata().ksName).append('.').append(this.metadata.cfName);
        this.appendCQLWhereClause(sb);
        if (this.limits() != DataLimits.NONE) {
            sb.append(' ').append(this.limits());
        }
        return sb.toString();
    }

    static class LegacyReadCommandSerializer
    implements IVersionedSerializer<ReadCommand> {
        LegacyReadCommandSerializer() {
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            assert (version < 10);
            assert (command.kind == Kind.SINGLE_PARTITION);
            SinglePartitionReadCommand singleReadCommand = (SinglePartitionReadCommand)command;
            singleReadCommand = LegacyReadCommandSerializer.maybeConvertNamesToSlice(singleReadCommand);
            CFMetaData metadata = singleReadCommand.metadata();
            out.writeByte(LegacyType.fromPartitionFilterKind((ClusteringIndexFilter.Kind)singleReadCommand.clusteringIndexFilter().kind()).serializedValue);
            out.writeBoolean(singleReadCommand.isDigestQuery());
            out.writeUTF(metadata.ksName);
            ByteBufferUtil.writeWithShortLength(singleReadCommand.partitionKey().getKey(), out);
            out.writeUTF(metadata.cfName);
            out.writeLong((long)singleReadCommand.nowInSec() * 1000L);
            if (singleReadCommand.clusteringIndexFilter().kind() == ClusteringIndexFilter.Kind.SLICE) {
                this.serializeSliceCommand(singleReadCommand, out);
            } else {
                this.serializeNamesCommand(singleReadCommand, out);
            }
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            assert (version < 10);
            LegacyType msgType = LegacyType.fromSerializedValue(in.readByte());
            boolean isDigest = in.readBoolean();
            String keyspaceName = in.readUTF();
            ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
            String cfName = in.readUTF();
            long nowInMillis = in.readLong();
            int nowInSeconds = (int)(nowInMillis / 1000L);
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspaceName, cfName);
            DecoratedKey dk = metadata.partitioner.decorateKey(key);
            switch (msgType) {
                case GET_BY_NAMES: {
                    return this.deserializeNamesCommand(in, isDigest, metadata, dk, nowInSeconds, version);
                }
                case GET_SLICES: {
                    return this.deserializeSliceCommand(in, isDigest, metadata, dk, nowInSeconds, version);
                }
            }
            throw new AssertionError();
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            assert (version < 10);
            assert (command.kind == Kind.SINGLE_PARTITION);
            SinglePartitionReadCommand singleReadCommand = (SinglePartitionReadCommand)command;
            singleReadCommand = LegacyReadCommandSerializer.maybeConvertNamesToSlice(singleReadCommand);
            int keySize = singleReadCommand.partitionKey().getKey().remaining();
            CFMetaData metadata = singleReadCommand.metadata();
            long size = 1L;
            size += (long)TypeSizes.sizeof(command.isDigestQuery());
            size += (long)TypeSizes.sizeof(metadata.ksName);
            size += (long)(TypeSizes.sizeof((short)keySize) + keySize);
            size += (long)TypeSizes.sizeof((long)command.nowInSec());
            if (singleReadCommand.clusteringIndexFilter().kind() == ClusteringIndexFilter.Kind.SLICE) {
                return size + this.serializedSliceCommandSize(singleReadCommand);
            }
            return size + this.serializedNamesCommandSize(singleReadCommand);
        }

        private void serializeNamesCommand(SinglePartitionReadCommand command, DataOutputPlus out) throws IOException {
            LegacyReadCommandSerializer.serializeNamesFilter(command, (ClusteringIndexNamesFilter)command.clusteringIndexFilter(), out);
        }

        private static void serializeNamesFilter(ReadCommand command, ClusteringIndexNamesFilter filter, DataOutputPlus out) throws IOException {
            PartitionColumns columns = command.columnFilter().fetchedColumns();
            CFMetaData metadata = command.metadata();
            NavigableSet<Clustering> requestedRows = filter.requestedRows();
            if (requestedRows.isEmpty()) {
                out.writeInt(columns.size());
                for (ColumnDefinition column : columns) {
                    ByteBufferUtil.writeWithShortLength(column.name.bytes, out);
                }
            } else {
                out.writeInt(requestedRows.size() * columns.size());
                for (Clustering clustering : requestedRows) {
                    for (ColumnDefinition column : columns) {
                        ByteBufferUtil.writeWithShortLength(LegacyLayout.encodeCellName(metadata, clustering, column.name.bytes, null), out);
                    }
                }
            }
            if (command.isForThrift() || command.limits().kind() == DataLimits.Kind.CQL_LIMIT && command.limits().perPartitionCount() == 1) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
            }
        }

        static long serializedNamesFilterSize(ClusteringIndexNamesFilter filter, CFMetaData metadata, PartitionColumns fetchedColumns) {
            NavigableSet<Clustering> requestedRows = filter.requestedRows();
            long size = 0L;
            if (requestedRows.isEmpty()) {
                size += (long)TypeSizes.sizeof(fetchedColumns.size());
                for (ColumnDefinition column : fetchedColumns) {
                    size += (long)ByteBufferUtil.serializedSizeWithShortLength(column.name.bytes);
                }
            } else {
                size += (long)TypeSizes.sizeof(requestedRows.size() * fetchedColumns.size());
                for (Clustering clustering : requestedRows) {
                    for (ColumnDefinition column : fetchedColumns) {
                        size += (long)ByteBufferUtil.serializedSizeWithShortLength(LegacyLayout.encodeCellName(metadata, clustering, column.name.bytes, null));
                    }
                }
            }
            return size + (long)TypeSizes.sizeof(true);
        }

        private SinglePartitionReadCommand deserializeNamesCommand(DataInputPlus in, boolean isDigest, CFMetaData metadata, DecoratedKey key, int nowInSeconds, int version) throws IOException {
            Pair<ColumnFilter, ClusteringIndexNamesFilter> selectionAndFilter = LegacyReadCommandSerializer.deserializeNamesSelectionAndFilter(in, metadata);
            return new SinglePartitionReadCommand(isDigest, version, true, metadata, nowInSeconds, (ColumnFilter)selectionAndFilter.left, RowFilter.NONE, DataLimits.NONE, key, (ClusteringIndexFilter)selectionAndFilter.right);
        }

        static Pair<ColumnFilter, ClusteringIndexNamesFilter> deserializeNamesSelectionAndFilter(DataInputPlus in, CFMetaData metadata) throws IOException {
            int numCellNames = in.readInt();
            TreeSet<Clusterable> clusterings = new TreeSet<Clusterable>(metadata.comparator);
            ColumnFilter.Builder selectionBuilder = ColumnFilter.selectionBuilder();
            for (int i = 0; i < numCellNames; ++i) {
                LegacyLayout.LegacyCellName cellName;
                ByteBuffer buffer = ByteBufferUtil.readWithShortLength(in);
                try {
                    cellName = LegacyLayout.decodeCellName(metadata, buffer);
                }
                catch (UnknownColumnException exc) {
                    throw new UnknownColumnFamilyException("Received legacy range read command with names filter for unrecognized column name. Fill name in filter (hex): " + ByteBufferUtil.bytesToHex(buffer), metadata.cfId);
                }
                if (metadata.isStaticCompactTable() && cellName.clustering.equals(Clustering.STATIC_CLUSTERING)) {
                    clusterings.add(new Clustering(cellName.column.name.bytes));
                    selectionBuilder.add(metadata.compactValueColumn());
                } else {
                    clusterings.add(cellName.clustering);
                }
                selectionBuilder.add(cellName.column);
            }
            if (metadata.isStaticCompactTable() && clusterings.isEmpty()) {
                selectionBuilder.addAll(metadata.partitionColumns());
            }
            in.readBoolean();
            ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings, false);
            return Pair.create(selectionBuilder.build(), filter);
        }

        private long serializedNamesCommandSize(SinglePartitionReadCommand command) {
            ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)command.clusteringIndexFilter();
            PartitionColumns columns = command.columnFilter().fetchedColumns();
            return LegacyReadCommandSerializer.serializedNamesFilterSize(filter, command.metadata(), columns);
        }

        private void serializeSliceCommand(SinglePartitionReadCommand command, DataOutputPlus out) throws IOException {
            CFMetaData metadata = command.metadata();
            ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)command.clusteringIndexFilter();
            Slices slices = filter.requestedSlices();
            boolean makeStaticSlice = !command.columnFilter().fetchedColumns().statics.isEmpty() && !slices.selects(Clustering.STATIC_CLUSTERING);
            LegacyReadCommandSerializer.serializeSlices(out, slices, filter.isReversed(), makeStaticSlice, metadata);
            out.writeBoolean(filter.isReversed());
            boolean selectsStatics = !command.columnFilter().fetchedColumns().statics.isEmpty() || slices.selects(Clustering.STATIC_CLUSTERING);
            DataLimits limits = command.limits();
            if (limits.isDistinct()) {
                out.writeInt(1);
            } else {
                out.writeInt(LegacyReadCommandSerializer.updateLimitForQuery(command.limits().count(), filter.requestedSlices()));
            }
            int compositesToGroup = limits.kind() == DataLimits.Kind.THRIFT_LIMIT || metadata.isDense() ? -1 : (limits.isDistinct() && !selectsStatics ? -2 : metadata.clusteringColumns().size());
            out.writeInt(compositesToGroup);
        }

        private SinglePartitionReadCommand deserializeSliceCommand(DataInputPlus in, boolean isDigest, CFMetaData metadata, DecoratedKey key, int nowInSeconds, int version) throws IOException {
            Pair<ClusteringIndexSliceFilter, Boolean> p = LegacyReadCommandSerializer.deserializeSlicePartitionFilter(in, metadata);
            ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)p.left;
            boolean selectsStatics = (Boolean)p.right;
            int count = in.readInt();
            int compositesToGroup = in.readInt();
            ColumnFilter columnFilter = LegacyRangeSliceCommandSerializer.getColumnSelectionForSlice(selectsStatics, compositesToGroup, metadata);
            DataLimits limits = compositesToGroup == -2 ? DataLimits.distinctLimits(count) : (compositesToGroup == -1 ? DataLimits.thriftLimits(1, count) : DataLimits.cqlLimits(count));
            return new SinglePartitionReadCommand(isDigest, version, true, metadata, nowInSeconds, columnFilter, RowFilter.NONE, limits, key, filter);
        }

        private long serializedSliceCommandSize(SinglePartitionReadCommand command) {
            CFMetaData metadata = command.metadata();
            ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)command.clusteringIndexFilter();
            Slices slices = filter.requestedSlices();
            boolean makeStaticSlice = !command.columnFilter().fetchedColumns().statics.isEmpty() && !slices.selects(Clustering.STATIC_CLUSTERING);
            long size = LegacyReadCommandSerializer.serializedSlicesSize(slices, makeStaticSlice, metadata);
            size += (long)TypeSizes.sizeof(command.clusteringIndexFilter().isReversed());
            return (size += (long)TypeSizes.sizeof(command.limits().count())) + (long)TypeSizes.sizeof(0);
        }

        static void serializeSlices(DataOutputPlus out, Slices slices, boolean isReversed, boolean makeStaticSlice, CFMetaData metadata) throws IOException {
            out.writeInt(slices.size() + (makeStaticSlice ? 1 : 0));
            if (isReversed) {
                for (int i = slices.size() - 1; i >= 0; --i) {
                    LegacyReadCommandSerializer.serializeSlice(out, slices.get(i), true, metadata);
                }
                if (makeStaticSlice) {
                    LegacyReadCommandSerializer.serializeStaticSlice(out, true, metadata);
                }
            } else {
                if (makeStaticSlice) {
                    LegacyReadCommandSerializer.serializeStaticSlice(out, false, metadata);
                }
                for (Slice slice : slices) {
                    LegacyReadCommandSerializer.serializeSlice(out, slice, false, metadata);
                }
            }
        }

        static long serializedSlicesSize(Slices slices, boolean makeStaticSlice, CFMetaData metadata) {
            long size = TypeSizes.sizeof(slices.size());
            for (Slice slice : slices) {
                ByteBuffer sliceStart = LegacyLayout.encodeBound(metadata, slice.start(), true);
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(sliceStart);
                ByteBuffer sliceEnd = LegacyLayout.encodeBound(metadata, slice.end(), false);
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(sliceEnd);
            }
            if (makeStaticSlice) {
                size += LegacyReadCommandSerializer.serializedStaticSliceSize(metadata);
            }
            return size;
        }

        static long serializedStaticSliceSize(CFMetaData metadata) {
            ByteBuffer sliceStart = LegacyLayout.encodeBound(metadata, Slice.Bound.BOTTOM, false);
            long size = ByteBufferUtil.serializedSizeWithShortLength(sliceStart);
            size += (long)TypeSizes.sizeof((short)(metadata.comparator.size() * 3 + 2));
            size += (long)TypeSizes.sizeof((short)-1);
            for (int i = 0; i < metadata.comparator.size(); ++i) {
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(ByteBufferUtil.EMPTY_BYTE_BUFFER);
                ++size;
            }
            return size;
        }

        private static void serializeSlice(DataOutputPlus out, Slice slice, boolean isReversed, CFMetaData metadata) throws IOException {
            ByteBuffer sliceStart = LegacyLayout.encodeBound(metadata, isReversed ? slice.end() : slice.start(), !isReversed);
            ByteBufferUtil.writeWithShortLength(sliceStart, out);
            ByteBuffer sliceEnd = LegacyLayout.encodeBound(metadata, isReversed ? slice.start() : slice.end(), isReversed);
            ByteBufferUtil.writeWithShortLength(sliceEnd, out);
        }

        private static void serializeStaticSlice(DataOutputPlus out, boolean isReversed, CFMetaData metadata) throws IOException {
            if (!isReversed) {
                ByteBuffer sliceStart = LegacyLayout.encodeBound(metadata, Slice.Bound.BOTTOM, false);
                ByteBufferUtil.writeWithShortLength(sliceStart, out);
            }
            out.writeShort(2 + metadata.comparator.size() * 3);
            out.writeShort(65535);
            for (int i = 0; i < metadata.comparator.size(); ++i) {
                ByteBufferUtil.writeWithShortLength(ByteBufferUtil.EMPTY_BYTE_BUFFER, out);
                out.writeByte(i == metadata.comparator.size() - 1 ? 1 : 0);
            }
            if (isReversed) {
                ByteBuffer sliceStart = LegacyLayout.encodeBound(metadata, Slice.Bound.BOTTOM, false);
                ByteBufferUtil.writeWithShortLength(sliceStart, out);
            }
        }

        static Pair<ClusteringIndexSliceFilter, Boolean> deserializeSlicePartitionFilter(DataInputPlus in, CFMetaData metadata) throws IOException {
            int numSlices = in.readInt();
            ByteBuffer[] startBuffers = new ByteBuffer[numSlices];
            ByteBuffer[] finishBuffers = new ByteBuffer[numSlices];
            for (int i = 0; i < numSlices; ++i) {
                startBuffers[i] = ByteBufferUtil.readWithShortLength(in);
                finishBuffers[i] = ByteBufferUtil.readWithShortLength(in);
            }
            boolean reversed = in.readBoolean();
            if (reversed) {
                ByteBuffer[] tmp = finishBuffers;
                finishBuffers = startBuffers;
                startBuffers = tmp;
            }
            boolean selectsStatics = false;
            Slices.Builder slicesBuilder = new Slices.Builder(metadata.comparator);
            for (int i = 0; i < numSlices; ++i) {
                LegacyLayout.LegacyBound start = LegacyLayout.decodeBound(metadata, startBuffers[i], true);
                LegacyLayout.LegacyBound finish = LegacyLayout.decodeBound(metadata, finishBuffers[i], false);
                if (start.isStatic) {
                    start = LegacyLayout.LegacyBound.BOTTOM;
                    if (start.bound.isInclusive()) {
                        selectsStatics = true;
                    }
                } else if (start == LegacyLayout.LegacyBound.BOTTOM) {
                    selectsStatics = true;
                }
                if (finish.isStatic) {
                    assert (finish.bound.isInclusive());
                    continue;
                }
                slicesBuilder.add(Slice.make(start.bound, finish.bound));
            }
            return Pair.create(new ClusteringIndexSliceFilter(slicesBuilder.build(), reversed), selectsStatics);
        }

        private static SinglePartitionReadCommand maybeConvertNamesToSlice(SinglePartitionReadCommand command) {
            if (command.clusteringIndexFilter().kind() != ClusteringIndexFilter.Kind.NAMES) {
                return command;
            }
            CFMetaData metadata = command.metadata();
            if (!LegacyReadCommandSerializer.shouldConvertNamesToSlice(metadata, command.columnFilter().fetchedColumns())) {
                return command;
            }
            ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)command.clusteringIndexFilter();
            ClusteringIndexSliceFilter sliceFilter = LegacyReadCommandSerializer.convertNamesFilterToSliceFilter(filter, metadata);
            return new SinglePartitionReadCommand(command.isDigestQuery(), command.digestVersion(), command.isForThrift(), metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), command.limits(), command.partitionKey(), sliceFilter);
        }

        static boolean shouldConvertNamesToSlice(CFMetaData metadata, PartitionColumns columns) {
            if (!metadata.isDense() && metadata.isCompound()) {
                return true;
            }
            for (ColumnDefinition column : columns) {
                if (!column.type.isMultiCell()) continue;
                return true;
            }
            return false;
        }

        private static ClusteringIndexSliceFilter convertNamesFilterToSliceFilter(ClusteringIndexNamesFilter filter, CFMetaData metadata) {
            Slices slices;
            NavigableSet<Clustering> requestedRows = filter.requestedRows();
            if (requestedRows.isEmpty()) {
                slices = Slices.NONE;
            } else if (requestedRows.size() == 1 && ((Clustering)requestedRows.first()).size() == 0) {
                slices = Slices.ALL;
            } else {
                Slices.Builder slicesBuilder = new Slices.Builder(metadata.comparator);
                for (Clustering clustering : requestedRows) {
                    slicesBuilder.add(Slice.Bound.inclusiveStartOf(clustering), Slice.Bound.inclusiveEndOf(clustering));
                }
                slices = slicesBuilder.build();
            }
            return new ClusteringIndexSliceFilter(slices, filter.isReversed());
        }

        static int updateLimitForQuery(int limit, Slices slices) {
            if (!slices.hasLowerBound() && !slices.hasUpperBound()) {
                return limit;
            }
            for (Slice slice : slices) {
                if (limit == Integer.MAX_VALUE) {
                    return limit;
                }
                if (!slice.start().isInclusive()) {
                    ++limit;
                }
                if (slice.end().isInclusive()) continue;
                ++limit;
            }
            return limit;
        }
    }

    private static class LegacyPagedRangeCommandSerializer
    implements IVersionedSerializer<ReadCommand> {
        private LegacyPagedRangeCommandSerializer() {
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            boolean selectsStatics;
            boolean isDistinct;
            assert (version < 10);
            PartitionRangeReadCommand rangeCommand = (PartitionRangeReadCommand)command;
            assert (rangeCommand.dataRange().isPaging());
            CFMetaData metadata = rangeCommand.metadata();
            out.writeUTF(metadata.ksName);
            out.writeUTF(metadata.cfName);
            out.writeLong((long)rangeCommand.nowInSec() * 1000L);
            AbstractBounds.rowPositionSerializer.serialize(rangeCommand.dataRange().keyRange(), out, version);
            ClusteringIndexSliceFilter filter = rangeCommand.dataRange().clusteringIndexFilter.kind() == ClusteringIndexFilter.Kind.NAMES ? LegacyReadCommandSerializer.convertNamesFilterToSliceFilter((ClusteringIndexNamesFilter)rangeCommand.dataRange().clusteringIndexFilter, metadata) : (ClusteringIndexSliceFilter)rangeCommand.dataRange().clusteringIndexFilter;
            boolean makeStaticSlice = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() && !filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
            LegacyReadCommandSerializer.serializeSlices(out, filter.requestedSlices(), filter.isReversed(), makeStaticSlice, metadata);
            out.writeBoolean(filter.isReversed());
            DataLimits.Kind kind = rangeCommand.limits().kind();
            boolean bl = isDistinct = (kind == DataLimits.Kind.CQL_LIMIT || kind == DataLimits.Kind.CQL_PAGING_LIMIT) && rangeCommand.limits().perPartitionCount() == 1;
            if (isDistinct) {
                out.writeInt(1);
            } else {
                out.writeInt(LegacyReadCommandSerializer.updateLimitForQuery(rangeCommand.limits().perPartitionCount(), filter.requestedSlices()));
            }
            boolean bl2 = selectsStatics = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() || filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
            int compositesToGroup = kind == DataLimits.Kind.THRIFT_LIMIT ? -1 : (isDistinct && !selectsStatics ? -2 : (metadata.isDense() ? -1 : metadata.clusteringColumns().size()));
            out.writeInt(compositesToGroup);
            DataRange.Paging pagingRange = (DataRange.Paging)rangeCommand.dataRange();
            Clustering lastReturned = pagingRange.getLastReturned();
            Slice.Bound newStart = Slice.Bound.exclusiveStartOf(lastReturned);
            Slice lastSlice = filter.requestedSlices().get(filter.requestedSlices().size() - 1);
            ByteBufferUtil.writeWithShortLength(LegacyLayout.encodeBound(metadata, newStart, true), out);
            ByteBufferUtil.writeWithShortLength(LegacyLayout.encodeClustering(metadata, lastSlice.end().clustering()), out);
            LegacyRangeSliceCommandSerializer.serializeRowFilter(out, rangeCommand.rowFilter());
            int maxResults = rangeCommand.limits().count() + (metadata.isCompound() ? 0 : 1);
            out.writeInt(maxResults);
            if (rangeCommand.isForThrift() || rangeCommand.limits().perPartitionCount() == 1) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
            }
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            String columnFamily;
            assert (version < 10);
            String keyspace = in.readUTF();
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily = in.readUTF());
            if (metadata == null) {
                String message = String.format("Got legacy paged range command for nonexistent table %s.%s.", keyspace, columnFamily);
                throw new UnknownColumnFamilyException(message, null);
            }
            int nowInSec = (int)(in.readLong() / 1000L);
            AbstractBounds<PartitionPosition> keyRange = AbstractBounds.rowPositionSerializer.deserialize(in, metadata.partitioner, version);
            Pair<ClusteringIndexSliceFilter, Boolean> p = LegacyReadCommandSerializer.deserializeSlicePartitionFilter(in, metadata);
            ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)p.left;
            boolean selectsStatics = (Boolean)p.right;
            int perPartitionLimit = in.readInt();
            int compositesToGroup = in.readInt();
            LegacyLayout.LegacyBound startBound = LegacyLayout.decodeBound(metadata, ByteBufferUtil.readWithShortLength(in), true);
            ByteBufferUtil.readWithShortLength(in);
            ColumnFilter selection = LegacyRangeSliceCommandSerializer.getColumnSelectionForSlice(selectsStatics, compositesToGroup, metadata);
            RowFilter rowFilter = LegacyRangeSliceCommandSerializer.deserializeRowFilter(in, metadata);
            int maxResults = in.readInt();
            boolean countCQL3Rows = in.readBoolean();
            boolean isDistinct = compositesToGroup == -2 || compositesToGroup != -1 && !countCQL3Rows;
            DataLimits limits = isDistinct ? DataLimits.distinctLimits(maxResults) : DataLimits.cqlLimits(maxResults);
            limits = limits.forPaging(maxResults);
            DataRange dataRange = new DataRange(keyRange, filter);
            Slices slices = filter.requestedSlices();
            if (!isDistinct && startBound != LegacyLayout.LegacyBound.BOTTOM && !startBound.bound.equals(slices.get(0).start())) {
                dataRange = dataRange.forPaging(keyRange, metadata.comparator, startBound.getAsClustering(metadata), false);
            }
            return new PartitionRangeReadCommand(false, 0, true, metadata, nowInSec, selection, rowFilter, limits, dataRange, Optional.empty());
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            assert (version < 10);
            assert (command.kind == Kind.PARTITION_RANGE);
            PartitionRangeReadCommand rangeCommand = (PartitionRangeReadCommand)command;
            CFMetaData metadata = rangeCommand.metadata();
            assert (rangeCommand.dataRange().isPaging());
            long size = TypeSizes.sizeof(metadata.ksName);
            size += (long)TypeSizes.sizeof(metadata.cfName);
            size += (long)TypeSizes.sizeof((long)rangeCommand.nowInSec());
            size += AbstractBounds.rowPositionSerializer.serializedSize(rangeCommand.dataRange().keyRange(), version);
            ClusteringIndexSliceFilter filter = rangeCommand.dataRange().clusteringIndexFilter.kind() == ClusteringIndexFilter.Kind.NAMES ? LegacyReadCommandSerializer.convertNamesFilterToSliceFilter((ClusteringIndexNamesFilter)rangeCommand.dataRange().clusteringIndexFilter, metadata) : (ClusteringIndexSliceFilter)rangeCommand.dataRange().clusteringIndexFilter;
            boolean makeStaticSlice = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() && !filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
            size += LegacyReadCommandSerializer.serializedSlicesSize(filter.requestedSlices(), makeStaticSlice, metadata);
            size += (long)TypeSizes.sizeof(filter.isReversed());
            size += (long)TypeSizes.sizeof(rangeCommand.limits().perPartitionCount());
            size += (long)TypeSizes.sizeof(0);
            DataRange.Paging pagingRange = (DataRange.Paging)rangeCommand.dataRange();
            Clustering lastReturned = pagingRange.getLastReturned();
            Slice lastSlice = filter.requestedSlices().get(filter.requestedSlices().size() - 1);
            size += (long)ByteBufferUtil.serializedSizeWithShortLength(LegacyLayout.encodeClustering(metadata, lastReturned));
            size += (long)ByteBufferUtil.serializedSizeWithShortLength(LegacyLayout.encodeClustering(metadata, lastSlice.end().clustering()));
            size += LegacyRangeSliceCommandSerializer.serializedRowFilterSize(rangeCommand.rowFilter());
            return (size += (long)TypeSizes.sizeof(rangeCommand.limits().count())) + (long)TypeSizes.sizeof(true);
        }
    }

    private static class LegacyRangeSliceCommandSerializer
    implements IVersionedSerializer<ReadCommand> {
        private LegacyRangeSliceCommandSerializer() {
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            assert (version < 10);
            PartitionRangeReadCommand rangeCommand = (PartitionRangeReadCommand)command;
            assert (!rangeCommand.dataRange().isPaging());
            rangeCommand = LegacyRangeSliceCommandSerializer.maybeConvertNamesToSlice(rangeCommand);
            CFMetaData metadata = rangeCommand.metadata();
            out.writeUTF(metadata.ksName);
            out.writeUTF(metadata.cfName);
            out.writeLong((long)rangeCommand.nowInSec() * 1000L);
            if (rangeCommand.isNamesQuery()) {
                out.writeByte(1);
                ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)rangeCommand.dataRange().clusteringIndexFilter;
                LegacyReadCommandSerializer.serializeNamesFilter(rangeCommand, filter, out);
            } else {
                boolean selectsStatics;
                out.writeByte(0);
                ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)rangeCommand.dataRange().clusteringIndexFilter;
                boolean makeStaticSlice = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() && !filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
                LegacyReadCommandSerializer.serializeSlices(out, filter.requestedSlices(), filter.isReversed(), makeStaticSlice, metadata);
                out.writeBoolean(filter.isReversed());
                DataLimits limits = rangeCommand.limits();
                if (limits.isDistinct()) {
                    out.writeInt(1);
                } else {
                    out.writeInt(LegacyReadCommandSerializer.updateLimitForQuery(rangeCommand.limits().count(), filter.requestedSlices()));
                }
                boolean bl = selectsStatics = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() || filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
                int compositesToGroup = limits.kind() == DataLimits.Kind.THRIFT_LIMIT ? -1 : (limits.isDistinct() && !selectsStatics ? -2 : (metadata.isDense() ? -1 : metadata.clusteringColumns().size()));
                out.writeInt(compositesToGroup);
            }
            LegacyRangeSliceCommandSerializer.serializeRowFilter(out, rangeCommand.rowFilter());
            AbstractBounds.rowPositionSerializer.serialize(rangeCommand.dataRange().keyRange(), out, version);
            out.writeInt(rangeCommand.limits().count());
            if (rangeCommand.isForThrift() || rangeCommand.limits().perPartitionCount() == 1) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
            }
            out.writeBoolean(false);
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            boolean isDistinct;
            ClusteringIndexFilter filter;
            ColumnFilter selection;
            String columnFamily;
            assert (version < 10);
            String keyspace = in.readUTF();
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily = in.readUTF());
            if (metadata == null) {
                String message = String.format("Got legacy range command for nonexistent table %s.%s.", keyspace, columnFamily);
                throw new UnknownColumnFamilyException(message, null);
            }
            int nowInSec = (int)(in.readLong() / 1000L);
            int compositesToGroup = 0;
            int perPartitionLimit = -1;
            byte readType = in.readByte();
            if (readType == 1) {
                Pair<ColumnFilter, ClusteringIndexNamesFilter> selectionAndFilter = LegacyReadCommandSerializer.deserializeNamesSelectionAndFilter(in, metadata);
                selection = (ColumnFilter)selectionAndFilter.left;
                filter = (ClusteringIndexFilter)selectionAndFilter.right;
            } else {
                Pair<ClusteringIndexSliceFilter, Boolean> p = LegacyReadCommandSerializer.deserializeSlicePartitionFilter(in, metadata);
                filter = (ClusteringIndexFilter)p.left;
                perPartitionLimit = in.readInt();
                compositesToGroup = in.readInt();
                selection = LegacyRangeSliceCommandSerializer.getColumnSelectionForSlice((Boolean)p.right, compositesToGroup, metadata);
            }
            RowFilter rowFilter = LegacyRangeSliceCommandSerializer.deserializeRowFilter(in, metadata);
            AbstractBounds<PartitionPosition> keyRange = AbstractBounds.rowPositionSerializer.deserialize(in, metadata.partitioner, version);
            int maxResults = in.readInt();
            boolean countCQL3Rows = in.readBoolean();
            in.readBoolean();
            boolean selectsStatics = !selection.fetchedColumns().statics.isEmpty() || filter.selects(Clustering.STATIC_CLUSTERING);
            boolean bl = isDistinct = compositesToGroup == -2 || compositesToGroup != -1 && !countCQL3Rows;
            DataLimits limits = isDistinct ? DataLimits.distinctLimits(maxResults) : (compositesToGroup == -1 ? DataLimits.thriftLimits(maxResults, perPartitionLimit) : DataLimits.cqlLimits(maxResults));
            return new PartitionRangeReadCommand(false, 0, true, metadata, nowInSec, selection, rowFilter, limits, new DataRange(keyRange, filter), Optional.empty());
        }

        static void serializeRowFilter(DataOutputPlus out, RowFilter rowFilter) throws IOException {
            ArrayList indexExpressions = Lists.newArrayList(rowFilter.iterator());
            out.writeInt(indexExpressions.size());
            for (RowFilter.Expression expression : indexExpressions) {
                ByteBufferUtil.writeWithShortLength(expression.column().name.bytes, out);
                expression.operator().writeTo(out);
                ByteBufferUtil.writeWithShortLength(expression.getIndexValue(), out);
            }
        }

        static RowFilter deserializeRowFilter(DataInputPlus in, CFMetaData metadata) throws IOException {
            int numRowFilters = in.readInt();
            if (numRowFilters == 0) {
                return RowFilter.NONE;
            }
            RowFilter rowFilter = RowFilter.create(numRowFilters);
            for (int i = 0; i < numRowFilters; ++i) {
                ByteBuffer columnName = ByteBufferUtil.readWithShortLength(in);
                ColumnDefinition column = metadata.getColumnDefinition(columnName);
                Operator op = Operator.readFrom(in);
                ByteBuffer indexValue = ByteBufferUtil.readWithShortLength(in);
                rowFilter.add(column, op, indexValue);
            }
            return rowFilter;
        }

        static long serializedRowFilterSize(RowFilter rowFilter) {
            long size = TypeSizes.sizeof(0);
            for (RowFilter.Expression expression : rowFilter) {
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(expression.column().name.bytes);
                size += (long)TypeSizes.sizeof(0);
                size += (long)ByteBufferUtil.serializedSizeWithShortLength(expression.getIndexValue());
            }
            return size;
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            assert (version < 10);
            assert (command.kind == Kind.PARTITION_RANGE);
            PartitionRangeReadCommand rangeCommand = (PartitionRangeReadCommand)command;
            rangeCommand = LegacyRangeSliceCommandSerializer.maybeConvertNamesToSlice(rangeCommand);
            CFMetaData metadata = rangeCommand.metadata();
            long size = TypeSizes.sizeof(metadata.ksName);
            size += (long)TypeSizes.sizeof(metadata.cfName);
            size += (long)TypeSizes.sizeof((long)rangeCommand.nowInSec());
            ++size;
            if (rangeCommand.isNamesQuery()) {
                PartitionColumns columns = rangeCommand.columnFilter().fetchedColumns();
                ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)rangeCommand.dataRange().clusteringIndexFilter;
                size += LegacyReadCommandSerializer.serializedNamesFilterSize(filter, metadata, columns);
            } else {
                ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)rangeCommand.dataRange().clusteringIndexFilter;
                boolean makeStaticSlice = !rangeCommand.columnFilter().fetchedColumns().statics.isEmpty() && !filter.requestedSlices().selects(Clustering.STATIC_CLUSTERING);
                size += LegacyReadCommandSerializer.serializedSlicesSize(filter.requestedSlices(), makeStaticSlice, metadata);
                size += (long)TypeSizes.sizeof(filter.isReversed());
                size += (long)TypeSizes.sizeof(rangeCommand.limits().perPartitionCount());
                size += (long)TypeSizes.sizeof(0);
            }
            if (rangeCommand.rowFilter().equals(RowFilter.NONE)) {
                size += (long)TypeSizes.sizeof(0);
            } else {
                ArrayList indexExpressions = Lists.newArrayList(rangeCommand.rowFilter().iterator());
                size += (long)TypeSizes.sizeof(indexExpressions.size());
                for (RowFilter.Expression expression : indexExpressions) {
                    size += (long)ByteBufferUtil.serializedSizeWithShortLength(expression.column().name.bytes);
                    size += (long)TypeSizes.sizeof(expression.operator().ordinal());
                    size += (long)ByteBufferUtil.serializedSizeWithShortLength(expression.getIndexValue());
                }
            }
            size += AbstractBounds.rowPositionSerializer.serializedSize(rangeCommand.dataRange().keyRange(), version);
            size += (long)TypeSizes.sizeof(rangeCommand.limits().count());
            return (size += (long)TypeSizes.sizeof(!rangeCommand.isForThrift())) + (long)TypeSizes.sizeof(rangeCommand.dataRange().isPaging());
        }

        static PartitionRangeReadCommand maybeConvertNamesToSlice(PartitionRangeReadCommand command) {
            if (!command.dataRange().isNamesQuery()) {
                return command;
            }
            CFMetaData metadata = command.metadata();
            if (!LegacyReadCommandSerializer.shouldConvertNamesToSlice(metadata, command.columnFilter().fetchedColumns())) {
                return command;
            }
            ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)command.dataRange().clusteringIndexFilter;
            ClusteringIndexSliceFilter sliceFilter = LegacyReadCommandSerializer.convertNamesFilterToSliceFilter(filter, metadata);
            DataRange newRange = new DataRange(command.dataRange().keyRange(), sliceFilter);
            return new PartitionRangeReadCommand(command.isDigestQuery(), command.digestVersion(), command.isForThrift(), metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), command.limits(), newRange, Optional.empty());
        }

        static ColumnFilter getColumnSelectionForSlice(boolean selectsStatics, int compositesToGroup, CFMetaData metadata) {
            if (compositesToGroup == -2) {
                return ColumnFilter.all(metadata);
            }
            PartitionColumns columns = selectsStatics ? metadata.partitionColumns() : metadata.partitionColumns().withoutStatics();
            return ColumnFilter.selectionBuilder().addAll(columns).build();
        }
    }

    private static enum LegacyType {
        GET_BY_NAMES(1),
        GET_SLICES(2);

        public final byte serializedValue;

        private LegacyType(byte b) {
            this.serializedValue = b;
        }

        public static LegacyType fromPartitionFilterKind(ClusteringIndexFilter.Kind kind) {
            return kind == ClusteringIndexFilter.Kind.SLICE ? GET_SLICES : GET_BY_NAMES;
        }

        public static LegacyType fromSerializedValue(byte b) {
            return b == 1 ? GET_BY_NAMES : GET_SLICES;
        }
    }

    private static class RangeSliceSerializer
    implements IVersionedSerializer<ReadCommand> {
        private RangeSliceSerializer() {
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                legacyRangeSliceCommandSerializer.serialize(command, out, version);
            } else {
                serializer.serialize(command, out, version);
            }
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            return version < 10 ? legacyRangeSliceCommandSerializer.deserialize(in, version) : serializer.deserialize(in, version);
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            return version < 10 ? legacyRangeSliceCommandSerializer.serializedSize(command, version) : serializer.serializedSize(command, version);
        }
    }

    private static class Serializer
    implements IVersionedSerializer<ReadCommand> {
        private Serializer() {
        }

        private static int digestFlag(boolean isDigest) {
            return isDigest ? 1 : 0;
        }

        private static boolean isDigest(int flags) {
            return (flags & 1) != 0;
        }

        private static int thriftFlag(boolean isForThrift) {
            return isForThrift ? 2 : 0;
        }

        private static boolean isForThrift(int flags) {
            return (flags & 2) != 0;
        }

        private static int indexFlag(boolean hasIndex) {
            return hasIndex ? 4 : 0;
        }

        private static boolean hasIndex(int flags) {
            return (flags & 4) != 0;
        }

        @Override
        public void serialize(ReadCommand command, DataOutputPlus out, int version) throws IOException {
            assert (version >= 10);
            out.writeByte(command.kind.ordinal());
            out.writeByte(Serializer.digestFlag(command.isDigestQuery()) | Serializer.thriftFlag(command.isForThrift()) | Serializer.indexFlag(command.index.isPresent()));
            if (command.isDigestQuery()) {
                out.writeUnsignedVInt(command.digestVersion());
            }
            CFMetaData.serializer.serialize(command.metadata(), out, version);
            out.writeInt(command.nowInSec());
            ColumnFilter.serializer.serialize(command.columnFilter(), out, version);
            RowFilter.serializer.serialize(command.rowFilter(), out, version);
            DataLimits.serializer.serialize(command.limits(), out, version);
            if (command.index.isPresent()) {
                IndexMetadata.serializer.serialize(command.index.get(), out, version);
            }
            command.serializeSelection(out, version);
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version) throws IOException {
            if (version < 10) {
                return legacyReadCommandSerializer.deserialize(in, version);
            }
            Kind kind = Kind.values()[in.readByte()];
            byte flags = in.readByte();
            boolean isDigest = Serializer.isDigest(flags);
            boolean isForThrift = Serializer.isForThrift(flags);
            boolean hasIndex = Serializer.hasIndex(flags);
            int digestVersion = isDigest ? (int)in.readUnsignedVInt() : 0;
            CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
            int nowInSec = in.readInt();
            ColumnFilter columnFilter = ColumnFilter.serializer.deserialize(in, version, metadata);
            RowFilter rowFilter = RowFilter.serializer.deserialize(in, version, metadata);
            DataLimits limits = DataLimits.serializer.deserialize(in, version);
            Optional<IndexMetadata> index = hasIndex ? this.deserializeIndexMetadata(in, version, metadata) : Optional.empty();
            return kind.selectionDeserializer.deserialize(in, version, isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        }

        private Optional<IndexMetadata> deserializeIndexMetadata(DataInputPlus in, int version, CFMetaData cfm) throws IOException {
            try {
                return Optional.of(IndexMetadata.serializer.deserialize(in, version, cfm));
            }
            catch (UnknownIndexException e) {
                String message = String.format("Couldn't find a defined index on %s.%s with the id %s. If an index was just created, this is likely due to the schema not being fully propagated. Local read will proceed without using the index. Please wait for schema agreement after index creation.", cfm.ksName, cfm.cfName, e.indexId.toString());
                logger.info(message);
                return Optional.empty();
            }
        }

        @Override
        public long serializedSize(ReadCommand command, int version) {
            assert (version >= 10);
            return (long)(2 + (command.isDigestQuery() ? TypeSizes.sizeofUnsignedVInt(command.digestVersion()) : 0)) + CFMetaData.serializer.serializedSize(command.metadata(), version) + (long)TypeSizes.sizeof(command.nowInSec()) + ColumnFilter.serializer.serializedSize(command.columnFilter(), version) + RowFilter.serializer.serializedSize(command.rowFilter(), version) + DataLimits.serializer.serializedSize(command.limits(), version) + command.selectionSerializedSize(version) + command.indexSerializedSize(version);
        }
    }

    protected static enum Kind {
        SINGLE_PARTITION(SinglePartitionReadCommand.selectionDeserializer),
        PARTITION_RANGE(PartitionRangeReadCommand.selectionDeserializer);

        private final SelectionDeserializer selectionDeserializer;

        private Kind(SelectionDeserializer selectionDeserializer) {
            this.selectionDeserializer = selectionDeserializer;
        }
    }

    protected static abstract class SelectionDeserializer {
        protected SelectionDeserializer() {
        }

        public abstract ReadCommand deserialize(DataInputPlus var1, int var2, boolean var3, int var4, boolean var5, CFMetaData var6, int var7, ColumnFilter var8, RowFilter var9, DataLimits var10, Optional<IndexMetadata> var11) throws IOException;
    }
}

