/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.cql3.statements.TableAttributes;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type.Raw validator;
    public final ColumnIdentifier.Raw rawColumnName;
    private final TableAttributes attrs;
    private final Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames;
    private final boolean isStatic;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier.Raw columnName, CQL3Type.Raw validator, TableAttributes attrs, Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames, boolean isStatic) {
        super(name);
        this.oType = type;
        this.rawColumnName = columnName;
        this.validator = validator;
        this.attrs = attrs;
        this.renames = renames;
        this.isStatic = isStatic;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (meta.isView()) {
            throw new InvalidRequestException("Cannot use ALTER TABLE on Materialized View");
        }
        CFMetaData cfm = meta.copy();
        CQL3Type validator = this.validator == null ? null : this.validator.prepare(this.keyspace());
        ColumnIdentifier columnName = null;
        ColumnDefinition def = null;
        if (this.rawColumnName != null) {
            columnName = this.rawColumnName.prepare(cfm);
            def = cfm.getColumnDefinition(columnName);
        }
        ArrayList<ViewDefinition> viewUpdates = null;
        Iterable<ViewDefinition> views = View.findAll(this.keyspace(), this.columnFamily());
        switch (this.oType) {
            case ADD: {
                assert (columnName != null);
                if (cfm.isDense()) {
                    throw new InvalidRequestException("Cannot add new column to a COMPACT STORAGE table");
                }
                if (this.isStatic) {
                    if (!cfm.isCompound()) {
                        throw new InvalidRequestException("Static columns are not allowed in COMPACT STORAGE tables");
                    }
                    if (cfm.clusteringColumns().isEmpty()) {
                        throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                    }
                }
                if (def != null) {
                    switch (def.kind) {
                        case PARTITION_KEY: 
                        case CLUSTERING: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", columnName));
                        }
                    }
                    throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", columnName));
                }
                if (meta.isCounter() && meta.getDroppedColumns().containsKey(columnName.bytes)) {
                    throw new InvalidRequestException(String.format("Cannot re-add previously dropped counter column %s", columnName));
                }
                AbstractType<?> type = validator.getType();
                if (type.isCollection() && type.isMultiCell()) {
                    if (!cfm.isCompound()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections in COMPACT STORAGE tables");
                    }
                    if (cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections with super column families");
                    }
                    CFMetaData.DroppedColumn dropped = cfm.getDroppedColumns().get(columnName.bytes);
                    if (dropped != null && dropped.type instanceof CollectionType && dropped.type.isMultiCell() && !type.isCompatibleWith(dropped.type)) {
                        String string = String.format("Cannot add a collection with the name %s because a collection with the same name and a different type (%s) has already been used in the past", columnName, dropped.type.asCQL3Type());
                        throw new InvalidRequestException(string);
                    }
                }
                cfm.addColumnDefinition(this.isStatic ? ColumnDefinition.staticDef(cfm, columnName.bytes, type) : ColumnDefinition.regularDef(cfm, columnName.bytes, type));
                if (this.isStatic) break;
                for (ViewDefinition viewDefinition : views) {
                    if (!viewDefinition.includeAllColumns) continue;
                    ViewDefinition viewCopy = viewDefinition.copy();
                    viewCopy.metadata.addColumnDefinition(ColumnDefinition.regularDef(viewCopy.metadata, columnName.bytes, type));
                    if (viewUpdates == null) {
                        viewUpdates = new ArrayList<ViewDefinition>();
                    }
                    viewUpdates.add(viewCopy);
                }
                break;
            }
            case ALTER: {
                assert (columnName != null);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                AbstractType validatorType = def.isReversedType() && !validator.getType().isReversed() ? ReversedType.getInstance(validator.getType()) : validator.getType();
                AlterTableStatement.validateAlter(cfm, def, validatorType);
                cfm.addOrReplaceColumnDefinition(def.withNewType(validatorType));
                for (ViewDefinition view : views) {
                    if (!view.includes(columnName)) continue;
                    ViewDefinition viewCopy = view.copy();
                    ColumnDefinition viewDef = view.metadata.getColumnDefinition(columnName);
                    AbstractType viewType = viewDef.isReversedType() && !validator.getType().isReversed() ? ReversedType.getInstance(validator.getType()) : validator.getType();
                    AlterTableStatement.validateAlter(view.metadata, viewDef, viewType);
                    viewCopy.metadata.addOrReplaceColumnDefinition(viewDef.withNewType(viewType));
                    if (viewUpdates == null) {
                        viewUpdates = new ArrayList();
                    }
                    viewUpdates.add(viewCopy);
                }
                break;
            }
            case DROP: {
                assert (columnName != null);
                if (!cfm.isCQLTable()) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 table");
                }
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", columnName));
                    }
                    case REGULAR: 
                    case STATIC: {
                        void var11_16;
                        Object var11_14 = null;
                        for (ColumnDefinition columnDef : cfm.partitionColumns()) {
                            if (!columnDef.name.equals(columnName)) continue;
                            ColumnDefinition columnDefinition = columnDef;
                            break;
                        }
                        assert (var11_16 != null);
                        cfm.removeColumnDefinition((ColumnDefinition)var11_16);
                        cfm.recordColumnDrop((ColumnDefinition)var11_16);
                    }
                }
                Indexes indexes = cfm.getIndexes();
                if (!indexes.isEmpty()) {
                    ColumnFamilyStore store = Keyspace.openAndGetStore(cfm);
                    Set<IndexMetadata> dependentIndexes = store.indexManager.getDependentIndexes(def);
                    if (!dependentIndexes.isEmpty()) {
                        throw new InvalidRequestException(String.format("Cannot drop column %s because it has dependent secondary indexes (%s)", def, dependentIndexes.stream().map(i -> i.name).collect(Collectors.joining(","))));
                    }
                }
                boolean rejectAlter = false;
                StringBuilder builder = new StringBuilder();
                for (ViewDefinition view : views) {
                    if (!view.includes(columnName)) continue;
                    if (rejectAlter) {
                        builder.append(',');
                    }
                    rejectAlter = true;
                    builder.append(view.viewName);
                }
                if (!rejectAlter) break;
                throw new InvalidRequestException(String.format("Cannot drop column %s, depended on by materialized views (%s.{%s})", columnName.toString(), this.keyspace(), builder.toString()));
            }
            case OPTS: {
                if (this.attrs == null) {
                    throw new InvalidRequestException("ALTER TABLE WITH invoked, but no parameters found");
                }
                this.attrs.validate();
                TableParams params = this.attrs.asAlteredTableParams(cfm.params);
                if (!Iterables.isEmpty(views) && params.gcGraceSeconds == 0) {
                    throw new InvalidRequestException("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.");
                }
                if (meta.isCounter() && params.defaultTimeToLive > 0) {
                    throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
                }
                cfm.params(params);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier.Raw, ColumnIdentifier.Raw> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey().prepare(cfm);
                    ColumnIdentifier to = entry.getValue().prepare(cfm);
                    cfm.renameColumn(from, to);
                    for (ViewDefinition view : views) {
                        if (!view.includes(from)) continue;
                        ViewDefinition viewCopy = view.copy();
                        ColumnIdentifier viewFrom = entry.getKey().prepare(viewCopy.metadata);
                        ColumnIdentifier viewTo = entry.getValue().prepare(viewCopy.metadata);
                        viewCopy.renameColumn(viewFrom, viewTo);
                        if (viewUpdates == null) {
                            viewUpdates = new ArrayList();
                        }
                        viewUpdates.add(viewCopy);
                    }
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        if (viewUpdates != null) {
            for (ViewDefinition viewUpdate : viewUpdates) {
                MigrationManager.announceViewUpdate(viewUpdate, isLocalOnly);
            }
        }
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    private static void validateAlter(CFMetaData cfm, ColumnDefinition def, AbstractType<?> validatorType) {
        switch (def.kind) {
            case PARTITION_KEY: {
                if (validatorType instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", def.name));
                }
                AbstractType<?> currentType = cfm.getKeyValidatorAsClusteringComparator().subtype(def.position());
                if (validatorType.isValueCompatibleWith(currentType)) break;
                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", def.name, currentType.asCQL3Type(), validatorType.asCQL3Type()));
            }
            case CLUSTERING: {
                if (!cfm.isCQLTable()) {
                    throw new InvalidRequestException(String.format("Cannot alter clustering column %s in a non-CQL3 table", def.name));
                }
                AbstractType<?> oldType = cfm.comparator.subtype(def.position());
                if (validatorType.isCompatibleWith(oldType)) break;
                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", def.name, oldType.asCQL3Type(), validatorType.asCQL3Type()));
            }
            case REGULAR: 
            case STATIC: {
                if (validatorType.isValueCompatibleWith(def.type)) break;
                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", def.name, def.type.asCQL3Type(), validatorType.asCQL3Type()));
            }
        }
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.rawColumnName, this.validator});
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

