/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.PendingRangeMaps;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SortedBiMultiValMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TokenMetadata.class);
    private final BiMultiValMap<Token, InetAddress> tokenToEndpointMap;
    private final BiMap<InetAddress, UUID> endpointToHostIdMap;
    private final BiMultiValMap<Token, InetAddress> bootstrapTokens = new BiMultiValMap();
    private final BiMap<InetAddress, InetAddress> replacementToOriginal = HashBiMap.create();
    private final Set<InetAddress> leavingEndpoints = new HashSet<InetAddress>();
    private final ConcurrentMap<String, PendingRangeMaps> pendingRanges = new ConcurrentHashMap<String, PendingRangeMaps>();
    private final Set<Pair<Token, InetAddress>> movingEndpoints = new HashSet<Pair<Token, InetAddress>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile ArrayList<Token> sortedTokens;
    private volatile Topology topology;
    public final IPartitioner partitioner;
    private static final Comparator<InetAddress> inetaddressCmp = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress o1, InetAddress o2) {
            return ByteBuffer.wrap(o1.getAddress()).compareTo(ByteBuffer.wrap(o2.getAddress()));
        }
    };
    @GuardedBy(value="lock")
    private long ringVersion = 0L;
    private final AtomicReference<TokenMetadata> cachedTokenMap = new AtomicReference();

    public TokenMetadata() {
        this(SortedBiMultiValMap.create(null, inetaddressCmp), (BiMap<InetAddress, UUID>)HashBiMap.create(), Topology.empty(), DatabaseDescriptor.getPartitioner());
    }

    private TokenMetadata(BiMultiValMap<Token, InetAddress> tokenToEndpointMap, BiMap<InetAddress, UUID> endpointsMap, Topology topology, IPartitioner partitioner) {
        this.tokenToEndpointMap = tokenToEndpointMap;
        this.topology = topology;
        this.partitioner = partitioner;
        this.endpointToHostIdMap = endpointsMap;
        this.sortedTokens = this.sortTokens();
    }

    @VisibleForTesting
    public TokenMetadata cloneWithNewPartitioner(IPartitioner newPartitioner) {
        return new TokenMetadata(this.tokenToEndpointMap, this.endpointToHostIdMap, this.topology, newPartitioner);
    }

    private ArrayList<Token> sortTokens() {
        return new ArrayList<Token>(this.tokenToEndpointMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingRangeChanges(InetAddress source) {
        int n = 0;
        Collection<Range<Token>> sourceRanges = this.getPrimaryRangesFor(this.getTokens(source));
        this.lock.readLock().lock();
        try {
            for (Token token : this.bootstrapTokens.keySet()) {
                for (Range<Token> range : sourceRanges) {
                    if (!range.contains(token)) continue;
                    ++n;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return n;
    }

    public void updateNormalToken(Token token, InetAddress endpoint) {
        this.updateNormalTokens(Collections.singleton(token), endpoint);
    }

    public void updateNormalTokens(Collection<Token> tokens, InetAddress endpoint) {
        HashMultimap endpointTokens = HashMultimap.create();
        for (Token token : tokens) {
            endpointTokens.put((Object)endpoint, (Object)token);
        }
        this.updateNormalTokens((Multimap<InetAddress, Token>)endpointTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormalTokens(Multimap<InetAddress, Token> endpointTokens) {
        if (endpointTokens.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            boolean shouldSortTokens = false;
            Topology.Builder topologyBuilder = this.topology.unbuild();
            for (InetAddress endpoint : endpointTokens.keySet()) {
                Collection tokens = endpointTokens.get((Object)endpoint);
                assert (tokens != null && !tokens.isEmpty());
                this.bootstrapTokens.removeValue(endpoint);
                this.tokenToEndpointMap.removeValue(endpoint);
                topologyBuilder.addEndpoint(endpoint);
                this.leavingEndpoints.remove(endpoint);
                this.replacementToOriginal.remove((Object)endpoint);
                this.removeFromMoving(endpoint);
                for (Token token : tokens) {
                    InetAddress prev = this.tokenToEndpointMap.put(token, endpoint);
                    if (endpoint.equals(prev)) continue;
                    if (prev != null) {
                        logger.warn("Token {} changing ownership from {} to {}", new Object[]{token, prev, endpoint});
                    }
                    shouldSortTokens = true;
                }
            }
            this.topology = topologyBuilder.build();
            if (shouldSortTokens) {
                this.sortedTokens = this.sortTokens();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHostId(UUID hostId, InetAddress endpoint) {
        assert (hostId != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            InetAddress storedEp = (InetAddress)this.endpointToHostIdMap.inverse().get((Object)hostId);
            if (storedEp != null && !storedEp.equals(endpoint) && FailureDetector.instance.isAlive(storedEp)) {
                throw new RuntimeException(String.format("Host ID collision between active endpoint %s and %s (id=%s)", storedEp, endpoint, hostId));
            }
            UUID storedId = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
            if (storedId != null && !storedId.equals(hostId)) {
                logger.warn("Changing {}'s host ID from {} to {}", new Object[]{endpoint, storedId, hostId});
            }
            this.endpointToHostIdMap.forcePut((Object)endpoint, (Object)hostId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public UUID getHostId(InetAddress endpoint) {
        this.lock.readLock().lock();
        try {
            UUID uUID = (UUID)this.endpointToHostIdMap.get((Object)endpoint);
            return uUID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InetAddress getEndpointForHostId(UUID hostId) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = (InetAddress)this.endpointToHostIdMap.inverse().get((Object)hostId);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<InetAddress, UUID> getEndpointToHostIdMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMap<InetAddress, UUID> readMap = new HashMap<InetAddress, UUID>();
            readMap.putAll((Map<InetAddress, UUID>)this.endpointToHostIdMap);
            HashMap<InetAddress, UUID> hashMap = readMap;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public void addBootstrapToken(Token token, InetAddress endpoint) {
        this.addBootstrapTokens(Collections.singleton(token), endpoint);
    }

    public void addBootstrapTokens(Collection<Token> tokens, InetAddress endpoint) {
        this.addBootstrapTokens(tokens, endpoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBootstrapTokens(Collection<Token> tokens, InetAddress endpoint, InetAddress original) {
        assert (tokens != null && !tokens.isEmpty());
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                InetAddress oldEndpoint = this.bootstrapTokens.get(token);
                if (oldEndpoint != null && !oldEndpoint.equals(endpoint)) {
                    throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
                }
                oldEndpoint = this.tokenToEndpointMap.get(token);
                if (oldEndpoint == null || oldEndpoint.equals(endpoint) || oldEndpoint.equals(original)) continue;
                throw new RuntimeException("Bootstrap Token collision between " + oldEndpoint + " and " + endpoint + " (token " + token);
            }
            this.bootstrapTokens.removeValue(endpoint);
            for (Token token : tokens) {
                this.bootstrapTokens.put(token, endpoint);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplaceTokens(Collection<Token> replacingTokens, InetAddress newNode, InetAddress oldNode) {
        assert (replacingTokens != null && !replacingTokens.isEmpty());
        assert (newNode != null && oldNode != null);
        this.lock.writeLock().lock();
        try {
            Collection oldNodeTokens = this.tokenToEndpointMap.inverse().get((Object)oldNode);
            if (!replacingTokens.containsAll(oldNodeTokens) || !oldNodeTokens.containsAll(replacingTokens)) {
                throw new RuntimeException(String.format("Node %s is trying to replace node %s with tokens %s with a different set of tokens %s.", newNode, oldNode, oldNodeTokens, replacingTokens));
            }
            logger.debug("Replacing {} with {}", (Object)newNode, (Object)oldNode);
            this.replacementToOriginal.put((Object)newNode, (Object)oldNode);
            this.addBootstrapTokens(replacingTokens, newNode, oldNode);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<InetAddress> getReplacementNode(InetAddress endpoint) {
        this.lock.readLock().lock();
        try {
            Optional<Object> optional = Optional.ofNullable(this.replacementToOriginal.inverse().get((Object)endpoint));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<InetAddress> getReplacingNode(InetAddress endpoint) {
        this.lock.readLock().lock();
        try {
            Optional<Object> optional = Optional.ofNullable(this.replacementToOriginal.get((Object)endpoint));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBootstrapTokens(Collection<Token> tokens) {
        assert (tokens != null && !tokens.isEmpty());
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                this.bootstrapTokens.remove(token);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addLeavingEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndpoints.add(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addMovingEndpoint(Token token, InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.movingEndpoints.add(Pair.create(token, endpoint));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeEndpoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.removeValue(endpoint);
            this.tokenToEndpointMap.removeValue(endpoint);
            this.topology = this.topology.unbuild().removeEndpoint(endpoint).build();
            this.leavingEndpoints.remove(endpoint);
            if (this.replacementToOriginal.remove((Object)endpoint) != null) {
                logger.debug("Node {} failed during replace.", (Object)endpoint);
            }
            this.endpointToHostIdMap.remove((Object)endpoint);
            this.sortedTokens = this.sortTokens();
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Topology updateTopology(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            logger.info("Updating topology for {}", (Object)endpoint);
            this.topology = this.topology.unbuild().updateEndpoint(endpoint).build();
            this.invalidateCachedRingsUnsafe();
            Topology topology = this.topology;
            return topology;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Topology updateTopology() {
        this.lock.writeLock().lock();
        try {
            logger.info("Updating topology for all endpoints that have changed");
            this.topology = this.topology.unbuild().updateEndpoints().build();
            this.invalidateCachedRingsUnsafe();
            Topology topology = this.topology;
            return topology;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                this.movingEndpoints.remove(pair);
                break;
            }
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<Token> getTokens(InetAddress endpoint) {
        assert (endpoint != null);
        assert (this.isMember(endpoint));
        this.lock.readLock().lock();
        try {
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokenToEndpointMap.inverse().get((Object)endpoint));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public Token getToken(InetAddress endpoint) {
        return this.getTokens(endpoint).iterator().next();
    }

    public boolean isMember(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.tokenToEndpointMap.inverse().containsKey((Object)endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isLeaving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.leavingEndpoints.contains(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMoving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            for (Pair<Token, InetAddress> pair : this.movingEndpoints) {
                if (!((InetAddress)pair.right).equals(endpoint)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TokenMetadata cloneOnlyTokenMap() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = new TokenMetadata(SortedBiMultiValMap.create(this.tokenToEndpointMap, null, inetaddressCmp), (BiMap<InetAddress, UUID>)HashBiMap.create(this.endpointToHostIdMap), this.topology, this.partitioner);
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cachedOnlyTokenMap() {
        TokenMetadata tm = this.cachedTokenMap.get();
        if (tm != null) {
            return tm;
        }
        TokenMetadata tokenMetadata = this;
        synchronized (tokenMetadata) {
            tm = this.cachedTokenMap.get();
            if (tm != null) {
                return tm;
            }
            tm = this.cloneOnlyTokenMap();
            this.cachedTokenMap.set(tm);
            return tm;
        }
    }

    public TokenMetadata cloneAfterAllLeft() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = TokenMetadata.removeEndpoints(this.cloneOnlyTokenMap(), this.leavingEndpoints);
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static TokenMetadata removeEndpoints(TokenMetadata allLeftMetadata, Set<InetAddress> leavingEndpoints) {
        for (InetAddress endpoint : leavingEndpoints) {
            allLeftMetadata.removeEndpoint(endpoint);
        }
        return allLeftMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllSettled() {
        this.lock.readLock().lock();
        try {
            TokenMetadata metadata = this.cloneOnlyTokenMap();
            for (InetAddress inetAddress : this.leavingEndpoints) {
                metadata.removeEndpoint(inetAddress);
            }
            for (Pair pair : this.movingEndpoints) {
                metadata.updateNormalToken((Token)pair.left, (InetAddress)pair.right);
            }
            TokenMetadata tokenMetadata = metadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public InetAddress getEndpoint(Token token) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = this.tokenToEndpointMap.get(token);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Range<Token>> getPrimaryRangesFor(Collection<Token> tokens) {
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(tokens.size());
        for (Token right : tokens) {
            ranges.add(new Range<Token>(this.getPredecessor(right), right));
        }
        return ranges;
    }

    @Deprecated
    public Range<Token> getPrimaryRangeFor(Token right) {
        return this.getPrimaryRangesFor(Arrays.asList(right)).iterator().next();
    }

    public ArrayList<Token> sortedTokens() {
        return this.sortedTokens;
    }

    public Multimap<Range<Token>, InetAddress> getPendingRangesMM(String keyspaceName) {
        HashMultimap map = HashMultimap.create();
        PendingRangeMaps pendingRangeMaps = (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
        if (pendingRangeMaps != null) {
            for (Map.Entry<Range<Token>, List<InetAddress>> entry : pendingRangeMaps) {
                Range<Token> range = entry.getKey();
                for (InetAddress address : entry.getValue()) {
                    map.put(range, (Object)address);
                }
            }
        }
        return map;
    }

    public PendingRangeMaps getPendingRanges(String keyspaceName) {
        return (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
    }

    public List<Range<Token>> getPendingRanges(String keyspaceName, InetAddress endpoint) {
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
        for (Map.Entry entry : this.getPendingRangesMM(keyspaceName).entries()) {
            if (!((InetAddress)entry.getValue()).equals(endpoint)) continue;
            ranges.add((Range<Token>)entry.getKey());
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        long startedAt = System.currentTimeMillis();
        ConcurrentMap<String, PendingRangeMaps> concurrentMap = this.pendingRanges;
        synchronized (concurrentMap) {
            TokenMetadata metadata;
            HashSet<Pair<Token, InetAddress>> movingEndpointsClone;
            HashSet<InetAddress> leavingEndpointsClone;
            BiMultiValMap<Token, InetAddress> bootstrapTokensClone;
            this.lock.readLock().lock();
            try {
                if (this.bootstrapTokens.isEmpty() && this.leavingEndpoints.isEmpty() && this.movingEndpoints.isEmpty()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("No bootstrapping, leaving or moving nodes -> empty pending ranges for {}", (Object)keyspaceName);
                    }
                    this.pendingRanges.put(keyspaceName, new PendingRangeMaps());
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting pending range calculation for {}", (Object)keyspaceName);
                }
                bootstrapTokensClone = new BiMultiValMap<Token, InetAddress>(this.bootstrapTokens);
                leavingEndpointsClone = new HashSet<InetAddress>(this.leavingEndpoints);
                movingEndpointsClone = new HashSet<Pair<Token, InetAddress>>(this.movingEndpoints);
                metadata = this.cloneOnlyTokenMap();
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.pendingRanges.put(keyspaceName, TokenMetadata.calculatePendingRanges(strategy, metadata, bootstrapTokensClone, leavingEndpointsClone, movingEndpointsClone));
            long took = System.currentTimeMillis() - startedAt;
            if (logger.isDebugEnabled()) {
                logger.debug("Pending range calculation for {} completed (took: {}ms)", (Object)keyspaceName, (Object)took);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Calculated pending ranges for {}:\n{}", (Object)keyspaceName, (Object)(this.pendingRanges.isEmpty() ? "<empty>" : this.printPendingRanges()));
            }
        }
    }

    private static PendingRangeMaps calculatePendingRanges(AbstractReplicationStrategy strategy, TokenMetadata metadata, BiMultiValMap<Token, InetAddress> bootstrapTokens, Set<InetAddress> leavingEndpoints, Set<Pair<Token, InetAddress>> movingEndpoints) {
        PendingRangeMaps newPendingRanges = new PendingRangeMaps();
        Multimap<InetAddress, Range<Token>> addressRanges = strategy.getAddressRanges(metadata);
        TokenMetadata allLeftMetadata = TokenMetadata.removeEndpoints(metadata.cloneOnlyTokenMap(), leavingEndpoints);
        HashSet affectedRanges = new HashSet();
        for (InetAddress endpoint : leavingEndpoints) {
            affectedRanges.addAll(addressRanges.get((Object)endpoint));
        }
        for (Range range : affectedRanges) {
            ImmutableSet immutableSet = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, metadata));
            ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
            for (InetAddress address : Sets.difference((Set)newEndpoints, (Set)immutableSet)) {
                newPendingRanges.addPendingRange(range, address);
            }
        }
        Multimap<InetAddress, Token> bootstrapAddresses = bootstrapTokens.inverse();
        for (InetAddress inetAddress : bootstrapAddresses.keySet()) {
            Collection tokens = bootstrapAddresses.get((Object)inetAddress);
            allLeftMetadata.updateNormalTokens(tokens, inetAddress);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)inetAddress)) {
                newPendingRanges.addPendingRange(range, inetAddress);
            }
            allLeftMetadata.removeEndpoint(inetAddress);
        }
        for (Pair pair : movingEndpoints) {
            HashSet<Range> moveAffectedRanges = new HashSet<Range>();
            InetAddress endpoint = (InetAddress)pair.right;
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                moveAffectedRanges.add(range);
            }
            allLeftMetadata.updateNormalToken((Token)pair.left, endpoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                moveAffectedRanges.add(range);
            }
            for (Range range : moveAffectedRanges) {
                ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, metadata));
                ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
                Sets.SetView difference = Sets.difference((Set)newEndpoints, (Set)currentEndpoints);
                for (InetAddress address : difference) {
                    Collection newRanges = strategy.getAddressRanges(allLeftMetadata).get((Object)address);
                    Collection oldRanges = strategy.getAddressRanges(metadata).get((Object)address);
                    newRanges.removeAll(oldRanges);
                    for (Range newRange : newRanges) {
                        for (Range<Token> range2 : newRange.subtractAll(oldRanges)) {
                            newPendingRanges.addPendingRange(range2, address);
                        }
                    }
                }
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        return newPendingRanges;
    }

    public Token getPredecessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + this.tokenToEndpointMapKeysAsStrings();
        return (Token)(index == 0 ? tokens.get(tokens.size() - 1) : tokens.get(index - 1));
    }

    public Token getSuccessor(Token token) {
        ArrayList<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + this.tokenToEndpointMapKeysAsStrings();
        return (Token)(index == tokens.size() - 1 ? tokens.get(0) : tokens.get(index + 1));
    }

    private String tokenToEndpointMapKeysAsStrings() {
        this.lock.readLock().lock();
        try {
            String string = StringUtils.join(this.tokenToEndpointMap.keySet(), (String)", ");
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BiMultiValMap<Token, InetAddress> getBootstrapTokens() {
        this.lock.readLock().lock();
        try {
            BiMultiValMap<Token, InetAddress> biMultiValMap = new BiMultiValMap<Token, InetAddress>(this.bootstrapTokens);
            return biMultiValMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<InetAddress> getAllEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.endpointToHostIdMap.keySet());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<InetAddress> getLeavingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.leavingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<Pair<Token, InetAddress>> getMovingEndpoints() {
        this.lock.readLock().lock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.movingEndpoints);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static int firstTokenIndex(ArrayList ring, Token start, boolean insertMin) {
        assert (ring.size() > 0);
        int i = Collections.binarySearch(ring, start);
        if (i < 0 && (i = (i + 1) * -1) >= ring.size()) {
            i = insertMin ? -1 : 0;
        }
        return i;
    }

    public static Token firstToken(ArrayList<Token> ring, Token start) {
        return ring.get(TokenMetadata.firstTokenIndex(ring, start, false));
    }

    public static Iterator<Token> ringIterator(final ArrayList<Token> ring, final Token start, boolean includeMin) {
        if (ring.isEmpty()) {
            return includeMin ? Iterators.singletonIterator((Object)start.getPartitioner().getMinimumToken()) : Iterators.emptyIterator();
        }
        final boolean insertMin = includeMin && !ring.get(0).isMinimum();
        final int startIndex = TokenMetadata.firstTokenIndex(ring, start, insertMin);
        return new AbstractIterator<Token>(){
            int j;
            {
                this.j = startIndex;
            }

            protected Token computeNext() {
                Token token;
                block10: {
                    block8: {
                        Token token2;
                        block9: {
                            if (this.j < -1) {
                                return (Token)this.endOfData();
                            }
                            try {
                                if (this.j != -1) break block8;
                                token2 = start.getPartitioner().getMinimumToken();
                                ++this.j;
                                if (this.j != ring.size()) break block9;
                                int n = this.j = insertMin ? -1 : 0;
                            }
                            catch (Throwable throwable) {
                                ++this.j;
                                if (this.j == ring.size()) {
                                    int n = this.j = insertMin ? -1 : 0;
                                }
                                if (this.j == startIndex) {
                                    this.j = -2;
                                }
                                throw throwable;
                            }
                        }
                        if (this.j == startIndex) {
                            this.j = -2;
                        }
                        return token2;
                    }
                    token = (Token)ring.get(this.j);
                    ++this.j;
                    if (this.j != ring.size()) break block10;
                    int n = this.j = insertMin ? -1 : 0;
                }
                if (this.j == startIndex) {
                    this.j = -2;
                }
                return token;
            }
        };
    }

    public void clearUnsafe() {
        this.lock.writeLock().lock();
        try {
            this.tokenToEndpointMap.clear();
            this.endpointToHostIdMap.clear();
            this.bootstrapTokens.clear();
            this.leavingEndpoints.clear();
            this.pendingRanges.clear();
            this.movingEndpoints.clear();
            this.sortedTokens.clear();
            this.topology = Topology.empty();
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            Set eps = this.tokenToEndpointMap.inverse().keySet();
            if (!eps.isEmpty()) {
                sb.append("Normal Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress inetAddress : eps) {
                    sb.append(inetAddress);
                    sb.append(':');
                    sb.append(this.tokenToEndpointMap.inverse().get((Object)inetAddress));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.bootstrapTokens.isEmpty()) {
                sb.append("Bootstrapping Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (Map.Entry entry : this.bootstrapTokens.entrySet()) {
                    sb.append(entry.getValue()).append(':').append(entry.getKey());
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.leavingEndpoints.isEmpty()) {
                sb.append("Leaving Endpoints:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress inetAddress : this.leavingEndpoints) {
                    sb.append(inetAddress);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.pendingRanges.isEmpty()) {
                sb.append("Pending Ranges:");
                sb.append(System.getProperty("line.separator"));
                sb.append(this.printPendingRanges());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    private String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (PendingRangeMaps pendingRangeMaps : this.pendingRanges.values()) {
            sb.append(pendingRangeMaps.printPendingRanges());
        }
        return sb.toString();
    }

    public Collection<InetAddress> pendingEndpointsFor(Token token, String keyspaceName) {
        PendingRangeMaps pendingRangeMaps = (PendingRangeMaps)this.pendingRanges.get(keyspaceName);
        if (pendingRangeMaps == null) {
            return Collections.emptyList();
        }
        return pendingRangeMaps.pendingEndpointsFor(token);
    }

    public Collection<InetAddress> getWriteEndpoints(Token token, String keyspaceName, Collection<InetAddress> naturalEndpoints) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(naturalEndpoints, this.pendingEndpointsFor(token, keyspaceName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<InetAddress, Token> getEndpointToTokenMapForReading() {
        this.lock.readLock().lock();
        try {
            HashMultimap cloned = HashMultimap.create();
            for (Map.Entry<Token, InetAddress> entry : this.tokenToEndpointMap.entrySet()) {
                cloned.put((Object)entry.getValue(), (Object)entry.getKey());
            }
            HashMultimap hashMultimap = cloned;
            return hashMultimap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<Token, InetAddress> getNormalAndBootstrappingTokenToEndpointMap() {
        this.lock.readLock().lock();
        try {
            HashMap<Token, InetAddress> map = new HashMap<Token, InetAddress>(this.tokenToEndpointMap.size() + this.bootstrapTokens.size());
            map.putAll(this.tokenToEndpointMap);
            map.putAll(this.bootstrapTokens);
            HashMap<Token, InetAddress> hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Topology getTopology() {
        assert (this != StorageService.instance.getTokenMetadata());
        return this.topology;
    }

    public long getRingVersion() {
        this.lock.readLock().lock();
        try {
            long l = this.ringVersion;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void invalidateCachedRings() {
        this.lock.writeLock().lock();
        try {
            this.invalidateCachedRingsUnsafe();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void invalidateCachedRingsUnsafe() {
        ++this.ringVersion;
        this.cachedTokenMap.set(null);
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.partitioner.decorateKey(key);
    }

    public static class Topology {
        private final ImmutableMultimap<String, InetAddress> dcEndpoints;
        private final ImmutableMap<String, ImmutableMultimap<String, InetAddress>> dcRacks;
        private final ImmutableMap<InetAddress, Pair<String, String>> currentLocations;

        private Topology(Builder builder) {
            this.dcEndpoints = ImmutableMultimap.copyOf((Multimap)builder.dcEndpoints);
            ImmutableMap.Builder dcRackBuilder = ImmutableMap.builder();
            for (Map.Entry entry : builder.dcRacks.entrySet()) {
                dcRackBuilder.put(entry.getKey(), (Object)ImmutableMultimap.copyOf((Multimap)((Multimap)entry.getValue())));
            }
            this.dcRacks = dcRackBuilder.build();
            this.currentLocations = ImmutableMap.copyOf((Map)builder.currentLocations);
        }

        public Multimap<String, InetAddress> getDatacenterEndpoints() {
            return this.dcEndpoints;
        }

        public ImmutableMap<String, ImmutableMultimap<String, InetAddress>> getDatacenterRacks() {
            return this.dcRacks;
        }

        Builder unbuild() {
            return new Builder(this);
        }

        static Builder builder() {
            return new Builder();
        }

        static Topology empty() {
            return Topology.builder().build();
        }

        private static class Builder {
            private final Multimap<String, InetAddress> dcEndpoints;
            private final Map<String, Multimap<String, InetAddress>> dcRacks;
            private final Map<InetAddress, Pair<String, String>> currentLocations;

            Builder() {
                this.dcEndpoints = HashMultimap.create();
                this.dcRacks = new HashMap<String, Multimap<String, InetAddress>>();
                this.currentLocations = new HashMap<InetAddress, Pair<String, String>>();
            }

            Builder(Topology from) {
                this.dcEndpoints = HashMultimap.create((Multimap)from.dcEndpoints);
                this.dcRacks = Maps.newHashMapWithExpectedSize((int)from.dcRacks.size());
                for (Map.Entry entry : from.dcRacks.entrySet()) {
                    this.dcRacks.put((String)entry.getKey(), (Multimap<String, InetAddress>)HashMultimap.create((Multimap)((Multimap)entry.getValue())));
                }
                this.currentLocations = new HashMap<InetAddress, Pair<String, String>>((Map<InetAddress, Pair<String, String>>)from.currentLocations);
            }

            Builder addEndpoint(InetAddress ep) {
                IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                String dc = snitch.getDatacenter(ep);
                String rack = snitch.getRack(ep);
                Pair<String, String> current = this.currentLocations.get(ep);
                if (current != null) {
                    if (((String)current.left).equals(dc) && ((String)current.right).equals(rack)) {
                        return this;
                    }
                    this.doRemoveEndpoint(ep, current);
                }
                this.doAddEndpoint(ep, dc, rack);
                return this;
            }

            private void doAddEndpoint(InetAddress ep, String dc, String rack) {
                this.dcEndpoints.put((Object)dc, (Object)ep);
                if (!this.dcRacks.containsKey(dc)) {
                    this.dcRacks.put(dc, (Multimap<String, InetAddress>)HashMultimap.create());
                }
                this.dcRacks.get(dc).put((Object)rack, (Object)ep);
                this.currentLocations.put(ep, Pair.create(dc, rack));
            }

            Builder removeEndpoint(InetAddress ep) {
                if (!this.currentLocations.containsKey(ep)) {
                    return this;
                }
                this.doRemoveEndpoint(ep, this.currentLocations.remove(ep));
                return this;
            }

            private void doRemoveEndpoint(InetAddress ep, Pair<String, String> current) {
                this.dcRacks.get(current.left).remove(current.right, (Object)ep);
                this.dcEndpoints.remove(current.left, (Object)ep);
            }

            Builder updateEndpoint(InetAddress ep) {
                IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                if (snitch == null || !this.currentLocations.containsKey(ep)) {
                    return this;
                }
                this.updateEndpoint(ep, snitch);
                return this;
            }

            Builder updateEndpoints() {
                IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                if (snitch == null) {
                    return this;
                }
                for (InetAddress ep : this.currentLocations.keySet()) {
                    this.updateEndpoint(ep, snitch);
                }
                return this;
            }

            private void updateEndpoint(InetAddress ep, IEndpointSnitch snitch) {
                Pair<String, String> current = this.currentLocations.get(ep);
                String dc = snitch.getDatacenter(ep);
                String rack = snitch.getRack(ep);
                if (dc.equals(current.left) && rack.equals(current.right)) {
                    return;
                }
                this.doRemoveEndpoint(ep, current);
                this.doAddEndpoint(ep, dc, rack);
            }

            Topology build() {
                return new Topology(this);
            }
        }
    }
}

