/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.utils.ChecksumType;

public abstract class Version {
    private static final Pattern VALIDATION = Pattern.compile("[a-z]+");
    protected final String version;
    protected final SSTableFormat format;

    protected Version(SSTableFormat format, String version) {
        this.format = format;
        this.version = version;
    }

    public abstract boolean isLatestVersion();

    public abstract boolean hasSamplingLevel();

    public abstract boolean hasNewStatsFile();

    public abstract ChecksumType compressedChecksumType();

    public abstract ChecksumType uncompressedChecksumType();

    public abstract boolean hasRepairedAt();

    public abstract boolean tracksLegacyCounterShards();

    public abstract boolean hasNewFileName();

    public abstract boolean storeRows();

    public abstract int correspondingMessagingVersion();

    public abstract boolean hasOldBfHashOrder();

    public abstract boolean hasCompactionAncestors();

    public abstract boolean hasBoundaries();

    public abstract boolean hasCommitLogLowerBound();

    public abstract boolean hasCommitLogIntervals();

    public abstract boolean hasAccurateMinMax();

    public String getVersion() {
        return this.version;
    }

    public SSTableFormat getSSTableFormat() {
        return this.format;
    }

    public static boolean validate(String ver) {
        return ver != null && VALIDATION.matcher(ver).matches();
    }

    public abstract boolean isCompatible();

    public abstract boolean isCompatibleForStreaming();

    public String toString() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version1 = (Version)o;
        return !(this.version != null ? !this.version.equals(version1.version) : version1.version != null);
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public abstract boolean hasOriginatingHostId();
}

