/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.command.Command;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="compactionhistory", description="Print history of compaction")
public class CompactionHistory
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.println("Compaction History: ");
        TabularData tabularData = probe.getCompactionHistory();
        if (tabularData.isEmpty()) {
            out.printf("There is no compaction history", new Object[0]);
            return;
        }
        String format = "%-41s%-19s%-29s%-26s%-15s%-15s%s%n";
        List<String> indexNames = tabularData.getTabularType().getIndexNames();
        out.printf(format, Iterables.toArray(indexNames, Object.class));
        Set<?> values = tabularData.keySet();
        for (Object eachValue : values) {
            List value = (List)eachValue;
            out.printf(format, Iterables.toArray((Iterable)value, Object.class));
        }
    }
}

