/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.transport.ProtocolVersionLimit;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfiguredLimit
implements ProtocolVersionLimit {
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredLimit.class);
    static final String DISABLE_MAX_PROTOCOL_AUTO_OVERRIDE = "cassandra.disable_max_protocol_auto_override";
    static final CassandraVersion MIN_VERSION_FOR_V4 = new CassandraVersion("3.0.0");

    @Override
    public abstract int getMaxVersion();

    public abstract void updateMaxSupportedVersion();

    public static ConfiguredLimit newLimit() {
        if (Boolean.getBoolean(DISABLE_MAX_PROTOCOL_AUTO_OVERRIDE)) {
            return new StaticLimit(4);
        }
        int fromConfig = DatabaseDescriptor.getNativeProtocolMaxVersionOverride();
        return fromConfig != Integer.MIN_VALUE ? new StaticLimit(fromConfig) : new DynamicLimit(4);
    }

    private static class DynamicLimit
    extends ConfiguredLimit {
        private volatile int maxVersion;

        private DynamicLimit(int initialLimit) {
            this.maxVersion = initialLimit;
            this.maybeUpdateVersion(true);
        }

        @Override
        public int getMaxVersion() {
            return this.maxVersion;
        }

        @Override
        public void updateMaxSupportedVersion() {
            this.maybeUpdateVersion(false);
        }

        private void maybeUpdateVersion(boolean allowLowering) {
            boolean enforceV3Cap = SystemKeyspace.loadPeerVersions().values().stream().anyMatch(v -> v.compareTo(MIN_VERSION_FOR_V4) < 0);
            if (!enforceV3Cap) {
                this.maxVersion = 4;
                return;
            }
            if (this.maxVersion > 3 && !allowLowering) {
                logger.info("Detected peers which do not fully support protocol V4, but V4 was previously negotiable. Not enforcing cap as this can cause issues for older client versions. After the next restart the server will apply the cap");
                return;
            }
            logger.info("Detected peers which do not fully support protocol V4. Capping max negotiable version to V3");
            this.maxVersion = 3;
        }
    }

    private static class StaticLimit
    extends ConfiguredLimit {
        private final int maxVersion;

        private StaticLimit(int maxVersion) {
            if (maxVersion < 3 || maxVersion > 4) {
                throw new IllegalArgumentException(String.format("Invalid max protocol version supplied (%s); Values between %s and %s are supported", maxVersion, 3, 4));
            }
            this.maxVersion = maxVersion;
            logger.info("Native transport max negotiable version statically limited to {}", (Object)maxVersion);
        }

        @Override
        public int getMaxVersion() {
            return this.maxVersion;
        }

        @Override
        public void updateMaxSupportedVersion() {
        }
    }
}

