/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.EmptyPartitionsDiscarder;
import org.apache.cassandra.db.transform.Filter;
import org.apache.cassandra.db.transform.FilteredPartitions;
import org.apache.cassandra.db.transform.MorePartitions;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.ReplicaFilteringProtection;
import org.apache.cassandra.service.ResponseResolver;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public class DataResolver
extends ResponseResolver {
    private static final boolean DROP_OVERSIZED_READ_REPAIR_MUTATIONS = Boolean.getBoolean("cassandra.drop_oversized_readrepair_mutations");
    @VisibleForTesting
    final List<AsyncOneResponse> repairResults = Collections.synchronizedList(new ArrayList());
    private final boolean enforceStrictLiveness;

    DataResolver(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, int maxResponseCount) {
        super(keyspace, command, consistency, maxResponseCount);
        this.enforceStrictLiveness = command.metadata().enforceStrictLiveness();
    }

    @Override
    public PartitionIterator getData() {
        ReadResponse response = (ReadResponse)((MessageIn)this.responses.iterator().next()).payload;
        return UnfilteredPartitionIterators.filter(response.makeIterator(this.command), this.command.nowInSec());
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    @Override
    public void compareResponses() {
        try (PartitionIterator iterator = this.resolve();){
            PartitionIterators.consume(iterator);
        }
    }

    @Override
    public PartitionIterator resolve() {
        if (!this.needsReplicaFilteringProtection()) {
            ResolveContext context = new ResolveContext(this.responses.size());
            return this.resolveWithReadRepair(context, i -> this.shortReadProtectedResponse(i, context), UnaryOperator.identity());
        }
        return this.resolveWithReplicaFilteringProtection();
    }

    private boolean needsReplicaFilteringProtection() {
        return !this.command.rowFilter().isEmpty();
    }

    private UnfilteredPartitionIterator shortReadProtectedResponse(int i, ResolveContext context) {
        UnfilteredPartitionIterator originalResponse = ((ReadResponse)((MessageIn)this.responses.get((int)i)).payload).makeIterator(this.command);
        return context.needShortReadProtection() ? this.extendWithShortReadProtection(originalResponse, context.sources[i], context.mergedResultCounter) : originalResponse;
    }

    private PartitionIterator resolveWithReadRepair(ResolveContext context, ResponseProvider responseProvider, UnaryOperator<PartitionIterator> preCountFilter) {
        return this.resolveInternal(context, new RepairMergeListener(context.sources), responseProvider, preCountFilter);
    }

    private PartitionIterator resolveWithReplicaFilteringProtection() {
        int count = this.responses.size();
        ResolveContext firstPhaseContext = new ResolveContext(count);
        ResolveContext secondPhaseContext = new ResolveContext(count);
        ReplicaFilteringProtection rfp = new ReplicaFilteringProtection(this.keyspace, this.command, this.consistency, firstPhaseContext.sources);
        PartitionIterator firstPhasePartitions = this.resolveInternal(firstPhaseContext, rfp.mergeController(), i -> this.shortReadProtectedResponse(i, firstPhaseContext), UnaryOperator.identity());
        PartitionIterators.consume(firstPhasePartitions);
        firstPhasePartitions.close();
        this.responses.clearUnsafe();
        return this.resolveWithReadRepair(secondPhaseContext, rfp::queryProtectedPartitions, results -> this.command.rowFilter().filter((PartitionIterator)results, this.command.metadata(), this.command.nowInSec()));
    }

    private PartitionIterator resolveInternal(ResolveContext context, UnfilteredPartitionIterators.MergeListener mergeListener, ResponseProvider responseProvider, UnaryOperator<PartitionIterator> preCountFilter) {
        int count = context.sources.length;
        ArrayList<UnfilteredPartitionIterator> results = new ArrayList<UnfilteredPartitionIterator>(count);
        for (int i = 0; i < count; ++i) {
            results.add(responseProvider.getResponse(i));
        }
        UnfilteredPartitionIterator merged = UnfilteredPartitionIterators.merge(results, this.command.nowInSec(), mergeListener);
        FilteredPartitions filtered = FilteredPartitions.filter(merged, new Filter(this.command.nowInSec(), this.command.metadata().enforceStrictLiveness()));
        PartitionIterator counted = Transformation.apply((PartitionIterator)preCountFilter.apply(filtered), context.mergedResultCounter);
        return this.command.isForThrift() ? counted : Transformation.apply(counted, new EmptyPartitionsDiscarder());
    }

    private UnfilteredPartitionIterator extendWithShortReadProtection(UnfilteredPartitionIterator partitions, InetAddress source, DataLimits.Counter mergedResultCounter) {
        DataLimits.Counter singleResultCounter = this.command.limits().newCounter(this.command.nowInSec(), false, this.command.selectsFullPartition(), this.enforceStrictLiveness).onlyCount();
        ShortReadPartitionsProtection protection = new ShortReadPartitionsProtection(source, singleResultCounter, mergedResultCounter);
        if (!this.command.isLimitedToOnePartition()) {
            partitions = MorePartitions.extend(partitions, protection);
        }
        partitions = Transformation.apply(partitions, protection);
        partitions = Transformation.apply(partitions, singleResultCounter);
        return partitions;
    }

    private class ShortReadPartitionsProtection
    extends Transformation<UnfilteredRowIterator>
    implements MorePartitions<UnfilteredPartitionIterator> {
        private final InetAddress source;
        private final DataLimits.Counter singleResultCounter;
        private final DataLimits.Counter mergedResultCounter;
        private DecoratedKey lastPartitionKey;
        private boolean partitionsFetched;

        private ShortReadPartitionsProtection(InetAddress source, DataLimits.Counter singleResultCounter, DataLimits.Counter mergedResultCounter) {
            this.source = source;
            this.singleResultCounter = singleResultCounter;
            this.mergedResultCounter = mergedResultCounter;
        }

        @Override
        public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            this.partitionsFetched = true;
            this.lastPartitionKey = partition.partitionKey();
            ShortReadRowsProtection protection = new ShortReadRowsProtection(partition.metadata(), partition.partitionKey());
            return Transformation.apply(MoreRows.extend(partition, protection), protection);
        }

        @Override
        public UnfilteredPartitionIterator moreContents() {
            assert (!this.mergedResultCounter.isDone());
            assert (!DataResolver.this.command.limits().isUnlimited());
            assert (!DataResolver.this.command.isLimitedToOnePartition());
            if (!this.singleResultCounter.isDone() && DataResolver.this.command.limits().perPartitionCount() == Integer.MAX_VALUE) {
                return null;
            }
            if (!this.partitionsFetched) {
                return null;
            }
            this.partitionsFetched = false;
            int toQuery = DataResolver.this.command.limits().count() != Integer.MAX_VALUE ? DataResolver.this.command.limits().count() - this.mergedResultCounter.counted() : DataResolver.this.command.limits().perPartitionCount();
            ColumnFamilyStore.metricsFor((UUID)DataResolver.this.command.metadata().cfId).shortReadProtectionRequests.mark();
            Tracing.trace("Requesting {} extra rows from {} for short read protection", (Object)toQuery, (Object)this.source);
            PartitionRangeReadCommand cmd = this.makeFetchAdditionalPartitionReadCommand(toQuery);
            return this.executeReadCommand(cmd);
        }

        private PartitionRangeReadCommand makeFetchAdditionalPartitionReadCommand(int toQuery) {
            PartitionRangeReadCommand cmd = (PartitionRangeReadCommand)DataResolver.this.command;
            DataLimits newLimits = cmd.limits().forShortReadRetry(toQuery);
            AbstractBounds<PartitionPosition> bounds = cmd.dataRange().keyRange();
            Range<PartitionPosition> newBounds = bounds.inclusiveRight() ? new Range<DecoratedKey>(this.lastPartitionKey, (DecoratedKey)bounds.right) : new ExcludingBounds<DecoratedKey>(this.lastPartitionKey, (DecoratedKey)bounds.right);
            DataRange newDataRange = cmd.dataRange().forSubRange(newBounds);
            return cmd.withUpdatedLimitsAndDataRange(newLimits, newDataRange);
        }

        private UnfilteredPartitionIterator executeReadCommand(ReadCommand cmd) {
            DataResolver resolver = new DataResolver(DataResolver.this.keyspace, cmd, ConsistencyLevel.ONE, 1);
            ReadCallback handler = new ReadCallback(resolver, ConsistencyLevel.ONE, cmd, Collections.singletonList(this.source));
            if (StorageProxy.canDoLocalRequest(this.source)) {
                StageManager.getStage(Stage.READ).maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(cmd, handler));
            } else {
                MessagingService.instance().sendRRWithFailure(cmd.createMessage(MessagingService.current_version), this.source, handler);
            }
            handler.awaitResults();
            assert (resolver.responses.size() == 1);
            return ((ReadResponse)((MessageIn)resolver.responses.get((int)0)).payload).makeIterator(DataResolver.this.command);
        }

        private class ShortReadRowsProtection
        extends Transformation
        implements MoreRows<UnfilteredRowIterator> {
            private final CFMetaData metadata;
            private final DecoratedKey partitionKey;
            private Clustering lastClustering;
            private int lastCounted = 0;
            private int lastFetched = 0;
            private int lastQueried = 0;

            private ShortReadRowsProtection(CFMetaData metadata, DecoratedKey partitionKey) {
                this.metadata = metadata;
                this.partitionKey = partitionKey;
            }

            @Override
            public Row applyToRow(Row row) {
                this.lastClustering = row.clustering();
                return row;
            }

            @Override
            public UnfilteredRowIterator moreContents() {
                assert (!ShortReadPartitionsProtection.this.mergedResultCounter.isDoneForPartition());
                assert (!DataResolver.this.command.limits().isUnlimited());
                if (!ShortReadPartitionsProtection.this.singleResultCounter.isDoneForPartition() && DataResolver.this.command.limits().perPartitionCount() == Integer.MAX_VALUE) {
                    return null;
                }
                if (ShortReadPartitionsProtection.this.singleResultCounter.countedInCurrentPartition() == 0) {
                    return null;
                }
                if (Clustering.EMPTY == this.lastClustering) {
                    return null;
                }
                this.lastFetched = ShortReadPartitionsProtection.this.singleResultCounter.countedInCurrentPartition() - this.lastCounted;
                this.lastCounted = ShortReadPartitionsProtection.this.singleResultCounter.countedInCurrentPartition();
                if (this.lastQueried > 0 && this.lastFetched < this.lastQueried) {
                    return null;
                }
                this.lastQueried = Math.min(DataResolver.this.command.limits().count(), DataResolver.this.command.limits().perPartitionCount());
                ColumnFamilyStore.metricsFor((UUID)this.metadata.cfId).shortReadProtectionRequests.mark();
                Tracing.trace("Requesting {} extra rows from {} for short read protection", (Object)this.lastQueried, (Object)ShortReadPartitionsProtection.this.source);
                SinglePartitionReadCommand cmd = this.makeFetchAdditionalRowsReadCommand(this.lastQueried);
                return UnfilteredPartitionIterators.getOnlyElement(ShortReadPartitionsProtection.this.executeReadCommand(cmd), cmd);
            }

            private SinglePartitionReadCommand makeFetchAdditionalRowsReadCommand(int toQuery) {
                ClusteringIndexFilter filter = DataResolver.this.command.clusteringIndexFilter(this.partitionKey);
                if (null != this.lastClustering) {
                    filter = filter.forPaging(this.metadata.comparator, this.lastClustering, false);
                }
                return SinglePartitionReadCommand.create(DataResolver.this.command.isForThrift(), DataResolver.this.command.metadata(), DataResolver.this.command.nowInSec(), DataResolver.this.command.columnFilter(), DataResolver.this.command.rowFilter(), DataResolver.this.command.limits().forShortReadRetry(toQuery), this.partitionKey, filter, DataResolver.this.command.indexMetadata());
            }
        }
    }

    private class RepairMergeListener
    implements UnfilteredPartitionIterators.MergeListener {
        private final InetAddress[] sources;

        private RepairMergeListener(InetAddress[] sources) {
            this.sources = sources;
        }

        @Override
        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
            return new MergeListener(partitionKey, this.columns(versions), this.isReversed(versions));
        }

        private PartitionColumns columns(List<UnfilteredRowIterator> versions) {
            Columns statics = Columns.NONE;
            Columns regulars = Columns.NONE;
            for (UnfilteredRowIterator iter : versions) {
                if (iter == null) continue;
                PartitionColumns cols = iter.columns();
                statics = statics.mergeTo(cols.statics);
                regulars = regulars.mergeTo(cols.regulars);
            }
            return new PartitionColumns(statics, regulars);
        }

        private boolean isReversed(List<UnfilteredRowIterator> versions) {
            for (UnfilteredRowIterator iter : versions) {
                if (iter == null) continue;
                return iter.isReverseOrder();
            }
            assert (false) : "Expected at least one iterator";
            return false;
        }

        @Override
        public void close() {
            try {
                FBUtilities.waitOnFutures(DataResolver.this.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
            }
            catch (TimeoutException ex) {
                int blockFor = DataResolver.this.consistency.blockFor(DataResolver.this.keyspace);
                if (Tracing.isTracing()) {
                    Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                } else {
                    ResponseResolver.logger.debug("Timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                }
                throw new ReadTimeoutException(DataResolver.this.consistency, blockFor - 1, blockFor, true);
            }
        }

        private class MergeListener
        implements UnfilteredRowIterators.MergeListener {
            private final DecoratedKey partitionKey;
            private final PartitionColumns columns;
            private final boolean isReversed;
            private final PartitionUpdate[] repairs;
            private final Row.Builder[] currentRows;
            private final RowDiffListener diffListener;
            private DeletionTime partitionLevelDeletion;
            private DeletionTime mergedDeletionTime;
            private final DeletionTime[] sourceDeletionTime;
            private final Slice.Bound[] markerToRepair;

            private MergeListener(DecoratedKey partitionKey, PartitionColumns columns, boolean isReversed) {
                this.repairs = new PartitionUpdate[RepairMergeListener.this.sources.length];
                this.currentRows = new Row.Builder[RepairMergeListener.this.sources.length];
                this.sourceDeletionTime = new DeletionTime[RepairMergeListener.this.sources.length];
                this.markerToRepair = new Slice.Bound[RepairMergeListener.this.sources.length];
                this.partitionKey = partitionKey;
                this.columns = columns;
                this.isReversed = isReversed;
                this.diffListener = new RowDiffListener(){

                    @Override
                    public void onPrimaryKeyLivenessInfo(int i, Clustering clustering, LivenessInfo merged, LivenessInfo original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addPrimaryKeyLivenessInfo(merged);
                        }
                    }

                    @Override
                    public void onDeletion(int i, Clustering clustering, Row.Deletion merged, Row.Deletion original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addRowDeletion(merged);
                        }
                    }

                    @Override
                    public void onComplexDeletion(int i, Clustering clustering, ColumnDefinition column, DeletionTime merged, DeletionTime original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addComplexDeletion(column, merged);
                        }
                    }

                    @Override
                    public void onCell(int i, Clustering clustering, Cell merged, Cell original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addCell(merged);
                        }
                    }
                };
            }

            private PartitionUpdate update(int i) {
                if (this.repairs[i] == null) {
                    this.repairs[i] = new PartitionUpdate(DataResolver.this.command.metadata(), this.partitionKey, this.columns, 1);
                }
                return this.repairs[i];
            }

            private DeletionTime partitionLevelRepairDeletion(int i) {
                return this.repairs[i] == null ? DeletionTime.LIVE : this.repairs[i].partitionLevelDeletion();
            }

            private Row.Builder currentRow(int i, Clustering clustering) {
                if (this.currentRows[i] == null) {
                    this.currentRows[i] = BTreeRow.sortedBuilder();
                    this.currentRows[i].newRow(clustering);
                }
                return this.currentRows[i];
            }

            @Override
            public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                this.partitionLevelDeletion = mergedDeletion;
                for (int i = 0; i < versions.length; ++i) {
                    if (!mergedDeletion.supersedes(versions[i])) continue;
                    this.update(i).addPartitionDeletion(mergedDeletion);
                }
            }

            @Override
            public Row onMergedRows(Row merged, Row[] versions) {
                if (merged.isEmpty()) {
                    return merged;
                }
                Rows.diff(this.diffListener, merged, versions);
                for (int i = 0; i < this.currentRows.length; ++i) {
                    if (this.currentRows[i] == null) continue;
                    this.update(i).add(this.currentRows[i].build());
                }
                Arrays.fill(this.currentRows, null);
                return merged;
            }

            private DeletionTime currentDeletion() {
                return this.mergedDeletionTime == null ? this.partitionLevelDeletion : this.mergedDeletionTime;
            }

            @Override
            public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                try {
                    this.internalOnMergedRangeTombstoneMarkers(merged, versions);
                }
                catch (AssertionError e) {
                    CFMetaData table = DataResolver.this.command.metadata();
                    String details = String.format("Error merging RTs on %s.%s: command=%s, reversed=%b, merged=%s, versions=%s, sources={%s}, responses:%n %s", table.ksName, table.cfName, DataResolver.this.command.toCQLString(), this.isReversed, merged == null ? "null" : merged.toString(table), '[' + Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(versions), rt -> rt == null ? "null" : rt.toString(table))) + ']', Arrays.toString(RepairMergeListener.this.sources), this.makeResponsesDebugString());
                    throw new AssertionError(details, (Throwable)((Object)e));
                }
            }

            private String makeResponsesDebugString() {
                return Joiner.on((String)",\n").join(Iterables.transform(DataResolver.this.getMessages(), m -> m.from + " => " + ((ReadResponse)m.payload).toDebugString(DataResolver.this.command, this.partitionKey)));
            }

            private void internalOnMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                DeletionTime currentDeletion = this.currentDeletion();
                for (int i = 0; i < versions.length; ++i) {
                    DeletionTime sourceDeletion;
                    DeletionTime newDeletion;
                    RangeTombstoneMarker marker = versions[i];
                    if (marker != null) {
                        DeletionTime deletionTime = this.sourceDeletionTime[i] = marker.isOpen(this.isReversed) ? marker.openDeletionTime(this.isReversed) : null;
                    }
                    if (merged == null) {
                        if (marker == null) continue;
                        assert (!currentDeletion.isLive()) : currentDeletion.toString();
                        DeletionTime partitionRepairDeletion = this.partitionLevelRepairDeletion(i);
                        if (this.markerToRepair[i] == null && currentDeletion.supersedes(partitionRepairDeletion)) {
                            assert (marker.isClose(this.isReversed) && currentDeletion.equals(marker.closeDeletionTime(this.isReversed))) : String.format("currentDeletion=%s, marker=%s", currentDeletion, marker.toString(DataResolver.this.command.metadata()));
                            if (marker.isOpen(this.isReversed) && currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                            this.markerToRepair[i] = marker.closeBound(this.isReversed).invert();
                            continue;
                        }
                        if (!marker.isOpen(this.isReversed) || !currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                        this.closeOpenMarker(i, marker.openBound(this.isReversed).invert());
                        continue;
                    }
                    if (merged.isClose(this.isReversed) && this.markerToRepair[i] != null) {
                        this.closeOpenMarker(i, merged.closeBound(this.isReversed));
                    }
                    if (!merged.isOpen(this.isReversed) || (newDeletion = merged.openDeletionTime(this.isReversed)).equals(sourceDeletion = this.sourceDeletionTime[i])) continue;
                    this.markerToRepair[i] = merged.openBound(this.isReversed);
                }
                if (merged != null) {
                    this.mergedDeletionTime = merged.isOpen(this.isReversed) ? merged.openDeletionTime(this.isReversed) : null;
                }
            }

            private void closeOpenMarker(int i, Slice.Bound close) {
                Slice.Bound open = this.markerToRepair[i];
                this.update(i).add(new RangeTombstone(Slice.make(this.isReversed ? close : open, this.isReversed ? open : close), this.currentDeletion()));
                this.markerToRepair[i] = null;
            }

            @Override
            public void close() {
                for (int i = 0; i < this.repairs.length; ++i) {
                    if (null == this.repairs[i]) continue;
                    this.sendRepairMutation(this.repairs[i], RepairMergeListener.this.sources[i]);
                }
            }

            private void sendRepairMutation(PartitionUpdate partition, InetAddress destination) {
                int maxMutationSize;
                Mutation mutation = new Mutation(partition);
                int messagingVersion = MessagingService.instance().getVersion(destination);
                int mutationSize = (int)Mutation.serializer.serializedSize(mutation, messagingVersion);
                if (mutationSize <= (maxMutationSize = DatabaseDescriptor.getMaxMutationSize())) {
                    Tracing.trace("Sending read-repair-mutation to {}", (Object)destination);
                    MessageOut<Mutation> message = mutation.createMessage(MessagingService.Verb.READ_REPAIR);
                    DataResolver.this.repairResults.add(MessagingService.instance().sendRR(message, destination));
                    ColumnFamilyStore.metricsFor((UUID)DataResolver.this.command.metadata().cfId).readRepairRequests.mark();
                } else if (DROP_OVERSIZED_READ_REPAIR_MUTATIONS) {
                    ResponseResolver.logger.debug("Encountered an oversized ({}/{}) read repair mutation for table {}.{}, key {}, node {}", new Object[]{mutationSize, maxMutationSize, DataResolver.this.command.metadata().ksName, DataResolver.this.command.metadata().cfName, DataResolver.this.command.metadata().getKeyValidator().getString(this.partitionKey.getKey()), destination});
                } else {
                    ResponseResolver.logger.warn("Encountered an oversized ({}/{}) read repair mutation for table {}.{}, key {}, node {}", new Object[]{mutationSize, maxMutationSize, DataResolver.this.command.metadata().ksName, DataResolver.this.command.metadata().cfName, DataResolver.this.command.metadata().getKeyValidator().getString(this.partitionKey.getKey()), destination});
                    int blockFor = DataResolver.this.consistency.blockFor(DataResolver.this.keyspace);
                    Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                    throw new ReadTimeoutException(DataResolver.this.consistency, blockFor - 1, blockFor, true);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface ResponseProvider {
        public UnfilteredPartitionIterator getResponse(int var1);
    }

    private class ResolveContext {
        private final InetAddress[] sources;
        private final DataLimits.Counter mergedResultCounter;

        private ResolveContext(int count) {
            assert (count <= DataResolver.this.responses.size());
            this.sources = new InetAddress[count];
            for (int i = 0; i < count; ++i) {
                this.sources[i] = ((MessageIn)DataResolver.this.responses.get((int)i)).from;
            }
            this.mergedResultCounter = DataResolver.this.command.limits().newCounter(DataResolver.this.command.nowInSec(), true, DataResolver.this.command.selectsFullPartition(), DataResolver.this.enforceStrictLiveness);
        }

        private boolean needShortReadProtection() {
            return this.sources.length > 1 && !DataResolver.this.command.limits().isUnlimited();
        }
    }
}

