/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;

public class EndpointSnitchInfo
implements EndpointSnitchInfoMBean {
    public static void create() {
        MBeanWrapper.instance.registerMBean((Object)new EndpointSnitchInfo(), "org.apache.cassandra.db:type=EndpointSnitchInfo");
    }

    @Override
    public String getDatacenter(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getDatacenter(InetAddress.getByName(host));
    }

    @Override
    public String getRack(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getRack(InetAddress.getByName(host));
    }

    @Override
    public String getDatacenter() {
        return DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
    }

    @Override
    public String getRack() {
        return DatabaseDescriptor.getEndpointSnitch().getRack(FBUtilities.getBroadcastAddress());
    }

    @Override
    public String getSnitchName() {
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }
}

