/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FastByteOperations;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unmetered
public abstract class AbstractType<T>
implements Comparator<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractType.class);
    public final Comparator<ByteBuffer> reverseComparator;
    public final ComparisonType comparisonType;
    public final boolean isByteOrderComparable;

    protected AbstractType(ComparisonType comparisonType) {
        this.comparisonType = comparisonType;
        this.isByteOrderComparable = comparisonType == ComparisonType.BYTE_ORDER;
        this.reverseComparator = (o1, o2) -> this.compare((ByteBuffer)o2, (ByteBuffer)o1);
        try {
            Method custom = this.getClass().getMethod("compareCustom", ByteBuffer.class, ByteBuffer.class);
            if (custom.getDeclaringClass() == AbstractType.class == (comparisonType == ComparisonType.CUSTOM)) {
                throw new IllegalStateException((comparisonType == ComparisonType.CUSTOM ? "compareCustom must be overridden if ComparisonType is CUSTOM" : "compareCustom should not be overridden if ComparisonType is not CUSTOM") + " (" + this.getClass().getSimpleName() + ")");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
    }

    public static List<String> asCQLTypeStringList(List<AbstractType<?>> abstractTypes) {
        ArrayList<String> r = new ArrayList<String>(abstractTypes.size());
        for (AbstractType<?> abstractType : abstractTypes) {
            r.add(abstractType.asCQL3Type().toString());
        }
        return r;
    }

    public T compose(ByteBuffer bytes) {
        return this.getSerializer().deserialize(bytes);
    }

    public ByteBuffer decompose(T value) {
        return this.getSerializer().serialize(value);
    }

    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "null";
        }
        TypeSerializer<T> serializer = this.getSerializer();
        serializer.validate(bytes);
        return serializer.toString(serializer.deserialize(bytes));
    }

    public abstract ByteBuffer fromString(String var1) throws MarshalException;

    public abstract Term fromJSONObject(Object var1) throws MarshalException;

    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + this.getSerializer().deserialize(buffer).toString() + '\"';
    }

    public void validate(ByteBuffer bytes) throws MarshalException {
        this.getSerializer().validate(bytes);
    }

    @Override
    public final int compare(ByteBuffer left, ByteBuffer right) {
        return this.isByteOrderComparable ? FastByteOperations.compareUnsigned(left, right) : this.compareCustom(left, right);
    }

    public int compareCustom(ByteBuffer left, ByteBuffer right) {
        throw new UnsupportedOperationException();
    }

    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        this.validate(cellValue);
    }

    public CQL3Type asCQL3Type() {
        return new CQL3Type.Custom(this);
    }

    public int compareForCQL(ByteBuffer v1, ByteBuffer v2) {
        return this.compare(v1, v2);
    }

    public abstract TypeSerializer<T> getSerializer();

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public boolean isCounter() {
        return false;
    }

    public boolean isFrozenCollection() {
        return this.isCollection() && !this.isMultiCell();
    }

    public boolean isReversed() {
        return false;
    }

    public static AbstractType<?> parseDefaultParameters(AbstractType<?> baseType, TypeParser parser) throws SyntaxException {
        Map<String, String> parameters = parser.getKeyValueParameters();
        String reversed = parameters.get("reversed");
        if (reversed != null && (reversed.isEmpty() || reversed.equals("true"))) {
            return ReversedType.getInstance(baseType);
        }
        return baseType;
    }

    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this.equals(previous);
    }

    public boolean isValueCompatibleWith(AbstractType<?> otherType) {
        return this.isValueCompatibleWithInternal(otherType instanceof ReversedType ? ((ReversedType)otherType).baseType : otherType);
    }

    protected boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this.isCompatibleWith(otherType);
    }

    public int compareCollectionMembers(ByteBuffer v1, ByteBuffer v2, ByteBuffer collectionName) {
        return this.compare(v1, v2);
    }

    public void validateCollectionMember(ByteBuffer bytes, ByteBuffer collectionName) throws MarshalException {
        this.validate(bytes);
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isMultiCell() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isUDT() {
        return false;
    }

    public AbstractType<?> freeze() {
        return this;
    }

    public boolean isEmptyValueMeaningless() {
        return false;
    }

    public String toString(boolean ignoreFreezing) {
        return this.toString();
    }

    public int componentsCount() {
        return 1;
    }

    public List<AbstractType<?>> getComponents() {
        return Collections.singletonList(this);
    }

    protected int valueLengthIfFixed() {
        return -1;
    }

    public void validateIfFixedSize(ByteBuffer value) {
        if (this.valueLengthIfFixed() < 0) {
            return;
        }
        this.validate(value);
    }

    public void writeValue(ByteBuffer value, DataOutputPlus out) throws IOException {
        assert (value.hasRemaining());
        if (this.valueLengthIfFixed() >= 0) {
            out.write(value);
        } else {
            ByteBufferUtil.writeWithVIntLength(value, out);
        }
    }

    public long writtenLength(ByteBuffer value) {
        assert (value.hasRemaining());
        return this.valueLengthIfFixed() >= 0 ? (long)value.remaining() : (long)TypeSizes.sizeofWithVIntLength(value);
    }

    public ByteBuffer readValue(DataInputPlus in) throws IOException {
        return this.readValue(in, Integer.MAX_VALUE);
    }

    public ByteBuffer readValue(DataInputPlus in, int maxValueSize) throws IOException {
        int length = this.valueLengthIfFixed();
        if (length >= 0) {
            return ByteBufferUtil.read(in, length);
        }
        int l = (int)in.readUnsignedVInt();
        if (l < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        if (l > maxValueSize) {
            throw new IOException(String.format("Corrupt value length %d encountered, as it exceeds the maximum of %d, which is set via max_value_size_in_mb in cassandra.yaml", l, maxValueSize));
        }
        return ByteBufferUtil.read(in, l);
    }

    public void skipValue(DataInputPlus in) throws IOException {
        int length = this.valueLengthIfFixed();
        if (length >= 0) {
            in.skipBytesFully(length);
        } else {
            ByteBufferUtil.skipWithVIntLength(in);
        }
    }

    public boolean referencesUserType(String userTypeName) {
        return false;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void checkComparable() {
        switch (this.comparisonType) {
            case NOT_COMPARABLE: {
                throw new IllegalArgumentException(this + " cannot be used in comparisons, so cannot be used as a clustering column");
            }
        }
    }

    public static enum ComparisonType {
        NOT_COMPARABLE,
        BYTE_ORDER,
        CUSTOM;

    }
}

