/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.FilteredPartitions;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.MergeIterator;

public abstract class UnfilteredPartitionIterators {
    private static final Serializer serializer = new Serializer();
    private static final Comparator<UnfilteredRowIterator> partitionComparator = (p1, p2) -> p1.partitionKey().compareTo(p2.partitionKey());

    private UnfilteredPartitionIterators() {
    }

    public static UnfilteredRowIterator getOnlyElement(UnfilteredPartitionIterator iter, SinglePartitionReadCommand command) {
        UnfilteredRowIterator toReturn = iter.hasNext() ? (UnfilteredRowIterator)iter.next() : EmptyIterators.unfilteredRow(command.metadata(), command.partitionKey(), command.clusteringIndexFilter().isReversed());
        class Close
        extends Transformation {
            final /* synthetic */ UnfilteredPartitionIterator val$iter;

            Close(UnfilteredPartitionIterator unfilteredPartitionIterator) {
                this.val$iter = unfilteredPartitionIterator;
            }

            @Override
            public void onPartitionClose() {
                boolean hadNext = this.val$iter.hasNext();
                this.val$iter.close();
                assert (!hadNext);
            }
        }
        return Transformation.apply(toReturn, new Close(iter));
    }

    public static PartitionIterator filter(UnfilteredPartitionIterator iterator, int nowInSec) {
        return FilteredPartitions.filter(iterator, nowInSec);
    }

    public static UnfilteredPartitionIterator merge(final List<? extends UnfilteredPartitionIterator> iterators, final int nowInSec, final MergeListener listener) {
        assert (listener != null);
        assert (!iterators.isEmpty());
        final boolean isForThrift = iterators.get(0).isForThrift();
        final CFMetaData metadata = iterators.get(0).metadata();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            private DecoratedKey partitionKey;
            private boolean isReverseOrder;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.partitionKey = current.partitionKey();
                this.isReverseOrder = current.isReverseOrder();
                this.toMerge.set(idx, current);
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                UnfilteredRowIterators.MergeListener rowListener = listener.getRowMergeListener(this.partitionKey, this.toMerge);
                for (int i = 0; i < this.toMerge.size(); ++i) {
                    if (this.toMerge.get(i) != null) continue;
                    this.toMerge.set(i, EmptyIterators.unfilteredRow(metadata, this.partitionKey, this.isReverseOrder));
                }
                return UnfilteredRowIterators.merge(this.toMerge, nowInSec, rowListener);
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
                for (int i = 0; i < iterators.size(); ++i) {
                    this.toMerge.add(null);
                }
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public boolean isForThrift() {
                return isForThrift;
            }

            @Override
            public CFMetaData metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
                listener.close();
            }
        };
    }

    public static UnfilteredPartitionIterator mergeLazily(final List<? extends UnfilteredPartitionIterator> iterators, final int nowInSec) {
        assert (!iterators.isEmpty());
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        final boolean isForThrift = iterators.get(0).isForThrift();
        final CFMetaData metadata = iterators.get(0).metadata();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public boolean trivialReduceIsTrivial() {
                return false;
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.toMerge.add(current);
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                return new LazilyInitializedUnfilteredRowIterator(this.toMerge.get(0).partitionKey()){

                    @Override
                    protected UnfilteredRowIterator initializeIterator() {
                        return UnfilteredRowIterators.merge(toMerge, nowInSec);
                    }
                };
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public boolean isForThrift() {
                return isForThrift;
            }

            @Override
            public CFMetaData metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
            }
        };
    }

    public static void digest(ReadCommand command, UnfilteredPartitionIterator iterator, MessageDigest digest, int version) {
        while (iterator.hasNext()) {
            UnfilteredRowIterator partition = (UnfilteredRowIterator)iterator.next();
            Throwable throwable = null;
            try {
                UnfilteredRowIterators.digest(command, partition, digest, version);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static Serializer serializerForIntraNode() {
        return serializer;
    }

    public static UnfilteredPartitionIterator loggingIterator(UnfilteredPartitionIterator iterator, final String id, final boolean fullDetails) {
        class Logging
        extends Transformation<UnfilteredRowIterator> {
            Logging() {
            }

            @Override
            public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
                return UnfilteredRowIterators.loggingIterator(partition, id, fullDetails);
            }
        }
        return Transformation.apply(iterator, new Logging());
    }

    public static class Serializer {
        public void serialize(UnfilteredPartitionIterator iter, ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            assert (version >= 10);
            out.writeBoolean(iter.isForThrift());
            while (iter.hasNext()) {
                out.writeBoolean(true);
                UnfilteredRowIterator partition = (UnfilteredRowIterator)iter.next();
                Throwable throwable = null;
                try {
                    UnfilteredRowIteratorSerializer.serializer.serialize(partition, selection, out, version);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partition == null) continue;
                    if (throwable != null) {
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            out.writeBoolean(false);
        }

        public UnfilteredPartitionIterator deserialize(final DataInputPlus in, final int version, final CFMetaData metadata, final ColumnFilter selection, final SerializationHelper.Flag flag) throws IOException {
            assert (version >= 10);
            final boolean isForThrift = in.readBoolean();
            return new AbstractUnfilteredPartitionIterator(){
                private UnfilteredRowIterator next;
                private boolean hasNext;
                private boolean nextReturned = true;

                @Override
                public boolean isForThrift() {
                    return isForThrift;
                }

                @Override
                public CFMetaData metadata() {
                    return metadata;
                }

                @Override
                public boolean hasNext() {
                    if (!this.nextReturned) {
                        return this.hasNext;
                    }
                    if (null != this.next) {
                        while (this.next.hasNext()) {
                            this.next.next();
                        }
                    }
                    try {
                        this.hasNext = in.readBoolean();
                        this.nextReturned = false;
                        return this.hasNext;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public UnfilteredRowIterator next() {
                    if (this.nextReturned && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.nextReturned = true;
                        this.next = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, selection, flag);
                        return this.next;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public void close() {
                    if (this.next != null) {
                        this.next.close();
                    }
                }
            };
        }
    }

    public static interface MergeListener {
        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey var1, List<UnfilteredRowIterator> var2);

        public void close();
    }
}

