/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;

public class ComplexColumnData
extends ColumnData
implements Iterable<Cell> {
    static final Cell[] NO_CELLS = new Cell[0];
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ComplexColumnData(ColumnDefinition.regularDef("", "", "", SetType.getInstance(ByteType.instance, true)), NO_CELLS, new DeletionTime(0L, 0)));
    private final Object[] cells;
    private final DeletionTime complexDeletion;

    ComplexColumnData(ColumnDefinition column, Object[] cells, DeletionTime complexDeletion) {
        super(column);
        assert (column.isComplex());
        assert (cells.length > 0 || !complexDeletion.isLive());
        this.cells = cells;
        this.complexDeletion = complexDeletion;
    }

    public boolean hasCells() {
        return !BTree.isEmpty(this.cells);
    }

    public int cellsCount() {
        return BTree.size(this.cells);
    }

    public Cell getCell(CellPath path) {
        return (Cell)((Object)BTree.find(this.cells, this.column.asymmetricCellPathComparator(), path));
    }

    public Cell getCellByIndex(int idx) {
        return (Cell)BTree.findByIndex(this.cells, idx);
    }

    public DeletionTime complexDeletion() {
        return this.complexDeletion;
    }

    @Override
    public Iterator<Cell> iterator() {
        return BTree.iterator(this.cells);
    }

    public Iterator<Cell> reverseIterator() {
        return BTree.iterator(this.cells, BTree.Dir.DESC);
    }

    @Override
    public int dataSize() {
        int size = this.complexDeletion.dataSize();
        for (Cell cell : this) {
            size += cell.dataSize();
        }
        return size;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        long heapSize = EMPTY_SIZE + ObjectSizes.sizeOfArray(this.cells);
        for (Cell cell : this) {
            heapSize += cell.unsharedHeapSizeExcludingData();
        }
        return heapSize;
    }

    @Override
    public void validate() {
        for (Cell cell : this) {
            cell.validate();
        }
    }

    @Override
    public void digest(MessageDigest digest) {
        if (!this.complexDeletion.isLive()) {
            this.complexDeletion.digest(digest);
        }
        for (Cell cell : this) {
            cell.digest(digest);
        }
    }

    @Override
    public ComplexColumnData markCounterLocalToBeCleared() {
        return this.transformAndFilter(this.complexDeletion, (Function<? super Cell, ? extends Cell>)((Function)Cell::markCounterLocalToBeCleared));
    }

    public ComplexColumnData filter(ColumnFilter filter, DeletionTime activeDeletion, CFMetaData.DroppedColumn dropped) {
        ColumnFilter.Tester cellTester = filter.newTester(this.column);
        if (cellTester == null && activeDeletion.isLive() && dropped == null) {
            return this;
        }
        DeletionTime newDeletion = activeDeletion.supersedes(this.complexDeletion) ? DeletionTime.LIVE : this.complexDeletion;
        return this.transformAndFilter(newDeletion, (Function<? super Cell, ? extends Cell>)((Function)cell -> !(cellTester != null && !cellTester.includes(cell.path()) || activeDeletion.deletes((Cell)cell) || dropped != null && cell.timestamp() <= dropped.droppedTime) ? cell : null));
    }

    @Override
    public ComplexColumnData purge(DeletionPurger purger, int nowInSec) {
        DeletionTime newDeletion = this.complexDeletion.isLive() || purger.shouldPurge(this.complexDeletion) ? DeletionTime.LIVE : this.complexDeletion;
        return this.transformAndFilter(newDeletion, (Function<? super Cell, ? extends Cell>)((Function)cell -> cell.purge(purger, nowInSec)));
    }

    private ComplexColumnData transformAndFilter(DeletionTime newDeletion, Function<? super Cell, ? extends Cell> function) {
        Object[] transformed = BTree.transformAndFilter(this.cells, function);
        if (this.cells == transformed && newDeletion == this.complexDeletion) {
            return this;
        }
        if (newDeletion == DeletionTime.LIVE && BTree.isEmpty(transformed)) {
            return null;
        }
        return new ComplexColumnData(this.column, transformed, newDeletion);
    }

    @Override
    public ComplexColumnData updateAllTimestamp(long newTimestamp) {
        DeletionTime newDeletion = this.complexDeletion.isLive() ? this.complexDeletion : new DeletionTime(newTimestamp - 1L, this.complexDeletion.localDeletionTime());
        return this.transformAndFilter(newDeletion, (Function<? super Cell, ? extends Cell>)((Function)cell -> (Cell)cell.updateAllTimestamp(newTimestamp)));
    }

    @Override
    public long maxTimestamp() {
        long timestamp = this.complexDeletion.markedForDeleteAt();
        for (Cell cell : this) {
            timestamp = Math.max(timestamp, cell.timestamp());
        }
        return timestamp;
    }

    void setValue(CellPath path, ByteBuffer value) {
        Cell current = (Cell)((Object)BTree.find(this.cells, this.column.asymmetricCellPathComparator(), path));
        BTree.replaceInSitu(this.cells, this.column.cellComparator(), current, current.withUpdatedValue(value));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComplexColumnData)) {
            return false;
        }
        ComplexColumnData that = (ComplexColumnData)other;
        return this.column().equals(that.column()) && this.complexDeletion().equals(that.complexDeletion) && BTree.equals(this.cells, that.cells);
    }

    public int hashCode() {
        return Objects.hash(this.column(), this.complexDeletion(), BTree.hashCode(this.cells));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static BiFunction<Cell, Cell, Cell> noResolve = (a, b) -> {
            throw new IllegalStateException();
        };
        private DeletionTime complexDeletion;
        private ColumnDefinition column;
        private BTree.Builder<Cell> builder;

        public void newColumn(ColumnDefinition column) {
            this.column = column;
            this.complexDeletion = DeletionTime.LIVE;
            if (this.builder == null) {
                this.builder = BTree.builder(column.cellComparator());
            } else {
                this.builder.reuse(column.cellComparator());
            }
        }

        public void addComplexDeletion(DeletionTime complexDeletion) {
            this.complexDeletion = complexDeletion;
        }

        public void addCell(Cell cell) {
            this.builder.add(cell);
        }

        public ComplexColumnData build() {
            if (this.complexDeletion.isLive() && this.builder.isEmpty()) {
                return null;
            }
            return new ComplexColumnData(this.column, this.builder.build(), this.complexDeletion);
        }
    }
}

