/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SerializationHeader {
    public static final Serializer serializer = new Serializer();
    private final boolean isForSSTable;
    private final AbstractType<?> keyType;
    private final List<AbstractType<?>> clusteringTypes;
    private final PartitionColumns columns;
    private final EncodingStats stats;
    private final Map<ByteBuffer, AbstractType<?>> typeMap;

    private SerializationHeader(boolean isForSSTable, AbstractType<?> keyType, List<AbstractType<?>> clusteringTypes, PartitionColumns columns, EncodingStats stats, Map<ByteBuffer, AbstractType<?>> typeMap) {
        this.isForSSTable = isForSSTable;
        this.keyType = keyType;
        this.clusteringTypes = clusteringTypes;
        this.columns = columns;
        this.stats = stats;
        this.typeMap = typeMap;
    }

    public static SerializationHeader makeWithoutStats(CFMetaData metadata) {
        return new SerializationHeader(true, metadata, metadata.partitionColumns(), EncodingStats.NO_STATS);
    }

    public static SerializationHeader forKeyCache(CFMetaData metadata) {
        int size = metadata.clusteringColumns().size();
        ArrayList clusteringTypes = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            clusteringTypes.add(BytesType.instance);
        }
        return new SerializationHeader(false, BytesType.instance, clusteringTypes, PartitionColumns.NONE, EncodingStats.NO_STATS, Collections.emptyMap());
    }

    public static SerializationHeader make(CFMetaData metadata, Collection<SSTableReader> sstables) {
        EncodingStats.Collector stats = new EncodingStats.Collector();
        PartitionColumns.Builder columns = PartitionColumns.builder();
        for (SSTableReader sstable : sstables) {
            stats.updateTimestamp(sstable.getMinTimestamp());
            stats.updateLocalDeletionTime(sstable.getMinLocalDeletionTime());
            stats.updateTTL(sstable.getMinTTL());
            if (sstable.header == null) {
                columns.addAll(metadata.partitionColumns());
                continue;
            }
            columns.addAll(sstable.header.columns());
        }
        return new SerializationHeader(true, metadata, columns.build(), stats.get());
    }

    public SerializationHeader(boolean isForSSTable, CFMetaData metadata, PartitionColumns columns, EncodingStats stats) {
        this(isForSSTable, metadata.getKeyValidator(), SerializationHeader.typesOf(metadata.clusteringColumns()), columns, stats, null);
    }

    private static List<AbstractType<?>> typesOf(List<ColumnDefinition> columns) {
        return ImmutableList.copyOf((Collection)Lists.transform(columns, column -> column.type));
    }

    public PartitionColumns columns() {
        return this.columns;
    }

    public boolean hasStatic() {
        return !this.columns.statics.isEmpty();
    }

    public boolean isForSSTable() {
        return this.isForSSTable;
    }

    public EncodingStats stats() {
        return this.stats;
    }

    public AbstractType<?> keyType() {
        return this.keyType;
    }

    public List<AbstractType<?>> clusteringTypes() {
        return this.clusteringTypes;
    }

    public Columns columns(boolean isStatic) {
        return isStatic ? this.columns.statics : this.columns.regulars;
    }

    public AbstractType<?> getType(ColumnDefinition column) {
        return this.typeMap == null ? column.type : this.typeMap.get(column.name.bytes);
    }

    public void writeTimestamp(long timestamp, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(timestamp - this.stats.minTimestamp);
    }

    public void writeLocalDeletionTime(int localDeletionTime, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(localDeletionTime - this.stats.minLocalDeletionTime);
    }

    public void writeTTL(int ttl, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt(ttl - this.stats.minTTL);
    }

    public void writeDeletionTime(DeletionTime dt, DataOutputPlus out) throws IOException {
        this.writeTimestamp(dt.markedForDeleteAt(), out);
        this.writeLocalDeletionTime(dt.localDeletionTime(), out);
    }

    public long readTimestamp(DataInputPlus in) throws IOException {
        return in.readUnsignedVInt() + this.stats.minTimestamp;
    }

    public int readLocalDeletionTime(DataInputPlus in) throws IOException {
        return (int)in.readUnsignedVInt() + this.stats.minLocalDeletionTime;
    }

    public int readTTL(DataInputPlus in) throws IOException {
        return (int)in.readUnsignedVInt() + this.stats.minTTL;
    }

    public DeletionTime readDeletionTime(DataInputPlus in) throws IOException {
        long markedAt = this.readTimestamp(in);
        int localDeletionTime = this.readLocalDeletionTime(in);
        return new DeletionTime(markedAt, localDeletionTime);
    }

    public long timestampSerializedSize(long timestamp) {
        return TypeSizes.sizeofUnsignedVInt(timestamp - this.stats.minTimestamp);
    }

    public long localDeletionTimeSerializedSize(int localDeletionTime) {
        return TypeSizes.sizeofUnsignedVInt(localDeletionTime - this.stats.minLocalDeletionTime);
    }

    public long ttlSerializedSize(int ttl) {
        return TypeSizes.sizeofUnsignedVInt(ttl - this.stats.minTTL);
    }

    public long deletionTimeSerializedSize(DeletionTime dt) {
        return this.timestampSerializedSize(dt.markedForDeleteAt()) + this.localDeletionTimeSerializedSize(dt.localDeletionTime());
    }

    public void skipTimestamp(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipLocalDeletionTime(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipTTL(DataInputPlus in) throws IOException {
        in.readUnsignedVInt();
    }

    public void skipDeletionTime(DataInputPlus in) throws IOException {
        this.skipTimestamp(in);
        this.skipLocalDeletionTime(in);
    }

    public Component toComponent() {
        LinkedHashMap<ByteBuffer, AbstractType> staticColumns = new LinkedHashMap<ByteBuffer, AbstractType>();
        LinkedHashMap<ByteBuffer, AbstractType> regularColumns = new LinkedHashMap<ByteBuffer, AbstractType>();
        for (ColumnDefinition column : this.columns.statics) {
            staticColumns.put(column.name.bytes, column.type);
        }
        for (ColumnDefinition column : this.columns.regulars) {
            regularColumns.put(column.name.bytes, column.type);
        }
        return new Component(this.keyType, this.clusteringTypes, staticColumns, regularColumns, this.stats);
    }

    public String toString() {
        return String.format("SerializationHeader[key=%s, cks=%s, columns=%s, stats=%s, typeMap=%s]", this.keyType, this.clusteringTypes, this.columns, this.stats, this.typeMap);
    }

    public static class Serializer
    implements IMetadataComponentSerializer<Component> {
        public void serializeForMessaging(SerializationHeader header, ColumnFilter selection, DataOutputPlus out, boolean hasStatic) throws IOException {
            EncodingStats.serializer.serialize(header.stats, out);
            if (selection == null) {
                if (hasStatic) {
                    Columns.serializer.serialize(((SerializationHeader)header).columns.statics, out);
                }
                Columns.serializer.serialize(((SerializationHeader)header).columns.regulars, out);
            } else {
                if (hasStatic) {
                    Columns.serializer.serializeSubset(((SerializationHeader)header).columns.statics, selection.fetchedColumns().statics, out);
                }
                Columns.serializer.serializeSubset(((SerializationHeader)header).columns.regulars, selection.fetchedColumns().regulars, out);
            }
        }

        public SerializationHeader deserializeForMessaging(DataInputPlus in, CFMetaData metadata, ColumnFilter selection, boolean hasStatic) throws IOException {
            Columns regulars;
            Columns statics;
            EncodingStats stats = EncodingStats.serializer.deserialize(in);
            AbstractType<?> keyType = metadata.getKeyValidator();
            List clusteringTypes = SerializationHeader.typesOf(metadata.clusteringColumns());
            if (selection == null) {
                statics = hasStatic ? Columns.serializer.deserialize(in, metadata) : Columns.NONE;
                regulars = Columns.serializer.deserialize(in, metadata);
            } else {
                statics = hasStatic ? Columns.serializer.deserializeSubset(selection.fetchedColumns().statics, in) : Columns.NONE;
                regulars = Columns.serializer.deserializeSubset(selection.fetchedColumns().regulars, in);
            }
            return new SerializationHeader(false, keyType, clusteringTypes, new PartitionColumns(statics, regulars), stats, null);
        }

        public long serializedSizeForMessaging(SerializationHeader header, ColumnFilter selection, boolean hasStatic) {
            long size = EncodingStats.serializer.serializedSize(header.stats);
            if (selection == null) {
                if (hasStatic) {
                    size += Columns.serializer.serializedSize(((SerializationHeader)header).columns.statics);
                }
                size += Columns.serializer.serializedSize(((SerializationHeader)header).columns.regulars);
            } else {
                if (hasStatic) {
                    size += Columns.serializer.serializedSubsetSize(((SerializationHeader)header).columns.statics, selection.fetchedColumns().statics);
                }
                size += Columns.serializer.serializedSubsetSize(((SerializationHeader)header).columns.regulars, selection.fetchedColumns().regulars);
            }
            return size;
        }

        @Override
        public void serialize(Version version, Component header, DataOutputPlus out) throws IOException {
            EncodingStats.serializer.serialize(header.stats, out);
            this.writeType(header.keyType, out);
            out.writeUnsignedVInt(header.clusteringTypes.size());
            for (AbstractType type : header.clusteringTypes) {
                this.writeType(type, out);
            }
            this.writeColumnsWithTypes(header.staticColumns, out);
            this.writeColumnsWithTypes(header.regularColumns, out);
        }

        @Override
        public Component deserialize(Version version, DataInputPlus in) throws IOException {
            EncodingStats stats = EncodingStats.serializer.deserialize(in);
            AbstractType<?> keyType = this.readType(in);
            int size = (int)in.readUnsignedVInt();
            ArrayList clusteringTypes = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                clusteringTypes.add(this.readType(in));
            }
            LinkedHashMap staticColumns = new LinkedHashMap();
            LinkedHashMap regularColumns = new LinkedHashMap();
            this.readColumnsWithType(in, staticColumns);
            this.readColumnsWithType(in, regularColumns);
            return new Component(keyType, clusteringTypes, staticColumns, regularColumns, stats);
        }

        @Override
        public int serializedSize(Version version, Component header) {
            int size = EncodingStats.serializer.serializedSize(header.stats);
            size += this.sizeofType(header.keyType);
            size += TypeSizes.sizeofUnsignedVInt(header.clusteringTypes.size());
            for (AbstractType type : header.clusteringTypes) {
                size += this.sizeofType(type);
            }
            size = (int)((long)size + this.sizeofColumnsWithTypes(header.staticColumns));
            size = (int)((long)size + this.sizeofColumnsWithTypes(header.regularColumns));
            return size;
        }

        private void writeColumnsWithTypes(Map<ByteBuffer, AbstractType<?>> columns, DataOutputPlus out) throws IOException {
            out.writeUnsignedVInt(columns.size());
            for (Map.Entry<ByteBuffer, AbstractType<?>> entry : columns.entrySet()) {
                ByteBufferUtil.writeWithVIntLength(entry.getKey(), out);
                this.writeType(entry.getValue(), out);
            }
        }

        private long sizeofColumnsWithTypes(Map<ByteBuffer, AbstractType<?>> columns) {
            long size = TypeSizes.sizeofUnsignedVInt(columns.size());
            for (Map.Entry<ByteBuffer, AbstractType<?>> entry : columns.entrySet()) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(entry.getKey());
                size += (long)this.sizeofType(entry.getValue());
            }
            return size;
        }

        private void readColumnsWithType(DataInputPlus in, Map<ByteBuffer, AbstractType<?>> typeMap) throws IOException {
            int length = (int)in.readUnsignedVInt();
            for (int i = 0; i < length; ++i) {
                ByteBuffer name = ByteBufferUtil.readWithVIntLength(in);
                typeMap.put(name, this.readType(in));
            }
        }

        private void writeType(AbstractType<?> type, DataOutputPlus out) throws IOException {
            ByteBufferUtil.writeWithVIntLength(UTF8Type.instance.decompose(type.toString()), out);
        }

        private AbstractType<?> readType(DataInputPlus in) throws IOException {
            ByteBuffer raw = ByteBufferUtil.readWithVIntLength(in);
            return TypeParser.parse((String)UTF8Type.instance.compose(raw));
        }

        private int sizeofType(AbstractType<?> type) {
            return ByteBufferUtil.serializedSizeWithVIntLength(UTF8Type.instance.decompose(type.toString()));
        }
    }

    public static class Component
    extends MetadataComponent {
        private final AbstractType<?> keyType;
        private final List<AbstractType<?>> clusteringTypes;
        private final Map<ByteBuffer, AbstractType<?>> staticColumns;
        private final Map<ByteBuffer, AbstractType<?>> regularColumns;
        private final EncodingStats stats;

        private Component(AbstractType<?> keyType, List<AbstractType<?>> clusteringTypes, Map<ByteBuffer, AbstractType<?>> staticColumns, Map<ByteBuffer, AbstractType<?>> regularColumns, EncodingStats stats) {
            this.keyType = keyType;
            this.clusteringTypes = clusteringTypes;
            this.staticColumns = staticColumns;
            this.regularColumns = regularColumns;
            this.stats = stats;
        }

        @Override
        public MetadataType getType() {
            return MetadataType.HEADER;
        }

        public SerializationHeader toHeader(CFMetaData metadata) {
            HashMap typeMap = new HashMap(this.staticColumns.size() + this.regularColumns.size());
            typeMap.putAll(this.staticColumns);
            typeMap.putAll(this.regularColumns);
            PartitionColumns.Builder builder = PartitionColumns.builder();
            for (ByteBuffer name : typeMap.keySet()) {
                boolean isStatic;
                ColumnDefinition column = metadata.getColumnDefinition(name);
                if (column == null && (column = metadata.getDroppedColumnDefinition(name, isStatic = this.staticColumns.containsKey(name))) == null) {
                    throw new RuntimeException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
                }
                builder.add(column);
            }
            return new SerializationHeader(true, this.keyType, this.clusteringTypes, builder.build(), this.stats, typeMap);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Component)) {
                return false;
            }
            Component that = (Component)o;
            return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.clusteringTypes, that.clusteringTypes) && Objects.equals(this.staticColumns, that.staticColumns) && Objects.equals(this.regularColumns, that.regularColumns) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.keyType, this.clusteringTypes, this.staticColumns, this.regularColumns, this.stats);
        }

        public String toString() {
            return String.format("SerializationHeader.Component[key=%s, cks=%s, statics=%s, regulars=%s, stats=%s]", this.keyType, this.clusteringTypes, this.staticColumns, this.regularColumns, this.stats);
        }

        public AbstractType<?> getKeyType() {
            return this.keyType;
        }

        public List<AbstractType<?>> getClusteringTypes() {
            return this.clusteringTypes;
        }

        public Map<ByteBuffer, AbstractType<?>> getStaticColumns() {
            return this.staticColumns;
        }

        public Map<ByteBuffer, AbstractType<?>> getRegularColumns() {
            return this.regularColumns;
        }

        public EncodingStats getEncodingStats() {
            return this.stats;
        }
    }
}

