/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String PROPERTY_PREFIX = "cassandra.";
    public String cluster_name = "Test Cluster";
    public String authenticator;
    public String authorizer;
    public String role_manager;
    public volatile int permissions_validity_in_ms = 2000;
    public int permissions_cache_max_entries = 1000;
    public volatile int permissions_update_interval_in_ms = -1;
    public volatile int roles_validity_in_ms = 2000;
    public int roles_cache_max_entries = 1000;
    public volatile int roles_update_interval_in_ms = -1;
    public String partitioner;
    public Boolean auto_bootstrap = true;
    public volatile boolean hinted_handoff_enabled = true;
    public Set<String> hinted_handoff_disabled_datacenters = Sets.newConcurrentHashSet();
    public volatile Integer max_hint_window_in_ms = 10800000;
    public String hints_directory;
    public ParameterizedClass seed_provider;
    public DiskAccessMode disk_access_mode = DiskAccessMode.auto;
    public DiskFailurePolicy disk_failure_policy = DiskFailurePolicy.ignore;
    public CommitFailurePolicy commit_failure_policy = CommitFailurePolicy.stop;
    public String initial_token;
    public Integer num_tokens = 1;
    public String allocate_tokens_for_keyspace = null;
    public volatile Long request_timeout_in_ms = 10000L;
    public volatile Long read_request_timeout_in_ms = 5000L;
    public volatile Long range_request_timeout_in_ms = 10000L;
    public volatile Long write_request_timeout_in_ms = 2000L;
    public volatile Long counter_write_request_timeout_in_ms = 5000L;
    public volatile Long cas_contention_timeout_in_ms = 1000L;
    public volatile Long truncate_request_timeout_in_ms = 60000L;
    public Integer streaming_socket_timeout_in_ms = 86400000;
    public boolean cross_node_timeout = false;
    public volatile Double phi_convict_threshold = 8.0;
    public Integer concurrent_reads = 32;
    public Integer concurrent_writes = 32;
    public Integer concurrent_counter_writes = 32;
    public Integer concurrent_materialized_view_writes = 32;
    @Deprecated
    public Integer concurrent_replicates = null;
    public Integer memtable_flush_writers = null;
    public Integer memtable_heap_space_in_mb;
    public Integer memtable_offheap_space_in_mb;
    public Float memtable_cleanup_threshold = null;
    public Integer storage_port = 7000;
    public Integer ssl_storage_port = 7001;
    public String listen_address;
    public String listen_interface;
    public Boolean listen_interface_prefer_ipv6 = false;
    public String broadcast_address;
    public Boolean listen_on_broadcast_address = false;
    public String internode_authenticator;
    public Boolean start_rpc = true;
    public String rpc_address;
    public String rpc_interface;
    public Boolean rpc_interface_prefer_ipv6 = false;
    public String broadcast_rpc_address;
    public Integer rpc_port = 9160;
    public Integer rpc_listen_backlog = 50;
    public String rpc_server_type = "sync";
    public Boolean rpc_keepalive = true;
    public Integer rpc_min_threads = 16;
    public Integer rpc_max_threads = Integer.MAX_VALUE;
    public Integer rpc_send_buff_size_in_bytes;
    public Integer rpc_recv_buff_size_in_bytes;
    public Integer internode_send_buff_size_in_bytes;
    public Integer internode_recv_buff_size_in_bytes;
    public Boolean start_native_transport = false;
    public Integer native_transport_port = 9042;
    public Integer native_transport_port_ssl = null;
    public Integer native_transport_max_threads = 128;
    public Integer native_transport_max_frame_size_in_mb = 256;
    public volatile Long native_transport_max_concurrent_connections = -1L;
    public volatile Long native_transport_max_concurrent_connections_per_ip = -1L;
    @Deprecated
    public Integer thrift_max_message_length_in_mb = 16;
    public Integer max_value_size_in_mb = 256;
    public Integer thrift_framed_transport_size_in_mb = 15;
    public Boolean snapshot_before_compaction = false;
    public Boolean auto_snapshot = true;
    public Integer column_index_size_in_kb = 64;
    public volatile int batch_size_warn_threshold_in_kb = 5;
    public volatile int batch_size_fail_threshold_in_kb = 50;
    public Integer unlogged_batch_across_partitions_warn_threshold = 10;
    public Integer concurrent_compactors;
    public volatile Integer compaction_throughput_mb_per_sec = 16;
    public volatile Integer compaction_large_partition_warning_threshold_mb = 100;
    public Integer min_free_space_per_drive_in_mb = 50;
    @Deprecated
    public Integer max_streaming_retries = 3;
    public volatile Integer stream_throughput_outbound_megabits_per_sec = 200;
    public volatile Integer inter_dc_stream_throughput_outbound_megabits_per_sec = 200;
    public String[] data_file_directories = new String[0];
    public String saved_caches_directory;
    public String commitlog_directory;
    public Integer commitlog_total_space_in_mb;
    public CommitLogSync commitlog_sync;
    public Double commitlog_sync_batch_window_in_ms;
    public Integer commitlog_sync_period_in_ms;
    public int commitlog_segment_size_in_mb = 32;
    public ParameterizedClass commitlog_compression;
    public int commitlog_max_compression_buffers_in_pool = 3;
    public Integer max_mutation_size_in_kb;
    @Deprecated
    public int commitlog_periodic_queue_size = -1;
    public String endpoint_snitch;
    public Boolean dynamic_snitch = true;
    public Integer dynamic_snitch_update_interval_in_ms = 100;
    public Integer dynamic_snitch_reset_interval_in_ms = 600000;
    public Double dynamic_snitch_badness_threshold = 0.1;
    public String request_scheduler;
    public RequestSchedulerId request_scheduler_id;
    public RequestSchedulerOptions request_scheduler_options;
    public EncryptionOptions.ServerEncryptionOptions server_encryption_options = new EncryptionOptions.ServerEncryptionOptions();
    public EncryptionOptions.ClientEncryptionOptions client_encryption_options = new EncryptionOptions.ClientEncryptionOptions();
    public EncryptionOptions.ServerEncryptionOptions encryption_options;
    public InternodeCompression internode_compression = InternodeCompression.none;
    @Deprecated
    public Integer index_interval = null;
    public int hinted_handoff_throttle_in_kb = 1024;
    public int batchlog_replay_throttle_in_kb = 1024;
    public int max_hints_delivery_threads = 2;
    public int hints_flush_period_in_ms = 10000;
    public int max_hints_file_size_in_mb = 128;
    public ParameterizedClass hints_compression;
    public int sstable_preemptive_open_interval_in_mb = 50;
    public volatile boolean incremental_backups = false;
    public boolean trickle_fsync = false;
    public int trickle_fsync_interval_in_kb = 10240;
    public Long key_cache_size_in_mb = null;
    public volatile int key_cache_save_period = 14400;
    public volatile int key_cache_keys_to_save = Integer.MAX_VALUE;
    public String row_cache_class_name = "org.apache.cassandra.cache.OHCProvider";
    public long row_cache_size_in_mb = 0L;
    public volatile int row_cache_save_period = 0;
    public volatile int row_cache_keys_to_save = Integer.MAX_VALUE;
    public Long counter_cache_size_in_mb = null;
    public volatile int counter_cache_save_period = 7200;
    public volatile int counter_cache_keys_to_save = Integer.MAX_VALUE;
    private static boolean isClientMode = false;
    public Integer file_cache_size_in_mb = 512;
    public boolean buffer_pool_use_heap_if_exhausted = true;
    public DiskOptimizationStrategy disk_optimization_strategy = DiskOptimizationStrategy.ssd;
    public double disk_optimization_estimate_percentile = 0.95;
    public double disk_optimization_page_cross_chance = 0.1;
    public boolean inter_dc_tcp_nodelay = true;
    public MemtableAllocationType memtable_allocation_type = MemtableAllocationType.heap_buffers;
    @Deprecated
    protected static boolean outboundBindAny = false;
    public volatile int tombstone_warn_threshold = 1000;
    public volatile int tombstone_failure_threshold = 100000;
    public volatile Long index_summary_capacity_in_mb;
    public volatile int index_summary_resize_interval_in_minutes = 60;
    public int gc_log_threshold_in_ms = 200;
    public int gc_warn_threshold_in_ms = 0;
    public int tracetype_query_ttl = (int)TimeUnit.DAYS.toSeconds(1L);
    public int tracetype_repair_ttl = (int)TimeUnit.DAYS.toSeconds(7L);
    public String otc_coalescing_strategy = "TIMEHORIZON";
    public static final int otc_coalescing_window_us_default = 200;
    public int otc_coalescing_window_us = 200;
    public int otc_coalescing_enough_coalesced_messages = 8;
    public int windows_timer_interval = 0;
    public boolean enable_user_defined_functions = false;
    public boolean enable_scripted_user_defined_functions = false;
    public boolean enable_user_defined_functions_threads = true;
    public long user_defined_function_warn_timeout = 500L;
    public long user_defined_function_fail_timeout = 1500L;
    public UserFunctionTimeoutPolicy user_function_timeout_policy = UserFunctionTimeoutPolicy.die;
    private static final List<String> SENSITIVE_KEYS = new ArrayList<String>(){
        {
            this.add("client_encryption_options");
            this.add("server_encryption_options");
        }
    };

    public static boolean getOutboundBindAny() {
        return outboundBindAny;
    }

    public static void setOutboundBindAny(boolean value) {
        outboundBindAny = value;
    }

    public static boolean isClientMode() {
        return isClientMode;
    }

    public static void setClientMode(boolean clientMode) {
        isClientMode = clientMode;
    }

    public static void log(Config config) {
        TreeMap<String, String> configMap = new TreeMap<String, String>();
        for (Field field : Config.class.getFields()) {
            String value;
            if (Modifier.isFinal(field.getModifiers())) continue;
            String name = field.getName();
            if (SENSITIVE_KEYS.contains(name)) {
                configMap.put(name, "<REDACTED>");
                continue;
            }
            try {
                value = field.get(config).toString();
            }
            catch (IllegalAccessException | NullPointerException npe) {
                value = "null";
            }
            configMap.put(name, value);
        }
        logger.info("Node configuration:[" + Joiner.on((String)"; ").join(configMap.entrySet()) + "]");
    }

    public static enum DiskOptimizationStrategy {
        ssd,
        spinning;

    }

    public static enum RequestSchedulerId {
        keyspace;

    }

    public static enum UserFunctionTimeoutPolicy {
        ignore,
        die,
        die_immediate;

    }

    public static enum CommitFailurePolicy {
        stop,
        stop_commit,
        ignore,
        die;

    }

    public static enum DiskFailurePolicy {
        best_effort,
        stop,
        ignore,
        stop_paranoid,
        die;

    }

    public static enum MemtableAllocationType {
        unslabbed_heap_buffers,
        heap_buffers,
        offheap_buffers,
        offheap_objects;

    }

    public static enum DiskAccessMode {
        auto,
        mmap,
        mmap_index_only,
        standard;

    }

    public static enum InternodeCompression {
        all,
        none,
        dc;

    }

    public static enum CommitLogSync {
        periodic,
        batch;

    }
}

