/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.utils.MergeIterator;

public abstract class Rows {
    public static final Row EMPTY_STATIC_ROW = BTreeRow.emptyRow(Clustering.STATIC_CLUSTERING);

    private Rows() {
    }

    public static Row.Builder copy(Row row, Row.Builder builder) {
        builder.newRow(row.clustering());
        builder.addPrimaryKeyLivenessInfo(row.primaryKeyLivenessInfo());
        builder.addRowDeletion(row.deletion());
        for (ColumnData cd : row) {
            if (cd.column().isSimple()) {
                builder.addCell((Cell)cd);
                continue;
            }
            ComplexColumnData complexData = (ComplexColumnData)cd;
            builder.addComplexDeletion(complexData.column(), complexData.complexDeletion());
            for (Cell cell : complexData) {
                builder.addCell(cell);
            }
        }
        return builder;
    }

    public static int collectStats(Row row, PartitionStatisticsCollector collector) {
        assert (!row.isEmpty());
        collector.update(row.primaryKeyLivenessInfo());
        collector.update(row.deletion().time());
        int columnCount = 0;
        int cellCount = 0;
        for (ColumnData cd : row) {
            if (cd.column().isSimple()) {
                ++columnCount;
                ++cellCount;
                Cells.collectStats((Cell)cd, collector);
                continue;
            }
            ComplexColumnData complexData = (ComplexColumnData)cd;
            collector.update(complexData.complexDeletion());
            if (!complexData.hasCells()) continue;
            ++columnCount;
            for (Cell cell : complexData) {
                ++cellCount;
                Cells.collectStats(cell, collector);
            }
        }
        collector.updateColumnSetPerRow(columnCount);
        return cellCount;
    }

    public static void diff(final RowDiffListener diffListener, Row merged, final Row ... inputs) {
        final Clustering clustering = merged.clustering();
        LivenessInfo mergedInfo = merged.primaryKeyLivenessInfo().isEmpty() ? null : merged.primaryKeyLivenessInfo();
        Row.Deletion mergedDeletion = merged.deletion().isLive() ? null : merged.deletion();
        for (int i = 0; i < inputs.length; ++i) {
            Row.Deletion inputDeletion;
            Row[] input = inputs[i];
            LivenessInfo inputInfo = input == null || input.primaryKeyLivenessInfo().isEmpty() ? null : input.primaryKeyLivenessInfo();
            Row.Deletion deletion = inputDeletion = input == null || input.deletion().isLive() ? null : input.deletion();
            if (mergedInfo != null || inputInfo != null) {
                diffListener.onPrimaryKeyLivenessInfo(i, clustering, mergedInfo, inputInfo);
            }
            if (mergedDeletion == null && inputDeletion == null) continue;
            diffListener.onDeletion(i, clustering, mergedDeletion, inputDeletion);
        }
        ArrayList inputIterators = new ArrayList(1 + inputs.length);
        inputIterators.add(merged.iterator());
        for (Row row : inputs) {
            inputIterators.add(row == null ? Collections.emptyIterator() : row.iterator());
        }
        MergeIterator<ColumnData, Object> iter = MergeIterator.get(inputIterators, ColumnData.comparator, new MergeIterator.Reducer<ColumnData, Object>(){
            ColumnData mergedData;
            ColumnData[] inputDatas;
            {
                this.inputDatas = new ColumnData[inputs.length];
            }

            @Override
            public void reduce(int idx, ColumnData current) {
                if (idx == 0) {
                    this.mergedData = current;
                } else {
                    this.inputDatas[idx - 1] = current;
                }
            }

            @Override
            protected Object getReduced() {
                for (int i = 0; i != this.inputDatas.length; ++i) {
                    ColumnData input = this.inputDatas[i];
                    if (this.mergedData == null && input == null) continue;
                    ColumnDefinition column = (this.mergedData != null ? this.mergedData : input).column;
                    if (column.isSimple()) {
                        diffListener.onCell(i, clustering, (Cell)this.mergedData, (Cell)input);
                        continue;
                    }
                    ComplexColumnData mergedData = (ComplexColumnData)this.mergedData;
                    ComplexColumnData inputData = (ComplexColumnData)input;
                    if (mergedData == null) {
                        if (!inputData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, clustering, column, null, inputData.complexDeletion());
                        }
                        for (Cell inputCell : inputData) {
                            diffListener.onCell(i, clustering, null, inputCell);
                        }
                        continue;
                    }
                    if (inputData == null) {
                        if (!mergedData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, clustering, column, mergedData.complexDeletion(), null);
                        }
                        for (Cell mergedCell : mergedData) {
                            diffListener.onCell(i, clustering, mergedCell, null);
                        }
                        continue;
                    }
                    if (!mergedData.complexDeletion().isLive() || !inputData.complexDeletion().isLive()) {
                        diffListener.onComplexDeletion(i, clustering, column, mergedData.complexDeletion(), inputData.complexDeletion());
                    }
                    PeekingIterator mergedCells = Iterators.peekingIterator(mergedData.iterator());
                    PeekingIterator inputCells = Iterators.peekingIterator(inputData.iterator());
                    while (mergedCells.hasNext() && inputCells.hasNext()) {
                        int cmp = column.cellPathComparator().compare(((Cell)mergedCells.peek()).path(), ((Cell)inputCells.peek()).path());
                        if (cmp == 0) {
                            diffListener.onCell(i, clustering, (Cell)mergedCells.next(), (Cell)inputCells.next());
                            continue;
                        }
                        if (cmp < 0) {
                            diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                            continue;
                        }
                        diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                    }
                    while (mergedCells.hasNext()) {
                        diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                    }
                    while (inputCells.hasNext()) {
                        diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                    }
                }
                return null;
            }

            @Override
            protected void onKeyChange() {
                this.mergedData = null;
                Arrays.fill(this.inputDatas, null);
            }
        });
        while (iter.hasNext()) {
            iter.next();
        }
    }

    public static Row merge(Row row1, Row row2, int nowInSec) {
        Row.Builder builder = BTreeRow.sortedBuilder();
        Rows.merge(row1, row2, builder, nowInSec);
        return builder.build();
    }

    public static long merge(Row existing, Row update, Row.Builder builder, int nowInSec) {
        Row.Deletion rowDeletion;
        Clustering clustering = existing.clustering();
        builder.newRow(clustering);
        LivenessInfo existingInfo = existing.primaryKeyLivenessInfo();
        LivenessInfo updateInfo = update.primaryKeyLivenessInfo();
        LivenessInfo mergedInfo = existingInfo.supersedes(updateInfo) ? existingInfo : updateInfo;
        long timeDelta = Math.abs(existingInfo.timestamp() - mergedInfo.timestamp());
        Row.Deletion deletion = rowDeletion = existing.deletion().supersedes(update.deletion()) ? existing.deletion() : update.deletion();
        if (rowDeletion.deletes(mergedInfo)) {
            mergedInfo = LivenessInfo.EMPTY;
        } else if (rowDeletion.isShadowedBy(mergedInfo)) {
            rowDeletion = Row.Deletion.LIVE;
        }
        builder.addPrimaryKeyLivenessInfo(mergedInfo);
        builder.addRowDeletion(rowDeletion);
        DeletionTime deletion2 = rowDeletion.time();
        Iterator a = existing.iterator();
        Iterator b = update.iterator();
        ColumnData nexta = a.hasNext() ? (ColumnData)a.next() : null;
        ColumnData nextb = b.hasNext() ? (ColumnData)b.next() : null;
        while (nexta != null | nextb != null) {
            int comparison = nexta == null ? 1 : (nextb == null ? -1 : nexta.column.compareTo(nextb.column));
            ColumnData cura = comparison <= 0 ? nexta : null;
            ColumnData curb = comparison >= 0 ? nextb : null;
            ColumnDefinition column = (cura != null ? cura : curb).column;
            if (column.isSimple()) {
                timeDelta = Math.min(timeDelta, Cells.reconcile((Cell)cura, (Cell)curb, deletion2, builder, nowInSec));
            } else {
                DeletionTime maxDt;
                ComplexColumnData existingData = (ComplexColumnData)cura;
                ComplexColumnData updateData = (ComplexColumnData)curb;
                DeletionTime existingDt = existingData == null ? DeletionTime.LIVE : existingData.complexDeletion();
                DeletionTime updateDt = updateData == null ? DeletionTime.LIVE : updateData.complexDeletion();
                DeletionTime deletionTime = maxDt = existingDt.supersedes(updateDt) ? existingDt : updateDt;
                if (maxDt.supersedes(deletion2)) {
                    builder.addComplexDeletion(column, maxDt);
                } else {
                    maxDt = deletion2;
                }
                Iterator<Cell> existingCells = existingData == null ? null : existingData.iterator();
                Iterator<Cell> updateCells = updateData == null ? null : updateData.iterator();
                timeDelta = Math.min(timeDelta, Cells.reconcileComplex(column, existingCells, updateCells, maxDt, builder, nowInSec));
            }
            if (cura != null) {
                ColumnData columnData = nexta = a.hasNext() ? (ColumnData)a.next() : null;
            }
            if (curb == null) continue;
            nextb = b.hasNext() ? (ColumnData)b.next() : null;
        }
        return timeDelta;
    }
}

