/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSeedProvider.class);

    public SimpleSeedProvider(Map<String, String> args) {
    }

    @Override
    public List<InetAddress> getSeeds() {
        Config conf;
        try {
            conf = DatabaseDescriptor.loadConfig();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        String[] hosts = conf.seed_provider.parameters.get("seeds").split(",", -1);
        ArrayList<InetAddress> seeds = new ArrayList<InetAddress>(hosts.length);
        for (String host : hosts) {
            try {
                seeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host {}", (Object)host);
            }
        }
        return Collections.unmodifiableList(seeds);
    }
}

