/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.UUIDGen;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        @Override
        public QueryMessage decode(ByteBuf body, int version) {
            String query = CBUtil.readLongString(body);
            if (version == 1) {
                ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
                return new QueryMessage(query, QueryOptions.fromProtocolV1(consistency, Collections.emptyList()));
            }
            return new QueryMessage(query, QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(QueryMessage msg, ByteBuf dest, int version) {
            CBUtil.writeLongString(msg.query, dest);
            if (version == 1) {
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(QueryMessage msg, int version) {
            int size = CBUtil.sizeOfLongString(msg.query);
            size = version == 1 ? (size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency())) : (size += QueryOptions.codec.encodedSize(msg.options, version));
            return size;
        }
    };
    public final String query;
    public final QueryOptions options;

    public QueryMessage(String query, QueryOptions options) {
        super(Message.Type.QUERY);
        this.query = query;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"query", (Object)this.query);
                if (this.options.getPageSize() > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
                }
                if (this.options.getConsistency() != null) {
                    builder.put((Object)"consistency_level", (Object)this.options.getConsistency().name());
                }
                if (this.options.getSerialConsistency() != null) {
                    builder.put((Object)"serial_consistency_level", (Object)this.options.getSerialConsistency().name());
                }
                Tracing.instance.begin("Execute CQL3 query", state.getClientAddress(), (Map<String, String>)builder.build());
            }
            ResultMessage response = ClientState.getCQLQueryHandler().process(this.query, state, this.options, this.getCustomPayload());
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            if (!(e instanceof RequestValidationException) && !(e instanceof RequestExecutionException)) {
                logger.error("Unexpected error during query", (Throwable)e);
            }
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "QUERY " + this.query + "[pageSize = " + this.options.getPageSize() + "]";
    }
}

