/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.RowUpdateBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.MaterializedViews;
import org.apache.cassandra.schema.SpeculativeRetryParam;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SchemaKeyspace.class);
    public static final String NAME = "system_schema";
    public static final String KEYSPACES = "keyspaces";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String DROPPED_COLUMNS = "dropped_columns";
    public static final String TRIGGERS = "triggers";
    public static final String MATERIALIZED_VIEWS = "materialized_views";
    public static final String TYPES = "types";
    public static final String FUNCTIONS = "functions";
    public static final String AGGREGATES = "aggregates";
    public static final String INDEXES = "indexes";
    public static final List<String> ALL = ImmutableList.of((Object)"keyspaces", (Object)"tables", (Object)"columns", (Object)"triggers", (Object)"materialized_views", (Object)"types", (Object)"functions", (Object)"aggregates", (Object)"indexes");
    private static final CFMetaData Keyspaces = SchemaKeyspace.compile("keyspaces", "keyspace definitions", "CREATE TABLE %s (keyspace_name text,durable_writes boolean,replication frozen<map<text, text>>,PRIMARY KEY ((keyspace_name)))");
    private static final CFMetaData Tables = SchemaKeyspace.compile("tables", "table definitions", "CREATE TABLE %s (keyspace_name text,table_name text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,flags frozen<set<text>>,gc_grace_seconds int,id uuid,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,PRIMARY KEY ((keyspace_name), table_name))");
    private static final CFMetaData Columns = SchemaKeyspace.compile("columns", "column definitions", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,column_name_bytes blob,component_index int,type text,validator text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData DroppedColumns = SchemaKeyspace.compile("dropped_columns", "dropped column registry", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,dropped_time timestamp,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData Triggers = SchemaKeyspace.compile("triggers", "trigger definitions", "CREATE TABLE %s (keyspace_name text,table_name text,trigger_name text,trigger_options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, trigger_name))");
    private static final CFMetaData MaterializedViews = SchemaKeyspace.compile("materialized_views", "materialized views definitions", "CREATE TABLE %s (keyspace_name text,table_name text,view_name text,target_columns frozen<list<text>>,clustering_columns frozen<list<text>>,included_columns frozen<list<text>>,PRIMARY KEY ((keyspace_name), table_name, view_name))");
    private static final CFMetaData Indexes = SchemaKeyspace.compile("indexes", "secondary index definitions", "CREATE TABLE %s (keyspace_name text,table_name text,index_name text,index_type text,options frozen<map<text, text>>,target_columns frozen<set<text>>,target_type text,PRIMARY KEY ((keyspace_name), table_name, index_name))");
    private static final CFMetaData Types = SchemaKeyspace.compile("types", "user defined type definitions", "CREATE TABLE %s (keyspace_name text,type_name text,field_names frozen<list<text>>,field_types frozen<list<text>>,PRIMARY KEY ((keyspace_name), type_name))");
    private static final CFMetaData Functions = SchemaKeyspace.compile("functions", "user defined function definitions", "CREATE TABLE %s (keyspace_name text,function_name text,signature frozen<list<text>>,argument_names frozen<list<text>>,argument_types frozen<list<text>>,body text,language text,return_type text,called_on_null_input boolean,PRIMARY KEY ((keyspace_name), function_name, signature))");
    private static final CFMetaData Aggregates = SchemaKeyspace.compile("aggregates", "user defined aggregate definitions", "CREATE TABLE %s (keyspace_name text,aggregate_name text,signature frozen<list<text>>,argument_types frozen<list<text>>,final_func text,initcond blob,return_type text,state_func text,state_type text,PRIMARY KEY ((keyspace_name), aggregate_name, signature))");
    public static final List<CFMetaData> ALL_TABLE_METADATA = ImmutableList.of((Object)Keyspaces, (Object)Tables, (Object)Columns, (Object)Triggers, (Object)DroppedColumns, (Object)MaterializedViews, (Object)Types, (Object)Functions, (Object)Aggregates, (Object)Indexes);

    private SchemaKeyspace() {
    }

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), NAME).comment(description).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(7L));
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create(NAME, KeyspaceParams.local(), org.apache.cassandra.schema.Tables.of(ALL_TABLE_METADATA));
    }

    public static void saveSystemKeyspacesSchema() {
        KeyspaceMetadata system = Schema.instance.getKSMetaData("system");
        KeyspaceMetadata schema = Schema.instance.getKSMetaData(NAME);
        long timestamp = FBUtilities.timestampMicros();
        for (String schemaTable : ALL) {
            String query = String.format("DELETE FROM %s.%s USING TIMESTAMP ? WHERE keyspace_name = ?", NAME, schemaTable);
            for (String systemKeyspace : Schema.SYSTEM_KEYSPACE_NAMES) {
                QueryProcessor.executeOnceInternal(query, timestamp, systemKeyspace);
            }
        }
        SchemaKeyspace.makeCreateKeyspaceMutation(system, timestamp + 1L).apply();
        SchemaKeyspace.makeCreateKeyspaceMutation(schema, timestamp + 1L).apply();
    }

    /*
     * Exception decompiling
     */
    public static List<KeyspaceMetadata> readSchemaFromSystemTables() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void truncate() {
        ALL.forEach(table -> SchemaKeyspace.getSchemaCFS(table).truncateBlocking());
    }

    static void flush() {
        if (!Boolean.getBoolean("cassandra.unsafesystem")) {
            ALL.forEach(table -> FBUtilities.waitOnFuture(SchemaKeyspace.getSchemaCFS(table).forceFlush()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UUID calculateSchemaDigest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Iterator<String> iterator = ALL.iterator();
        block28: while (iterator.hasNext()) {
            String table = iterator.next();
            ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(table);
            ReadOrderGroup orderGroup = cmd.startOrderGroup();
            Throwable throwable = null;
            try {
                PartitionIterator schema = cmd.executeInternal(orderGroup);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator partition;
                        block34: {
                            if (!schema.hasNext()) continue block28;
                            partition = (RowIterator)schema.next();
                            Throwable throwable3 = null;
                            try {
                                if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) {
                                    RowIterators.digest(partition, digest);
                                }
                                if (partition == null) continue;
                                if (throwable3 == null) break block34;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (partition == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            partition.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    partition.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (schema == null) continue;
                    if (throwable2 != null) {
                        try {
                            schema.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    schema.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (orderGroup == null) continue;
                if (throwable != null) {
                    try {
                        orderGroup.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                orderGroup.close();
            }
        }
        return UUID.nameUUIDFromBytes(digest.digest());
    }

    private static ColumnFamilyStore getSchemaCFS(String schemaTableName) {
        return Keyspace.open(NAME).getColumnFamilyStore(schemaTableName);
    }

    private static ReadCommand getReadCommandForTableSchema(String schemaTableName) {
        ColumnFamilyStore cfs = SchemaKeyspace.getSchemaCFS(schemaTableName);
        return PartitionRangeReadCommand.allDataRead(cfs.metadata, FBUtilities.nowInSeconds());
    }

    public static Collection<Mutation> convertSchemaToMutations() {
        HashMap<DecoratedKey, Mutation> mutationMap = new HashMap<DecoratedKey, Mutation>();
        for (String table : ALL) {
            SchemaKeyspace.convertSchemaToMutations(mutationMap, table);
        }
        return mutationMap.values();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertSchemaToMutations(Map<DecoratedKey, Mutation> mutationMap, String schemaTableName) {
        ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(schemaTableName);
        try (ReadOrderGroup orderGroup = cmd.startOrderGroup();
             UnfilteredPartitionIterator iter = cmd.executeLocally(orderGroup);){
            Throwable throwable;
            UnfilteredRowIterator partition;
            while (iter.hasNext()) {
                block40: {
                    block38: {
                        block39: {
                            partition = (UnfilteredRowIterator)iter.next();
                            throwable = null;
                            if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) break block38;
                            if (partition == null) continue;
                            if (throwable == null) break block39;
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        partition.close();
                        continue;
                    }
                    DecoratedKey key = partition.partitionKey();
                    Mutation mutation = mutationMap.get(key);
                    if (mutation == null) {
                        mutation = new Mutation(NAME, key);
                        mutationMap.put(key, mutation);
                    }
                    mutation.add(PartitionUpdate.fromIterator(partition));
                    if (partition == null) continue;
                    if (throwable == null) break block40;
                    try {
                        partition.close();
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        continue;
                    }
                }
                partition.close();
            }
            return;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (partition == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            partition.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    partition.close();
                    throw throwable5;
                }
            }
        }
    }

    private static Map<DecoratedKey, FilteredPartition> readSchemaForKeyspaces(String schemaTableName, Set<String> keyspaceNames) {
        HashMap<DecoratedKey, FilteredPartition> schema = new HashMap<DecoratedKey, FilteredPartition>();
        for (String keyspaceName : keyspaceNames) {
            SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(schemaTableName, keyspaceName, (RowIterator partition) -> {
                if (!partition.isEmpty()) {
                    schema.put(partition.partitionKey(), FilteredPartition.create(partition));
                }
                return null;
            });
        }
        return schema;
    }

    private static ByteBuffer getSchemaKSKey(String ksName) {
        return AsciiType.instance.fromString(ksName);
    }

    private static <T> T readSchemaPartitionForKeyspaceAndApply(String schemaTableName, String keyspaceName, Function<RowIterator, T> fct) {
        return SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(schemaTableName, SchemaKeyspace.getSchemaKSKey(keyspaceName), fct);
    }

    private static <T> T readSchemaPartitionForKeyspaceAndApply(String schemaTableName, ByteBuffer keyspaceKey, Function<RowIterator, T> fct) {
        ColumnFamilyStore store = SchemaKeyspace.getSchemaCFS(schemaTableName);
        return SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(store, store.decorateKey(keyspaceKey), fct);
    }

    private static <T> T readSchemaPartitionForKeyspaceAndApply(String schemaTableName, DecoratedKey keyspaceKey, Function<RowIterator, T> fct) {
        return SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(SchemaKeyspace.getSchemaCFS(schemaTableName), keyspaceKey, fct);
    }

    /*
     * Exception decompiling
     */
    private static <T> T readSchemaPartitionForKeyspaceAndApply(ColumnFamilyStore store, DecoratedKey keyspaceKey, Function<RowIterator, T> fct) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static <T> T readSchemaPartitionForTableAndApply(String schemaTableName, String keyspaceName, String tableName, Function<RowIterator, T> fct) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isSystemKeyspaceSchemaPartition(DecoratedKey partitionKey) {
        return Schema.isSystemKeyspace((String)UTF8Type.instance.compose(partitionKey.getKey()));
    }

    public static synchronized void mergeSchema(Collection<Mutation> mutations) throws ConfigurationException, IOException {
        SchemaKeyspace.mergeSchema(mutations, true);
        Schema.instance.updateVersionAndAnnounce();
    }

    public static synchronized void mergeSchema(Collection<Mutation> mutations, boolean doFlush) throws IOException {
        HashSet<String> keyspaces = new HashSet<String>(mutations.size());
        for (Mutation mutation : mutations) {
            keyspaces.add(ByteBufferUtil.string(mutation.key().getKey()));
        }
        Map<DecoratedKey, FilteredPartition> oldKeyspaces = SchemaKeyspace.readSchemaForKeyspaces(KEYSPACES, keyspaces);
        Map<DecoratedKey, FilteredPartition> oldColumnFamilies = SchemaKeyspace.readSchemaForKeyspaces(TABLES, keyspaces);
        Map<DecoratedKey, FilteredPartition> oldTypes = SchemaKeyspace.readSchemaForKeyspaces(TYPES, keyspaces);
        Map<DecoratedKey, FilteredPartition> oldFunctions = SchemaKeyspace.readSchemaForKeyspaces(FUNCTIONS, keyspaces);
        Map<DecoratedKey, FilteredPartition> oldAggregates = SchemaKeyspace.readSchemaForKeyspaces(AGGREGATES, keyspaces);
        mutations.forEach(Mutation::apply);
        if (doFlush) {
            SchemaKeyspace.flush();
        }
        Map<DecoratedKey, FilteredPartition> newKeyspaces = SchemaKeyspace.readSchemaForKeyspaces(KEYSPACES, keyspaces);
        Map<DecoratedKey, FilteredPartition> newColumnFamilies = SchemaKeyspace.readSchemaForKeyspaces(TABLES, keyspaces);
        Map<DecoratedKey, FilteredPartition> newTypes = SchemaKeyspace.readSchemaForKeyspaces(TYPES, keyspaces);
        Map<DecoratedKey, FilteredPartition> newFunctions = SchemaKeyspace.readSchemaForKeyspaces(FUNCTIONS, keyspaces);
        Map<DecoratedKey, FilteredPartition> newAggregates = SchemaKeyspace.readSchemaForKeyspaces(AGGREGATES, keyspaces);
        Set<String> keyspacesToDrop = SchemaKeyspace.mergeKeyspaces(oldKeyspaces, newKeyspaces);
        SchemaKeyspace.mergeTables(oldColumnFamilies, newColumnFamilies);
        SchemaKeyspace.mergeTypes(oldTypes, newTypes);
        SchemaKeyspace.mergeFunctions(oldFunctions, newFunctions);
        SchemaKeyspace.mergeAggregates(oldAggregates, newAggregates);
        keyspacesToDrop.forEach(Schema.instance::dropKeyspace);
    }

    private static Set<String> mergeKeyspaces(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after) {
        for (FilteredPartition newPartition : after.values()) {
            String name = (String)AsciiType.instance.compose(newPartition.partitionKey().getKey());
            KeyspaceParams params = SchemaKeyspace.createKeyspaceParamsFromSchemaPartition(newPartition.rowIterator());
            FilteredPartition oldPartition = before.remove(newPartition.partitionKey());
            if (oldPartition == null || oldPartition.isEmpty()) {
                Schema.instance.addKeyspace(KeyspaceMetadata.create(name, params));
                continue;
            }
            Schema.instance.updateKeyspace(name, params);
        }
        return SchemaKeyspace.asKeyspaceNamesSet(before.keySet());
    }

    private static Set<String> asKeyspaceNamesSet(Set<DecoratedKey> keys) {
        HashSet<String> names = new HashSet<String>(keys.size());
        for (DecoratedKey key : keys) {
            names.add((String)AsciiType.instance.compose(key.getKey()));
        }
        return names;
    }

    private static void mergeTables(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after) {
        SchemaKeyspace.diffSchema(before, after, new Differ(){

            @Override
            public void onDropped(UntypedResultSet.Row oldRow) {
                Schema.instance.dropTable(oldRow.getString("keyspace_name"), oldRow.getString("table_name"));
            }

            @Override
            public void onAdded(UntypedResultSet.Row newRow) {
                Schema.instance.addTable(SchemaKeyspace.createTableFromTableRow(newRow));
            }

            @Override
            public void onUpdated(UntypedResultSet.Row oldRow, UntypedResultSet.Row newRow) {
                Schema.instance.updateTable(newRow.getString("keyspace_name"), newRow.getString("table_name"));
            }
        });
    }

    private static void mergeTypes(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after) {
        SchemaKeyspace.diffSchema(before, after, new Differ(){

            @Override
            public void onDropped(UntypedResultSet.Row oldRow) {
                Schema.instance.dropType(SchemaKeyspace.createTypeFromRow(oldRow));
            }

            @Override
            public void onAdded(UntypedResultSet.Row newRow) {
                Schema.instance.addType(SchemaKeyspace.createTypeFromRow(newRow));
            }

            @Override
            public void onUpdated(UntypedResultSet.Row oldRow, UntypedResultSet.Row newRow) {
                Schema.instance.updateType(SchemaKeyspace.createTypeFromRow(newRow));
            }
        });
    }

    private static void mergeFunctions(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after) {
        SchemaKeyspace.diffSchema(before, after, new Differ(){

            @Override
            public void onDropped(UntypedResultSet.Row oldRow) {
                Schema.instance.dropFunction(SchemaKeyspace.createFunctionFromFunctionRow(oldRow));
            }

            @Override
            public void onAdded(UntypedResultSet.Row newRow) {
                Schema.instance.addFunction(SchemaKeyspace.createFunctionFromFunctionRow(newRow));
            }

            @Override
            public void onUpdated(UntypedResultSet.Row oldRow, UntypedResultSet.Row newRow) {
                Schema.instance.updateFunction(SchemaKeyspace.createFunctionFromFunctionRow(newRow));
            }
        });
    }

    private static void mergeAggregates(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after) {
        SchemaKeyspace.diffSchema(before, after, new Differ(){

            @Override
            public void onDropped(UntypedResultSet.Row oldRow) {
                Schema.instance.dropAggregate(SchemaKeyspace.createAggregateFromAggregateRow(oldRow));
            }

            @Override
            public void onAdded(UntypedResultSet.Row newRow) {
                Schema.instance.addAggregate(SchemaKeyspace.createAggregateFromAggregateRow(newRow));
            }

            @Override
            public void onUpdated(UntypedResultSet.Row oldRow, UntypedResultSet.Row newRow) {
                Schema.instance.updateAggregate(SchemaKeyspace.createAggregateFromAggregateRow(newRow));
            }
        });
    }

    private static void diffSchema(Map<DecoratedKey, FilteredPartition> before, Map<DecoratedKey, FilteredPartition> after, Differ differ) {
        for (FilteredPartition newPartition : after.values()) {
            Row newRow;
            CFMetaData metadata = newPartition.metadata();
            DecoratedKey key = newPartition.partitionKey();
            FilteredPartition oldPartition = before.remove(key);
            if (oldPartition == null || oldPartition.isEmpty()) {
                for (Row row : newPartition) {
                    differ.onAdded(UntypedResultSet.Row.fromInternalRow(metadata, key, row));
                }
                continue;
            }
            Iterator<Row> oldIter = oldPartition.iterator();
            Iterator<Row> newIter = newPartition.iterator();
            Row oldRow = oldIter.hasNext() ? oldIter.next() : null;
            Row row = newRow = newIter.hasNext() ? newIter.next() : null;
            while (oldRow != null && newRow != null) {
                int cmp = metadata.comparator.compare(oldRow.clustering(), newRow.clustering());
                if (cmp < 0) {
                    differ.onDropped(UntypedResultSet.Row.fromInternalRow(metadata, key, oldRow));
                    oldRow = oldIter.hasNext() ? oldIter.next() : null;
                    continue;
                }
                if (cmp > 0) {
                    differ.onAdded(UntypedResultSet.Row.fromInternalRow(metadata, key, newRow));
                    newRow = newIter.hasNext() ? newIter.next() : null;
                    continue;
                }
                if (!oldRow.equals(newRow)) {
                    differ.onUpdated(UntypedResultSet.Row.fromInternalRow(metadata, key, oldRow), UntypedResultSet.Row.fromInternalRow(metadata, key, newRow));
                }
                oldRow = oldIter.hasNext() ? oldIter.next() : null;
                newRow = newIter.hasNext() ? newIter.next() : null;
            }
            while (oldRow != null) {
                differ.onDropped(UntypedResultSet.Row.fromInternalRow(metadata, key, oldRow));
                oldRow = oldIter.hasNext() ? oldIter.next() : null;
            }
            while (newRow != null) {
                differ.onAdded(UntypedResultSet.Row.fromInternalRow(metadata, key, newRow));
                newRow = newIter.hasNext() ? newIter.next() : null;
            }
        }
        for (FilteredPartition partition : before.values()) {
            for (Row row : partition) {
                differ.onDropped(UntypedResultSet.Row.fromInternalRow(partition.metadata(), partition.partitionKey(), row));
            }
        }
    }

    public static Mutation makeCreateKeyspaceMutation(String name, KeyspaceParams params, long timestamp) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Keyspaces, timestamp, name).clustering(new Object[0]);
        return adder.add(KeyspaceParams.Option.DURABLE_WRITES.toString(), (Object)params.durableWrites).frozenMap(KeyspaceParams.Option.REPLICATION.toString(), params.replication.asMap()).build();
    }

    public static Mutation makeCreateKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        keyspace.tables.forEach(table -> SchemaKeyspace.addTableToSchemaMutation(table, timestamp, true, mutation));
        keyspace.types.forEach(type -> SchemaKeyspace.addTypeToSchemaMutation(type, timestamp, mutation));
        keyspace.functions.udfs().forEach(udf -> SchemaKeyspace.addFunctionToSchemaMutation(udf, timestamp, mutation));
        keyspace.functions.udas().forEach(uda -> SchemaKeyspace.addAggregateToSchemaMutation(uda, timestamp, mutation));
        return mutation;
    }

    public static Mutation makeDropKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        int nowInSec = FBUtilities.nowInSeconds();
        Mutation mutation = new Mutation(NAME, Keyspaces.decorateKey(SchemaKeyspace.getSchemaKSKey(keyspace.name)));
        for (CFMetaData schemaTable : ALL_TABLE_METADATA) {
            mutation.add(PartitionUpdate.fullPartitionDelete(schemaTable, mutation.key(), timestamp, nowInSec));
        }
        return mutation;
    }

    private static KeyspaceMetadata createKeyspaceFromSchemaPartitions(RowIterator serializedParams, RowIterator serializedTables, RowIterator serializedTypes, RowIterator serializedFunctions, RowIterator serializedAggregates) {
        String name = (String)AsciiType.instance.compose(serializedParams.partitionKey().getKey());
        KeyspaceParams params = SchemaKeyspace.createKeyspaceParamsFromSchemaPartition(serializedParams);
        Tables tables = SchemaKeyspace.createTablesFromTablesPartition(serializedTables);
        Types types = SchemaKeyspace.createTypesFromPartition(serializedTypes);
        Collection<UDFunction> udfs = SchemaKeyspace.createFunctionsFromFunctionsPartition(serializedFunctions);
        Collection<UDAggregate> udas = SchemaKeyspace.createAggregatesFromAggregatesPartition(serializedAggregates);
        Functions functions = org.apache.cassandra.schema.Functions.builder().add(udfs).add(udas).build();
        return KeyspaceMetadata.create(name, params, tables, types, functions);
    }

    private static KeyspaceParams createKeyspaceParamsFromSchemaPartition(RowIterator partition) {
        String query = String.format("SELECT * FROM %s.%s", NAME, KEYSPACES);
        UntypedResultSet.Row row = QueryProcessor.resultify(query, partition).one();
        return KeyspaceParams.create(row.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString()), row.getFrozenTextMap(KeyspaceParams.Option.REPLICATION.toString()));
    }

    public static Mutation makeCreateTypeMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTypeToSchemaMutation(type, timestamp, mutation);
        return mutation;
    }

    static void addTypeToSchemaMutation(UserType type, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Types, timestamp, mutation).clustering(type.getNameAsString()).frozenList("field_names", type.fieldNames().stream().map(SchemaKeyspace::bbToString).collect(Collectors.toList())).frozenList("field_types", type.fieldTypes().stream().map(AbstractType::toString).collect(Collectors.toList()));
        adder.build();
    }

    private static String bbToString(ByteBuffer bb) {
        try {
            return ByteBufferUtil.string(bb);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Mutation dropTypeFromSchemaMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Types, timestamp, mutation, type.name);
    }

    private static Types createTypesFromPartition(RowIterator partition) {
        String query = String.format("SELECT * FROM %s.%s", NAME, TYPES);
        Types.Builder types = org.apache.cassandra.schema.Types.builder();
        QueryProcessor.resultify(query, partition).forEach(row -> types.add(SchemaKeyspace.createTypeFromRow(row)));
        return types.build();
    }

    private static UserType createTypeFromRow(UntypedResultSet.Row row) {
        String keyspace = row.getString("keyspace_name");
        ByteBuffer name = ByteBufferUtil.bytes(row.getString("type_name"));
        List<String> rawColumns = row.getFrozenList("field_names", UTF8Type.instance);
        List<String> rawTypes = row.getFrozenList("field_types", UTF8Type.instance);
        ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>(rawColumns.size());
        for (String rawColumn : rawColumns) {
            columns.add(ByteBufferUtil.bytes(rawColumn));
        }
        ArrayList types = new ArrayList(rawTypes.size());
        for (String rawType : rawTypes) {
            types.add(SchemaKeyspace.parseType(rawType));
        }
        return new UserType(keyspace, name, columns, types);
    }

    public static Mutation makeCreateTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(table, timestamp, true, mutation);
        return mutation;
    }

    static void addTableToSchemaMutation(CFMetaData table, long timestamp, boolean withColumnsAndTriggers, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Tables, timestamp, mutation).clustering(table.cfName);
        SchemaKeyspace.addTableParamsToSchemaMutation(table.params, adder);
        adder.add("id", (Object)table.cfId).frozenSet("flags", CFMetaData.flagsToStrings(table.flags())).build();
        if (withColumnsAndTriggers) {
            for (ColumnDefinition columnDefinition : table.allColumns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, columnDefinition, timestamp, mutation);
            }
            for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, droppedColumn, timestamp, mutation);
            }
            for (TriggerMetadata triggerMetadata : table.getTriggers()) {
                SchemaKeyspace.addTriggerToSchemaMutation(table, triggerMetadata, timestamp, mutation);
            }
            for (MaterializedViewDefinition materializedViewDefinition : table.getMaterializedViews()) {
                SchemaKeyspace.addMaterializedViewToSchemaMutation(table, materializedViewDefinition, timestamp, mutation);
            }
            for (IndexMetadata indexMetadata : table.getIndexes()) {
                SchemaKeyspace.addIndexToSchemaMutation(table, indexMetadata, timestamp, mutation);
            }
        }
    }

    private static void addTableParamsToSchemaMutation(TableParams params, RowUpdateBuilder adder) {
        adder.add("bloom_filter_fp_chance", (Object)params.bloomFilterFpChance).add("comment", (Object)params.comment).add("dclocal_read_repair_chance", (Object)params.dcLocalReadRepairChance).add("default_time_to_live", (Object)params.defaultTimeToLive).add("gc_grace_seconds", (Object)params.gcGraceSeconds).add("max_index_interval", (Object)params.maxIndexInterval).add("memtable_flush_period_in_ms", (Object)params.memtableFlushPeriodInMs).add("min_index_interval", (Object)params.minIndexInterval).add("read_repair_chance", (Object)params.readRepairChance).add("speculative_retry", (Object)params.speculativeRetry.toString()).frozenMap("caching", params.caching.asMap()).frozenMap("compaction", params.compaction.asMap()).frozenMap("compression", params.compression.asMap()).frozenMap("extensions", (Map<?, ?>)params.extensions);
    }

    public static Mutation makeUpdateTableMutation(KeyspaceMetadata keyspace, CFMetaData oldTable, CFMetaData newTable, long timestamp, boolean fromThrift) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(newTable, timestamp, false, mutation);
        MapDifference columnDiff = Maps.difference(oldTable.getColumnMetadata(), newTable.getColumnMetadata());
        for (ColumnDefinition column : columnDiff.entriesOnlyOnLeft().values()) {
            if (fromThrift && column.kind != ColumnDefinition.Kind.REGULAR && (!newTable.isStaticCompactTable() || column.kind != ColumnDefinition.Kind.STATIC)) continue;
            SchemaKeyspace.dropColumnFromSchemaMutation(oldTable, column, timestamp, mutation);
        }
        for (ColumnDefinition column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, column, timestamp, mutation);
        }
        for (Iterator name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, newTable.getColumnDefinition((ByteBuffer)((Object)name)), timestamp, mutation);
        }
        MapDifference droppedColumnDiff = Maps.difference(oldTable.getDroppedColumns(), newTable.getDroppedColumns());
        for (CFMetaData.DroppedColumn column : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, column, timestamp, mutation);
        }
        for (Iterator name : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, newTable.getDroppedColumns().get(name), timestamp, mutation);
        }
        MapDifference<String, TriggerMetadata> triggerDiff = SchemaKeyspace.triggersDiff(oldTable.getTriggers(), newTable.getTriggers());
        for (Iterator trigger : triggerDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(oldTable, (TriggerMetadata)((Object)trigger), timestamp, mutation);
        }
        for (Iterator trigger : triggerDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addTriggerToSchemaMutation(newTable, (TriggerMetadata)((Object)trigger), timestamp, mutation);
        }
        MapDifference<String, MaterializedViewDefinition> materializedViewDiff = SchemaKeyspace.materializedViewsDiff(oldTable.getMaterializedViews(), newTable.getMaterializedViews());
        for (MaterializedViewDefinition materializedView : materializedViewDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropMaterializedViewFromSchemaMutation(oldTable, materializedView, timestamp, mutation);
        }
        for (MaterializedViewDefinition materializedView : materializedViewDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addMaterializedViewToSchemaMutation(newTable, materializedView, timestamp, mutation);
        }
        for (MapDifference.ValueDifference diff : materializedViewDiff.entriesDiffering().values()) {
            SchemaKeyspace.addUpdatedMaterializedViewDefinitionToSchemaMutation(newTable, (MaterializedViewDefinition)diff.rightValue(), timestamp, mutation);
        }
        MapDifference<String, IndexMetadata> indexesDiff = SchemaKeyspace.indexesDiff(oldTable.getIndexes(), newTable.getIndexes());
        for (IndexMetadata index : indexesDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(oldTable, index, timestamp, mutation);
        }
        for (IndexMetadata index : indexesDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addIndexToSchemaMutation(newTable, index, timestamp, mutation);
        }
        for (MapDifference.ValueDifference diff : indexesDiff.entriesDiffering().values()) {
            SchemaKeyspace.addUpdatedIndexToSchemaMutation(newTable, (IndexMetadata)diff.rightValue(), timestamp, mutation);
        }
        return mutation;
    }

    private static MapDifference<String, IndexMetadata> indexesDiff(Indexes before, Indexes after) {
        HashMap beforeMap = new HashMap();
        before.forEach(i -> beforeMap.put(i.name, i));
        HashMap afterMap = new HashMap();
        after.forEach(i -> afterMap.put(i.name, i));
        return Maps.difference(beforeMap, afterMap);
    }

    private static MapDifference<String, TriggerMetadata> triggersDiff(Triggers before, Triggers after) {
        HashMap beforeMap = new HashMap();
        before.forEach(t -> beforeMap.put(t.name, t));
        HashMap afterMap = new HashMap();
        after.forEach(t -> afterMap.put(t.name, t));
        return Maps.difference(beforeMap, afterMap);
    }

    private static MapDifference<String, MaterializedViewDefinition> materializedViewsDiff(MaterializedViews before, MaterializedViews after) {
        HashMap beforeMap = new HashMap();
        before.forEach(v -> beforeMap.put(v.viewName, v));
        HashMap afterMap = new HashMap();
        after.forEach(v -> afterMap.put(v.viewName, v));
        return Maps.difference(beforeMap, afterMap);
    }

    public static Mutation makeDropTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        RowUpdateBuilder.deleteRow(Tables, timestamp, mutation, table.cfName);
        for (ColumnDefinition column : table.allColumns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, column, timestamp, mutation);
        }
        for (TriggerMetadata trigger : table.getTriggers()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(table, trigger, timestamp, mutation);
        }
        for (MaterializedViewDefinition materializedView : table.getMaterializedViews()) {
            SchemaKeyspace.dropMaterializedViewFromSchemaMutation(table, materializedView, timestamp, mutation);
        }
        for (IndexMetadata index : table.getIndexes()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, index, timestamp, mutation);
        }
        return mutation;
    }

    public static CFMetaData createTableFromName(String keyspace, String table) {
        return SchemaKeyspace.readSchemaPartitionForTableAndApply(TABLES, keyspace, table, partition -> {
            if (partition.isEmpty()) {
                throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspace, table));
            }
            return SchemaKeyspace.createTableFromTablePartition(partition);
        });
    }

    private static Tables createTablesFromTablesPartition(RowIterator partition) {
        String query = String.format("SELECT * FROM %s.%s", NAME, TABLES);
        Tables.Builder tables = org.apache.cassandra.schema.Tables.builder();
        QueryProcessor.resultify(query, partition).forEach(row -> tables.add(SchemaKeyspace.createTableFromTableRow(row)));
        return tables.build();
    }

    private static List<ColumnDefinition> createColumnsFromColumnsPartition(RowIterator serializedColumns) {
        String query = String.format("SELECT * FROM %s.%s", NAME, COLUMNS);
        return SchemaKeyspace.createColumnsFromColumnRows(QueryProcessor.resultify(query, serializedColumns));
    }

    private static CFMetaData createTableFromTablePartition(RowIterator partition) {
        String query = String.format("SELECT * FROM %s.%s", NAME, TABLES);
        return SchemaKeyspace.createTableFromTableRow(QueryProcessor.resultify(query, partition).one());
    }

    public static CFMetaData createTableFromTablePartitionAndColumnsPartition(RowIterator tablePartition, RowIterator columnsPartition) {
        List<ColumnDefinition> columns = SchemaKeyspace.createColumnsFromColumnsPartition(columnsPartition);
        String query = String.format("SELECT * FROM %s.%s", NAME, TABLES);
        return SchemaKeyspace.createTableFromTableRowAndColumns(QueryProcessor.resultify(query, tablePartition).one(), columns);
    }

    private static CFMetaData createTableFromTableRow(UntypedResultSet.Row row) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        List columns = SchemaKeyspace.readSchemaPartitionForTableAndApply(COLUMNS, keyspace, table, SchemaKeyspace::createColumnsFromColumnsPartition);
        Map droppedColumns = SchemaKeyspace.readSchemaPartitionForTableAndApply(DROPPED_COLUMNS, keyspace, table, SchemaKeyspace::createDroppedColumnsFromDroppedColumnsPartition);
        Triggers triggers = SchemaKeyspace.readSchemaPartitionForTableAndApply(TRIGGERS, keyspace, table, SchemaKeyspace::createTriggersFromTriggersPartition);
        MaterializedViews views = SchemaKeyspace.readSchemaPartitionForTableAndApply(MATERIALIZED_VIEWS, keyspace, table, SchemaKeyspace::createMaterializedViewsFromMaterializedViewsPartition);
        CFMetaData cfm = SchemaKeyspace.createTableFromTableRowAndColumns(row, columns).droppedColumns(droppedColumns).triggers(triggers).materializedViews(views);
        Indexes indexes = SchemaKeyspace.readSchemaPartitionForTableAndApply(INDEXES, keyspace, table, rowIterator -> SchemaKeyspace.createIndexesFromIndexesPartition(cfm, rowIterator));
        cfm.indexes(indexes);
        return cfm;
    }

    public static CFMetaData createTableFromTableRowAndColumns(UntypedResultSet.Row row, List<ColumnDefinition> columns) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        UUID id = row.getUUID("id");
        Set flags = row.has("flags") ? CFMetaData.flagsFromStrings(row.getFrozenSet("flags", UTF8Type.instance)) : Collections.emptySet();
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = flags.contains((Object)CFMetaData.Flag.COMPOUND);
        boolean isMaterializedView = flags.contains((Object)CFMetaData.Flag.VIEW);
        return CFMetaData.create(keyspace, table, id, isDense, isCompound, isSuper, isCounter, isMaterializedView, columns, DatabaseDescriptor.getPartitioner()).params(SchemaKeyspace.createTableParamsFromRow(row));
    }

    private static TableParams createTableParamsFromRow(UntypedResultSet.Row row) {
        TableParams.Builder builder = TableParams.builder();
        builder.bloomFilterFpChance(row.getDouble("bloom_filter_fp_chance")).caching(CachingParams.fromMap(row.getFrozenTextMap("caching"))).comment(row.getString("comment")).compaction(CompactionParams.fromMap(row.getFrozenTextMap("compaction"))).compression(CompressionParams.fromMap(row.getFrozenTextMap("compression"))).dcLocalReadRepairChance(row.getDouble("dclocal_read_repair_chance")).defaultTimeToLive(row.getInt("default_time_to_live")).gcGraceSeconds(row.getInt("gc_grace_seconds")).maxIndexInterval(row.getInt("max_index_interval")).memtableFlushPeriodInMs(row.getInt("memtable_flush_period_in_ms")).minIndexInterval(row.getInt("min_index_interval")).readRepairChance(row.getDouble("read_repair_chance")).speculativeRetry(SpeculativeRetryParam.fromString(row.getString("speculative_retry")));
        if (row.has("extensions")) {
            builder.extensions(row.getFrozenMap("extensions", UTF8Type.instance, BytesType.instance));
        }
        return builder.build();
    }

    private static void addColumnToSchemaMutation(CFMetaData table, ColumnDefinition column, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Columns, timestamp, mutation).clustering(table.cfName, column.name.toString());
        adder.add("column_name_bytes", (Object)column.name.bytes).add("validator", (Object)column.type.toString()).add("type", (Object)column.kind.toString().toLowerCase()).add("component_index", column.isOnAllComponents() ? null : Integer.valueOf(column.position())).build();
    }

    private static void dropColumnFromSchemaMutation(CFMetaData table, ColumnDefinition column, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Columns, timestamp, mutation, table.cfName, column.name.toString());
    }

    private static List<ColumnDefinition> createColumnsFromColumnRows(UntypedResultSet rows) {
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>(rows.size());
        rows.forEach(row -> columns.add(SchemaKeyspace.createColumnFromColumnRow(row)));
        return columns;
    }

    private static ColumnDefinition createColumnFromColumnRow(UntypedResultSet.Row row) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        ColumnIdentifier name = ColumnIdentifier.getInterned(row.getBytes("column_name_bytes"), row.getString("column_name"));
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("type").toUpperCase());
        Integer componentIndex = null;
        if (row.has("component_index")) {
            componentIndex = row.getInt("component_index");
        }
        AbstractType<?> validator = SchemaKeyspace.parseType(row.getString("validator"));
        return new ColumnDefinition(keyspace, table, name, validator, componentIndex, kind);
    }

    private static void addDroppedColumnToSchemaMutation(CFMetaData table, CFMetaData.DroppedColumn column, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(DroppedColumns, timestamp, mutation).clustering(table.cfName, column.name);
        adder.add("dropped_time", (Object)new Date(TimeUnit.MICROSECONDS.toMillis(column.droppedTime))).add("type", (Object)column.type.toString()).build();
    }

    private static Map<ByteBuffer, CFMetaData.DroppedColumn> createDroppedColumnsFromDroppedColumnsPartition(RowIterator serializedColumns) {
        String query = String.format("SELECT * FROM %s.%s", NAME, DROPPED_COLUMNS);
        HashMap<ByteBuffer, CFMetaData.DroppedColumn> columns = new HashMap<ByteBuffer, CFMetaData.DroppedColumn>();
        for (CFMetaData.DroppedColumn column : SchemaKeyspace.createDroppedColumnsFromDroppedColumnRows(QueryProcessor.resultify(query, serializedColumns))) {
            columns.put(UTF8Type.instance.decompose(column.name), column);
        }
        return columns;
    }

    private static List<CFMetaData.DroppedColumn> createDroppedColumnsFromDroppedColumnRows(UntypedResultSet rows) {
        ArrayList<CFMetaData.DroppedColumn> columns = new ArrayList<CFMetaData.DroppedColumn>(rows.size());
        rows.forEach(row -> columns.add(SchemaKeyspace.createDroppedColumnFromDroppedColumnRow(row)));
        return columns;
    }

    private static CFMetaData.DroppedColumn createDroppedColumnFromDroppedColumnRow(UntypedResultSet.Row row) {
        String name = row.getString("column_name");
        AbstractType<?> type = TypeParser.parse(row.getString("type"));
        long droppedTime = TimeUnit.MILLISECONDS.toMicros(row.getLong("dropped_time"));
        return new CFMetaData.DroppedColumn(name, type, droppedTime);
    }

    private static void addTriggerToSchemaMutation(CFMetaData table, TriggerMetadata trigger, long timestamp, Mutation mutation) {
        new RowUpdateBuilder(Triggers, timestamp, mutation).clustering(table.cfName, trigger.name).frozenMap("trigger_options", Collections.singletonMap("class", trigger.classOption)).build();
    }

    private static void dropTriggerFromSchemaMutation(CFMetaData table, TriggerMetadata trigger, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Triggers, timestamp, mutation, table.cfName, trigger.name);
    }

    private static Triggers createTriggersFromTriggersPartition(RowIterator partition) {
        Triggers.Builder triggers = org.apache.cassandra.schema.Triggers.builder();
        String query = String.format("SELECT * FROM %s.%s", NAME, TRIGGERS);
        QueryProcessor.resultify(query, partition).forEach(row -> triggers.add(SchemaKeyspace.createTriggerFromTriggerRow(row)));
        return triggers.build();
    }

    private static TriggerMetadata createTriggerFromTriggerRow(UntypedResultSet.Row row) {
        String name = row.getString("trigger_name");
        String classOption = row.getFrozenTextMap("trigger_options").get("class");
        return new TriggerMetadata(name, classOption);
    }

    private static void addMaterializedViewToSchemaMutation(CFMetaData table, MaterializedViewDefinition materializedView, long timestamp, Mutation mutation) {
        RowUpdateBuilder builder = new RowUpdateBuilder(MaterializedViews, timestamp, mutation).clustering(table.cfName, materializedView.viewName);
        builder.frozenList("target_columns", materializedView.partitionColumns.stream().map(ColumnIdentifier::toString).collect(Collectors.toList()));
        builder.frozenList("clustering_columns", materializedView.clusteringColumns.stream().map(ColumnIdentifier::toString).collect(Collectors.toList()));
        builder.frozenList("included_columns", materializedView.included.stream().map(ColumnIdentifier::toString).collect(Collectors.toList()));
        builder.build();
    }

    private static void dropMaterializedViewFromSchemaMutation(CFMetaData table, MaterializedViewDefinition materializedView, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(MaterializedViews, timestamp, mutation, table.cfName, materializedView.viewName);
    }

    private static void addUpdatedMaterializedViewDefinitionToSchemaMutation(CFMetaData table, MaterializedViewDefinition materializedView, long timestamp, Mutation mutation) {
        SchemaKeyspace.addMaterializedViewToSchemaMutation(table, materializedView, timestamp, mutation);
    }

    private static MaterializedViews createMaterializedViewsFromMaterializedViewsPartition(RowIterator partition) {
        MaterializedViews.Builder views = org.apache.cassandra.schema.MaterializedViews.builder();
        String query = String.format("SELECT * FROM %s.%s", NAME, MATERIALIZED_VIEWS);
        for (UntypedResultSet.Row row : QueryProcessor.resultify(query, partition)) {
            MaterializedViewDefinition mv = SchemaKeyspace.createMaterializedViewFromMaterializedViewRow(row);
            views.add(mv);
        }
        return views.build();
    }

    private static MaterializedViewDefinition createMaterializedViewFromMaterializedViewRow(UntypedResultSet.Row row) {
        String name = row.getString("view_name");
        List<String> partitionColumnNames = row.getFrozenList("target_columns", UTF8Type.instance);
        String cfName = row.getString("table_name");
        List<String> clusteringColumnNames = row.getFrozenList("clustering_columns", UTF8Type.instance);
        ArrayList<ColumnIdentifier> partitionColumns = new ArrayList<ColumnIdentifier>();
        for (String string : partitionColumnNames) {
            partitionColumns.add(ColumnIdentifier.getInterned(string, true));
        }
        ArrayList<ColumnIdentifier> clusteringColumns = new ArrayList<ColumnIdentifier>();
        for (String columnName : clusteringColumnNames) {
            clusteringColumns.add(ColumnIdentifier.getInterned(columnName, true));
        }
        List<String> list = row.getFrozenList("included_columns", UTF8Type.instance);
        HashSet<ColumnIdentifier> includedColumns = new HashSet<ColumnIdentifier>();
        if (list != null) {
            for (String columnName : list) {
                includedColumns.add(ColumnIdentifier.getInterned(columnName, true));
            }
        }
        return new MaterializedViewDefinition(cfName, name, partitionColumns, clusteringColumns, includedColumns);
    }

    private static void addIndexToSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        RowUpdateBuilder builder = new RowUpdateBuilder(Indexes, timestamp, mutation).clustering(table.cfName, index.name);
        builder.add("index_type", (Object)index.indexType.toString());
        builder.frozenMap("options", index.options);
        builder.frozenSet("target_columns", index.columns.stream().map(ColumnIdentifier::toString).collect(Collectors.toSet()));
        builder.add("target_type", (Object)index.targetType.toString());
        builder.build();
    }

    private static void dropIndexFromSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Indexes, timestamp, mutation, table.cfName, index.name);
    }

    private static void addUpdatedIndexToSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        SchemaKeyspace.addIndexToSchemaMutation(table, index, timestamp, mutation);
    }

    private static Indexes createIndexesFromIndexesPartition(CFMetaData cfm, RowIterator partition) {
        Indexes.Builder indexes = org.apache.cassandra.schema.Indexes.builder();
        String query = String.format("SELECT * FROM %s.%s", NAME, INDEXES);
        QueryProcessor.resultify(query, partition).forEach(row -> indexes.add(SchemaKeyspace.createIndexMetadataFromIndexesRow(cfm, row)));
        return indexes.build();
    }

    private static IndexMetadata createIndexMetadataFromIndexesRow(CFMetaData cfm, UntypedResultSet.Row row) {
        String name = row.getString("index_name");
        IndexMetadata.IndexType type = IndexMetadata.IndexType.valueOf(row.getString("index_type"));
        IndexMetadata.TargetType targetType = IndexMetadata.TargetType.valueOf(row.getString("target_type"));
        Map<String, String> options = row.getFrozenTextMap("options");
        if (options == null) {
            options = Collections.emptyMap();
        }
        Set<String> targetColumnNames = row.getFrozenSet("target_columns", UTF8Type.instance);
        assert (targetType == IndexMetadata.TargetType.COLUMN) : "Per row indexes with dynamic target columns are not supported yet";
        HashSet targetColumns = new HashSet();
        if (targetColumnNames != null) {
            assert (targetColumnNames.size() == 1) : "Secondary indexes targetting multiple columns are not supported yet";
            targetColumnNames.forEach(targetColumnName -> {
                if (cfm.isCQLTable()) {
                    targetColumns.add(ColumnIdentifier.getInterned(targetColumnName, true));
                } else {
                    SchemaKeyspace.findColumnIdentifierWithName(targetColumnName, cfm.allColumns()).ifPresent(targetColumns::add);
                }
            });
        }
        return IndexMetadata.singleColumnIndex((ColumnIdentifier)targetColumns.iterator().next(), name, type, options);
    }

    private static Optional<ColumnIdentifier> findColumnIdentifierWithName(String name, Iterable<ColumnDefinition> columns) {
        for (ColumnDefinition column : columns) {
            if (!column.name.toString().equals(name)) continue;
            return Optional.of(column.name);
        }
        return Optional.empty();
    }

    public static Mutation makeCreateFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addFunctionToSchemaMutation(function, timestamp, mutation);
        return mutation;
    }

    static void addFunctionToSchemaMutation(UDFunction function, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Functions, timestamp, mutation).clustering(function.name().name, SchemaKeyspace.functionSignatureWithTypes(function));
        adder.add("body", (Object)function.body()).add("language", (Object)function.language()).add("return_type", (Object)function.returnType().toString()).add("called_on_null_input", (Object)function.isCalledOnNullInput()).frozenList("argument_names", function.argNames().stream().map(c -> SchemaKeyspace.bbToString(c.bytes)).collect(Collectors.toList())).frozenList("argument_types", function.argTypes().stream().map(AbstractType::toString).collect(Collectors.toList()));
        adder.build();
    }

    public static Mutation makeDropFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Functions, timestamp, mutation, function.name().name, SchemaKeyspace.functionSignatureWithTypes(function));
    }

    private static Collection<UDFunction> createFunctionsFromFunctionsPartition(RowIterator partition) {
        ArrayList<UDFunction> functions = new ArrayList<UDFunction>();
        String query = String.format("SELECT * FROM %s.%s", NAME, FUNCTIONS);
        for (UntypedResultSet.Row row : QueryProcessor.resultify(query, partition)) {
            functions.add(SchemaKeyspace.createFunctionFromFunctionRow(row));
        }
        return functions;
    }

    private static UDFunction createFunctionFromFunctionRow(UntypedResultSet.Row row) {
        UDFunction udf;
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("function_name");
        FunctionName name = new FunctionName(ksName, functionName);
        ArrayList<ColumnIdentifier> argNames = new ArrayList<ColumnIdentifier>();
        if (row.has("argument_names")) {
            for (String string : row.getFrozenList("argument_names", UTF8Type.instance)) {
                argNames.add(new ColumnIdentifier(string, true));
            }
        }
        ArrayList argTypes = new ArrayList();
        if (row.has("argument_types")) {
            for (String type : row.getFrozenList("argument_types", UTF8Type.instance)) {
                argTypes.add(SchemaKeyspace.parseType(type));
            }
        }
        AbstractType<?> abstractType = SchemaKeyspace.parseType(row.getString("return_type"));
        String language = row.getString("language");
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        org.apache.cassandra.cql3.functions.Function existing = Schema.instance.findFunction(name, argTypes).orElse(null);
        if (existing instanceof UDFunction && (udf = (UDFunction)existing).argNames().equals(argNames) && udf.returnType().equals(abstractType) && !udf.isAggregate() && udf.language().equals(language) && udf.body().equals(body) && udf.isCalledOnNullInput() == calledOnNullInput) {
            logger.debug("Skipping duplicate compilation of already existing UDF {}", (Object)name);
            return udf;
        }
        try {
            return UDFunction.create(name, argNames, argTypes, abstractType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            logger.error(String.format("Cannot load function '%s' from schema: this function won't be available (on this node)", name), (Throwable)e);
            return UDFunction.createBrokenFunction(name, argNames, argTypes, abstractType, calledOnNullInput, language, body, e);
        }
    }

    public static Mutation makeCreateAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addAggregateToSchemaMutation(aggregate, timestamp, mutation);
        return mutation;
    }

    static void addAggregateToSchemaMutation(UDAggregate aggregate, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Aggregates, timestamp, mutation).clustering(aggregate.name().name, SchemaKeyspace.functionSignatureWithTypes(aggregate));
        adder.add("return_type", (Object)aggregate.returnType().toString()).add("state_func", (Object)aggregate.stateFunction().name().name).add("state_type", aggregate.stateType() != null ? aggregate.stateType().toString() : null).add("final_func", aggregate.finalFunction() != null ? aggregate.finalFunction().name().name : null).add("initcond", (Object)aggregate.initialCondition()).frozenList("argument_types", aggregate.argTypes().stream().map(AbstractType::toString).collect(Collectors.toList())).build();
    }

    private static Collection<UDAggregate> createAggregatesFromAggregatesPartition(RowIterator partition) {
        ArrayList<UDAggregate> aggregates = new ArrayList<UDAggregate>();
        String query = String.format("SELECT * FROM %s.%s", NAME, AGGREGATES);
        for (UntypedResultSet.Row row : QueryProcessor.resultify(query, partition)) {
            aggregates.add(SchemaKeyspace.createAggregateFromAggregateRow(row));
        }
        return aggregates;
    }

    private static UDAggregate createAggregateFromAggregateRow(UntypedResultSet.Row row) {
        List<AbstractType<?>> argTypes;
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("aggregate_name");
        FunctionName name = new FunctionName(ksName, functionName);
        List<String> types = row.getFrozenList("argument_types", UTF8Type.instance);
        if (types == null) {
            argTypes = Collections.emptyList();
        } else {
            argTypes = new ArrayList(types.size());
            for (String type : types) {
                argTypes.add(SchemaKeyspace.parseType(type));
            }
        }
        AbstractType<?> returnType = SchemaKeyspace.parseType(row.getString("return_type"));
        FunctionName stateFunc = new FunctionName(ksName, row.getString("state_func"));
        FunctionName finalFunc = row.has("final_func") ? new FunctionName(ksName, row.getString("final_func")) : null;
        AbstractType<?> stateType = row.has("state_type") ? SchemaKeyspace.parseType(row.getString("state_type")) : null;
        ByteBuffer initcond = row.has("initcond") ? row.getBytes("initcond") : null;
        try {
            return UDAggregate.create(name, argTypes, returnType, stateFunc, finalFunc, stateType, initcond);
        }
        catch (InvalidRequestException reason) {
            return UDAggregate.createBroken(name, argTypes, returnType, initcond, reason);
        }
    }

    public static Mutation makeDropAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Aggregates, timestamp, mutation, aggregate.name().name, SchemaKeyspace.functionSignatureWithTypes(aggregate));
    }

    private static AbstractType<?> parseType(String str) {
        return TypeParser.parse(str);
    }

    public static ByteBuffer functionSignatureWithTypes(AbstractFunction fun) {
        ListType<String> list = ListType.getInstance(UTF8Type.instance, false);
        ArrayList<String> strList = new ArrayList<String>(fun.argTypes().size());
        for (AbstractType<?> argType : fun.argTypes()) {
            strList.add(argType.asCQL3Type().toString());
        }
        return list.decompose((String)((Object)strList));
    }

    private static /* synthetic */ Boolean lambda$readSchemaFromSystemTables$196(DecoratedKey decoratedKey, List list, RowIterator rowIterator, RowIterator types) {
        return SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(TABLES, decoratedKey, (RowIterator tables) -> SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(FUNCTIONS, decoratedKey, (RowIterator functions) -> SchemaKeyspace.readSchemaPartitionForKeyspaceAndApply(AGGREGATES, decoratedKey, (RowIterator aggregates) -> list.add(SchemaKeyspace.createKeyspaceFromSchemaPartitions(rowIterator, tables, types, functions, aggregates)))));
    }

    public static interface Differ {
        public void onDropped(UntypedResultSet.Row var1);

        public void onAdded(UntypedResultSet.Row var1);

        public void onUpdated(UntypedResultSet.Row var1, UntypedResultSet.Row var2);
    }
}

