/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.RandomAccessReader;

public final class ChecksummedDataInput
extends RandomAccessReader.RandomAccessReaderWithOwnChannel {
    private final CRC32 crc = new CRC32();
    private int crcPosition = 0;
    private boolean crcUpdateDisabled = false;
    private long limit;
    private FileMark limitMark;

    private ChecksummedDataInput(Builder builder) {
        super(builder);
        this.resetLimit();
    }

    public static ChecksummedDataInput open(File file) {
        return new Builder(new ChannelProxy(file)).build();
    }

    public void resetCrc() {
        this.crc.reset();
        this.crcPosition = this.buffer.position();
    }

    public void limit(long newLimit) {
        this.limit = newLimit;
        this.limitMark = this.mark();
    }

    public void resetLimit() {
        this.limit = Long.MAX_VALUE;
        this.limitMark = null;
    }

    public void checkLimit(int length) throws IOException {
        if (this.limitMark == null) {
            return;
        }
        if (this.bytesPastLimit() + (long)length > this.limit) {
            throw new IOException("Digest mismatch exception");
        }
    }

    public long bytesPastLimit() {
        assert (this.limitMark != null);
        return this.bytesPastMark(this.limitMark);
    }

    public boolean checkCrc() throws IOException {
        try {
            this.updateCrc();
            this.crcUpdateDisabled = true;
            boolean bl = (int)this.crc.getValue() == this.readInt();
            return bl;
        }
        finally {
            this.crcPosition = this.buffer.position();
            this.crcUpdateDisabled = false;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkLimit(b.length);
        super.readFully(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkLimit(len);
        return super.read(b, off, len);
    }

    @Override
    public void reBuffer() {
        this.updateCrc();
        super.reBuffer();
        this.crcPosition = this.buffer.position();
    }

    private void updateCrc() {
        if (this.crcPosition == this.buffer.position() | this.crcUpdateDisabled) {
            return;
        }
        assert (this.crcPosition >= 0 && this.crcPosition < this.buffer.position());
        ByteBuffer unprocessed = this.buffer.duplicate();
        unprocessed.position(this.crcPosition).limit(this.buffer.position());
        this.crc.update(unprocessed);
    }

    public static final class Builder
    extends RandomAccessReader.Builder {
        public Builder(ChannelProxy channel) {
            super(channel);
        }

        @Override
        public ChecksummedDataInput build() {
            return new ChecksummedDataInput(this);
        }
    }
}

