/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Conflicts;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class TemporalRow {
    private static final int NO_TTL = 0;
    private static final long NO_TIMESTAMP = Long.MIN_VALUE;
    private static final int NO_DELETION_TIME = DeletionTime.LIVE.localDeletionTime();
    public static final Resolver oldValueIfUpdated = TemporalCell.Versions::getOldCellIfUpdated;
    public static final Resolver earliest = TemporalCell.Versions::getEarliestCell;
    public static final Resolver latest = TemporalCell.Versions::getLatestCell;
    private final ColumnFamilyStore baseCfs;
    private final java.util.Set<ColumnIdentifier> viewPrimaryKey;
    private final ByteBuffer basePartitionKey;
    private final Map<ColumnIdentifier, ByteBuffer> clusteringColumns;
    private final Row startRow;
    private final boolean startIsNew;
    public final int nowInSec;
    private final Map<ColumnIdentifier, Map<CellPath, TemporalCell.Versions>> columnValues = new HashMap<ColumnIdentifier, Map<CellPath, TemporalCell.Versions>>();
    private int viewClusteringTtl = 0;
    private long viewClusteringTimestamp = Long.MIN_VALUE;
    private int viewClusteringLocalDeletionTime = NO_DELETION_TIME;

    TemporalRow(ColumnFamilyStore baseCfs, java.util.Set<ColumnIdentifier> viewPrimaryKey, ByteBuffer key, Row row, int nowInSec, boolean isNew) {
        this.baseCfs = baseCfs;
        this.viewPrimaryKey = viewPrimaryKey;
        this.basePartitionKey = key;
        this.startRow = row;
        this.startIsNew = isNew;
        this.nowInSec = nowInSec;
        LivenessInfo liveness = row.primaryKeyLivenessInfo();
        this.viewClusteringLocalDeletionTime = TemporalRow.minValueIfSet(this.viewClusteringLocalDeletionTime, row.deletion().localDeletionTime(), NO_DELETION_TIME);
        this.viewClusteringTimestamp = TemporalRow.minValueIfSet(this.viewClusteringTimestamp, liveness.timestamp(), Long.MIN_VALUE);
        this.viewClusteringTtl = TemporalRow.minValueIfSet(this.viewClusteringTtl, liveness.ttl(), 0);
        List<ColumnDefinition> clusteringDefs = baseCfs.metadata.clusteringColumns();
        this.clusteringColumns = new HashMap<ColumnIdentifier, ByteBuffer>();
        for (int i = 0; i < clusteringDefs.size(); ++i) {
            ColumnDefinition cdef = clusteringDefs.get(i);
            this.clusteringColumns.put(cdef.name, row.clustering().get(i));
            this.addColumnValue(cdef.name, null, Long.MIN_VALUE, 0, NO_DELETION_TIME, row.clustering().get(i), isNew);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalRow that = (TemporalRow)o;
        if (!this.clusteringColumns.equals(that.clusteringColumns)) {
            return false;
        }
        return this.basePartitionKey.equals(that.basePartitionKey);
    }

    public int hashCode() {
        int result = this.basePartitionKey.hashCode();
        result = 31 * result + this.clusteringColumns.hashCode();
        return result;
    }

    public void addColumnValue(ColumnIdentifier identifier, CellPath cellPath, long timestamp, int ttl, int localDeletionTime, ByteBuffer value, boolean isNew) {
        Map<CellPath, TemporalCell.Versions> innerMap;
        if (!this.columnValues.containsKey(identifier)) {
            this.columnValues.put(identifier, new HashMap());
        }
        if (!(innerMap = this.columnValues.get(identifier)).containsKey(cellPath)) {
            innerMap.put(cellPath, new TemporalCell.Versions());
        }
        if (this.viewPrimaryKey.contains(identifier)) {
            this.viewClusteringTtl = TemporalRow.minValueIfSet(this.viewClusteringTtl, ttl, 0);
            this.viewClusteringTimestamp = TemporalRow.minValueIfSet(this.viewClusteringTimestamp, timestamp, Long.MIN_VALUE);
            this.viewClusteringLocalDeletionTime = TemporalRow.minValueIfSet(this.viewClusteringLocalDeletionTime, localDeletionTime, NO_DELETION_TIME);
        }
        innerMap.get(cellPath).setVersion(new TemporalCell(value, timestamp, ttl, localDeletionTime, isNew));
    }

    private static int minValueIfSet(int existing, int update, int defaultValue) {
        if (existing == defaultValue) {
            return update;
        }
        if (update == defaultValue) {
            return existing;
        }
        return Math.min(existing, update);
    }

    private static long minValueIfSet(long existing, long update, long defaultValue) {
        if (existing == defaultValue) {
            return update;
        }
        if (update == defaultValue) {
            return existing;
        }
        return Math.min(existing, update);
    }

    public int viewClusteringTtl() {
        return this.viewClusteringTtl;
    }

    public long viewClusteringTimestamp() {
        return this.viewClusteringTimestamp;
    }

    public int viewClusteringLocalDeletionTime() {
        return this.viewClusteringLocalDeletionTime;
    }

    public void addCell(Cell cell, boolean isNew) {
        this.addColumnValue(cell.column().name, cell.path(), cell.timestamp(), cell.ttl(), cell.localDeletionTime(), cell.value(), isNew);
    }

    public ByteBuffer clusteringValue(ColumnDefinition definition, Resolver resolver) {
        ColumnDefinition baseDefinition;
        ColumnDefinition columnDefinition = baseDefinition = definition.cfName.equals(this.baseCfs.name) ? definition : this.baseCfs.metadata.getColumnDefinition(definition.name);
        if (baseDefinition.isPartitionKey()) {
            if (baseDefinition.isOnAllComponents()) {
                return this.basePartitionKey;
            }
            CompositeType keyComparator = (CompositeType)this.baseCfs.metadata.getKeyValidator();
            ByteBuffer[] components = keyComparator.split(this.basePartitionKey);
            return components[baseDefinition.position()];
        }
        ColumnIdentifier columnIdentifier = baseDefinition.name;
        if (this.clusteringColumns.containsKey(columnIdentifier)) {
            return this.clusteringColumns.get(columnIdentifier);
        }
        Collection<Cell> val = this.values(definition, resolver);
        if (val != null && val.size() == 1) {
            return ((Cell)Iterables.getOnlyElement(val)).value();
        }
        return null;
    }

    public DeletionTime deletionTime(AbstractBTreePartition partition) {
        DeletionInfo deletionInfo = partition.deletionInfo();
        if (!deletionInfo.getPartitionDeletion().isLive()) {
            return deletionInfo.getPartitionDeletion();
        }
        Clustering baseClustering = this.baseClusteringBuilder().build();
        RangeTombstone clusterTombstone = deletionInfo.rangeCovering(baseClustering);
        if (clusterTombstone != null) {
            return clusterTombstone.deletionTime();
        }
        Row row = partition.getRow(baseClustering);
        return row == null || row.deletion().isLive() ? DeletionTime.LIVE : row.deletion();
    }

    public Collection<Cell> values(ColumnDefinition definition, Resolver resolver) {
        Map<CellPath, TemporalCell.Versions> innerMap = this.columnValues.get(definition.name);
        if (innerMap == null) {
            return Collections.emptyList();
        }
        ArrayList<Cell> value = new ArrayList<Cell>();
        for (Map.Entry<CellPath, TemporalCell.Versions> pathAndCells : innerMap.entrySet()) {
            TemporalCell cell = resolver.resolve(pathAndCells.getValue());
            if (cell == null) continue;
            value.add(cell.cell(definition, pathAndCells.getKey()));
        }
        return value;
    }

    public Slice baseSlice() {
        return this.baseClusteringBuilder().buildSlice();
    }

    private CBuilder baseClusteringBuilder() {
        CFMetaData metadata = this.baseCfs.metadata;
        CBuilder builder = CBuilder.create(metadata.comparator);
        ByteBuffer[] buffers = new ByteBuffer[this.clusteringColumns.size()];
        for (Map.Entry<ColumnIdentifier, ByteBuffer> buffer : this.clusteringColumns.entrySet()) {
            buffers[metadata.getColumnDefinition((ColumnIdentifier)buffer.getKey()).position()] = buffer.getValue();
        }
        for (ByteBuffer byteBuffer : buffers) {
            builder = builder.add(byteBuffer);
        }
        return builder;
    }

    static class Set
    implements Iterable<TemporalRow> {
        private final ColumnFamilyStore baseCfs;
        private final java.util.Set<ColumnIdentifier> viewPrimaryKey;
        private final ByteBuffer key;
        public final DecoratedKey dk;
        private final Map<Clustering, TemporalRow> clusteringToRow;
        final int nowInSec = FBUtilities.nowInSeconds();
        private boolean hasTombstonedExisting = false;

        Set(ColumnFamilyStore baseCfs, java.util.Set<ColumnIdentifier> viewPrimaryKey, ByteBuffer key) {
            this.baseCfs = baseCfs;
            this.viewPrimaryKey = viewPrimaryKey;
            this.key = key;
            this.dk = baseCfs.decorateKey(key);
            this.clusteringToRow = new HashMap<Clustering, TemporalRow>();
        }

        @Override
        public Iterator<TemporalRow> iterator() {
            return this.clusteringToRow.values().iterator();
        }

        public TemporalRow getClustering(Clustering clustering) {
            return this.clusteringToRow.get(clustering);
        }

        public void addRow(Row row, boolean isNew) {
            TemporalRow temporalRow = this.clusteringToRow.get(row.clustering());
            if (temporalRow == null) {
                temporalRow = new TemporalRow(this.baseCfs, this.viewPrimaryKey, this.key, row, this.nowInSec, isNew);
                this.clusteringToRow.put(row.clustering(), temporalRow);
            }
            for (Cell cell : row.cells()) {
                temporalRow.addCell(cell, isNew);
            }
        }

        private void addRow(TemporalRow row) {
            TemporalRow newRow = new TemporalRow(this.baseCfs, this.viewPrimaryKey, this.key, row.startRow, this.nowInSec, row.startIsNew);
            TemporalRow existing = this.clusteringToRow.put(row.startRow.clustering(), newRow);
            assert (existing == null);
            for (Map.Entry entry : row.columnValues.entrySet()) {
                for (Map.Entry cellPathEntry : ((Map)entry.getValue()).entrySet()) {
                    TemporalCell.Versions cellVersions = (TemporalCell.Versions)cellPathEntry.getValue();
                    cellVersions.addToRow(newRow, (ColumnIdentifier)entry.getKey(), (CellPath)cellPathEntry.getKey());
                }
            }
        }

        public Set withNewViewPrimaryKey(java.util.Set<ColumnIdentifier> viewPrimaryKey) {
            Set newSet = new Set(this.baseCfs, viewPrimaryKey, this.key);
            for (TemporalRow row : this) {
                newSet.addRow(row);
            }
            return newSet;
        }

        public boolean hasTombstonedExisting() {
            return this.hasTombstonedExisting;
        }

        public void setTombstonedExisting() {
            this.hasTombstonedExisting = true;
        }

        public int size() {
            return this.clusteringToRow.size();
        }
    }

    private static class TemporalCell {
        public final ByteBuffer value;
        public final long timestamp;
        public final int ttl;
        public final int localDeletionTime;
        public final boolean isNew;

        private TemporalCell(ByteBuffer value, long timestamp, int ttl, int localDeletionTime, boolean isNew) {
            this.value = value;
            this.timestamp = timestamp;
            this.ttl = ttl;
            this.localDeletionTime = localDeletionTime;
            this.isNew = isNew;
        }

        public TemporalCell reconcile(TemporalCell that) {
            int now = FBUtilities.nowInSeconds();
            Conflicts.Resolution resolution = Conflicts.resolveRegular(that.timestamp, that.isLive(now), that.localDeletionTime, that.value, this.timestamp, this.isLive(now), this.localDeletionTime, this.value);
            assert (resolution != Conflicts.Resolution.MERGE);
            if (resolution == Conflicts.Resolution.LEFT_WINS) {
                return that;
            }
            return this;
        }

        private boolean isLive(int now) {
            return this.localDeletionTime == NO_DELETION_TIME || this.ttl != 0 && now < this.localDeletionTime;
        }

        public Cell cell(ColumnDefinition definition, CellPath cellPath) {
            return new BufferCell(definition, this.timestamp, this.ttl, this.localDeletionTime, this.value, cellPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporalCell that = (TemporalCell)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (this.ttl != that.ttl) {
                return false;
            }
            if (this.localDeletionTime != that.localDeletionTime) {
                return false;
            }
            if (this.isNew != that.isNew) {
                return false;
            }
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + this.ttl;
            result = 31 * result + this.localDeletionTime;
            result = 31 * result + (this.isNew ? 1 : 0);
            return result;
        }

        static class Versions {
            private TemporalCell existingCell = null;
            private TemporalCell newCell = null;
            private int numSet = 0;

            Versions() {
            }

            public TemporalCell getEarliestCell() {
                assert (this.numSet > 0);
                if (this.numSet == 1) {
                    return this.existingCell == null ? this.newCell : this.existingCell;
                }
                TemporalCell latest = this.existingCell.reconcile(this.newCell);
                return latest == this.newCell ? this.existingCell : this.newCell;
            }

            public TemporalCell getLatestCell() {
                assert (this.numSet > 0);
                if (this.numSet == 1) {
                    return this.existingCell == null ? this.newCell : this.existingCell;
                }
                return this.existingCell.reconcile(this.newCell);
            }

            public TemporalCell getOldCellIfUpdated() {
                assert (this.numSet > 0);
                if (this.numSet == 1) {
                    return null;
                }
                TemporalCell value = this.existingCell.reconcile(this.newCell);
                return ByteBufferUtil.compareUnsigned(this.existingCell.value, value.value) != 0 ? this.existingCell : null;
            }

            void setVersion(TemporalCell cell) {
                assert (cell != null);
                if (cell.isNew) {
                    assert (this.newCell == null || this.newCell.equals(cell)) : "Only one cell version can be marked New";
                    this.newCell = cell;
                    this.numSet = this.existingCell == null ? 1 : 2;
                } else {
                    assert (this.existingCell == null || this.existingCell.equals(cell)) : "Only one cell version can be marked Existing";
                    this.existingCell = cell;
                    this.numSet = this.newCell == null ? 1 : 2;
                }
            }

            public void addToRow(TemporalRow row, ColumnIdentifier column, CellPath path) {
                if (this.existingCell != null) {
                    row.addColumnValue(column, path, this.existingCell.timestamp, this.existingCell.ttl, this.existingCell.localDeletionTime, this.existingCell.value, this.existingCell.isNew);
                }
                if (this.newCell != null) {
                    row.addColumnValue(column, path, this.newCell.timestamp, this.newCell.ttl, this.newCell.localDeletionTime, this.newCell.value, this.newCell.isNew);
                }
            }
        }
    }

    public static interface Resolver {
        public TemporalCell resolve(TemporalCell.Versions var1);
    }
}

