/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public final class MaterializedViewUtils {
    private MaterializedViewUtils() {
    }

    public static InetAddress getViewNaturalEndpoint(String keyspaceName, Token baseToken, Token viewToken) {
        AbstractReplicationStrategy replicationStrategy = Keyspace.open(keyspaceName).getReplicationStrategy();
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        ArrayList<InetAddress> localBaseEndpoints = new ArrayList<InetAddress>();
        ArrayList<InetAddress> localViewEndpoints = new ArrayList<InetAddress>();
        for (InetAddress baseEndpoint : replicationStrategy.getNaturalEndpoints(baseToken)) {
            if (!DatabaseDescriptor.getEndpointSnitch().getDatacenter(baseEndpoint).equals(localDataCenter)) continue;
            localBaseEndpoints.add(baseEndpoint);
        }
        for (InetAddress viewEndpoint : replicationStrategy.getNaturalEndpoints(viewToken)) {
            if (viewEndpoint.equals(FBUtilities.getBroadcastAddress())) {
                return viewEndpoint;
            }
            if (localBaseEndpoints.contains(viewEndpoint)) {
                localBaseEndpoints.remove(viewEndpoint);
                continue;
            }
            if (!DatabaseDescriptor.getEndpointSnitch().getDatacenter(viewEndpoint).equals(localDataCenter)) continue;
            localViewEndpoints.add(viewEndpoint);
        }
        assert (localBaseEndpoints.size() == localViewEndpoints.size()) : "Replication strategy should have the same number of endpoints for the base and the view";
        int baseIdx = localBaseEndpoints.indexOf(FBUtilities.getBroadcastAddress());
        if (baseIdx < 0) {
            if (StorageService.instance.getTokenMetadata().pendingEndpointsFor(viewToken, keyspaceName).size() > 0) {
                return FBUtilities.getBroadcastAddress();
            }
            throw new RuntimeException("Trying to get the view natural endpoint on a non-data replica");
        }
        return (InetAddress)localViewEndpoints.get(baseIdx);
    }
}

