/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public abstract class ReadResponse {
    public static final IVersionedSerializer<ReadResponse> serializer = new Serializer();
    public static final IVersionedSerializer<ReadResponse> rangeSliceSerializer = new RangeSliceSerializer();
    public static final IVersionedSerializer<ReadResponse> legacyRangeSliceReplySerializer = new LegacyRangeSliceReplySerializer();
    private final CFMetaData metadata;

    protected ReadResponse(CFMetaData metadata) {
        this.metadata = metadata;
    }

    public static ReadResponse createDataResponse(UnfilteredPartitionIterator data, ColumnFilter selection) {
        return new LocalDataResponse(data, selection);
    }

    @VisibleForTesting
    public static ReadResponse createRemoteDataResponse(UnfilteredPartitionIterator data, ColumnFilter selection) {
        return new RemoteDataResponse(LocalDataResponse.build(data, selection));
    }

    public static ReadResponse createDigestResponse(UnfilteredPartitionIterator data, int version) {
        return new DigestResponse(ReadResponse.makeDigest(data, version));
    }

    public abstract UnfilteredPartitionIterator makeIterator(CFMetaData var1, ReadCommand var2);

    public abstract ByteBuffer digest(CFMetaData var1, ReadCommand var2);

    public abstract boolean isDigestResponse();

    protected static ByteBuffer makeDigest(UnfilteredPartitionIterator iterator, int version) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        UnfilteredPartitionIterators.digest(iterator, digest, version);
        return ByteBuffer.wrap(digest.digest());
    }

    private static class LegacyRangeSliceReplySerializer
    implements IVersionedSerializer<ReadResponse> {
        private LegacyRangeSliceReplySerializer() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            Throwable throwable;
            assert (version < 10);
            int numPartitions = 0;
            assert (!(response instanceof LegacyRemoteDataResponse));
            try (UnfilteredPartitionIterator iterator = response.makeIterator(response.metadata, null);){
                while (iterator.hasNext()) {
                    UnfilteredRowIterator atomIterator;
                    block47: {
                        atomIterator = (UnfilteredRowIterator)iterator.next();
                        throwable = null;
                        try {
                            ++numPartitions;
                            while (atomIterator.hasNext()) {
                                atomIterator.next();
                            }
                            if (atomIterator == null) continue;
                            if (throwable == null) break block47;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (atomIterator == null) throw throwable3;
                                if (throwable == null) {
                                    atomIterator.close();
                                    throw throwable3;
                                }
                                try {
                                    atomIterator.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            atomIterator.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    atomIterator.close();
                }
            }
            out.writeInt(numPartitions);
            iterator = response.makeIterator(response.metadata, null);
            var6_6 = null;
            try {
                while (iterator.hasNext()) {
                    UnfilteredRowIterator partition;
                    block49: {
                        partition = (UnfilteredRowIterator)iterator.next();
                        throwable = null;
                        try {
                            ByteBufferUtil.writeWithShortLength(partition.partitionKey().getKey(), out);
                            LegacyLayout.serializeAsLegacyPartition(partition, out, version);
                            if (partition == null) continue;
                            if (throwable == null) break block49;
                        }
                        catch (Throwable throwable6) {
                            try {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                if (partition == null) throw throwable7;
                                if (throwable != null) {
                                    try {
                                        partition.close();
                                        throw throwable7;
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                        throw throwable7;
                                    }
                                }
                                partition.close();
                                throw throwable7;
                            }
                        }
                        try {
                            partition.close();
                            continue;
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                            continue;
                        }
                    }
                    partition.close();
                }
                return;
            }
            catch (Throwable throwable10) {
                var6_6 = throwable10;
                throw throwable10;
            }
            finally {
                if (iterator != null) {
                    if (var6_6 != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable11) {
                            var6_6.addSuppressed(throwable11);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
        }

        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            int partitionCount = in.readInt();
            ArrayList<ImmutableBTreePartition> partitions = new ArrayList<ImmutableBTreePartition>(partitionCount);
            for (int i = 0; i < partitionCount; ++i) {
                ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
                try (UnfilteredRowIterator partition = LegacyLayout.deserializeLegacyPartition(in, version, SerializationHelper.Flag.FROM_REMOTE, key);){
                    partitions.add(ImmutableBTreePartition.create(partition));
                    continue;
                }
            }
            return new LegacyRemoteDataResponse(partitions);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long serializedSize(ReadResponse response, int version) {
            assert (version < 10);
            long size = TypeSizes.sizeof(0);
            assert (!(response instanceof LegacyRemoteDataResponse));
            try (UnfilteredPartitionIterator iterator = response.makeIterator(response.metadata, null);){
                while (iterator.hasNext()) {
                    UnfilteredRowIterator partition;
                    block24: {
                        partition = (UnfilteredRowIterator)iterator.next();
                        Throwable throwable = null;
                        try {
                            size += (long)ByteBufferUtil.serializedSizeWithShortLength(partition.partitionKey().getKey());
                            size += LegacyLayout.serializedSizeAsLegacyPartition(partition, version);
                            if (partition == null) continue;
                            if (throwable == null) break block24;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (partition == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        partition.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                partition.close();
                                throw throwable3;
                            }
                        }
                        try {
                            partition.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    partition.close();
                }
                return size;
            }
        }
    }

    private static class RangeSliceSerializer
    implements IVersionedSerializer<ReadResponse> {
        private RangeSliceSerializer() {
        }

        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                legacyRangeSliceReplySerializer.serialize(response, out, version);
            } else {
                serializer.serialize(response, out, version);
            }
        }

        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            return version < 10 ? legacyRangeSliceReplySerializer.deserialize(in, version) : serializer.deserialize(in, version);
        }

        @Override
        public long serializedSize(ReadResponse response, int version) {
            return version < 10 ? legacyRangeSliceReplySerializer.serializedSize(response, version) : serializer.serializedSize(response, version);
        }
    }

    private static class Serializer
    implements IVersionedSerializer<ReadResponse> {
        private Serializer() {
        }

        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            ByteBuffer digest;
            boolean isDigest = response instanceof DigestResponse;
            ByteBuffer byteBuffer = digest = isDigest ? ((DigestResponse)response).digest : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            if (version < 10) {
                out.writeInt(digest.remaining());
                out.write(digest);
                out.writeBoolean(isDigest);
                if (!isDigest) {
                    assert (!(response instanceof LegacyRemoteDataResponse));
                    try (UnfilteredPartitionIterator iter = response.makeIterator(response.metadata, null);){
                        assert (iter.hasNext());
                        try (UnfilteredRowIterator partition = (UnfilteredRowIterator)iter.next();){
                            ByteBufferUtil.writeWithShortLength(partition.partitionKey().getKey(), out);
                            LegacyLayout.serializeAsLegacyPartition(partition, out, version);
                        }
                        assert (!iter.hasNext());
                    }
                }
                return;
            }
            ByteBufferUtil.writeWithVIntLength(digest, out);
            if (!isDigest) {
                ByteBuffer data = ((DataResponse)response).data;
                ByteBufferUtil.writeWithVIntLength(data, out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            if (version < 10) {
                byte[] digest = null;
                int digestSize = in.readInt();
                if (digestSize > 0) {
                    digest = new byte[digestSize];
                    in.readFully(digest, 0, digestSize);
                }
                boolean isDigest = in.readBoolean();
                assert (isDigest == digestSize > 0);
                if (isDigest) {
                    assert (digest != null);
                    return new DigestResponse(ByteBuffer.wrap(digest));
                }
                ByteBuffer key = ByteBufferUtil.readWithShortLength(in);
                UnfilteredRowIterator rowIterator = LegacyLayout.deserializeLegacyPartition(in, version, SerializationHelper.Flag.FROM_REMOTE, key);
                if (rowIterator == null) {
                    return new LegacyRemoteDataResponse(Collections.emptyList());
                }
                try {
                    LegacyRemoteDataResponse legacyRemoteDataResponse = new LegacyRemoteDataResponse(Collections.singletonList(ImmutableBTreePartition.create(rowIterator)));
                    return legacyRemoteDataResponse;
                }
                finally {
                    rowIterator.close();
                }
            }
            ByteBuffer digest = ByteBufferUtil.readWithVIntLength(in);
            if (digest.hasRemaining()) {
                return new DigestResponse(digest);
            }
            assert (version == 10);
            ByteBuffer data = ByteBufferUtil.readWithVIntLength(in);
            return new RemoteDataResponse(data);
        }

        @Override
        public long serializedSize(ReadResponse response, int version) {
            ByteBuffer digest;
            boolean isDigest = response instanceof DigestResponse;
            ByteBuffer byteBuffer = digest = isDigest ? ((DigestResponse)response).digest : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            if (version < 10) {
                long size = TypeSizes.sizeof(digest.remaining()) + digest.remaining() + TypeSizes.sizeof(isDigest);
                if (!isDigest) {
                    assert (!(response instanceof LegacyRemoteDataResponse));
                    try (UnfilteredPartitionIterator iter = response.makeIterator(response.metadata, null);){
                        assert (iter.hasNext());
                        try (UnfilteredRowIterator partition = (UnfilteredRowIterator)iter.next();){
                            size += (long)ByteBufferUtil.serializedSizeWithShortLength(partition.partitionKey().getKey());
                            size += LegacyLayout.serializedSizeAsLegacyPartition(partition, version);
                        }
                        assert (!iter.hasNext());
                    }
                }
                return size;
            }
            long size = ByteBufferUtil.serializedSizeWithVIntLength(digest);
            if (!isDigest) {
                assert (version == 10);
                ByteBuffer data = ((DataResponse)response).data;
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(data);
            }
            return size;
        }
    }

    @VisibleForTesting
    static class LegacyRemoteDataResponse
    extends ReadResponse {
        private final List<ImmutableBTreePartition> partitions;

        @VisibleForTesting
        LegacyRemoteDataResponse(List<ImmutableBTreePartition> partitions) {
            super(null);
            this.partitions = partitions;
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(final CFMetaData metadata, final ReadCommand command) {
            boolean skipFirst = false;
            boolean skipLast = false;
            if (!this.partitions.isEmpty() && command instanceof PartitionRangeReadCommand) {
                AbstractBounds<PartitionPosition> keyRange = ((PartitionRangeReadCommand)command).dataRange().keyRange();
                boolean isExcludingBounds = keyRange instanceof ExcludingBounds;
                skipFirst = isExcludingBounds && !keyRange.contains(this.partitions.get(0).partitionKey());
                boolean bl = skipLast = (isExcludingBounds || keyRange instanceof IncludingExcludingBounds) && !keyRange.contains(this.partitions.get(this.partitions.size() - 1).partitionKey());
            }
            final List<Object> toReturn = skipFirst || skipLast ? (this.partitions.size() == 1 ? Collections.emptyList() : this.partitions.subList(skipFirst ? 1 : 0, skipLast ? this.partitions.size() - 1 : this.partitions.size())) : this.partitions;
            return new AbstractUnfilteredPartitionIterator(){
                private int idx;

                @Override
                public boolean isForThrift() {
                    return true;
                }

                @Override
                public CFMetaData metadata() {
                    return metadata;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < toReturn.size();
                }

                @Override
                public UnfilteredRowIterator next() {
                    ImmutableBTreePartition partition = (ImmutableBTreePartition)toReturn.get(this.idx++);
                    ClusteringIndexFilter filter = command.clusteringIndexFilter(partition.partitionKey());
                    if (!command.metadata().isCompound()) {
                        return filter.filter(partition.sliceableUnfilteredIterator(command.columnFilter(), filter.isReversed()));
                    }
                    return partition.unfilteredIterator(command.columnFilter(), Slices.ALL, filter.isReversed());
                }
            };
        }

        @Override
        public ByteBuffer digest(CFMetaData metadata, ReadCommand command) {
            try (UnfilteredPartitionIterator iterator = this.makeIterator(metadata, command);){
                ByteBuffer byteBuffer = LegacyRemoteDataResponse.makeDigest(iterator, command.digestVersion());
                return byteBuffer;
            }
        }

        @Override
        public boolean isDigestResponse() {
            return false;
        }
    }

    static abstract class DataResponse
    extends ReadResponse {
        private final ByteBuffer data;
        private final SerializationHelper.Flag flag;

        protected DataResponse(CFMetaData metadata, ByteBuffer data, SerializationHelper.Flag flag) {
            super(metadata);
            this.data = data;
            this.flag = flag;
        }

        protected abstract ColumnFilter selection(ReadCommand var1);

        @Override
        public UnfilteredPartitionIterator makeIterator(CFMetaData metadata, ReadCommand command) {
            try {
                DataInputBuffer in = new DataInputBuffer(this.data, true);
                return UnfilteredPartitionIterators.serializerForIntraNode().deserialize(in, 10, metadata, this.selection(command), this.flag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ByteBuffer digest(CFMetaData metadata, ReadCommand command) {
            try (UnfilteredPartitionIterator iterator = this.makeIterator(metadata, command);){
                ByteBuffer byteBuffer = DataResponse.makeDigest(iterator, command.digestVersion());
                return byteBuffer;
            }
        }

        @Override
        public boolean isDigestResponse() {
            return false;
        }
    }

    private static class RemoteDataResponse
    extends DataResponse {
        protected RemoteDataResponse(ByteBuffer data) {
            super(null, data, SerializationHelper.Flag.FROM_REMOTE);
        }

        @Override
        protected ColumnFilter selection(ReadCommand sent) {
            assert (sent != null);
            return sent.columnFilter();
        }
    }

    private static class LocalDataResponse
    extends DataResponse {
        private final ColumnFilter received;

        private LocalDataResponse(UnfilteredPartitionIterator iter, ColumnFilter received) {
            super(iter.metadata(), LocalDataResponse.build(iter, received), SerializationHelper.Flag.LOCAL);
            this.received = received;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static ByteBuffer build(UnfilteredPartitionIterator iter, ColumnFilter selection) {
            try (DataOutputBuffer buffer = new DataOutputBuffer();){
                UnfilteredPartitionIterators.serializerForIntraNode().serialize(iter, selection, buffer, 10);
                ByteBuffer byteBuffer = buffer.buffer();
                return byteBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected ColumnFilter selection(ReadCommand sent) {
            assert (sent == null || sent.columnFilter() == this.received);
            return this.received;
        }
    }

    private static class DigestResponse
    extends ReadResponse {
        private final ByteBuffer digest;

        private DigestResponse(ByteBuffer digest) {
            super(null);
            assert (digest.hasRemaining());
            this.digest = digest;
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(CFMetaData metadata, ReadCommand command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer digest(CFMetaData metadata, ReadCommand command) {
            return this.digest;
        }

        @Override
        public boolean isDigestResponse() {
            return true;
        }
    }
}

