/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.MaterializedViewManager;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.metrics.KeyspaceMetrics;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keyspace {
    private static final Logger logger = LoggerFactory.getLogger(Keyspace.class);
    private static final String TEST_FAIL_WRITES_KS = System.getProperty("cassandra.test.fail_writes_ks", "");
    private static final boolean TEST_FAIL_WRITES;
    public final KeyspaceMetrics metric;
    private volatile KeyspaceMetadata metadata;
    public static final OpOrder writeOrder;
    private final ConcurrentMap<UUID, ColumnFamilyStore> columnFamilyStores = new ConcurrentHashMap<UUID, ColumnFamilyStore>();
    private volatile AbstractReplicationStrategy replicationStrategy;
    public static final Function<String, Keyspace> keyspaceTransformer;
    private static volatile boolean initialized;

    public static void setInitialized() {
        initialized = true;
    }

    public static Keyspace open(String keyspaceName) {
        assert (initialized || Schema.isSystemKeyspace(keyspaceName));
        return Keyspace.open(keyspaceName, Schema.instance, true);
    }

    public static Keyspace openWithoutSSTables(String keyspaceName) {
        return Keyspace.open(keyspaceName, Schema.instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Keyspace open(String keyspaceName, Schema schema, boolean loadSSTables) {
        Keyspace keyspaceInstance = schema.getKeyspaceInstance(keyspaceName);
        if (keyspaceInstance != null) return keyspaceInstance;
        Class<Keyspace> clazz = Keyspace.class;
        synchronized (Keyspace.class) {
            keyspaceInstance = schema.getKeyspaceInstance(keyspaceName);
            if (keyspaceInstance != null) return keyspaceInstance;
            keyspaceInstance = new Keyspace(keyspaceName, loadSSTables);
            schema.storeKeyspaceInstance(keyspaceInstance);
            for (ColumnFamilyStore cfs : keyspaceInstance.getColumnFamilyStores()) {
                cfs.init();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return keyspaceInstance;
        }
    }

    public static Keyspace clear(String keyspaceName) {
        return Keyspace.clear(keyspaceName, Schema.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyspace clear(String keyspaceName, Schema schema) {
        Class<Keyspace> clazz = Keyspace.class;
        synchronized (Keyspace.class) {
            Keyspace t = schema.removeKeyspaceInstance(keyspaceName);
            if (t != null) {
                for (ColumnFamilyStore cfs : t.getColumnFamilyStores()) {
                    t.unloadCf(cfs);
                }
                t.metric.release();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return t;
        }
    }

    public static ColumnFamilyStore openAndGetStore(CFMetaData cfm) {
        return Keyspace.open(cfm.ksName).getColumnFamilyStore(cfm.cfId);
    }

    public static void removeUnreadableSSTables(File directory) {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore baseCfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore cfs : baseCfs.concatWithIndexes()) {
                    cfs.maybeRemoveUnreadableSSTables(directory);
                }
            }
        }
    }

    public void setMetadata(KeyspaceMetadata metadata) {
        this.metadata = metadata;
        this.createReplicationStrategy(metadata);
    }

    public KeyspaceMetadata getMetadata() {
        return this.metadata;
    }

    public Collection<ColumnFamilyStore> getColumnFamilyStores() {
        return Collections.unmodifiableCollection(this.columnFamilyStores.values());
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        UUID id = Schema.instance.getId(this.getName(), cfName);
        if (id == null) {
            throw new IllegalArgumentException(String.format("Unknown keyspace/cf pair (%s.%s)", this.getName(), cfName));
        }
        return this.getColumnFamilyStore(id);
    }

    public ColumnFamilyStore getColumnFamilyStore(UUID id) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(id);
        if (cfs == null) {
            throw new IllegalArgumentException("Unknown CF " + id);
        }
        return cfs;
    }

    public boolean hasColumnFamilyStore(UUID id) {
        return this.columnFamilyStores.containsKey(id);
    }

    public void snapshot(String snapshotName, String columnFamilyName) throws IOException {
        assert (snapshotName != null);
        boolean tookSnapShot = false;
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (columnFamilyName != null && !cfStore.name.equals(columnFamilyName)) continue;
            tookSnapShot = true;
            cfStore.snapshot(snapshotName);
        }
        if (columnFamilyName != null && !tookSnapShot) {
            throw new IOException("Failed taking snapshot. Table " + columnFamilyName + " does not exist.");
        }
    }

    public static String getTimestampedSnapshotName(String clientSuppliedName) {
        String snapshotName = Long.toString(System.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        return snapshotName;
    }

    public boolean snapshotExists(String snapshotName) {
        assert (snapshotName != null);
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (!cfStore.snapshotExists(snapshotName)) continue;
            return true;
        }
        return false;
    }

    public static void clearSnapshot(String snapshotName, String keyspace) {
        List<File> snapshotDirs = Directories.getKSChildDirectories(keyspace);
        Directories.clearSnapshot(snapshotName, snapshotDirs);
    }

    public List<SSTableReader> getAllSSTables(SSTableSet sstableSet) {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            Iterables.addAll(list, cfStore.getSSTables(sstableSet));
        }
        return list;
    }

    private Keyspace(String keyspaceName, boolean loadSSTables) {
        this.metadata = Schema.instance.getKSMetaData(keyspaceName);
        assert (this.metadata != null) : "Unknown keyspace " + keyspaceName;
        this.createReplicationStrategy(this.metadata);
        this.metric = new KeyspaceMetrics(this);
        for (CFMetaData cfm : this.metadata.tables) {
            logger.debug("Initializing {}.{}", (Object)this.getName(), (Object)cfm.cfName);
            this.initCf(cfm.cfId, cfm.cfName, loadSSTables);
        }
    }

    private Keyspace(KeyspaceMetadata metadata) {
        this.metadata = metadata;
        this.createReplicationStrategy(metadata);
        this.metric = new KeyspaceMetrics(this);
    }

    public static Keyspace mockKS(KeyspaceMetadata metadata) {
        return new Keyspace(metadata);
    }

    private void createReplicationStrategy(KeyspaceMetadata ksm) {
        this.replicationStrategy = AbstractReplicationStrategy.createReplicationStrategy(ksm.name, ksm.params.replication.klass, StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), ksm.params.replication.options);
    }

    public void dropCf(UUID cfId) {
        assert (this.columnFamilyStores.containsKey(cfId));
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.remove(cfId);
        if (cfs == null) {
            return;
        }
        cfs.getCompactionStrategyManager().shutdown();
        CompactionManager.instance.interruptCompactionForCFs(cfs.concatWithIndexes(), true);
        Keyspace cfr_ignored_0 = cfs.keyspace;
        writeOrder.awaitNewBarrier();
        cfs.readOrdering.awaitNewBarrier();
        this.unloadCf(cfs);
    }

    private void unloadCf(ColumnFamilyStore cfs) {
        cfs.forceBlockingFlush();
        cfs.invalidate();
    }

    public void initCf(UUID cfId, String cfName, boolean loadSSTables) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(cfId);
        if (cfs == null) {
            ColumnFamilyStore newCfs = ColumnFamilyStore.createColumnFamilyStore(this, cfName, loadSSTables);
            ColumnFamilyStore oldCfs = this.columnFamilyStores.putIfAbsent(cfId, newCfs);
            if (oldCfs != null) {
                throw new IllegalStateException("added multiple mappings for cf id " + cfId);
            }
            newCfs.init();
        } else {
            assert (cfs.name.equals(cfName));
            cfs.metadata.reload();
            cfs.reload();
        }
    }

    public void apply(Mutation mutation, boolean writeCommitLog) {
        this.apply(mutation, writeCommitLog, true, false);
    }

    public void apply(Mutation mutation, boolean writeCommitLog, boolean updateIndexes) {
        this.apply(mutation, writeCommitLog, updateIndexes, false);
    }

    public void applyFromCommitLog(Mutation mutation) {
        this.apply(mutation, false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Mutation mutation, boolean writeCommitLog, boolean updateIndexes, boolean isClReplay) {
        boolean requiresViewUpdate;
        if (TEST_FAIL_WRITES && this.metadata.name.equals(TEST_FAIL_WRITES_KS)) {
            throw new RuntimeException("Testing write failures");
        }
        Lock lock = null;
        boolean bl = requiresViewUpdate = updateIndexes && MaterializedViewManager.updatesAffectView(Collections.singleton(mutation), false);
        if (requiresViewUpdate && (lock = MaterializedViewManager.acquireLockFor(mutation.key().getKey())) == null) {
            if (System.currentTimeMillis() - mutation.createdAt > DatabaseDescriptor.getWriteRpcTimeout()) {
                logger.debug("Could not acquire lock for {}", (Object)ByteBufferUtil.bytesToHex(mutation.key().getKey()));
                Tracing.trace("Could not acquire MV lock");
                throw new WriteTimeoutException(WriteType.MATERIALIZED_VIEW, ConsistencyLevel.LOCAL_ONE, 0, 1);
            }
            StageManager.getStage(Stage.MUTATION).execute(() -> {
                if (writeCommitLog) {
                    mutation.apply();
                } else {
                    mutation.applyUnsafe();
                }
            });
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        try (OpOrder.Group opGroup = writeOrder.start();){
            ReplayPosition replayPosition = null;
            if (writeCommitLog) {
                Tracing.trace("Appending to commitlog");
                replayPosition = CommitLog.instance.add(mutation);
            }
            for (PartitionUpdate upd : mutation.getPartitionUpdates()) {
                ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(upd.metadata().cfId);
                if (cfs == null) {
                    logger.error("Attempting to mutate non-existant table {} ({}.{})", new Object[]{upd.metadata().cfId, upd.metadata().ksName, upd.metadata().cfName});
                    continue;
                }
                if (requiresViewUpdate) {
                    try {
                        Tracing.trace("Creating materialized view mutations from base table replica");
                        cfs.materializedViewManager.pushViewReplicaUpdates(upd, !isClReplay);
                    }
                    catch (Throwable t) {
                        JVMStabilityInspector.inspectThrowable(t);
                        logger.error(String.format("Unknown exception caught while attempting to update MaterializedView! %s.%s", upd.metadata().ksName, upd.metadata().cfName), t);
                        throw t;
                    }
                }
                Tracing.trace("Adding to {} memtable", (Object)upd.metadata().cfName);
                UpdateTransaction indexTransaction = updateIndexes ? cfs.indexManager.newUpdateTransaction(upd, opGroup, nowInSec) : UpdateTransaction.NO_OP;
                cfs.apply(upd, indexTransaction, opGroup, replayPosition);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public AbstractReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public static void indexPartition(DecoratedKey key, ColumnFamilyStore cfs, Set<Index> indexes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Indexing partition {} ", (Object)cfs.metadata.getKeyValidator().getString(key.getKey()));
        }
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.fullPartitionRead(cfs.metadata, FBUtilities.nowInSeconds(), key);
        Keyspace cfr_ignored_0 = cfs.keyspace;
        try (OpOrder.Group opGroup = writeOrder.start();
             UnfilteredRowIterator partition = cmd.queryMemtableAndDisk(cfs, opGroup);){
            cfs.indexManager.indexPartition(partition, opGroup, indexes, cmd.nowInSec());
        }
    }

    public List<Future<?>> flush() {
        ArrayList futures = new ArrayList(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfs : this.columnFamilyStores.values()) {
            futures.add((Future<?>)cfs.forceFlush());
        }
        return futures;
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String ... cfNames) throws IOException {
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        if (cfNames.length == 0) {
            for (ColumnFamilyStore cfStore : this.getColumnFamilyStores()) {
                valid.add(cfStore);
                if (!autoAddIndexes) continue;
                valid.addAll(this.getIndexColumnFamilyStores(cfStore));
            }
            return valid;
        }
        for (String cfName : cfNames) {
            if (SecondaryIndexManager.isIndexColumnFamily(cfName)) {
                if (!allowIndexes) {
                    logger.warn("Operation not allowed on secondary Index table ({})", (Object)cfName);
                    continue;
                }
                String baseName = SecondaryIndexManager.getParentCfsName(cfName);
                String indexName = SecondaryIndexManager.getIndexName(cfName);
                ColumnFamilyStore baseCfs = this.getColumnFamilyStore(baseName);
                Index index = baseCfs.indexManager.getIndexByName(indexName);
                if (index == null) {
                    throw new IllegalArgumentException(String.format("Invalid index specified: %s/%s.", baseCfs.metadata.cfName, indexName));
                }
                if (!index.getBackingTable().isPresent()) continue;
                valid.add(index.getBackingTable().get());
                continue;
            }
            ColumnFamilyStore cfStore = this.getColumnFamilyStore(cfName);
            valid.add(cfStore);
            if (!autoAddIndexes) continue;
            valid.addAll(this.getIndexColumnFamilyStores(cfStore));
        }
        return valid;
    }

    private Set<ColumnFamilyStore> getIndexColumnFamilyStores(ColumnFamilyStore baseCfs) {
        HashSet<ColumnFamilyStore> stores = new HashSet<ColumnFamilyStore>();
        for (ColumnFamilyStore indexCfs : baseCfs.indexManager.getAllIndexColumnFamilyStores()) {
            logger.info("adding secondary index table {} to operation", (Object)indexCfs.metadata.cfName);
            stores.add(indexCfs);
        }
        return stores;
    }

    public static Iterable<Keyspace> all() {
        return Iterables.transform(Schema.instance.getKeyspaces(), keyspaceTransformer);
    }

    public static Iterable<Keyspace> nonSystem() {
        return Iterables.transform(Schema.instance.getNonSystemKeyspaces(), keyspaceTransformer);
    }

    public static Iterable<Keyspace> system() {
        return Iterables.transform(Schema.SYSTEM_KEYSPACE_NAMES, keyspaceTransformer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.getName() + "')";
    }

    public String getName() {
        return this.metadata.name;
    }

    static {
        boolean bl = TEST_FAIL_WRITES = !TEST_FAIL_WRITES_KS.isEmpty();
        if (!Config.isClientMode()) {
            DatabaseDescriptor.createAllDirectories();
        }
        writeOrder = new OpOrder();
        keyspaceTransformer = new Function<String, Keyspace>(){

            public Keyspace apply(String keyspaceName) {
                return Keyspace.open(keyspaceName);
            }
        };
        initialized = false;
    }
}

