/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnIndex {
    public final List<IndexHelper.IndexInfo> columnsIndex;
    private static final ColumnIndex EMPTY = new ColumnIndex(Collections.emptyList());

    private ColumnIndex(List<IndexHelper.IndexInfo> columnsIndex) {
        assert (columnsIndex != null);
        this.columnsIndex = columnsIndex;
    }

    public static ColumnIndex writeAndBuildIndex(UnfilteredRowIterator iterator, SequentialWriter output, SerializationHeader header, Version version) throws IOException {
        assert (!iterator.isEmpty() && version.storeRows());
        Builder builder = new Builder(iterator, output, header, version.correspondingMessagingVersion());
        return builder.build();
    }

    @VisibleForTesting
    public static ColumnIndex nothing() {
        return EMPTY;
    }

    private static class Builder {
        private final UnfilteredRowIterator iterator;
        private final SequentialWriter writer;
        private final SerializationHeader header;
        private final int version;
        private final ColumnIndex result;
        private final long initialPosition;
        private long startPosition = -1L;
        private int written;
        private ClusteringPrefix firstClustering;
        private ClusteringPrefix lastClustering;
        private DeletionTime openMarker;

        public Builder(UnfilteredRowIterator iterator, SequentialWriter writer, SerializationHeader header, int version) {
            this.iterator = iterator;
            this.writer = writer;
            this.header = header;
            this.version = version;
            this.result = new ColumnIndex(new ArrayList());
            this.initialPosition = writer.getFilePointer();
        }

        private void writePartitionHeader(UnfilteredRowIterator iterator) throws IOException {
            ByteBufferUtil.writeWithShortLength(iterator.partitionKey().getKey(), this.writer);
            DeletionTime.serializer.serialize(iterator.partitionLevelDeletion(), (DataOutputPlus)this.writer);
            if (this.header.hasStatic()) {
                UnfilteredSerializer.serializer.serialize(iterator.staticRow(), this.header, (DataOutputPlus)this.writer, this.version);
            }
        }

        public ColumnIndex build() throws IOException {
            this.writePartitionHeader(this.iterator);
            while (this.iterator.hasNext()) {
                this.add((Unfiltered)this.iterator.next());
            }
            return this.close();
        }

        private long currentPosition() {
            return this.writer.getFilePointer() - this.initialPosition;
        }

        private void addIndexBlock() {
            IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(this.firstClustering, this.lastClustering, this.startPosition, this.currentPosition() - this.startPosition, this.openMarker);
            this.result.columnsIndex.add(cIndexInfo);
            this.firstClustering = null;
        }

        private void add(Unfiltered unfiltered) throws IOException {
            if (this.firstClustering == null) {
                this.firstClustering = unfiltered.clustering();
                this.startPosition = this.currentPosition();
            }
            UnfilteredSerializer.serializer.serialize(unfiltered, this.header, (DataOutputPlus)this.writer, this.version);
            this.lastClustering = unfiltered.clustering();
            ++this.written;
            if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                RangeTombstoneMarker marker = (RangeTombstoneMarker)unfiltered;
                DeletionTime deletionTime = this.openMarker = marker.isOpen(false) ? marker.openDeletionTime(false) : null;
            }
            if (this.currentPosition() - this.startPosition >= (long)DatabaseDescriptor.getColumnIndexSize()) {
                this.addIndexBlock();
            }
        }

        private ColumnIndex close() throws IOException {
            UnfilteredSerializer.serializer.writeEndOfPartition(this.writer);
            if (this.written == 0) {
                return EMPTY;
            }
            if (this.firstClustering != null) {
                this.addIndexBlock();
            }
            assert (this.result.columnsIndex.size() > 0);
            return this.result;
        }
    }
}

