/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;

public enum Operator {
    EQ(0){

        @Override
        public String toString() {
            return "=";
        }
    }
    ,
    LT(4){

        @Override
        public String toString() {
            return "<";
        }
    }
    ,
    LTE(3){

        @Override
        public String toString() {
            return "<=";
        }
    }
    ,
    GTE(1){

        @Override
        public String toString() {
            return ">=";
        }
    }
    ,
    GT(2){

        @Override
        public String toString() {
            return ">";
        }
    }
    ,
    IN(7){}
    ,
    CONTAINS(5){}
    ,
    CONTAINS_KEY(6){

        @Override
        public String toString() {
            return "CONTAINS KEY";
        }
    }
    ,
    NEQ(8){

        @Override
        public String toString() {
            return "!=";
        }
    };

    private final int b;

    private Operator(int b) {
        this.b = b;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.b);
    }

    public static Operator readFrom(DataInput input) throws IOException {
        int b = input.readInt();
        for (Operator operator : Operator.values()) {
            if (operator.b != b) continue;
            return operator;
        }
        throw new IOException(String.format("Cannot resolve Relation.Type from binary representation: %s", b));
    }

    public boolean isSatisfiedBy(AbstractType<?> type, ByteBuffer leftOperand, ByteBuffer rightOperand) {
        int comparison = type.compareForCQL(leftOperand, rightOperand);
        switch (this) {
            case EQ: {
                return comparison == 0;
            }
            case LT: {
                return comparison < 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case NEQ: {
                return comparison != 0;
            }
        }
        throw new AssertionError();
    }

    public int serializedSize() {
        return 4;
    }

    public String toString() {
        return this.name();
    }
}

