/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePartitionPager
extends AbstractQueryPager {
    private static final Logger logger = LoggerFactory.getLogger(SinglePartitionPager.class);
    private final SinglePartitionReadCommand<?> command;
    private volatile Clustering lastReturned;

    public SinglePartitionPager(SinglePartitionReadCommand<?> command, PagingState state) {
        super(command);
        this.command = command;
        if (state != null) {
            this.lastReturned = state.cellName.hasRemaining() ? LegacyLayout.decodeClustering(command.metadata(), state.cellName) : null;
            this.restoreState(command.partitionKey(), state.remaining, state.remainingInPartition);
        }
    }

    public ByteBuffer key() {
        return this.command.partitionKey().getKey();
    }

    public DataLimits limits() {
        return this.command.limits();
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, LegacyLayout.encodeClustering(this.command.metadata(), this.lastReturned), this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected ReadCommand nextPageReadCommand(int pageSize) {
        return this.command.forPaging(this.lastReturned, pageSize);
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null) {
            this.lastReturned = last.clustering();
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return this.lastReturned != null;
    }
}

