/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintsDescriptor;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HintsReader
implements AutoCloseable,
Iterable<Page> {
    private static final Logger logger = LoggerFactory.getLogger(HintsReader.class);
    private static final int PAGE_SIZE = 524288;
    private final HintsDescriptor descriptor;
    private final File file;
    private final RandomAccessReader reader;
    private final ChecksummedDataInput crcInput;
    @Nullable
    private final RateLimiter rateLimiter;

    private HintsReader(HintsDescriptor descriptor, File file, RandomAccessReader reader, RateLimiter rateLimiter) {
        this.descriptor = descriptor;
        this.file = file;
        this.reader = reader;
        this.crcInput = ChecksummedDataInput.wrap(reader);
        this.rateLimiter = rateLimiter;
    }

    static HintsReader open(File file, RateLimiter rateLimiter) {
        RandomAccessReader reader = RandomAccessReader.open(file);
        try {
            HintsDescriptor descriptor = HintsDescriptor.deserialize(reader);
            return new HintsReader(descriptor, file, reader, rateLimiter);
        }
        catch (IOException e) {
            reader.close();
            throw new FSReadError((Throwable)e, file);
        }
    }

    static HintsReader open(File file) {
        return HintsReader.open(file, null);
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.reader);
    }

    public HintsDescriptor descriptor() {
        return this.descriptor;
    }

    void seek(long newPosition) {
        this.reader.seek(newPosition);
    }

    @Override
    public Iterator<Page> iterator() {
        return new PagesIterator();
    }

    final class BuffersIterator
    extends AbstractIterator<ByteBuffer> {
        private final long offset;

        BuffersIterator(long offset) {
            this.offset = offset;
        }

        @Override
        protected ByteBuffer computeNext() {
            ByteBuffer buffer;
            do {
                long position = HintsReader.this.reader.getFilePointer();
                if (HintsReader.this.reader.length() == position) {
                    return (ByteBuffer)this.endOfData();
                }
                if (position - this.offset >= 524288L) {
                    return (ByteBuffer)this.endOfData();
                }
                try {
                    buffer = this.computeNextInternal();
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, HintsReader.this.file);
                }
            } while (buffer == null);
            return buffer;
        }

        private ByteBuffer computeNextInternal() throws IOException {
            HintsReader.this.crcInput.resetCrc();
            HintsReader.this.crcInput.resetLimit();
            int size = HintsReader.this.crcInput.readInt();
            if (HintsReader.this.reader.readInt() != HintsReader.this.crcInput.getCrc()) {
                throw new IOException("Digest mismatch exception");
            }
            return this.readBuffer(size);
        }

        private ByteBuffer readBuffer(int size) throws IOException {
            if (HintsReader.this.rateLimiter != null) {
                HintsReader.this.rateLimiter.acquire(size);
            }
            HintsReader.this.crcInput.limit(size);
            ByteBuffer buffer = ByteBufferUtil.read(HintsReader.this.crcInput, size);
            if (HintsReader.this.reader.readInt() == HintsReader.this.crcInput.getCrc()) {
                return buffer;
            }
            logger.warn("Failed to read a hint for {} - digest mismatch for hint at position {} in file {}", new Object[]{((HintsReader)HintsReader.this).descriptor.hostId, HintsReader.this.crcInput.getPosition() - (long)size - 4L, HintsReader.this.descriptor.fileName()});
            return null;
        }
    }

    final class HintsIterator
    extends AbstractIterator<Hint> {
        private final long offset;

        HintsIterator(long offset) {
            this.offset = offset;
        }

        @Override
        protected Hint computeNext() {
            Hint hint;
            do {
                long position = HintsReader.this.reader.getFilePointer();
                if (HintsReader.this.reader.length() == position) {
                    return (Hint)this.endOfData();
                }
                if (position - this.offset >= 524288L) {
                    return (Hint)this.endOfData();
                }
                try {
                    hint = this.computeNextInternal();
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, HintsReader.this.file);
                }
            } while (hint == null);
            return hint;
        }

        private Hint computeNextInternal() throws IOException {
            HintsReader.this.crcInput.resetCrc();
            HintsReader.this.crcInput.resetLimit();
            int size = HintsReader.this.crcInput.readInt();
            if (HintsReader.this.reader.readInt() != HintsReader.this.crcInput.getCrc()) {
                throw new IOException("Digest mismatch exception");
            }
            return this.readHint(size);
        }

        private Hint readHint(int size) throws IOException {
            Hint hint;
            if (HintsReader.this.rateLimiter != null) {
                HintsReader.this.rateLimiter.acquire(size);
            }
            HintsReader.this.crcInput.limit(size);
            try {
                hint = Hint.serializer.deserialize(HintsReader.this.crcInput, HintsReader.this.descriptor.messagingVersion());
            }
            catch (UnknownColumnFamilyException e) {
                logger.warn("Failed to read a hint for {} - table with id {} is unknown in file {}", new Object[]{((HintsReader)HintsReader.this).descriptor.hostId, e.cfId, HintsReader.this.descriptor.fileName()});
                HintsReader.this.reader.skipBytes(HintsReader.this.crcInput.bytesRemaining());
                return null;
            }
            if (HintsReader.this.reader.readInt() == HintsReader.this.crcInput.getCrc()) {
                return hint;
            }
            logger.warn("Failed to read a hint for {} - digest mismatch for hint at position {} in file {}", new Object[]{((HintsReader)HintsReader.this).descriptor.hostId, HintsReader.this.crcInput.getPosition() - (long)size - 4L, HintsReader.this.descriptor.fileName()});
            return null;
        }
    }

    final class PagesIterator
    extends AbstractIterator<Page> {
        PagesIterator() {
        }

        @Override
        protected Page computeNext() {
            CLibrary.trySkipCache(HintsReader.this.reader.getChannel().getFileDescriptor(), 0L, HintsReader.this.reader.getFilePointer(), HintsReader.this.reader.getPath());
            if (HintsReader.this.reader.length() == HintsReader.this.reader.getFilePointer()) {
                return (Page)this.endOfData();
            }
            return new Page(HintsReader.this.reader.getFilePointer());
        }
    }

    final class Page {
        public final long offset;

        private Page(long offset) {
            this.offset = offset;
        }

        Iterator<Hint> hintsIterator() {
            return new HintsIterator(this.offset);
        }

        Iterator<ByteBuffer> buffersIterator() {
            return new BuffersIterator(this.offset);
        }
    }
}

