/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class StorageHelper {
    public static final String PIG_INPUT_RPC_PORT = "PIG_INPUT_RPC_PORT";
    public static final String PIG_INPUT_INITIAL_ADDRESS = "PIG_INPUT_INITIAL_ADDRESS";
    public static final String PIG_INPUT_PARTITIONER = "PIG_INPUT_PARTITIONER";
    public static final String PIG_OUTPUT_RPC_PORT = "PIG_OUTPUT_RPC_PORT";
    public static final String PIG_OUTPUT_INITIAL_ADDRESS = "PIG_OUTPUT_INITIAL_ADDRESS";
    public static final String PIG_OUTPUT_PARTITIONER = "PIG_OUTPUT_PARTITIONER";
    public static final String PIG_RPC_PORT = "PIG_RPC_PORT";
    public static final String PIG_INITIAL_ADDRESS = "PIG_INITIAL_ADDRESS";
    public static final String PIG_PARTITIONER = "PIG_PARTITIONER";
    public static final String PIG_INPUT_FORMAT = "PIG_INPUT_FORMAT";
    public static final String PIG_OUTPUT_FORMAT = "PIG_OUTPUT_FORMAT";
    public static final String PIG_INPUT_SPLIT_SIZE = "PIG_INPUT_SPLIT_SIZE";
    public static final String PARTITION_FILTER_SIGNATURE = "cassandra.partition.filter";

    protected static void setConnectionInformation(Configuration conf) {
        if (System.getenv(PIG_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(conf, System.getenv(PIG_RPC_PORT));
            ConfigHelper.setOutputRpcPort(conf, System.getenv(PIG_RPC_PORT));
        }
        if (System.getenv(PIG_INPUT_RPC_PORT) != null) {
            ConfigHelper.setInputRpcPort(conf, System.getenv(PIG_INPUT_RPC_PORT));
        }
        if (System.getenv(PIG_OUTPUT_RPC_PORT) != null) {
            ConfigHelper.setOutputRpcPort(conf, System.getenv(PIG_OUTPUT_RPC_PORT));
        }
        if (System.getenv(PIG_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(conf, System.getenv(PIG_INITIAL_ADDRESS));
            ConfigHelper.setOutputInitialAddress(conf, System.getenv(PIG_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_INPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setInputInitialAddress(conf, System.getenv(PIG_INPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_OUTPUT_INITIAL_ADDRESS) != null) {
            ConfigHelper.setOutputInitialAddress(conf, System.getenv(PIG_OUTPUT_INITIAL_ADDRESS));
        }
        if (System.getenv(PIG_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(conf, System.getenv(PIG_PARTITIONER));
            ConfigHelper.setOutputPartitioner(conf, System.getenv(PIG_PARTITIONER));
        }
        if (System.getenv(PIG_INPUT_PARTITIONER) != null) {
            ConfigHelper.setInputPartitioner(conf, System.getenv(PIG_INPUT_PARTITIONER));
        }
        if (System.getenv(PIG_OUTPUT_PARTITIONER) != null) {
            ConfigHelper.setOutputPartitioner(conf, System.getenv(PIG_OUTPUT_PARTITIONER));
        }
    }

    protected static Object cassandraToObj(AbstractType validator, ByteBuffer value, int nativeProtocolVersion) {
        if (validator instanceof DecimalType || validator instanceof InetAddressType) {
            return validator.getString(value);
        }
        if (validator instanceof CollectionType) {
            return ((CollectionSerializer)validator.getSerializer()).deserializeForNativeProtocol(value, nativeProtocolVersion);
        }
        return validator.compose(value);
    }

    protected static void setTupleValue(Tuple pair, int position, Object value) throws ExecException {
        if (value instanceof BigInteger) {
            pair.set(position, (Object)((BigInteger)value).intValue());
        } else if (value instanceof ByteBuffer) {
            pair.set(position, (Object)new DataByteArray(ByteBufferUtil.getArray((ByteBuffer)value)));
        } else if (value instanceof UUID) {
            pair.set(position, (Object)new DataByteArray(UUIDGen.decompose((UUID)value)));
        } else if (value instanceof Date) {
            pair.set(position, (Object)TimestampType.instance.decompose((Date)value).getLong());
        } else {
            pair.set(position, value);
        }
    }

    protected static byte getPigType(AbstractType type) {
        if (type instanceof LongType || type instanceof DateType || type instanceof TimestampType) {
            return 15;
        }
        if (type instanceof IntegerType || type instanceof Int32Type) {
            return 10;
        }
        if (type instanceof AsciiType || type instanceof UTF8Type || type instanceof DecimalType || type instanceof InetAddressType) {
            return 55;
        }
        if (type instanceof FloatType) {
            return 20;
        }
        if (type instanceof DoubleType) {
            return 25;
        }
        if (type instanceof AbstractCompositeType || type instanceof CollectionType) {
            return 110;
        }
        return 50;
    }
}

