/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;

public abstract class AbstractRangeTombstoneMarker
implements RangeTombstoneMarker {
    protected final RangeTombstone.Bound bound;

    protected AbstractRangeTombstoneMarker(RangeTombstone.Bound bound) {
        this.bound = bound;
    }

    @Override
    public RangeTombstone.Bound clustering() {
        return this.bound;
    }

    @Override
    public Unfiltered.Kind kind() {
        return Unfiltered.Kind.RANGE_TOMBSTONE_MARKER;
    }

    @Override
    public boolean isBoundary() {
        return this.bound.isBoundary();
    }

    @Override
    public boolean isOpen(boolean reversed) {
        return this.bound.isOpen(reversed);
    }

    @Override
    public boolean isClose(boolean reversed) {
        return this.bound.isClose(reversed);
    }

    @Override
    public void validateData(CFMetaData metadata) {
        RangeTombstone.Bound bound = this.clustering();
        for (int i = 0; i < bound.size(); ++i) {
            ByteBuffer value = bound.get(i);
            if (value == null) continue;
            metadata.comparator.subtype(i).validate(value);
        }
    }

    @Override
    public String toString(CFMetaData metadata, boolean fullDetails) {
        return this.toString(metadata);
    }
}

