/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class RowIndexEntry<T>
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    public int promotedSize(CFMetaData metadata, Version version, SerializationHeader header) {
        return 0;
    }

    public static RowIndexEntry<IndexHelper.IndexInfo> create(long position, DeletionTime deletionTime, ColumnIndex index) {
        assert (index != null);
        assert (deletionTime != null);
        if (index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionTime, index.columnsIndex);
        }
        return new RowIndexEntry<IndexHelper.IndexInfo>(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public long headerOffset() {
        return 0L;
    }

    public List<T> columnsIndex() {
        return Collections.emptyList();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    private static class IndexedEntry
    extends RowIndexEntry<IndexHelper.IndexInfo> {
        private final DeletionTime deletionTime;
        private final List<IndexHelper.IndexInfo> columnsIndex;
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, Arrays.asList(null, null))) + ObjectSizes.measure(new ArrayList(1));

        private IndexedEntry(long position, DeletionTime deletionTime, List<IndexHelper.IndexInfo> columnsIndex) {
            super(position);
            assert (deletionTime != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        public int promotedSize(CFMetaData metadata, Version version, SerializationHeader header) {
            long size = DeletionTime.serializer.serializedSize(this.deletionTime);
            size += (long)TypeSizes.sizeof(this.columnsIndex.size());
            IndexHelper.IndexInfo.Serializer idxSerializer = metadata.serializers().indexSerializer(version);
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += idxSerializer.serializedSize(info, header);
            }
            return Ints.checkedCast((long)size);
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexHelper.IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + this.deletionTime.unsharedHeapSize() + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.size());
        }
    }

    public static class Serializer
    implements IndexSerializer<IndexHelper.IndexInfo> {
        private final CFMetaData metadata;
        private final Version version;
        private final SerializationHeader header;

        public Serializer(CFMetaData metadata, Version version, SerializationHeader header) {
            this.metadata = metadata;
            this.version = version;
            this.header = header;
        }

        @Override
        public void serialize(RowIndexEntry<IndexHelper.IndexInfo> rie, DataOutputPlus out) throws IOException {
            out.writeLong(rie.position);
            out.writeInt(rie.promotedSize(this.metadata, this.version, this.header));
            if (rie.isIndexed()) {
                DeletionTime.serializer.serialize(rie.deletionTime(), out);
                out.writeInt(rie.columnsIndex().size());
                IndexHelper.IndexInfo.Serializer idxSerializer = this.metadata.serializers().indexSerializer(this.version);
                for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                    idxSerializer.serialize(info, out, this.header);
                }
            }
        }

        @Override
        public RowIndexEntry<IndexHelper.IndexInfo> deserialize(DataInputPlus in) throws IOException {
            long position = in.readLong();
            int size = in.readInt();
            if (size > 0) {
                DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                int entries = in.readInt();
                IndexHelper.IndexInfo.Serializer idxSerializer = this.metadata.serializers().indexSerializer(this.version);
                ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                for (int i = 0; i < entries; ++i) {
                    columnsIndex.add(idxSerializer.deserialize(in, this.header));
                }
                return new IndexedEntry(position, deletionTime, columnsIndex);
            }
            return new RowIndexEntry<IndexHelper.IndexInfo>(position);
        }

        public static void skip(DataInput in) throws IOException {
            in.readLong();
            Serializer.skipPromotedIndex(in);
        }

        public static void skipPromotedIndex(DataInput in) throws IOException {
            int size = in.readInt();
            if (size <= 0) {
                return;
            }
            FileUtils.skipBytesFully(in, size);
        }

        @Override
        public int serializedSize(RowIndexEntry<IndexHelper.IndexInfo> rie) {
            int size = TypeSizes.sizeof(rie.position) + TypeSizes.sizeof(rie.promotedSize(this.metadata, this.version, this.header));
            if (rie.isIndexed()) {
                List<IndexHelper.IndexInfo> index = rie.columnsIndex();
                size = (int)((long)size + DeletionTime.serializer.serializedSize(rie.deletionTime()));
                size += TypeSizes.sizeof(index.size());
                IndexHelper.IndexInfo.Serializer idxSerializer = this.metadata.serializers().indexSerializer(this.version);
                for (IndexHelper.IndexInfo info : index) {
                    size = (int)((long)size + idxSerializer.serializedSize(info, this.header));
                }
            }
            return size;
        }
    }

    public static interface IndexSerializer<T> {
        public void serialize(RowIndexEntry<T> var1, DataOutputPlus var2) throws IOException;

        public RowIndexEntry<T> deserialize(DataInputPlus var1) throws IOException;

        public int serializedSize(RowIndexEntry<T> var1);
    }
}

