/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.schema.IndexMetadata;

public class IndexTarget {
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final String INDEX_KEYS_OPTION_NAME = "index_keys";
    public static final String INDEX_VALUES_OPTION_NAME = "index_values";
    public static final String INDEX_ENTRIES_OPTION_NAME = "index_keys_and_values";
    public final ColumnIdentifier column;
    public final Type type;

    private IndexTarget(ColumnIdentifier column, Type type) {
        this.column = column;
        this.type = type;
    }

    public static enum Type {
        VALUES,
        KEYS,
        KEYS_AND_VALUES,
        FULL;


        public String toString() {
            switch (this) {
                case KEYS: {
                    return "keys";
                }
                case KEYS_AND_VALUES: {
                    return "entries";
                }
                case FULL: {
                    return "full";
                }
            }
            return "values";
        }

        public String indexOption() {
            switch (this) {
                case KEYS: {
                    return IndexTarget.INDEX_KEYS_OPTION_NAME;
                }
                case KEYS_AND_VALUES: {
                    return IndexTarget.INDEX_ENTRIES_OPTION_NAME;
                }
                case VALUES: {
                    return IndexTarget.INDEX_VALUES_OPTION_NAME;
                }
            }
            throw new AssertionError();
        }

        public static Type fromIndexMetadata(IndexMetadata index, CFMetaData cfm) {
            Map<String, String> options = index.options;
            if (options.containsKey(IndexTarget.INDEX_KEYS_OPTION_NAME)) {
                return KEYS;
            }
            if (options.containsKey(IndexTarget.INDEX_ENTRIES_OPTION_NAME)) {
                return KEYS_AND_VALUES;
            }
            ColumnDefinition cd = index.indexedColumn(cfm);
            if (cd.type.isCollection() && !cd.type.isMultiCell()) {
                return FULL;
            }
            return VALUES;
        }
    }

    public static class Raw {
        private final ColumnIdentifier.Raw column;
        private final Type type;

        private Raw(ColumnIdentifier.Raw column, Type type) {
            this.column = column;
            this.type = type;
        }

        public static Raw valuesOf(ColumnIdentifier.Raw c) {
            return new Raw(c, Type.VALUES);
        }

        public static Raw keysOf(ColumnIdentifier.Raw c) {
            return new Raw(c, Type.KEYS);
        }

        public static Raw keysAndValuesOf(ColumnIdentifier.Raw c) {
            return new Raw(c, Type.KEYS_AND_VALUES);
        }

        public static Raw fullCollection(ColumnIdentifier.Raw c) {
            return new Raw(c, Type.FULL);
        }

        public IndexTarget prepare(CFMetaData cfm) {
            return new IndexTarget(this.column.prepare(cfm), this.type);
        }
    }
}

