/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.utils.FBUtilities;

public class UpdateParameters {
    public final CFMetaData metadata;
    public final PartitionColumns updatedColumns;
    public final QueryOptions options;
    private final int nowInSec;
    private final long timestamp;
    private final int ttl;
    private final DeletionTime deletionTime;
    private final SecondaryIndexManager indexManager;
    private final Map<DecoratedKey, Partition> prefetchedRows;
    private Row.Builder staticBuilder;
    private Row.Builder regularBuilder;
    private Row.Builder builder;

    public UpdateParameters(CFMetaData metadata, PartitionColumns updatedColumns, QueryOptions options, long timestamp, int ttl, Map<DecoratedKey, Partition> prefetchedRows, boolean validateIndexedColumns) throws InvalidRequestException {
        SecondaryIndexManager manager;
        this.metadata = metadata;
        this.updatedColumns = updatedColumns;
        this.options = options;
        this.nowInSec = FBUtilities.nowInSeconds();
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.deletionTime = new DeletionTime(timestamp, this.nowInSec);
        this.prefetchedRows = prefetchedRows;
        this.indexManager = validateIndexedColumns ? ((manager = Keyspace.openAndGetStore((CFMetaData)metadata).indexManager).hasIndexes() ? manager : null) : null;
        if (timestamp == Long.MIN_VALUE) {
            throw new InvalidRequestException(String.format("Out of bound timestamp, must be in [%d, %d]", -9223372036854775807L, Long.MAX_VALUE));
        }
    }

    public void validateIndexedColumns(PartitionUpdate update) {
        if (this.indexManager == null) {
            return;
        }
        this.indexManager.validate(update);
    }

    public void newRow(Clustering clustering) throws InvalidRequestException {
        if (this.metadata.isDense() && !this.metadata.isCompound()) {
            assert (clustering.size() == 1);
            ByteBuffer value = clustering.get(0);
            if (value == null || !value.hasRemaining()) {
                throw new InvalidRequestException("Invalid empty or null value for column " + this.metadata.clusteringColumns().get((int)0).name);
            }
        }
        if (clustering == Clustering.STATIC_CLUSTERING) {
            if (this.staticBuilder == null) {
                this.staticBuilder = BTreeRow.unsortedBuilder(this.updatedColumns.statics, this.nowInSec);
            }
            this.builder = this.staticBuilder;
        } else {
            if (this.regularBuilder == null) {
                this.regularBuilder = BTreeRow.unsortedBuilder(this.updatedColumns.regulars, this.nowInSec);
            }
            this.builder = this.regularBuilder;
        }
        this.builder.newRow(clustering);
    }

    public Clustering currentClustering() {
        return this.builder.clustering();
    }

    public void addPrimaryKeyLivenessInfo() {
        this.builder.addPrimaryKeyLivenessInfo(LivenessInfo.create(this.metadata, this.timestamp, this.ttl, this.nowInSec));
    }

    public void addRowDeletion() {
        this.builder.addRowDeletion(this.deletionTime);
    }

    public void addTombstone(ColumnDefinition column) throws InvalidRequestException {
        this.addTombstone(column, null);
    }

    public void addTombstone(ColumnDefinition column, CellPath path) throws InvalidRequestException {
        this.builder.addCell(BufferCell.tombstone(column, this.timestamp, this.nowInSec, path));
    }

    public void addCell(ColumnDefinition column, ByteBuffer value) throws InvalidRequestException {
        this.addCell(column, null, value);
    }

    public void addCell(ColumnDefinition column, CellPath path, ByteBuffer value) throws InvalidRequestException {
        BufferCell cell = this.ttl == 0 ? BufferCell.live(this.metadata, column, this.timestamp, value, path) : BufferCell.expiring(column, this.timestamp, this.ttl, this.nowInSec, value, path);
        this.builder.addCell(cell);
    }

    public void addCounter(ColumnDefinition column, long increment) throws InvalidRequestException {
        assert (this.ttl == 0);
        this.builder.addCell(BufferCell.live(this.metadata, column, this.timestamp, CounterContext.instance().createLocal(increment)));
    }

    public void setComplexDeletionTime(ColumnDefinition column) {
        this.builder.addComplexDeletion(column, this.deletionTime);
    }

    public void setComplexDeletionTimeForOverwrite(ColumnDefinition column) {
        this.builder.addComplexDeletion(column, new DeletionTime(this.deletionTime.markedForDeleteAt() - 1L, this.deletionTime.localDeletionTime()));
    }

    public Row buildRow() {
        Row built = this.builder.build();
        this.builder = null;
        return built;
    }

    public DeletionTime deletionTime() {
        return this.deletionTime;
    }

    public RangeTombstone makeRangeTombstone(CBuilder cbuilder) {
        return new RangeTombstone(cbuilder.buildSlice(), this.deletionTime);
    }

    public Row getPrefetchedRow(DecoratedKey key, Clustering clustering) {
        if (this.prefetchedRows == null) {
            return null;
        }
        Partition partition = this.prefetchedRows.get(key);
        return partition == null ? null : partition.searchIterator(ColumnFilter.selection(partition.columns()), false).next(clustering);
    }
}

