/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.FileCacheMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheService {
    private static final Logger logger = LoggerFactory.getLogger(FileCacheService.class);
    private static final long MEMORY_USAGE_THRESHOLD = (long)DatabaseDescriptor.getFileCacheSizeInMB() * 1024L * 1024L;
    private static final int AFTER_ACCESS_EXPIRATION = 512;
    public static FileCacheService instance = new FileCacheService();
    private static final AtomicLong cacheKeyIdCounter = new AtomicLong();
    private static final Callable<CacheBucket> cacheForPathCreator = new Callable<CacheBucket>(){

        @Override
        public CacheBucket call() {
            return new CacheBucket();
        }
    };
    private static final AtomicInteger memoryUsage = new AtomicInteger();
    private final Cache<CacheKey, CacheBucket> cache;
    private final FileCacheMetrics metrics = new FileCacheMetrics();

    protected FileCacheService() {
        RemovalListener<CacheKey, CacheBucket> onRemove = new RemovalListener<CacheKey, CacheBucket>(){

            public void onRemoval(RemovalNotification<CacheKey, CacheBucket> notification) {
                CacheBucket bucket = (CacheBucket)notification.getValue();
                if (bucket == null) {
                    return;
                }
                bucket.discarded = true;
                ConcurrentLinkedQueue<RandomAccessReader> q = bucket.queue;
                boolean first = true;
                RandomAccessReader reader = (RandomAccessReader)q.poll();
                while (reader != null) {
                    if (logger.isDebugEnabled() && first) {
                        logger.debug("Evicting cold readers for {}", (Object)reader.getPath());
                        first = false;
                    }
                    memoryUsage.addAndGet(-1 * reader.getTotalBufferSize());
                    reader.deallocate();
                    reader = (RandomAccessReader)q.poll();
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(512L, TimeUnit.MILLISECONDS).concurrencyLevel(DatabaseDescriptor.getConcurrentReaders()).removalListener((RemovalListener)onRemove).initialCapacity(16384).build();
    }

    public RandomAccessReader get(CacheKey key) {
        this.metrics.requests.mark();
        CacheBucket bucket = this.getCacheFor(key);
        RandomAccessReader result = bucket.queue.poll();
        if (result != null) {
            this.metrics.hits.mark();
            memoryUsage.addAndGet(-result.getTotalBufferSize());
        }
        return result;
    }

    private CacheBucket getCacheFor(CacheKey key) {
        try {
            return (CacheBucket)this.cache.get((Object)key, cacheForPathCreator);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void put(CacheKey cacheKey, RandomAccessReader instance) {
        int memoryUsed = memoryUsage.get();
        if (logger.isTraceEnabled()) {
            logger.trace("Estimated memory usage is {} compared to actual usage {}", (Object)memoryUsed, (Object)this.sizeInBytes());
        }
        CacheBucket bucket = (CacheBucket)this.cache.getIfPresent((Object)cacheKey);
        if ((long)memoryUsed >= MEMORY_USAGE_THRESHOLD || bucket == null) {
            instance.deallocate();
        } else {
            RandomAccessReader reader;
            memoryUsage.addAndGet(instance.getTotalBufferSize());
            bucket.queue.add(instance);
            if (bucket.discarded && (reader = bucket.queue.poll()) != null) {
                memoryUsage.addAndGet(-1 * reader.getTotalBufferSize());
                reader.deallocate();
            }
        }
    }

    public void invalidate(CacheKey cacheKey, String path) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invalidating cache for {}", (Object)path);
        }
        this.cache.invalidate((Object)cacheKey);
    }

    public long sizeInBytes() {
        long n = 0L;
        for (CacheBucket bucket : this.cache.asMap().values()) {
            for (RandomAccessReader reader : bucket.queue) {
                n += (long)reader.getTotalBufferSize();
            }
        }
        return n;
    }

    static /* synthetic */ AtomicLong access$000() {
        return cacheKeyIdCounter;
    }

    private static final class CacheBucket {
        final ConcurrentLinkedQueue<RandomAccessReader> queue = new ConcurrentLinkedQueue();
        volatile boolean discarded = false;

        private CacheBucket() {
        }
    }

    public static final class CacheKey {
        final long id = FileCacheService.access$000().incrementAndGet();

        public boolean equals(Object that) {
            return that instanceof CacheKey && ((CacheKey)that).id == this.id;
        }

        public int hashCode() {
            return (int)this.id;
        }
    }
}

