/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.AnticompactionTask;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveRepairService {
    public static CassandraVersion SUPPORTS_GLOBAL_PREPARE_FLAG_VERSION = new CassandraVersion("2.2.1");
    private static final Logger logger = LoggerFactory.getLogger(ActiveRepairService.class);
    public static final ActiveRepairService instance = new ActiveRepairService(FailureDetector.instance, Gossiper.instance);
    public static final long UNREPAIRED_SSTABLE = 0L;
    private final ConcurrentMap<UUID, RepairSession> sessions = new ConcurrentHashMap<UUID, RepairSession>();
    private final ConcurrentMap<UUID, ParentRepairSession> parentRepairSessions = new ConcurrentHashMap<UUID, ParentRepairSession>();
    private final IFailureDetector failureDetector;
    private final Gossiper gossiper;

    public ActiveRepairService(IFailureDetector failureDetector, Gossiper gossiper) {
        this.failureDetector = failureDetector;
        this.gossiper = gossiper;
    }

    public RepairSession submitRepairSession(UUID parentRepairSession, Range<Token> range, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, long repairedAt, ListeningExecutorService executor, String ... cfnames) {
        if (endpoints.isEmpty()) {
            return null;
        }
        if (cfnames.length == 0) {
            return null;
        }
        final RepairSession session = new RepairSession(parentRepairSession, UUIDGen.getTimeUUID(), range, keyspace, parallelismDegree, endpoints, repairedAt, cfnames);
        this.sessions.put(session.getId(), session);
        this.gossiper.register(session);
        this.failureDetector.registerFailureDetectionEventListener(session);
        session.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.failureDetector.unregisterFailureDetectionEventListener(session);
                ActiveRepairService.this.gossiper.unregister(session);
                ActiveRepairService.this.sessions.remove(session.getId());
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        session.start(executor);
        return session;
    }

    public synchronized void terminateSessions() {
        IOException cause = new IOException("Terminate session is called");
        for (RepairSession session : this.sessions.values()) {
            session.forceShutdown(cause);
        }
        this.parentRepairSessions.clear();
    }

    public static Set<InetAddress> getNeighbors(String keyspaceName, Range<Token> toRepair, Collection<String> dataCenters, Collection<String> hosts) {
        StorageService ss = StorageService.instance;
        Map<Range<Token>, List<InetAddress>> replicaSets = ss.getRangeToAddressMap(keyspaceName);
        Range<Token> rangeSuperSet = null;
        for (Range<Token> range : ss.getLocalRanges(keyspaceName)) {
            if (range.contains((Token)((Object)toRepair))) {
                rangeSuperSet = range;
                break;
            }
            if (!range.intersects(toRepair)) continue;
            throw new IllegalArgumentException("Requested range intersects a local range but is not fully contained in one; this would lead to imprecise repair");
        }
        if (rangeSuperSet == null || !replicaSets.containsKey(rangeSuperSet)) {
            return Collections.emptySet();
        }
        HashSet<InetAddress> neighbors = new HashSet<InetAddress>((Collection)replicaSets.get(rangeSuperSet));
        neighbors.remove(FBUtilities.getBroadcastAddress());
        if (dataCenters != null && !dataCenters.isEmpty()) {
            TokenMetadata.Topology topology = ss.getTokenMetadata().cloneOnlyTokenMap().getTopology();
            HashSet dcEndpoints = Sets.newHashSet();
            Multimap<String, InetAddress> dcEndpointsMap = topology.getDatacenterEndpoints();
            for (String dc : dataCenters) {
                Collection c = dcEndpointsMap.get((Object)dc);
                if (c == null) continue;
                dcEndpoints.addAll(c);
            }
            return Sets.intersection(neighbors, (Set)dcEndpoints);
        }
        if (hosts != null && !hosts.isEmpty()) {
            HashSet<InetAddress> specifiedHost = new HashSet<InetAddress>();
            for (String host : hosts) {
                try {
                    InetAddress endpoint = InetAddress.getByName(host.trim());
                    if (!endpoint.equals(FBUtilities.getBroadcastAddress()) && !neighbors.contains(endpoint)) continue;
                    specifiedHost.add(endpoint);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unknown host specified " + host, e);
                }
            }
            if (!specifiedHost.contains(FBUtilities.getBroadcastAddress())) {
                throw new IllegalArgumentException("The current host must be part of the repair");
            }
            if (specifiedHost.size() <= 1) {
                String msg = "Repair requires at least two endpoints that are neighbours before it can continue, the endpoint used for this repair is %s, other available neighbours are %s but these neighbours were not part of the supplied list of hosts to use during the repair (%s).";
                throw new IllegalArgumentException(String.format(msg, specifiedHost, neighbors, hosts));
            }
            specifiedHost.remove(FBUtilities.getBroadcastAddress());
            return specifiedHost;
        }
        return neighbors;
    }

    public synchronized UUID prepareForRepair(UUID parentRepairSession, Set<InetAddress> endpoints, RepairOption options, List<ColumnFamilyStore> columnFamilyStores) {
        this.registerParentRepairSession(parentRepairSession, columnFamilyStores, options.getRanges(), options.isIncremental(), options.isGlobal());
        final CountDownLatch prepareLatch = new CountDownLatch(endpoints.size());
        final AtomicBoolean status = new AtomicBoolean(true);
        final Set<String> failedNodes = Collections.synchronizedSet(new HashSet());
        IAsyncCallbackWithFailure callback = new IAsyncCallbackWithFailure(){

            @Override
            public void response(MessageIn msg) {
                prepareLatch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }

            @Override
            public void onFailure(InetAddress from) {
                status.set(false);
                failedNodes.add(from.getHostAddress());
                prepareLatch.countDown();
            }
        };
        ArrayList<UUID> cfIds = new ArrayList<UUID>(columnFamilyStores.size());
        for (ColumnFamilyStore cfs : columnFamilyStores) {
            cfIds.add(cfs.metadata.cfId);
        }
        for (InetAddress neighbour : endpoints) {
            if (FailureDetector.instance.isAlive(neighbour)) {
                CassandraVersion peerVersion = SystemKeyspace.getReleaseVersion(neighbour);
                boolean isGlobal = options.isGlobal() && peerVersion != null && peerVersion.compareTo(SUPPORTS_GLOBAL_PREPARE_FLAG_VERSION) >= 0;
                logger.debug("Sending prepare message: options.isGlobal = {}, peerVersion = {}", (Object)options.isGlobal(), (Object)peerVersion);
                PrepareMessage message = new PrepareMessage(parentRepairSession, cfIds, options.getRanges(), options.isIncremental(), isGlobal);
                MessageOut<RepairMessage> msg = message.createMessage();
                MessagingService.instance().sendRR(msg, neighbour, callback, TimeUnit.HOURS.toMillis(1L), true);
                continue;
            }
            status.set(false);
            failedNodes.add(neighbour.getHostAddress());
            prepareLatch.countDown();
        }
        try {
            prepareLatch.await(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            this.parentRepairSessions.remove(parentRepairSession);
            throw new RuntimeException("Did not get replies from all endpoints. List of failed endpoint(s): " + failedNodes.toString(), e);
        }
        if (!status.get()) {
            this.parentRepairSessions.remove(parentRepairSession);
            throw new RuntimeException("Did not get positive replies from all endpoints. List of failed endpoint(s): " + failedNodes.toString());
        }
        return parentRepairSession;
    }

    public void registerParentRepairSession(UUID parentRepairSession, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, boolean isIncremental, boolean isGlobal) {
        this.parentRepairSessions.put(parentRepairSession, new ParentRepairSession(columnFamilyStores, ranges, isIncremental, isGlobal, System.currentTimeMillis()));
    }

    public Set<SSTableReader> currentlyRepairing(UUID cfId, UUID parentRepairSession) {
        HashSet<SSTableReader> repairing = new HashSet<SSTableReader>();
        for (Map.Entry entry : this.parentRepairSessions.entrySet()) {
            Collection sstables = (Collection)((ParentRepairSession)entry.getValue()).sstableMap.get(cfId);
            if (sstables == null || ((UUID)entry.getKey()).equals(parentRepairSession)) continue;
            repairing.addAll(sstables);
        }
        return repairing;
    }

    public synchronized ListenableFuture finishParentSession(UUID parentSession, Set<InetAddress> neighbors, Collection<Range<Token>> successfulRanges) {
        ArrayList<AnticompactionTask> tasks = new ArrayList<AnticompactionTask>(neighbors.size() + 1);
        for (InetAddress neighbor : neighbors) {
            AnticompactionTask task = new AnticompactionTask(parentSession, neighbor, successfulRanges);
            tasks.add(task);
            task.run();
        }
        tasks.add((AnticompactionTask)this.doAntiCompaction(parentSession, successfulRanges));
        return Futures.successfulAsList(tasks);
    }

    public ParentRepairSession getParentRepairSession(UUID parentSessionId) {
        return (ParentRepairSession)this.parentRepairSessions.get(parentSessionId);
    }

    public synchronized ParentRepairSession removeParentRepairSession(UUID parentSessionId) {
        return (ParentRepairSession)this.parentRepairSessions.remove(parentSessionId);
    }

    public ListenableFuture<List<Object>> doAntiCompaction(final UUID parentRepairSession, Collection<Range<Token>> successfulRanges) {
        assert (parentRepairSession != null);
        ParentRepairSession prs = this.getParentRepairSession(parentRepairSession);
        if (!prs.isGlobal) {
            logger.info("Not a global repair, will not do anticompaction");
            this.removeParentRepairSession(parentRepairSession);
            return Futures.immediateFuture(Collections.emptyList());
        }
        assert (prs.ranges.containsAll(successfulRanges)) : "Trying to perform anticompaction on unknown ranges";
        ArrayList futures = new ArrayList();
        if (!successfulRanges.isEmpty()) {
            for (Map.Entry columnFamilyStoreEntry : prs.columnFamilyStores.entrySet()) {
                Refs<SSTableReader> sstables = prs.getAndReferenceSSTables((UUID)columnFamilyStoreEntry.getKey());
                ColumnFamilyStore cfs = (ColumnFamilyStore)columnFamilyStoreEntry.getValue();
                futures.add(CompactionManager.instance.submitAntiCompaction(cfs, successfulRanges, sstables, prs.repairedAt));
            }
        }
        ListenableFuture allAntiCompactionResults = Futures.successfulAsList(futures);
        allAntiCompactionResults.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.removeParentRepairSession(parentRepairSession);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        return allAntiCompactionResults;
    }

    public void handleMessage(InetAddress endpoint, RepairMessage message) {
        RepairJobDesc desc = message.desc;
        RepairSession session = (RepairSession)this.sessions.get(desc.sessionId);
        if (session == null) {
            return;
        }
        switch (message.messageType) {
            case VALIDATION_COMPLETE: {
                ValidationComplete validation = (ValidationComplete)message;
                session.validationComplete(desc, endpoint, validation.tree);
                break;
            }
            case SYNC_COMPLETE: {
                SyncComplete sync = (SyncComplete)message;
                session.syncComplete(desc, sync.nodes, sync.success);
                break;
            }
        }
    }

    public static class ParentRepairSession {
        private final Map<UUID, ColumnFamilyStore> columnFamilyStores = new HashMap<UUID, ColumnFamilyStore>();
        private final Collection<Range<Token>> ranges;
        private final Map<UUID, Set<SSTableReader>> sstableMap = new HashMap<UUID, Set<SSTableReader>>();
        private final long repairedAt;
        public final boolean isIncremental;
        private final boolean isGlobal;

        public ParentRepairSession(List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, boolean isIncremental, boolean isGlobal, long repairedAt) {
            for (ColumnFamilyStore cfs : columnFamilyStores) {
                this.columnFamilyStores.put(cfs.metadata.cfId, cfs);
            }
            this.ranges = ranges;
            this.repairedAt = repairedAt;
            this.isGlobal = isGlobal;
            this.isIncremental = isIncremental;
        }

        public void addSSTables(UUID cfId, Set<SSTableReader> sstables) {
            Set<SSTableReader> existingSSTables = this.sstableMap.get(cfId);
            if (existingSSTables == null) {
                existingSSTables = new HashSet<SSTableReader>();
            }
            existingSSTables.addAll(sstables);
            this.sstableMap.put(cfId, existingSSTables);
        }

        public synchronized Refs<SSTableReader> getAndReferenceSSTables(UUID cfId) {
            Set<SSTableReader> sstables = this.sstableMap.get(cfId);
            Iterator<SSTableReader> sstableIterator = sstables.iterator();
            ImmutableMap.Builder references = ImmutableMap.builder();
            while (sstableIterator.hasNext()) {
                SSTableReader sstable = sstableIterator.next();
                if (!new File(sstable.descriptor.filenameFor(Component.DATA)).exists()) {
                    sstableIterator.remove();
                    continue;
                }
                Ref<SSTableReader> ref = sstable.tryRef();
                if (ref == null) {
                    sstableIterator.remove();
                    continue;
                }
                references.put((Object)sstable, ref);
            }
            return new Refs<SSTableReader>((Map<SSTableReader, Ref<SSTableReader>>)references.build());
        }

        public long getRepairedAt() {
            if (this.isGlobal) {
                return this.repairedAt;
            }
            return 0L;
        }

        public String toString() {
            return "ParentRepairSession{columnFamilyStores=" + this.columnFamilyStores + ", ranges=" + this.ranges + ", sstableMap=" + this.sstableMap + ", repairedAt=" + this.repairedAt + '}';
        }
    }
}

