/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.exceptions.UnrecognizedEntityException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.Pageable;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStatement
implements CQLStatement {
    private static final Logger logger = LoggerFactory.getLogger(SelectStatement.class);
    private static final int DEFAULT_COUNT_PAGE_SIZE = 10000;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Parameters parameters;
    private final Selection selection;
    private final Term limit;
    private final StatementRestrictions restrictions;
    private final boolean isReversed;
    private final Comparator<List<ByteBuffer>> orderingComparator;
    private static final Parameters defaultParameters = new Parameters(Collections.emptyMap(), false, false, false);

    public SelectStatement(CFMetaData cfm, int boundTerms, Parameters parameters, Selection selection, StatementRestrictions restrictions, boolean isReversed, Comparator<List<ByteBuffer>> orderingComparator, Term limit) {
        this.cfm = cfm;
        this.boundTerms = boundTerms;
        this.selection = selection;
        this.restrictions = restrictions;
        this.isReversed = isReversed;
        this.orderingComparator = orderingComparator;
        this.parameters = parameters;
        this.limit = limit;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return Iterables.concat(this.selection.getFunctions(), this.restrictions.getFunctions(), this.limit != null ? this.limit.getFunctions() : Collections.emptySet());
    }

    static SelectStatement forSelection(CFMetaData cfm, Selection selection) {
        return new SelectStatement(cfm, 0, defaultParameters, selection, StatementRestrictions.empty(cfm), false, null, null);
    }

    public ResultSet.ResultMetadata getResultMetadata() {
        return this.selection.getResultMetadata(this.parameters.isJson);
    }

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
        for (Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage.Rows execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        RequestValidations.checkNotNull(cl, "Invalid empty consistency level", new Object[0]);
        cl.validateForRead(this.keyspace());
        int limit = this.getLimit(options);
        long now = System.currentTimeMillis();
        Pageable command = this.getPageableCommand(options, limit, now);
        int pageSize = this.getPageSize(options);
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            return this.execute(command, options, limit, now, state);
        }
        QueryPager pager = QueryPagers.pager(command, cl, state.getClientState(), options.getPagingState());
        return this.execute(pager, options, limit, now, pageSize);
    }

    private Pageable getPageableCommand(QueryOptions options, int limit, long now) throws RequestValidationException {
        int limitForQuery = this.updateLimitForQuery(limit);
        if (this.restrictions.isKeyRange() || this.restrictions.usesSecondaryIndexing()) {
            return this.getRangeCommand(options, limitForQuery, now);
        }
        List<ReadCommand> commands = this.getSliceCommands(options, limitForQuery, now);
        return commands == null ? null : new Pageable.ReadCommands(commands, limitForQuery);
    }

    public Pageable getPageableCommand(QueryOptions options) throws RequestValidationException {
        return this.getPageableCommand(options, this.getLimit(options), System.currentTimeMillis());
    }

    private int getPageSize(QueryOptions options) {
        int pageSize = options.getPageSize();
        if (this.selection.isAggregate() && pageSize <= 0) {
            pageSize = 10000;
        }
        return pageSize;
    }

    private ResultMessage.Rows execute(Pageable command, QueryOptions options, int limit, long now, QueryState state) throws RequestValidationException, RequestExecutionException {
        List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? StorageProxy.read(((Pageable.ReadCommands)command).commands, options.getConsistency(), state.getClientState()) : StorageProxy.getRangeSlice((RangeSliceCommand)command, options.getConsistency()));
        return this.processResults(rows, options, limit, now);
    }

    private ResultMessage.Rows execute(QueryPager pager, QueryOptions options, int limit, long now, int pageSize) throws RequestValidationException, RequestExecutionException {
        if (this.selection.isAggregate()) {
            return this.pageAggregateQuery(pager, options, pageSize, now);
        }
        RequestValidations.checkFalse(this.needsPostQueryOrdering(), "Cannot page queries with both ORDER BY and a IN restriction on the partition key; you must either remove the ORDER BY or the IN and sort client side, or disable paging for this query");
        List<Row> page = pager.fetchPage(pageSize);
        ResultMessage.Rows msg = this.processResults(page, options, limit, now);
        if (!pager.isExhausted()) {
            msg.result.metadata.setHasMorePages(pager.state());
        }
        return msg;
    }

    private ResultMessage.Rows pageAggregateQuery(QueryPager pager, QueryOptions options, int pageSize, long now) throws RequestValidationException, RequestExecutionException {
        if (!this.restrictions.hasPartitionKeyRestrictions()) {
            logger.warn("Aggregation query used without partition key");
            ClientWarn.warn("Aggregation query used without partition key");
        } else if (this.restrictions.keyIsInRelation()) {
            logger.warn("Aggregation query used on multiple partition keys (IN restriction)");
            ClientWarn.warn("Aggregation query used on multiple partition keys (IN restriction)");
        }
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now, this.parameters.isJson);
        while (!pager.isExhausted()) {
            for (Row row : pager.fetchPage(pageSize)) {
                if (row.cf == null) continue;
                this.processColumnFamily(row.key.getKey(), row.cf, options, now, result);
            }
        }
        return new ResultMessage.Rows(result.build(options.getProtocolVersion()));
    }

    public ResultMessage.Rows processResults(List<Row> rows, QueryOptions options, int limit, long now) throws RequestValidationException {
        ResultSet rset = this.process(rows, options, limit, now);
        return new ResultMessage.Rows(rset);
    }

    static List<Row> readLocally(String keyspaceName, List<ReadCommand> cmds) {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        ArrayList<Row> rows = new ArrayList<Row>(cmds.size());
        for (ReadCommand cmd : cmds) {
            rows.add(cmd.getRow(keyspace));
        }
        return rows;
    }

    @Override
    public ResultMessage.Rows executeInternal(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        int limit = this.getLimit(options);
        long now = System.currentTimeMillis();
        Pageable command = this.getPageableCommand(options, limit, now);
        int pageSize = this.getPageSize(options);
        if (pageSize <= 0 || command == null || !QueryPagers.mayNeedPaging(command, pageSize)) {
            List<Row> rows = command == null ? Collections.emptyList() : (command instanceof Pageable.ReadCommands ? SelectStatement.readLocally(this.keyspace(), ((Pageable.ReadCommands)command).commands) : ((RangeSliceCommand)command).executeLocally());
            return this.processResults(rows, options, limit, now);
        }
        QueryPager pager = QueryPagers.localPager(command);
        return this.execute(pager, options, limit, now, pageSize);
    }

    public ResultSet process(List<Row> rows) throws InvalidRequestException {
        QueryOptions options = QueryOptions.DEFAULT;
        return this.process(rows, options, this.getLimit(options), System.currentTimeMillis());
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public StatementRestrictions getRestrictions() {
        return this.restrictions;
    }

    private List<ReadCommand> getSliceCommands(QueryOptions options, int limit, long now) throws RequestValidationException {
        Collection<ByteBuffer> keys = this.restrictions.getPartitionKeys(options);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        IDiskAtomFilter filter = this.makeFilter(options, limit);
        if (filter == null) {
            return null;
        }
        for (ByteBuffer key : keys) {
            QueryProcessor.validateKey(key);
            commands.add(ReadCommand.create(this.keyspace(), ByteBufferUtil.clone(key), this.columnFamily(), now, filter.cloneShallow()));
        }
        return commands;
    }

    private RangeSliceCommand getRangeCommand(QueryOptions options, int limit, long now) throws RequestValidationException {
        IDiskAtomFilter filter = this.makeFilter(options, limit);
        if (filter == null) {
            return null;
        }
        List<IndexExpression> expressions = this.getValidatedIndexExpressions(options);
        AbstractBounds<RowPosition> keyBounds = this.restrictions.getPartitionKeyBounds(options);
        return keyBounds == null ? null : new RangeSliceCommand(this.keyspace(), this.columnFamily(), now, filter, keyBounds, expressions, limit, !this.parameters.isDistinct, false);
    }

    private ColumnSlice makeStaticSlice() {
        return this.isReversed ? new ColumnSlice(this.cfm.comparator.staticPrefix().end(), Composites.EMPTY) : new ColumnSlice(Composites.EMPTY, this.cfm.comparator.staticPrefix().end());
    }

    private IDiskAtomFilter makeFilter(QueryOptions options, int limit) throws InvalidRequestException {
        int toGroup;
        int n = toGroup = this.cfm.comparator.isDense() ? -1 : this.cfm.clusteringColumns().size();
        if (this.parameters.isDistinct) {
            toGroup = this.selection.containsStaticColumns() ? toGroup : -2;
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, 1, toGroup);
        }
        if (this.restrictions.isColumnRange()) {
            ColumnSlice[] slices;
            ColumnSlice staticSlice;
            List<Composite> startBounds = this.restrictions.getClusteringColumnsBoundsAsComposites(Bound.START, options);
            List<Composite> endBounds = this.restrictions.getClusteringColumnsBoundsAsComposites(Bound.END, options);
            assert (startBounds.size() == endBounds.size());
            ColumnSlice columnSlice = staticSlice = this.selection.containsStaticColumns() && !this.restrictions.usesSecondaryIndexing() ? this.makeStaticSlice() : null;
            if (startBounds.size() == 1) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(0), endBounds.get(0));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) {
                    return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
                }
                if (staticSlice == null) {
                    return this.sliceFilter(slice, limit, toGroup);
                }
                if (this.isReversed) {
                    return slice.includes(this.cfm.comparator.reverseComparator(), staticSlice.start) ? this.sliceFilter(new ColumnSlice(slice.start, staticSlice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{slice, staticSlice}, limit, toGroup);
                }
                return slice.includes(this.cfm.comparator, staticSlice.finish) ? this.sliceFilter(new ColumnSlice(staticSlice.start, slice.finish), limit, toGroup) : this.sliceFilter(new ColumnSlice[]{staticSlice, slice}, limit, toGroup);
            }
            ArrayList<ColumnSlice> l = new ArrayList<ColumnSlice>(startBounds.size());
            for (int i = 0; i < startBounds.size(); ++i) {
                ColumnSlice slice = new ColumnSlice(startBounds.get(i), endBounds.get(i));
                if (slice.isAlwaysEmpty(this.cfm.comparator, this.isReversed)) continue;
                l.add(slice);
            }
            if (l.isEmpty()) {
                return staticSlice == null ? null : this.sliceFilter(staticSlice, limit, toGroup);
            }
            if (staticSlice == null) {
                return this.sliceFilter(l.toArray(new ColumnSlice[l.size()]), limit, toGroup);
            }
            if (this.isReversed) {
                if (((ColumnSlice)l.get(l.size() - 1)).includes(this.cfm.comparator.reverseComparator(), staticSlice.start)) {
                    slices = l.toArray(new ColumnSlice[l.size()]);
                    slices[slices.length - 1] = new ColumnSlice(slices[slices.length - 1].start, Composites.EMPTY);
                } else {
                    slices = l.toArray(new ColumnSlice[l.size() + 1]);
                    slices[slices.length - 1] = staticSlice;
                }
            } else if (((ColumnSlice)l.get(0)).includes(this.cfm.comparator, staticSlice.finish)) {
                slices = new ColumnSlice[l.size()];
                slices[0] = new ColumnSlice(Composites.EMPTY, ((ColumnSlice)l.get((int)0)).finish);
                for (int i = 1; i < l.size(); ++i) {
                    slices[i] = (ColumnSlice)l.get(i);
                }
            } else {
                slices = new ColumnSlice[l.size() + 1];
                slices[0] = staticSlice;
                for (int i = 0; i < l.size(); ++i) {
                    slices[i + 1] = (ColumnSlice)l.get(i);
                }
            }
            return this.sliceFilter(slices, limit, toGroup);
        }
        SortedSet<CellName> cellNames = this.getRequestedColumns(options);
        if (cellNames == null) {
            return null;
        }
        QueryProcessor.validateCellNames(cellNames, this.cfm.comparator);
        return new NamesQueryFilter(cellNames, true);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice slice, int limit, int toGroup) {
        return this.sliceFilter(new ColumnSlice[]{slice}, limit, toGroup);
    }

    private SliceQueryFilter sliceFilter(ColumnSlice[] slices, int limit, int toGroup) {
        assert (ColumnSlice.validateSlices(slices, this.cfm.comparator, this.isReversed)) : String.format("Invalid slices: " + Arrays.toString(slices) + (this.isReversed ? " (reversed)" : ""), new Object[0]);
        return new SliceQueryFilter(slices, this.isReversed, limit, toGroup);
    }

    public int getLimit(QueryOptions options) throws InvalidRequestException {
        if (this.limit != null) {
            ByteBuffer b = RequestValidations.checkNotNull(this.limit.bindAndGet(options), "Invalid null value of limit", new Object[0]);
            if (b == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Integer.MAX_VALUE;
            }
            try {
                Int32Type.instance.validate(b);
                int l = (Integer)Int32Type.instance.compose(b);
                RequestValidations.checkTrue(l > 0, "LIMIT must be strictly positive");
                return l;
            }
            catch (MarshalException e) {
                throw new InvalidRequestException("Invalid limit value");
            }
        }
        return Integer.MAX_VALUE;
    }

    private int updateLimitForQuery(int limit) {
        if (this.selection.isAggregate()) {
            return Integer.MAX_VALUE;
        }
        return this.restrictions.isNonCompositeSliceWithExclusiveBounds() && limit != Integer.MAX_VALUE ? limit + 1 : limit;
    }

    private SortedSet<CellName> getRequestedColumns(QueryOptions options) throws InvalidRequestException {
        assert (!this.restrictions.isColumnRange());
        TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
        for (Composite composite : this.restrictions.getClusteringColumnsAsComposites(options)) {
            columns.addAll(this.addSelectedColumns(composite));
        }
        return columns;
    }

    private SortedSet<CellName> addSelectedColumns(Composite prefix) {
        if (this.cfm.comparator.isDense()) {
            return FBUtilities.singleton(this.cfm.comparator.create(prefix, null), this.cfm.comparator);
        }
        TreeSet<Composite> columns = new TreeSet<Composite>(this.cfm.comparator);
        if (this.cfm.comparator.isCompound() && !this.cfm.isSuper()) {
            columns.add(this.cfm.comparator.rowMarker(prefix));
            for (ColumnDefinition def : this.selection.getColumns()) {
                if (!def.isRegular() && !def.isStatic()) continue;
                columns.add(this.cfm.comparator.create(prefix, def));
            }
        } else {
            for (ColumnDefinition def : this.cfm.regularColumns()) {
                columns.add(this.cfm.comparator.create(prefix, def));
            }
        }
        return columns;
    }

    public List<IndexExpression> getValidatedIndexExpressions(QueryOptions options) throws InvalidRequestException {
        if (!this.restrictions.usesSecondaryIndexing()) {
            return Collections.emptyList();
        }
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace()).getColumnFamilyStore(this.columnFamily());
        SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
        List<IndexExpression> expressions = this.restrictions.getIndexExpressions(secondaryIndexManager, options);
        secondaryIndexManager.validateIndexSearchersForQuery(expressions);
        return expressions;
    }

    private CellName makeExclusiveSliceBound(Bound bound, CellNameType type, QueryOptions options) throws InvalidRequestException {
        if (this.restrictions.areRequestedBoundsInclusive(bound)) {
            return null;
        }
        return type.makeCellName(this.restrictions.getClusteringColumnsBounds(bound, options).get(0));
    }

    private Iterator<Cell> applySliceRestriction(Iterator<Cell> cells, QueryOptions options) throws InvalidRequestException {
        final CellNameType type = this.cfm.comparator;
        final CellName excludedStart = this.makeExclusiveSliceBound(Bound.START, type, options);
        final CellName excludedEnd = this.makeExclusiveSliceBound(Bound.END, type, options);
        return Iterators.filter(cells, (Predicate)new Predicate<Cell>(){

            public boolean apply(Cell c) {
                return !(excludedStart != null && type.compare(c.name(), excludedStart) == 0 || excludedEnd != null && type.compare(c.name(), excludedEnd) == 0);
            }
        });
    }

    private ResultSet process(List<Row> rows, QueryOptions options, int limit, long now) throws InvalidRequestException {
        Selection.ResultSetBuilder result = this.selection.resultSetBuilder(now, this.parameters.isJson);
        for (Row row : rows) {
            if (row.cf == null) continue;
            this.processColumnFamily(row.key.getKey(), row.cf, options, now, result);
        }
        ResultSet cqlRows = result.build(options.getProtocolVersion());
        this.orderResults(cqlRows);
        if (this.isReversed) {
            cqlRows.reverse();
        }
        cqlRows.trim(limit);
        return cqlRows;
    }

    void processColumnFamily(ByteBuffer key, ColumnFamily cf, QueryOptions options, long now, Selection.ResultSetBuilder result) throws InvalidRequestException {
        CFMetaData cfm = cf.metadata();
        ByteBuffer[] keyComponents = null;
        keyComponents = cfm.getKeyValidator() instanceof CompositeType ? ((CompositeType)cfm.getKeyValidator()).split(key) : new ByteBuffer[]{key};
        Iterator<Cell> cells = cf.getSortedColumns().iterator();
        if (this.restrictions.isNonCompositeSliceWithExclusiveBounds()) {
            cells = this.applySliceRestriction(cells, options);
        }
        int protocolVersion = options.getProtocolVersion();
        CQL3Row.RowIterator iter = cfm.comparator.CQL3RowBuilder(cfm, now).group(cells);
        CQL3Row staticRow = iter.getStaticRow();
        if (staticRow != null && !iter.hasNext() && !this.restrictions.usesSecondaryIndexing() && this.restrictions.hasNoClusteringColumnsRestriction()) {
            result.newRow(protocolVersion);
            block11: for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        continue block11;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, options);
                        continue block11;
                    }
                }
                result.add((ByteBuffer)null);
            }
            return;
        }
        while (iter.hasNext()) {
            CQL3Row cql3Row = (CQL3Row)iter.next();
            result.newRow(protocolVersion);
            for (ColumnDefinition def : this.selection.getColumns()) {
                switch (def.kind) {
                    case PARTITION_KEY: {
                        result.add(keyComponents[def.position()]);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        result.add(cql3Row.getClusteringColumn(def.position()));
                        break;
                    }
                    case COMPACT_VALUE: {
                        result.add(cql3Row.getColumn(null));
                        break;
                    }
                    case REGULAR: {
                        SelectStatement.addValue(result, def, cql3Row, options);
                        break;
                    }
                    case STATIC: {
                        SelectStatement.addValue(result, def, staticRow, options);
                    }
                }
            }
        }
    }

    private static void addValue(Selection.ResultSetBuilder result, ColumnDefinition def, CQL3Row row, QueryOptions options) {
        if (row == null) {
            result.add((ByteBuffer)null);
            return;
        }
        if (def.type.isMultiCell()) {
            List<Cell> cells = row.getMultiCellColumn(def.name);
            ByteBuffer buffer = cells == null ? null : ((CollectionType)def.type).serializeForNativeProtocol(def, cells, options.getProtocolVersion());
            result.add(buffer);
            return;
        }
        result.add(row.getColumn(def.name));
    }

    private boolean needsPostQueryOrdering() {
        return this.restrictions.keyIsInRelation() && !this.parameters.orderings.isEmpty();
    }

    private void orderResults(ResultSet cqlRows) {
        if (cqlRows.size() == 0 || !this.needsPostQueryOrdering()) {
            return;
        }
        Collections.sort(cqlRows.rows, this.orderingComparator);
    }

    private static class CompositeComparator
    implements Comparator<List<ByteBuffer>> {
        private final List<Comparator<ByteBuffer>> orderTypes;
        private final List<Integer> positions;

        private CompositeComparator(List<Comparator<ByteBuffer>> orderTypes, List<Integer> positions) {
            this.orderTypes = orderTypes;
            this.positions = positions;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            for (int i = 0; i < this.positions.size(); ++i) {
                ByteBuffer bValue;
                int columnPos;
                ByteBuffer aValue;
                Comparator<ByteBuffer> type = this.orderTypes.get(i);
                int comparison = type.compare(aValue = a.get(columnPos = this.positions.get(i).intValue()), bValue = b.get(columnPos));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    private static class SingleColumnComparator
    implements Comparator<List<ByteBuffer>> {
        private final int index;
        private final Comparator<ByteBuffer> comparator;

        public SingleColumnComparator(int columnIndex, Comparator<ByteBuffer> orderer) {
            this.index = columnIndex;
            this.comparator = orderer;
        }

        @Override
        public int compare(List<ByteBuffer> a, List<ByteBuffer> b) {
            return this.comparator.compare(a.get(this.index), b.get(this.index));
        }
    }

    public static class Parameters {
        public final Map<ColumnIdentifier.Raw, Boolean> orderings;
        public final boolean isDistinct;
        public final boolean allowFiltering;
        public final boolean isJson;

        public Parameters(Map<ColumnIdentifier.Raw, Boolean> orderings, boolean isDistinct, boolean allowFiltering, boolean isJson) {
            this.orderings = orderings;
            this.isDistinct = isDistinct;
            this.allowFiltering = allowFiltering;
            this.isJson = isJson;
        }
    }

    public static class RawStatement
    extends CFStatement {
        private final Parameters parameters;
        private final List<RawSelector> selectClause;
        private final List<Relation> whereClause;
        private final Term.Raw limit;

        public RawStatement(CFName cfName, Parameters parameters, List<RawSelector> selectClause, List<Relation> whereClause, Term.Raw limit) {
            super(cfName);
            this.parameters = parameters;
            this.selectClause = selectClause;
            this.whereClause = whereClause == null ? Collections.emptyList() : whereClause;
            this.limit = limit;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            VariableSpecifications boundNames = this.getBoundVariables();
            Selection selection = this.selectClause.isEmpty() ? Selection.wildcard(cfm) : Selection.fromSelectors(cfm, this.selectClause);
            StatementRestrictions restrictions = this.prepareRestrictions(cfm, boundNames, selection);
            if (this.parameters.isDistinct) {
                RawStatement.validateDistinctSelection(cfm, selection, restrictions);
            }
            Comparator<List<ByteBuffer>> orderingComparator = null;
            boolean isReversed = false;
            if (!this.parameters.orderings.isEmpty()) {
                RawStatement.verifyOrderingIsAllowed(restrictions);
                orderingComparator = this.getOrderingComparator(cfm, selection, restrictions);
                isReversed = this.isReversed(cfm);
            }
            if (isReversed) {
                restrictions.reverse();
            }
            this.checkNeedsFiltering(restrictions);
            SelectStatement stmt = new SelectStatement(cfm, boundNames.size(), this.parameters, selection, restrictions, isReversed, orderingComparator, this.prepareLimit(boundNames));
            return new ParsedStatement.Prepared((CQLStatement)stmt, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        private StatementRestrictions prepareRestrictions(CFMetaData cfm, VariableSpecifications boundNames, Selection selection) throws InvalidRequestException {
            try {
                return new StatementRestrictions(cfm, this.whereClause, boundNames, selection.containsOnlyStaticColumns(), selection.containsACollection());
            }
            catch (UnrecognizedEntityException e) {
                if (this.containsAlias(e.entity)) {
                    throw RequestValidations.invalidRequest("Aliases aren't allowed in the where clause ('%s')", e.relation);
                }
                throw e;
            }
        }

        private Term prepareLimit(VariableSpecifications boundNames) throws InvalidRequestException {
            if (this.limit == null) {
                return null;
            }
            Term prepLimit = this.limit.prepare(this.keyspace(), this.limitReceiver());
            prepLimit.collectMarkerSpecification(boundNames);
            return prepLimit;
        }

        private static void verifyOrderingIsAllowed(StatementRestrictions restrictions) throws InvalidRequestException {
            RequestValidations.checkFalse(restrictions.usesSecondaryIndexing(), "ORDER BY with 2ndary indexes is not supported.");
            RequestValidations.checkFalse(restrictions.isKeyRange(), "ORDER BY is only supported when the partition key is restricted by an EQ or an IN.");
        }

        private static void validateDistinctSelection(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            List<ColumnDefinition> requestedColumns = selection.getColumns();
            for (ColumnDefinition def : requestedColumns) {
                RequestValidations.checkFalse(!def.isPartitionKey() && !def.isStatic(), "SELECT DISTINCT queries must only request partition key columns and/or static columns (not %s)", def.name);
            }
            if (!restrictions.isKeyRange()) {
                return;
            }
            for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                RequestValidations.checkTrue(requestedColumns.contains(def), "SELECT DISTINCT queries must request all the partition key columns (missing %s)", def.name);
            }
        }

        private void handleUnrecognizedOrderingColumn(ColumnIdentifier column) throws InvalidRequestException {
            RequestValidations.checkFalse(this.containsAlias(column), "Aliases are not allowed in order by clause ('%s')", column);
            RequestValidations.checkFalse(true, "Order by on unknown column %s", column);
        }

        private Comparator<List<ByteBuffer>> getOrderingComparator(CFMetaData cfm, Selection selection, StatementRestrictions restrictions) throws InvalidRequestException {
            if (!restrictions.keyIsInRelation()) {
                return null;
            }
            Map<ColumnIdentifier, Integer> orderingIndexes = this.getOrderingIndex(cfm, selection);
            ArrayList<Integer> idToSort = new ArrayList<Integer>();
            ArrayList<AbstractType> sorters = new ArrayList<AbstractType>();
            for (ColumnIdentifier.Raw raw : this.parameters.orderings.keySet()) {
                ColumnIdentifier identifier = raw.prepare(cfm);
                ColumnDefinition orderingColumn = cfm.getColumnDefinition(identifier);
                idToSort.add(orderingIndexes.get(orderingColumn.name));
                sorters.add(orderingColumn.type);
            }
            return idToSort.size() == 1 ? new SingleColumnComparator((Integer)idToSort.get(0), (Comparator)sorters.get(0)) : new CompositeComparator(sorters, idToSort);
        }

        private Map<ColumnIdentifier, Integer> getOrderingIndex(CFMetaData cfm, Selection selection) throws InvalidRequestException {
            HashMap<ColumnIdentifier, Integer> orderingIndexes = new HashMap<ColumnIdentifier, Integer>();
            for (ColumnIdentifier.Raw raw : this.parameters.orderings.keySet()) {
                int index;
                ColumnIdentifier column = raw.prepare(cfm);
                ColumnDefinition def = cfm.getColumnDefinition(column);
                if (def == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                if ((index = selection.getResultSetIndex(def)) < 0) {
                    index = selection.addColumnForOrdering(def);
                }
                orderingIndexes.put(def.name, index);
            }
            return orderingIndexes;
        }

        private boolean isReversed(CFMetaData cfm) throws InvalidRequestException {
            Boolean[] reversedMap = new Boolean[cfm.clusteringColumns().size()];
            int i = 0;
            for (Map.Entry<ColumnIdentifier.Raw, Boolean> entry : this.parameters.orderings.entrySet()) {
                ColumnIdentifier column = entry.getKey().prepare(cfm);
                boolean reversed = entry.getValue();
                ColumnDefinition def = cfm.getColumnDefinition(column);
                if (def == null) {
                    this.handleUnrecognizedOrderingColumn(column);
                }
                RequestValidations.checkTrue(def.isClusteringColumn(), "Order by is currently only supported on the clustered columns of the PRIMARY KEY, got %s", column);
                RequestValidations.checkTrue(i++ == def.position(), "Order by currently only support the ordering of columns following their declared order in the PRIMARY KEY");
                reversedMap[def.position()] = reversed != def.isReversedType();
            }
            Boolean isReversed = null;
            for (Boolean b : reversedMap) {
                if (b == null) continue;
                if (isReversed == null) {
                    isReversed = b;
                    continue;
                }
                RequestValidations.checkTrue(isReversed.equals(b), "Unsupported order by relation");
            }
            assert (isReversed != null);
            return isReversed;
        }

        private void checkNeedsFiltering(StatementRestrictions restrictions) throws InvalidRequestException {
            if (!this.parameters.allowFiltering && (restrictions.isKeyRange() || restrictions.usesSecondaryIndexing())) {
                RequestValidations.checkFalse(restrictions.needFiltering(), "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING");
            }
            if (restrictions.isNonCompositeSliceWithExclusiveBounds() && restrictions.isKeyRange() && this.limit != null) {
                SingleColumnRelation rel = this.findInclusiveClusteringRelationForCompact(restrictions.cfm);
                throw RequestValidations.invalidRequest("The query requests a restriction of rows with a strict bound (%s) over a range of partitions. This is not supported by the underlying storage engine for COMPACT tables if a LIMIT is provided. Please either make the condition non strict (%s) or remove the user LIMIT", rel, rel.withNonStrictOperator());
            }
        }

        private SingleColumnRelation findInclusiveClusteringRelationForCompact(CFMetaData cfm) {
            for (Relation r : this.whereClause) {
                SingleColumnRelation rel = (SingleColumnRelation)r;
                if (!cfm.getColumnDefinition(rel.getEntity().prepare(cfm)).isClusteringColumn() || rel.operator() != Operator.GT && rel.operator() != Operator.LT) continue;
                return rel;
            }
            throw new AssertionError();
        }

        private boolean containsAlias(final ColumnIdentifier name) {
            return Iterables.any(this.selectClause, (Predicate)new Predicate<RawSelector>(){

                public boolean apply(RawSelector raw) {
                    return name.equals(raw.alias);
                }
            });
        }

        private ColumnSpecification limitReceiver() {
            return new ColumnSpecification(this.keyspace(), this.columnFamily(), new ColumnIdentifier("[limit]", true), Int32Type.instance);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.cfName).add("selectClause", this.selectClause).add("whereClause", this.whereClause).add("isDistinct", this.parameters.isDistinct).toString();
        }
    }
}

