/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import org.apache.cassandra.io.sstable.format.SSTableFormat;

public abstract class Version {
    protected final String version;
    protected final SSTableFormat format;

    protected Version(SSTableFormat format, String version) {
        this.format = format;
        this.version = version;
    }

    public abstract boolean isLatestVersion();

    public abstract boolean hasSamplingLevel();

    public abstract boolean hasNewStatsFile();

    public abstract boolean hasAllAdlerChecksums();

    public abstract boolean hasRepairedAt();

    public abstract boolean tracksLegacyCounterShards();

    public abstract boolean hasNewFileName();

    public String getVersion() {
        return this.version;
    }

    public SSTableFormat getSSTableFormat() {
        return this.format;
    }

    public static boolean validate(String ver) {
        return ver != null && ver.matches("[a-z]+");
    }

    public abstract boolean isCompatible();

    public String toString() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version1 = (Version)o;
        return !(this.version != null ? !this.version.equals(version1.version) : version1.version != null);
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }
}

