/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BufferExpiringCell
extends BufferCell
implements ExpiringCell {
    private final int localExpirationTime;
    private final int timeToLive;

    public BufferExpiringCell(CellName name, ByteBuffer value, long timestamp, int timeToLive) {
        this(name, value, timestamp, timeToLive, (int)(System.currentTimeMillis() / 1000L) + timeToLive);
    }

    public BufferExpiringCell(CellName name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime) {
        super(name, value, timestamp);
        assert (timeToLive > 0) : timeToLive;
        assert (localExpirationTime > 0) : localExpirationTime;
        this.timeToLive = timeToLive;
        this.localExpirationTime = localExpirationTime;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Cell withUpdatedName(CellName newName) {
        return new BufferExpiringCell(newName, this.value(), this.timestamp(), this.timeToLive, this.localExpirationTime);
    }

    @Override
    public Cell withUpdatedTimestamp(long newTimestamp) {
        return new BufferExpiringCell(this.name(), this.value(), newTimestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public int cellDataSize() {
        return super.cellDataSize() + TypeSizes.NATIVE.sizeof(this.localExpirationTime) + TypeSizes.NATIVE.sizeof(this.timeToLive);
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        return super.serializedSize(type, typeSizes) + typeSizes.sizeof(this.localExpirationTime) + typeSizes.sizeof(this.timeToLive);
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        super.updateDigest(digest);
        FBUtilities.updateWithInt(digest, this.timeToLive);
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localExpirationTime;
    }

    @Override
    public ExpiringCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferExpiringCell(this.name.copy(metadata, allocator), allocator.clone(this.value), this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public ExpiringCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s!%d", super.getString(comparator), this.timeToLive);
    }

    @Override
    public boolean isLive() {
        return this.isLive(System.currentTimeMillis());
    }

    @Override
    public boolean isLive(long now) {
        return (int)(now / 1000L) < this.getLocalDeletionTime();
    }

    @Override
    public int serializationFlags() {
        return 2;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        super.validateFields(metadata);
        if (this.timeToLive <= 0) {
            throw new MarshalException("A column TTL should be > 0, but was " + this.timeToLive);
        }
        if (this.localExpirationTime < 0) {
            throw new MarshalException("The local expiration time should not be negative but was " + this.localExpirationTime);
        }
    }

    @Override
    public Cell reconcile(Cell cell) {
        int let2;
        int let1;
        long ts2;
        long ts1 = this.timestamp();
        if (ts1 != (ts2 = cell.timestamp())) {
            return ts1 < ts2 ? cell : this;
        }
        if (cell instanceof DeletedCell) {
            return cell;
        }
        int c = this.value().compareTo(cell.value());
        if (c != 0) {
            return c < 0 ? cell : this;
        }
        if (cell instanceof ExpiringCell && (let1 = this.localExpirationTime) < (let2 = cell.getLocalDeletionTime())) {
            return cell;
        }
        return this;
    }

    @Override
    public boolean equals(Cell cell) {
        if (!super.equals(cell)) {
            return false;
        }
        ExpiringCell that = (ExpiringCell)cell;
        return this.getLocalDeletionTime() == that.getLocalDeletionTime() && this.getTimeToLive() == that.getTimeToLive();
    }

    public static Cell create(CellName name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime, int expireBefore, ColumnSerializer.Flag flag) {
        if (localExpirationTime >= expireBefore || flag == ColumnSerializer.Flag.PRESERVE_SIZE) {
            return new BufferExpiringCell(name, value, timestamp, timeToLive, localExpirationTime);
        }
        return new BufferDeletedCell(name, localExpirationTime - timeToLive, timestamp);
    }
}

