/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.concurrent.InfiniteLoopExecutor;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ref<T>
implements RefCounted<T> {
    static final Logger logger = LoggerFactory.getLogger(Ref.class);
    public static final boolean DEBUG_ENABLED = System.getProperty("cassandra.debugrefcount", "false").equalsIgnoreCase("true");
    final State state;
    final T referent;
    private static final Set<GlobalState> globallyExtant = Collections.newSetFromMap(new ConcurrentHashMap());
    static final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private static final InfiniteLoopExecutor EXEC = new InfiniteLoopExecutor("Reference-Reaper", new InfiniteLoopExecutor.InterruptibleRunnable(){

        @Override
        public void run() throws InterruptedException {
            Ref.reapOneReference();
        }
    }).start();

    public Ref(T referent, RefCounted.Tidy tidy) {
        this.state = new State(new GlobalState(tidy), this, referenceQueue);
        this.referent = referent;
    }

    Ref(T referent, GlobalState state) {
        this.state = new State(state, this, referenceQueue);
        this.referent = referent;
    }

    public void release() {
        this.state.release(false);
    }

    public Throwable ensureReleased(Throwable accumulate) {
        return this.state.ensureReleased(accumulate);
    }

    public void ensureReleased() {
        Throwables.maybeFail(this.state.ensureReleased(null));
    }

    public void close() {
        this.ensureReleased();
    }

    public T get() {
        this.state.assertNotReleased();
        return this.referent;
    }

    @Override
    public Ref<T> tryRef() {
        return this.state.globalState.ref() ? new Ref<T>(this.referent, this.state.globalState) : null;
    }

    @Override
    public Ref<T> ref() {
        Ref<T> ref = this.tryRef();
        if (ref == null) {
            this.state.assertNotReleased();
        }
        return ref;
    }

    public String printDebugInfo() {
        if (DEBUG_ENABLED) {
            this.state.debug.log(this.state.toString());
            return "Memory was freed by " + this.state.debug.deallocateThread;
        }
        return "Memory was freed";
    }

    public int globalCount() {
        return this.state.globalState.count();
    }

    private static void reapOneReference() throws InterruptedException {
        Reference<Object> obj = referenceQueue.remove(100L);
        if (obj instanceof State) {
            ((State)obj).release(true);
        }
    }

    @VisibleForTesting
    public static void shutdownReferenceReaper(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, EXEC);
    }

    static final class GlobalState {
        private final Collection<State> locallyExtant = new ConcurrentLinkedDeque<State>();
        private final AtomicInteger counts = new AtomicInteger();
        private final RefCounted.Tidy tidy;

        GlobalState(RefCounted.Tidy tidy) {
            this.tidy = tidy;
            globallyExtant.add(this);
        }

        void register(State ref) {
            this.locallyExtant.add(ref);
        }

        boolean ref() {
            int cur;
            do {
                if ((cur = this.counts.get()) >= 0) continue;
                return false;
            } while (!this.counts.compareAndSet(cur, cur + 1));
            return true;
        }

        Throwable release(State ref, Throwable accumulate) {
            this.locallyExtant.remove(ref);
            if (-1 == this.counts.decrementAndGet()) {
                globallyExtant.remove(this);
                try {
                    this.tidy.tidy();
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
            }
            return accumulate;
        }

        int count() {
            return 1 + this.counts.get();
        }

        public String toString() {
            return this.tidy.getClass() + "@" + System.identityHashCode(this.tidy) + ":" + this.tidy.name();
        }
    }

    static final class Debug {
        String allocateThread;
        String deallocateThread;
        StackTraceElement[] allocateTrace;
        StackTraceElement[] deallocateTrace;

        Debug() {
            Thread thread = Thread.currentThread();
            this.allocateThread = thread.toString();
            this.allocateTrace = thread.getStackTrace();
        }

        synchronized void deallocate() {
            Thread thread = Thread.currentThread();
            this.deallocateThread = thread.toString();
            this.deallocateTrace = thread.getStackTrace();
        }

        synchronized void log(String id) {
            logger.error("Allocate trace {}:\n{}", (Object)id, (Object)this.print(this.allocateThread, this.allocateTrace));
            if (this.deallocateThread != null) {
                logger.error("Deallocate trace {}:\n{}", (Object)id, (Object)this.print(this.deallocateThread, this.deallocateTrace));
            }
        }

        String print(String thread, StackTraceElement[] trace) {
            StringBuilder sb = new StringBuilder();
            sb.append(thread);
            sb.append("\n");
            for (StackTraceElement element : trace) {
                sb.append("\tat ");
                sb.append(element);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    static final class State
    extends PhantomReference<Ref> {
        final Debug debug = DEBUG_ENABLED ? new Debug() : null;
        final GlobalState globalState;
        private volatile int released;
        private static final AtomicIntegerFieldUpdater<State> releasedUpdater = AtomicIntegerFieldUpdater.newUpdater(State.class, "released");

        public State(GlobalState globalState, Ref reference, ReferenceQueue<? super Ref> q) {
            super(reference, q);
            this.globalState = globalState;
            globalState.register(this);
        }

        void assertNotReleased() {
            if (DEBUG_ENABLED && this.released == 1) {
                this.debug.log(this.toString());
            }
            assert (this.released == 0);
        }

        Throwable ensureReleased(Throwable accumulate) {
            if (releasedUpdater.getAndSet(this, 1) == 0) {
                accumulate = this.globalState.release(this, accumulate);
                if (DEBUG_ENABLED) {
                    this.debug.deallocate();
                }
            }
            return accumulate;
        }

        void release(boolean leak) {
            if (!releasedUpdater.compareAndSet(this, 0, 1)) {
                if (!leak) {
                    String id = this.toString();
                    logger.error("BAD RELEASE: attempted to release a reference ({}) that has already been released", (Object)id);
                    if (DEBUG_ENABLED) {
                        this.debug.log(id);
                    }
                    throw new IllegalStateException("Attempted to release a reference that has already been released");
                }
                return;
            }
            Throwable fail = this.globalState.release(this, null);
            if (leak) {
                String id = this.toString();
                logger.error("LEAK DETECTED: a reference ({}) to {} was not released before the reference was garbage collected", (Object)id, (Object)this.globalState);
                if (DEBUG_ENABLED) {
                    this.debug.log(id);
                }
            } else if (DEBUG_ENABLED) {
                this.debug.deallocate();
            }
            if (fail != null) {
                logger.error("Error when closing {}", (Object)this.globalState, (Object)fail);
            }
        }
    }
}

