/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.command.Cli;
import io.airlift.command.Help;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import io.airlift.command.ParseArgumentsMissingException;
import io.airlift.command.ParseArgumentsUnexpectedException;
import io.airlift.command.ParseCommandMissingException;
import io.airlift.command.ParseCommandUnrecognizedException;
import io.airlift.command.ParseOptionConversionException;
import io.airlift.command.ParseOptionMissingException;
import io.airlift.command.ParseOptionMissingValueException;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.tools.INodeProbeFactory;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeProbeFactory;
import org.apache.cassandra.tools.nodetool.Assassinate;
import org.apache.cassandra.tools.nodetool.BootstrapResume;
import org.apache.cassandra.tools.nodetool.CfHistograms;
import org.apache.cassandra.tools.nodetool.CfStats;
import org.apache.cassandra.tools.nodetool.Cleanup;
import org.apache.cassandra.tools.nodetool.ClearSnapshot;
import org.apache.cassandra.tools.nodetool.Compact;
import org.apache.cassandra.tools.nodetool.CompactionHistory;
import org.apache.cassandra.tools.nodetool.CompactionStats;
import org.apache.cassandra.tools.nodetool.Decommission;
import org.apache.cassandra.tools.nodetool.DescribeCluster;
import org.apache.cassandra.tools.nodetool.DescribeRing;
import org.apache.cassandra.tools.nodetool.DisableAutoCompaction;
import org.apache.cassandra.tools.nodetool.DisableBackup;
import org.apache.cassandra.tools.nodetool.DisableBinary;
import org.apache.cassandra.tools.nodetool.DisableGossip;
import org.apache.cassandra.tools.nodetool.DisableHandoff;
import org.apache.cassandra.tools.nodetool.DisableThrift;
import org.apache.cassandra.tools.nodetool.Drain;
import org.apache.cassandra.tools.nodetool.EnableAutoCompaction;
import org.apache.cassandra.tools.nodetool.EnableBackup;
import org.apache.cassandra.tools.nodetool.EnableBinary;
import org.apache.cassandra.tools.nodetool.EnableGossip;
import org.apache.cassandra.tools.nodetool.EnableHandoff;
import org.apache.cassandra.tools.nodetool.EnableThrift;
import org.apache.cassandra.tools.nodetool.FailureDetectorInfo;
import org.apache.cassandra.tools.nodetool.Flush;
import org.apache.cassandra.tools.nodetool.GcStats;
import org.apache.cassandra.tools.nodetool.GetCompactionThreshold;
import org.apache.cassandra.tools.nodetool.GetCompactionThroughput;
import org.apache.cassandra.tools.nodetool.GetEndpoints;
import org.apache.cassandra.tools.nodetool.GetInterDCStreamThroughput;
import org.apache.cassandra.tools.nodetool.GetLoggingLevels;
import org.apache.cassandra.tools.nodetool.GetSSTables;
import org.apache.cassandra.tools.nodetool.GetStreamThroughput;
import org.apache.cassandra.tools.nodetool.GetTraceProbability;
import org.apache.cassandra.tools.nodetool.GossipInfo;
import org.apache.cassandra.tools.nodetool.Info;
import org.apache.cassandra.tools.nodetool.InvalidateCounterCache;
import org.apache.cassandra.tools.nodetool.InvalidateKeyCache;
import org.apache.cassandra.tools.nodetool.InvalidateRowCache;
import org.apache.cassandra.tools.nodetool.Join;
import org.apache.cassandra.tools.nodetool.ListSnapshots;
import org.apache.cassandra.tools.nodetool.Move;
import org.apache.cassandra.tools.nodetool.NetStats;
import org.apache.cassandra.tools.nodetool.PauseHandoff;
import org.apache.cassandra.tools.nodetool.ProxyHistograms;
import org.apache.cassandra.tools.nodetool.RangeKeySample;
import org.apache.cassandra.tools.nodetool.Rebuild;
import org.apache.cassandra.tools.nodetool.RebuildIndex;
import org.apache.cassandra.tools.nodetool.Refresh;
import org.apache.cassandra.tools.nodetool.RefreshSizeEstimates;
import org.apache.cassandra.tools.nodetool.ReloadTriggers;
import org.apache.cassandra.tools.nodetool.RemoveNode;
import org.apache.cassandra.tools.nodetool.Repair;
import org.apache.cassandra.tools.nodetool.ResetLocalSchema;
import org.apache.cassandra.tools.nodetool.ResumeHandoff;
import org.apache.cassandra.tools.nodetool.Ring;
import org.apache.cassandra.tools.nodetool.Scrub;
import org.apache.cassandra.tools.nodetool.SetCacheCapacity;
import org.apache.cassandra.tools.nodetool.SetCacheKeysToSave;
import org.apache.cassandra.tools.nodetool.SetCompactionThreshold;
import org.apache.cassandra.tools.nodetool.SetCompactionThroughput;
import org.apache.cassandra.tools.nodetool.SetHintedHandoffThrottleInKB;
import org.apache.cassandra.tools.nodetool.SetHostStat;
import org.apache.cassandra.tools.nodetool.SetInterDCStreamThroughput;
import org.apache.cassandra.tools.nodetool.SetLoggingLevel;
import org.apache.cassandra.tools.nodetool.SetStreamThroughput;
import org.apache.cassandra.tools.nodetool.SetTraceProbability;
import org.apache.cassandra.tools.nodetool.Snapshot;
import org.apache.cassandra.tools.nodetool.Status;
import org.apache.cassandra.tools.nodetool.StatusBackup;
import org.apache.cassandra.tools.nodetool.StatusBinary;
import org.apache.cassandra.tools.nodetool.StatusGossip;
import org.apache.cassandra.tools.nodetool.StatusHandoff;
import org.apache.cassandra.tools.nodetool.StatusThrift;
import org.apache.cassandra.tools.nodetool.Stop;
import org.apache.cassandra.tools.nodetool.StopDaemon;
import org.apache.cassandra.tools.nodetool.TableHistograms;
import org.apache.cassandra.tools.nodetool.TableStats;
import org.apache.cassandra.tools.nodetool.TopPartitions;
import org.apache.cassandra.tools.nodetool.TpStats;
import org.apache.cassandra.tools.nodetool.TruncateHints;
import org.apache.cassandra.tools.nodetool.UpgradeSSTable;
import org.apache.cassandra.tools.nodetool.Verify;
import org.apache.cassandra.tools.nodetool.Version;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NodeTool {
    private static final String HISTORYFILE = "nodetool.history";
    private final INodeProbeFactory nodeProbeFactory;

    public static void main(String ... args) {
        System.exit(new NodeTool(new NodeProbeFactory()).execute(args));
    }

    public NodeTool(INodeProbeFactory nodeProbeFactory) {
        this.nodeProbeFactory = nodeProbeFactory;
    }

    public int execute(String ... args) {
        ArrayList commands = Lists.newArrayList((Object[])new Class[]{CassHelp.class, Info.class, Ring.class, NetStats.class, CfStats.class, TableStats.class, CfHistograms.class, TableHistograms.class, Cleanup.class, ClearSnapshot.class, Compact.class, Scrub.class, Verify.class, Flush.class, UpgradeSSTable.class, DisableAutoCompaction.class, EnableAutoCompaction.class, CompactionStats.class, CompactionHistory.class, Decommission.class, DescribeCluster.class, DisableBinary.class, EnableBinary.class, EnableGossip.class, DisableGossip.class, EnableHandoff.class, EnableThrift.class, GcStats.class, GetCompactionThreshold.class, GetCompactionThroughput.class, GetStreamThroughput.class, GetTraceProbability.class, GetInterDCStreamThroughput.class, GetEndpoints.class, GetSSTables.class, GossipInfo.class, InvalidateKeyCache.class, InvalidateRowCache.class, InvalidateCounterCache.class, Join.class, Move.class, PauseHandoff.class, ResumeHandoff.class, ProxyHistograms.class, Rebuild.class, Refresh.class, RemoveNode.class, Assassinate.class, Repair.class, SetCacheCapacity.class, SetHintedHandoffThrottleInKB.class, SetCompactionThreshold.class, SetCompactionThroughput.class, SetStreamThroughput.class, SetInterDCStreamThroughput.class, SetTraceProbability.class, Snapshot.class, ListSnapshots.class, Status.class, StatusBinary.class, StatusGossip.class, StatusThrift.class, StatusBackup.class, StatusHandoff.class, Stop.class, StopDaemon.class, Version.class, DescribeRing.class, RebuildIndex.class, RangeKeySample.class, EnableBackup.class, DisableBackup.class, ResetLocalSchema.class, ReloadTriggers.class, SetCacheKeysToSave.class, DisableThrift.class, DisableHandoff.class, Drain.class, TruncateHints.class, TpStats.class, TopPartitions.class, SetLoggingLevel.class, GetLoggingLevels.class, FailureDetectorInfo.class, RefreshSizeEstimates.class});
        Cli.CliBuilder builder = Cli.builder((String)"nodetool");
        builder.withDescription("Manage your Cassandra cluster").withDefaultCommand(CassHelp.class).withCommands((Iterable)commands);
        builder.withGroup("bootstrap").withDescription("Monitor/manage node's bootstrap process").withDefaultCommand(CassHelp.class).withCommand(BootstrapResume.class);
        Cli parser = builder.build();
        int status = 0;
        try {
            Consumer parse = (Consumer)parser.parse(args);
            NodeTool.printHistory(args);
            parse.accept(this.nodeProbeFactory);
        }
        catch (ParseArgumentsMissingException | ParseArgumentsUnexpectedException | ParseCommandMissingException | ParseCommandUnrecognizedException | ParseOptionConversionException | ParseOptionMissingException | ParseOptionMissingValueException | IllegalArgumentException | IllegalStateException e) {
            this.badUse((Exception)e);
            status = 1;
        }
        catch (Throwable throwable) {
            this.err(Throwables.getRootCause((Throwable)throwable));
            status = 2;
        }
        return status;
    }

    private static void printHistory(String ... args) {
        if (args.length == 0) {
            return;
        }
        String cmdLine = Joiner.on((String)" ").skipNulls().join((Object[])args);
        cmdLine = cmdLine.replaceFirst("(?<=(-pw|--password))\\s+\\S+", " <hidden>");
        try (FileWriter writer = new FileWriter(new File(FBUtilities.getToolsOutputDirectory(), HISTORYFILE), true);){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            writer.append(sdf.format(new Date())).append(": ").append(cmdLine).append(System.lineSeparator());
        }
        catch (IOError | IOException throwable) {
            // empty catch block
        }
    }

    protected void badUse(Exception e) {
        System.out.println("nodetool: " + e.getMessage());
        System.out.println("See 'nodetool help' or 'nodetool help <command>'.");
    }

    protected void err(Throwable e) {
        System.err.println("error: " + e.getMessage());
        System.err.println("-- StackTrace --");
        System.err.println(Throwables.getStackTraceAsString((Throwable)e));
    }

    public static SortedMap<String, SetHostStat> getOwnershipByDc(NodeProbe probe, boolean resolveIp, Map<String, String> tokenToEndpoint, Map<InetAddress, Float> ownerships) {
        TreeMap ownershipByDc = Maps.newTreeMap();
        EndpointSnitchInfoMBean epSnitchInfo = probe.getEndpointSnitchInfoProxy();
        try {
            for (Map.Entry<String, String> tokenAndEndPoint : tokenToEndpoint.entrySet()) {
                String dc = epSnitchInfo.getDatacenter(tokenAndEndPoint.getValue());
                if (!ownershipByDc.containsKey(dc)) {
                    ownershipByDc.put(dc, new SetHostStat(resolveIp));
                }
                ((SetHostStat)ownershipByDc.get(dc)).add(tokenAndEndPoint.getKey(), tokenAndEndPoint.getValue(), ownerships);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return ownershipByDc;
    }

    public static abstract class NodeToolCmd
    implements Consumer<INodeProbeFactory> {
        @Option(type=OptionType.GLOBAL, name={"-h", "--host"}, description="Node hostname or ip address")
        private String host = "127.0.0.1";
        @Option(type=OptionType.GLOBAL, name={"-p", "--port"}, description="Remote jmx agent port number")
        private String port = "7199";
        @Option(type=OptionType.GLOBAL, name={"-u", "--username"}, description="Remote jmx agent username")
        private String username = "";
        @Option(type=OptionType.GLOBAL, name={"-pw", "--password"}, description="Remote jmx agent password")
        private String password = "";
        @Option(type=OptionType.GLOBAL, name={"-pwf", "--password-file"}, description="Path to the JMX password file")
        private String passwordFilePath = "";
        private INodeProbeFactory nodeProbeFactory;

        @Override
        public void accept(INodeProbeFactory nodeProbeFactory) {
            this.nodeProbeFactory = nodeProbeFactory;
            this.run();
        }

        public void run() {
            if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                if (StringUtils.isNotEmpty((CharSequence)this.passwordFilePath)) {
                    this.password = this.readUserPasswordFromFile(this.username, this.passwordFilePath);
                }
                if (StringUtils.isEmpty((CharSequence)this.password)) {
                    this.password = this.promptAndReadPassword();
                }
            }
            try (NodeProbe probe = this.connect();){
                this.execute(probe);
                if (probe.isFailed()) {
                    throw new RuntimeException("nodetool failed, check server logs");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while closing JMX connection", e);
            }
        }

        private String readUserPasswordFromFile(String username, String passwordFilePath) {
            String password = "";
            File passwordFile = new File(passwordFilePath);
            try (Scanner scanner = new Scanner(passwordFile).useDelimiter("\\s+");){
                while (scanner.hasNextLine()) {
                    String jmxRole;
                    if (scanner.hasNext() && (jmxRole = scanner.next()).equals(username) && scanner.hasNext()) {
                        password = scanner.next();
                        break;
                    }
                    scanner.nextLine();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            return password;
        }

        private String promptAndReadPassword() {
            String password = "";
            Console console = System.console();
            if (console != null) {
                password = String.valueOf(console.readPassword("Password:", new Object[0]));
            }
            return password;
        }

        protected abstract void execute(NodeProbe var1);

        private NodeProbe connect() {
            NodeProbe nodeClient = null;
            try {
                nodeClient = this.username.isEmpty() ? this.nodeProbeFactory.create(this.host, Integer.parseInt(this.port)) : this.nodeProbeFactory.create(this.host, Integer.parseInt(this.port), this.username, this.password);
            }
            catch (IOException e) {
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                System.err.println(String.format("nodetool: Failed to connect to '%s:%s' - %s: '%s'.", this.host, this.port, rootCause.getClass().getSimpleName(), rootCause.getMessage()));
                System.exit(1);
            }
            return nodeClient;
        }

        protected List<String> parseOptionalKeyspace(List<String> cmdArgs, NodeProbe nodeProbe) {
            return this.parseOptionalKeyspace(cmdArgs, nodeProbe, false);
        }

        protected List<String> parseOptionalKeyspace(List<String> cmdArgs, NodeProbe nodeProbe, boolean includeSystemKS) {
            ArrayList<String> keyspaces = new ArrayList<String>();
            if (cmdArgs == null || cmdArgs.isEmpty()) {
                keyspaces.addAll(includeSystemKS ? nodeProbe.getKeyspaces() : nodeProbe.getNonSystemKeyspaces());
            } else {
                keyspaces.add(cmdArgs.get(0));
            }
            for (String keyspace : keyspaces) {
                if (nodeProbe.getKeyspaces().contains(keyspace)) continue;
                throw new IllegalArgumentException("Keyspace [" + keyspace + "] does not exist.");
            }
            return Collections.unmodifiableList(keyspaces);
        }

        protected String[] parseOptionalColumnFamilies(List<String> cmdArgs) {
            return cmdArgs.size() <= 1 ? ArrayUtils.EMPTY_STRING_ARRAY : (String[])Iterables.toArray(cmdArgs.subList(1, cmdArgs.size()), String.class);
        }
    }

    public static class CassHelp
    extends Help
    implements Consumer<INodeProbeFactory> {
        @Override
        public void accept(INodeProbeFactory nodeProbeFactory) {
            this.run();
        }
    }
}

