/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.WriteResponseHandler;

public class DatacenterWriteResponseHandler<T>
extends WriteResponseHandler<T> {
    public DatacenterWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Keyspace keyspace, Runnable callback, WriteType writeType) {
        super(naturalEndpoints, pendingEndpoints, consistencyLevel, keyspace, callback, writeType);
        assert (consistencyLevel.isDatacenterLocal());
    }

    @Override
    public void response(MessageIn<T> message) {
        if (message == null || this.waitingFor(message.from)) {
            super.response(message);
        }
    }

    @Override
    protected int totalBlockFor() {
        return this.consistencyLevel.blockFor(this.keyspace) + this.consistencyLevel.countLocalEndpoints(this.pendingEndpoints);
    }

    @Override
    protected boolean waitingFor(InetAddress from) {
        return this.consistencyLevel.isLocal(from);
    }
}

