/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.io.sstable.format.Version;

public class AtomDeserializer {
    private final CellNameType type;
    private final CellNameType.Deserializer nameDeserializer;
    private final DataInput in;
    private final ColumnSerializer.Flag flag;
    private final int expireBefore;
    private final Version version;
    private int nextFlags = Integer.MIN_VALUE;

    public AtomDeserializer(CellNameType type, DataInput in, ColumnSerializer.Flag flag, int expireBefore, Version version) {
        this.type = type;
        this.nameDeserializer = type.newDeserializer(in);
        this.in = in;
        this.flag = flag;
        this.expireBefore = expireBefore;
        this.version = version;
    }

    public boolean hasNext() throws IOException {
        return this.nameDeserializer.hasNext();
    }

    public boolean hasUnprocessed() throws IOException {
        return this.nameDeserializer.hasUnprocessed();
    }

    public int compareNextTo(Composite composite) throws IOException {
        return this.nameDeserializer.compareNextTo(composite);
    }

    public boolean nextIsRangeTombstone() throws IOException {
        this.nextFlags = this.in.readUnsignedByte();
        return (this.nextFlags & 0x10) != 0;
    }

    public OnDiskAtom readNext() throws IOException {
        Composite name = this.nameDeserializer.readNext();
        assert (!name.isEmpty());
        this.nextFlags = this.nextFlags == Integer.MIN_VALUE ? this.in.readUnsignedByte() : this.nextFlags;
        RangeTombstone atom = (this.nextFlags & 0x10) != 0 ? this.type.rangeTombstoneSerializer().deserializeBody(this.in, name, this.version) : this.type.columnSerializer().deserializeColumnBody(this.in, (CellName)name, this.nextFlags, this.flag, this.expireBefore);
        this.nextFlags = Integer.MIN_VALUE;
        return atom;
    }

    public void skipNext() throws IOException {
        this.nameDeserializer.skipNext();
        int n = this.nextFlags = this.nextFlags == Integer.MIN_VALUE ? this.in.readUnsignedByte() : this.nextFlags;
        if ((this.nextFlags & 0x10) != 0) {
            this.type.rangeTombstoneSerializer().skipBody(this.in, this.version);
        } else {
            this.type.columnSerializer().skipColumnBody(this.in, this.nextFlags);
        }
        this.nextFlags = Integer.MIN_VALUE;
    }
}

