/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.concurrent.WrappedSharedCloseable;
import org.apache.cassandra.utils.obs.IBitSet;

public class BloomFilter
extends WrappedSharedCloseable
implements IFilter {
    private static final ThreadLocal<long[]> reusableIndexes = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[21];
        }
    };
    public final IBitSet bitset;
    public final int hashCount;
    public static final BloomFilterSerializer serializer = new BloomFilterSerializer();

    BloomFilter(int hashCount, IBitSet bitset) {
        super(bitset);
        this.hashCount = hashCount;
        this.bitset = bitset;
    }

    BloomFilter(BloomFilter copy) {
        super(copy);
        this.hashCount = copy.hashCount;
        this.bitset = copy.bitset;
    }

    @Override
    public long serializedSize() {
        return serializer.serializedSize(this, TypeSizes.NATIVE);
    }

    @VisibleForTesting
    public long[] getHashBuckets(IFilter.FilterKey key, int hashCount, long max) {
        long[] hash = new long[2];
        key.filterHash(hash);
        long[] indexes = new long[hashCount];
        this.setIndexes(hash[0], hash[1], hashCount, max, indexes);
        return indexes;
    }

    private long[] indexes(IFilter.FilterKey key) {
        long[] indexes = reusableIndexes.get();
        key.filterHash(indexes);
        this.setIndexes(indexes[0], indexes[1], this.hashCount, this.bitset.capacity(), indexes);
        return indexes;
    }

    private void setIndexes(long base, long inc, int count, long max, long[] results) {
        for (int i = 0; i < count; ++i) {
            results[i] = FBUtilities.abs(base % max);
            base += inc;
        }
    }

    @Override
    public void add(IFilter.FilterKey key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            this.bitset.set(indexes[i]);
        }
    }

    @Override
    public final boolean isPresent(IFilter.FilterKey key) {
        long[] indexes = this.indexes(key);
        for (int i = 0; i < this.hashCount; ++i) {
            if (this.bitset.get(indexes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public IFilter sharedCopy() {
        return new BloomFilter(this);
    }

    @Override
    public long offHeapSize() {
        return this.bitset.offHeapSize();
    }
}

