/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCloudSnitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(GoogleCloudSnitch.class);
    protected static final String ZONE_NAME_QUERY_URL = "http://metadata.google.internal/computeMetadata/v1/instance/zone";
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    private Map<InetAddress, Map<String, String>> savedEndpoints;
    protected String gceZone;
    protected String gceRegion;

    public GoogleCloudSnitch() throws IOException, ConfigurationException {
        String response = this.gceApiCall(ZONE_NAME_QUERY_URL);
        String[] splits = response.split("/");
        String az = splits[splits.length - 1];
        splits = az.split("-");
        this.gceZone = splits[splits.length - 1];
        int lastRegionIndex = az.lastIndexOf("-");
        this.gceRegion = az.substring(0, lastRegionIndex);
        String datacenterSuffix = new SnitchProperties().get("dc_suffix", "");
        this.gceRegion = this.gceRegion.concat(datacenterSuffix);
        logger.info("GCESnitch using region: {}, zone: {}.", (Object)this.gceRegion, (Object)this.gceZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String gceApiCall(String url) throws IOException, ConfigurationException {
        String string;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        DataInputStream d = null;
        try {
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Metadata-Flavor", "Google");
            if (conn.getResponseCode() != 200) {
                throw new ConfigurationException("GoogleCloudSnitch was unable to execute the API call. Not a gce node?");
            }
            int cl = conn.getContentLength();
            byte[] b = new byte[cl];
            d = new DataInputStream((FilterInputStream)conn.getContent());
            d.readFully(b);
            string = new String(b, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            FileUtils.close(d);
            conn.disconnect();
            throw throwable;
        }
        FileUtils.close(d);
        conn.disconnect();
        return string;
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.gceZone;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return this.gceRegion;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }
}

