/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.codahale.metrics.Counter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Blocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableDeletingTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableDeletingTask.class);
    private static final Set<SSTableDeletingTask> failedTasks = new CopyOnWriteArraySet<SSTableDeletingTask>();
    private static final Blocker blocker = new Blocker();
    private final Descriptor desc;
    private final Set<Component> components;
    private final long bytesOnDisk;
    private final Counter totalDiskSpaceUsed;

    public SSTableDeletingTask(Descriptor realDescriptor, Set<Component> components, Counter totalDiskSpaceUsed, long bytesOnDisk) {
        this.desc = realDescriptor;
        this.bytesOnDisk = bytesOnDisk;
        this.totalDiskSpaceUsed = totalDiskSpaceUsed;
        switch (this.desc.type) {
            case FINAL: {
                this.components = components;
                break;
            }
            case TEMPLINK: {
                this.components = Sets.newHashSet((Object[])new Component[]{Component.DATA, Component.PRIMARY_INDEX});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void schedule() {
        ScheduledExecutors.nonPeriodicTasks.submit(this);
    }

    @Override
    public void run() {
        blocker.ask();
        File datafile = new File(this.desc.filenameFor(Component.DATA));
        if (!datafile.delete()) {
            logger.error("Unable to delete {} (it will be removed on server restart; we'll also retry after GC)", (Object)datafile);
            failedTasks.add(this);
            return;
        }
        SSTable.delete(this.desc, (Set<Component>)Sets.difference(this.components, Collections.singleton(Component.DATA)));
        if (this.totalDiskSpaceUsed != null) {
            this.totalDiskSpaceUsed.dec(this.bytesOnDisk);
        }
    }

    public static void rescheduleFailedTasks() {
        for (SSTableDeletingTask task : failedTasks) {
            failedTasks.remove(task);
            task.schedule();
        }
    }

    @VisibleForTesting
    public static void waitForDeletions() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(runnable, 0L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    public static void pauseDeletions(boolean stop) {
        blocker.block(stop);
    }
}

