/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.serializers.SetSerializer;
import org.apache.cassandra.serializers.UTF8Serializer;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraAuthorizer
implements IAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(CassandraAuthorizer.class);
    private static final String ROLE = "role";
    private static final String RESOURCE = "resource";
    private static final String PERMISSIONS = "permissions";
    public static final String USERNAME = "username";
    public static final String USER_PERMISSIONS = "permissions";
    private SelectStatement authorizeRoleStatement;
    private SelectStatement legacyAuthorizeRoleStatement;

    @Override
    public Set<Permission> authorize(AuthenticatedUser user, IResource resource) {
        if (user.isSuper()) {
            return resource.applicablePermissions();
        }
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        try {
            for (RoleResource role : user.getRoles()) {
                this.addPermissionsForRole(permissions, resource, role);
            }
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
        catch (RequestExecutionException e) {
            logger.warn("CassandraAuthorizer failed to authorize {} for {}", (Object)user, (Object)resource);
            throw new RuntimeException(e);
        }
        return permissions;
    }

    @Override
    public void grant(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        this.modifyRolePermissions(permissions, resource, grantee, "+");
        this.addLookupEntry(resource, grantee);
    }

    @Override
    public void revoke(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource revokee) throws RequestValidationException, RequestExecutionException {
        this.modifyRolePermissions(permissions, resource, revokee, "-");
        this.removeLookupEntry(resource, revokee);
    }

    @Override
    public void revokeAllFrom(RoleResource revokee) {
        try {
            UntypedResultSet rows = this.process(String.format("SELECT resource FROM %s.%s WHERE role = '%s'", "system_auth", "role_permissions", this.escape(revokee.getRoleName())));
            ArrayList<CQLStatement> statements = new ArrayList<CQLStatement>();
            for (UntypedResultSet.Row row : rows) {
                statements.add(QueryProcessor.getStatement((String)String.format((String)"DELETE FROM %s.%s WHERE resource = '%s' AND role = '%s'", (Object[])new Object[]{"system_auth", "resource_role_permissons_index", this.escape((String)row.getString((String)RESOURCE)), this.escape((String)revokee.getRoleName())}), (ClientState)ClientState.forInternalCalls()).statement);
            }
            statements.add(QueryProcessor.getStatement((String)String.format((String)"DELETE FROM %s.%s WHERE role = '%s'", (Object[])new Object[]{"system_auth", "role_permissions", this.escape((String)revokee.getRoleName())}), (ClientState)ClientState.forInternalCalls()).statement);
            this.executeLoggedBatch(statements);
        }
        catch (RequestExecutionException | RequestValidationException e) {
            logger.warn("CassandraAuthorizer failed to revoke all permissions of {}: {}", (Object)revokee.getRoleName(), (Object)e);
        }
    }

    @Override
    public void revokeAllOn(IResource droppedResource) {
        try {
            UntypedResultSet rows = this.process(String.format("SELECT role FROM %s.%s WHERE resource = '%s'", "system_auth", "resource_role_permissons_index", this.escape(droppedResource.getName())));
            ArrayList<CQLStatement> statements = new ArrayList<CQLStatement>();
            for (UntypedResultSet.Row row : rows) {
                statements.add(QueryProcessor.getStatement((String)String.format((String)"DELETE FROM %s.%s WHERE role = '%s' AND resource = '%s'", (Object[])new Object[]{"system_auth", "role_permissions", this.escape((String)row.getString((String)ROLE)), this.escape((String)droppedResource.getName())}), (ClientState)ClientState.forInternalCalls()).statement);
            }
            statements.add(QueryProcessor.getStatement((String)String.format((String)"DELETE FROM %s.%s WHERE resource = '%s'", (Object[])new Object[]{"system_auth", "resource_role_permissons_index", this.escape((String)droppedResource.getName())}), (ClientState)ClientState.forInternalCalls()).statement);
            this.executeLoggedBatch(statements);
        }
        catch (RequestExecutionException | RequestValidationException e) {
            logger.warn("CassandraAuthorizer failed to revoke all permissions on {}: {}", (Object)droppedResource, (Object)e);
            return;
        }
    }

    private void executeLoggedBatch(List<CQLStatement> statements) throws RequestExecutionException, RequestValidationException {
        BatchStatement batch = new BatchStatement(0, BatchStatement.Type.LOGGED, Lists.newArrayList((Iterable)Iterables.filter(statements, ModificationStatement.class)), Attributes.none());
        QueryProcessor.instance.processBatch(batch, QueryState.forInternalCalls(), BatchQueryOptions.withoutPerStatementVariables(QueryOptions.DEFAULT));
    }

    private void addPermissionsForRole(Set<Permission> permissions, IResource resource, RoleResource role) throws RequestExecutionException, RequestValidationException {
        QueryOptions options = QueryOptions.forInternalCalls(ConsistencyLevel.LOCAL_ONE, Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(role.getRoleName()), ByteBufferUtil.bytes(resource.getName())}));
        SelectStatement statement = Schema.instance.getCFMetaData("system_auth", "permissions") == null ? this.authorizeRoleStatement : this.legacyAuthorizeRoleStatement;
        ResultMessage.Rows rows = statement.execute(QueryState.forInternalCalls(), options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        if (!result.isEmpty() && result.one().has("permissions")) {
            for (String perm : result.one().getSet("permissions", UTF8Type.instance)) {
                permissions.add(Permission.valueOf(perm));
            }
        }
    }

    private void modifyRolePermissions(Set<Permission> permissions, IResource resource, RoleResource role, String op) throws RequestExecutionException {
        this.process(String.format("UPDATE %s.%s SET permissions = permissions %s {%s} WHERE role = '%s' AND resource = '%s'", "system_auth", "role_permissions", op, "'" + StringUtils.join(permissions, (String)"','") + "'", this.escape(role.getRoleName()), this.escape(resource.getName())));
    }

    private void removeLookupEntry(IResource resource, RoleResource role) throws RequestExecutionException {
        this.process(String.format("DELETE FROM %s.%s WHERE resource = '%s' and role = '%s'", "system_auth", "resource_role_permissons_index", this.escape(resource.getName()), this.escape(role.getRoleName())));
    }

    private void addLookupEntry(IResource resource, RoleResource role) throws RequestExecutionException {
        this.process(String.format("INSERT INTO %s.%s (resource, role) VALUES ('%s','%s')", "system_auth", "resource_role_permissons_index", this.escape(resource.getName()), this.escape(role.getRoleName())));
    }

    @Override
    public Set<PermissionDetails> list(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        if (!performer.isSuper() && !performer.getRoles().contains(grantee)) {
            throw new UnauthorizedException(String.format("You are not authorized to view %s's permissions", grantee == null ? "everyone" : grantee.getRoleName()));
        }
        if (null == grantee) {
            return this.listPermissionsForRole(permissions, resource, grantee);
        }
        Set<RoleResource> roles = DatabaseDescriptor.getRoleManager().getRoles(grantee, true);
        HashSet<PermissionDetails> details = new HashSet<PermissionDetails>();
        for (RoleResource role : roles) {
            details.addAll(this.listPermissionsForRole(permissions, resource, role));
        }
        return details;
    }

    private Set<PermissionDetails> listPermissionsForRole(Set<Permission> permissions, IResource resource, RoleResource role) throws RequestExecutionException {
        HashSet<PermissionDetails> details = new HashSet<PermissionDetails>();
        boolean useLegacyTable = Schema.instance.getCFMetaData("system_auth", "permissions") != null;
        String entityColumnName = useLegacyTable ? USERNAME : ROLE;
        for (UntypedResultSet.Row row : this.process(this.buildListQuery(resource, role, useLegacyTable))) {
            if (!row.has("permissions")) continue;
            for (String p : row.getSet("permissions", UTF8Type.instance)) {
                Permission permission = Permission.valueOf(p);
                if (!permissions.contains((Object)permission)) continue;
                details.add(new PermissionDetails(row.getString(entityColumnName), Resources.fromName(row.getString(RESOURCE)), permission));
            }
        }
        return details;
    }

    private String buildListQuery(IResource resource, RoleResource grantee, boolean useLegacyTable) {
        String tableName = useLegacyTable ? "permissions" : "role_permissions";
        String entityName = useLegacyTable ? USERNAME : ROLE;
        ArrayList vars = Lists.newArrayList((Object[])new String[]{"system_auth", tableName});
        ArrayList<String> conditions = new ArrayList<String>();
        if (resource != null) {
            conditions.add("resource = '%s'");
            vars.add(this.escape(resource.getName()));
        }
        if (grantee != null) {
            conditions.add(entityName + " = '%s'");
            vars.add(this.escape(grantee.getRoleName()));
        }
        String query = "SELECT " + entityName + ", resource, permissions FROM %s.%s";
        if (!conditions.isEmpty()) {
            query = query + " WHERE " + StringUtils.join(conditions, (String)" AND ");
        }
        if (resource != null && grantee == null) {
            query = query + " ALLOW FILTERING";
        }
        return String.format(query, vars.toArray());
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table("system_auth", "role_permissions"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        this.authorizeRoleStatement = this.prepare(ROLE, "role_permissions");
        if (Schema.instance.getCFMetaData("system_auth", "permissions") != null) {
            this.legacyAuthorizeRoleStatement = this.prepare(USERNAME, "permissions");
            ScheduledExecutors.optionalTasks.schedule(new Runnable(){

                @Override
                public void run() {
                    CassandraAuthorizer.this.convertLegacyData();
                }
            }, AuthKeyspace.SUPERUSER_SETUP_DELAY, TimeUnit.MILLISECONDS);
        }
    }

    private SelectStatement prepare(String entityname, String permissionsTable) {
        String query = String.format("SELECT permissions FROM %s.%s WHERE %s = ? AND resource = ?", "system_auth", permissionsTable, entityname);
        return (SelectStatement)QueryProcessor.getStatement((String)query, (ClientState)ClientState.forInternalCalls()).statement;
    }

    private void convertLegacyData() {
        try {
            if (Schema.instance.getCFMetaData("system_auth", "permissions") != null) {
                logger.info("Converting legacy permissions data");
                CQLStatement insertStatement = QueryProcessor.getStatement((String)String.format((String)"INSERT INTO %s.%s (role, resource, permissions) VALUES (?, ?, ?)", (Object[])new Object[]{"system_auth", "role_permissions"}), (ClientState)ClientState.forInternalCalls()).statement;
                CQLStatement indexStatement = QueryProcessor.getStatement((String)String.format((String)"INSERT INTO %s.%s (resource, role) VALUES (?,?)", (Object[])new Object[]{"system_auth", "resource_role_permissons_index"}), (ClientState)ClientState.forInternalCalls()).statement;
                UntypedResultSet permissions = this.process("SELECT * FROM system_auth.permissions");
                for (UntypedResultSet.Row row : permissions) {
                    final IResource resource = Resources.fromName(row.getString(RESOURCE));
                    Predicate<String> isApplicable = new Predicate<String>(){

                        public boolean apply(String s) {
                            return resource.applicablePermissions().contains((Object)Permission.valueOf(s));
                        }
                    };
                    SetSerializer<String> serializer = SetSerializer.getInstance(UTF8Serializer.instance);
                    Set originalPerms = (Set)serializer.deserialize(row.getBytes("permissions"));
                    ImmutableSet filteredPerms = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)originalPerms, (Predicate)isApplicable));
                    insertStatement.execute(QueryState.forInternalCalls(), QueryOptions.forInternalCalls(ConsistencyLevel.ONE, Lists.newArrayList((Object[])new ByteBuffer[]{row.getBytes(USERNAME), row.getBytes(RESOURCE), serializer.serialize((String)filteredPerms)})));
                    indexStatement.execute(QueryState.forInternalCalls(), QueryOptions.forInternalCalls(ConsistencyLevel.ONE, Lists.newArrayList((Object[])new ByteBuffer[]{row.getBytes(RESOURCE), row.getBytes(USERNAME)})));
                }
                logger.info("Completed conversion of legacy permissions");
            }
        }
        catch (Exception e) {
            logger.info("Unable to complete conversion of legacy permissions data (perhaps not enough nodes are upgraded yet). Conversion should not be considered complete");
            logger.debug("Conversion error", (Throwable)e);
        }
    }

    private String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private UntypedResultSet process(String query) throws RequestExecutionException {
        return QueryProcessor.process(query, ConsistencyLevel.LOCAL_ONE);
    }
}

