/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.net.SocketException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);
    private static Killer killer = new Killer();

    private JVMStabilityInspector() {
    }

    public static void inspectThrowable(Throwable t) {
        boolean isUnstable = false;
        if (t instanceof OutOfMemoryError) {
            isUnstable = true;
        }
        if (DatabaseDescriptor.getDiskFailurePolicy() == Config.DiskFailurePolicy.die && (t instanceof FSError || t instanceof CorruptSSTableException)) {
            isUnstable = true;
        }
        if ((t instanceof FileNotFoundException || t instanceof SocketException) && t.getMessage().contains("Too many open files")) {
            isUnstable = true;
        }
        if (isUnstable) {
            killer.killCurrentJVM(t);
        }
    }

    public static void inspectCommitLogThrowable(Throwable t) {
        if (DatabaseDescriptor.getCommitFailurePolicy() == Config.CommitFailurePolicy.die) {
            killer.killCurrentJVM(t);
        } else {
            JVMStabilityInspector.inspectThrowable(t);
        }
    }

    public static void killCurrentJVM(Throwable t, boolean quiet) {
        killer.killCurrentJVM(t, quiet);
    }

    @VisibleForTesting
    public static Killer replaceKiller(Killer newKiller) {
        Killer oldKiller = killer;
        killer = newKiller;
        return oldKiller;
    }

    @VisibleForTesting
    public static class Killer {
        protected void killCurrentJVM(Throwable t) {
            this.killCurrentJVM(t, false);
        }

        protected void killCurrentJVM(Throwable t, boolean quiet) {
            if (!quiet) {
                t.printStackTrace(System.err);
                logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t);
            }
            StorageService.instance.removeShutdownHook();
            System.exit(100);
        }
    }
}

