/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.commons.lang3.ArrayUtils;

@Command(name="tablehistograms", description="Print statistic histograms for a given table")
public class TableHistograms
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table>", description="The keyspace and table name")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        int i;
        Preconditions.checkArgument((this.args.size() == 2 ? 1 : 0) != 0, (Object)"tablehistograms requires keyspace and table name arguments");
        String keyspace = this.args.get(0);
        String table = this.args.get(1);
        long[] estimatedRowSize = (long[])probe.getColumnFamilyMetric(keyspace, table, "EstimatedRowSizeHistogram");
        long[] estimatedColumnCount = (long[])probe.getColumnFamilyMetric(keyspace, table, "EstimatedColumnCountHistogram");
        double[] estimatedRowSizePercentiles = new double[7];
        double[] estimatedColumnCountPercentiles = new double[7];
        double[] offsetPercentiles = new double[]{0.5, 0.75, 0.95, 0.98, 0.99};
        if (ArrayUtils.isEmpty((long[])estimatedRowSize) || ArrayUtils.isEmpty((long[])estimatedColumnCount)) {
            System.err.println("No SSTables exists, unable to calculate 'Partition Size' and 'Cell Count' percentiles");
            for (int i2 = 0; i2 < 7; ++i2) {
                estimatedRowSizePercentiles[i2] = Double.NaN;
                estimatedColumnCountPercentiles[i2] = Double.NaN;
            }
        } else {
            long[] rowSizeBucketOffsets = new EstimatedHistogram(estimatedRowSize.length).getBucketOffsets();
            long[] columnCountBucketOffsets = new EstimatedHistogram(estimatedColumnCount.length).getBucketOffsets();
            EstimatedHistogram rowSizeHist = new EstimatedHistogram(rowSizeBucketOffsets, estimatedRowSize);
            EstimatedHistogram columnCountHist = new EstimatedHistogram(columnCountBucketOffsets, estimatedColumnCount);
            if (rowSizeHist.isOverflowed()) {
                System.err.println(String.format("Row sizes are larger than %s, unable to calculate percentiles", rowSizeBucketOffsets[rowSizeBucketOffsets.length - 1]));
                for (i = 0; i < offsetPercentiles.length; ++i) {
                    estimatedRowSizePercentiles[i] = Double.NaN;
                }
            } else {
                for (i = 0; i < offsetPercentiles.length; ++i) {
                    estimatedRowSizePercentiles[i] = rowSizeHist.percentile(offsetPercentiles[i]);
                }
            }
            if (columnCountHist.isOverflowed()) {
                System.err.println(String.format("Column counts are larger than %s, unable to calculate percentiles", columnCountBucketOffsets[columnCountBucketOffsets.length - 1]));
                for (i = 0; i < estimatedColumnCountPercentiles.length; ++i) {
                    estimatedColumnCountPercentiles[i] = Double.NaN;
                }
            } else {
                for (i = 0; i < offsetPercentiles.length; ++i) {
                    estimatedColumnCountPercentiles[i] = columnCountHist.percentile(offsetPercentiles[i]);
                }
            }
            estimatedRowSizePercentiles[5] = rowSizeHist.min();
            estimatedColumnCountPercentiles[5] = columnCountHist.min();
            estimatedRowSizePercentiles[6] = rowSizeHist.max();
            estimatedColumnCountPercentiles[6] = columnCountHist.max();
        }
        String[] percentiles = new String[]{"50%", "75%", "95%", "98%", "99%", "Min", "Max"};
        double[] readLatency = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspace, table, "ReadLatency"));
        double[] writeLatency = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspace, table, "WriteLatency"));
        double[] sstablesPerRead = probe.metricPercentilesAsArray((CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspace, table, "SSTablesPerReadHistogram"));
        System.out.println(String.format("%s/%s histograms", keyspace, table));
        System.out.println(String.format("%-10s%10s%18s%18s%18s%18s", "Percentile", "SSTables", "Write Latency", "Read Latency", "Partition Size", "Cell Count"));
        System.out.println(String.format("%-10s%10s%18s%18s%18s%18s", "", "", "(micros)", "(micros)", "(bytes)", ""));
        for (i = 0; i < percentiles.length; ++i) {
            System.out.println(String.format("%-10s%10.2f%18.2f%18.2f%18.0f%18.0f", percentiles[i], sstablesPerRead[i], writeLatency[i], readLatency[i], estimatedRowSizePercentiles[i], estimatedColumnCountPercentiles[i]));
        }
        System.out.println();
    }
}

